<?php
/**
 * @package SP Page Builder
 * @author Unitemplates http://www.Unitemplates.com
 * @version 1.6.0
 * @copyright Copyright (c) 2010 - 2021 Unitemplates
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted aceess');

class SppagebuilderAddonUttestimonial extends SppagebuilderAddons {

	public function render() {
		$settings = $this->addon->settings;
		$site_base = JURI::root(true); // For show images in live editor, in multilingual sites.
		$class = (isset($settings->class) && $settings->class) ? $settings->class : '';
		$style = (isset($settings->style) && $settings->style) ? $settings->style : '';
		$aut_pos = (isset($settings->author_position) && $settings->author_position) ? $settings->author_position : '';
		$av_pos = (isset($settings->avatar_position) && $settings->avatar_position) ? $settings->avatar_position : '';
		$avatar_col = (isset($settings->avatar_col) && $settings->avatar_col) ? $settings->avatar_col : '';
		$avatar_effect = (isset($settings->avatar_effect) && $settings->avatar_effect) ? $settings->avatar_effect : '';
		$avatar_effect_apply = (isset($settings->avatar_effect_apply) && $settings->avatar_effect_apply) ? $settings->avatar_effect_apply : '';
		$avatar_animation = (isset($settings->avatar_animation) && $settings->avatar_animation) ? $settings->avatar_animation : '';
		$enable_rating = (isset($settings->enable_rating) && $settings->enable_rating) ? $settings->enable_rating : '';
		$rating_pos = (isset($settings->rating_position) && $settings->rating_position) ? $settings->rating_position : '';

		// dots and navs
		$dots = (isset($settings->dots) && $settings->dots) ? $settings->dots : '';
		$dotsContainer = ((isset($settings->dotsContainer) && $settings->dotsContainer)) ? $settings->dotsContainer : '';
		$nav = (isset($settings->nav) && $settings->nav) ? $settings->nav : '';
		$nav_text = (isset($settings->nav_text) && $settings->nav_text) ? $settings->nav_text : '';
		switch ($nav_text) {
			case '': $nav_class_left = ''; $nav_class_right = ''; break;
			default: $nav_class_left = 'fas fa-'.$nav_text.'-left'; $nav_class_right = 'fas fa-'.$nav_text.'-right'; break;
		}
		$nav_class = ($nav_text != 'long-arrow') ? $nav_text : $nav_text.'-alt';
		$nav_text_prev = ($nav_text == '') ? JText::_('JPREV') : '';
		$nav_text_next = ($nav_text == '') ? JText::_('JNEXT') : '';
		$navContainer = ((isset($settings->navContainer) && $settings->navContainer)) ? $settings->navContainer : '';
		$interval = (isset($settings->interval) && $settings->interval) ? $settings->interval : 3000;

		$av_col = '';
		if($av_pos=='left' || $av_pos=='right') $av_col = 'sppb-col-sm-'.$avatar_col;
		$message_col = '';
		if($av_pos=='left' || $av_pos=='right') $message_col = 'sppb-col-sm-'.(12 - $avatar_col);

		//Output
		$output  = '<div class="ut-testimonial '.$class.'">';
		$output .= '<div id="uttestimonial-'.$this->addon->id.'" class="swiper-container">';
		$output .= '<div class="swiper-wrapper">';

		foreach ($settings->ut_testimonial_item as $key => $value) {
			$authorname = (isset($value->author) && $value->author) ?'<div class="client-name">'. $value->author .'</div>' : '';
			$authorposition = (isset($value->position) && $value->position) ? '<span class="client-position">'. $value->position .'</span>' : '';
	        $target = (isset($value->target) && $value->target) ? ' rel="noopener noreferrer" target="' . $value->target . '"' : '';
			$companyurl = ((isset($value->url) && $value->url) && (isset($value->company) && $value->company)) ? ' <span class="client-company"><a href="' .$value->url. '" '.$target.'>'. $value->company .'</a></span>' : '';
			$company = (isset($value->company) && $value->company) ? ' <span class="client-company">'. $value->company .'</span>' : '';
			if($companyurl){
				$authorcompany = $companyurl;
			} else {
				$authorcompany = $company;
			}

			//ratings
			$rating_count = (isset($value->rating) && $value->rating) ? $value->rating : '';
			$rating = '';
			if($enable_rating && $rating_count){
				$rating .= '<div class="ut-testimonial-rating">';
				for ($i=0; $i < 5; $i++) { 
					$rating .= ($i < $rating_count) ? '<i class="fa fa-star" aria-hidden="true"></i>' : '<i class="fa fa-star-o" aria-hidden="true"></i>';
				}
				$rating .= '</div>';
			}
			$rating_on_author = ($enable_rating && $rating_pos == 'after_author') ? $rating : '';
			$rating_on_message = ($enable_rating && $rating_pos == 'after_message') ? $rating : '';


			$avatar_img = (isset($value->avatar) && $value->avatar) ? $value->avatar : '';
			$avatar_src	= isset($avatar_img->src) ? $avatar_img->src : $avatar_img;
			list($width, $height, $type, $attr) = ($avatar_src) ? getimagesize(JURI::root().$avatar_src) : '';

			if($authorname || $authorposition || $authorcompany) $author = '<div class="ut-testimonial-client">' . $authorname . $authorposition . $authorcompany . $rating_on_author .'</div>';
			$photo = '<div class="avatar-author-'.$aut_pos.'"><img class="sppb-img-responsive '. $value->avatar_style .' '.$avatar_effect.' '.$avatar_animation.'" src="'.  $site_base .'/' . $avatar_src .'" alt="'.$value->author.'" loading="lazy" '.$attr.'></div>';

			$avatar = '<div class="author-avatar author-'.$aut_pos.' '.$av_col.'">';
				if($aut_pos=='before') $avatar .= $author;
				if($aut_pos=='left') $avatar .= $author;
				$avatar .= $photo;
				if($aut_pos=='right') $avatar .= $author;
				if($aut_pos=='after') $avatar .= $author;
			$avatar .= '</div>';

			$output   .= '<div class="ut-testimonial-item testimonial-avatar-'.$av_pos.' effect-on-'.$avatar_effect_apply.' swiper-slide" data-swiper-autoplay="'.$interval.'">';

				if($av_pos=='left' || $av_pos=='right') $output .= '<div class="sppb-row">';

				if($av_pos=='before' && $avatar_src) $output .= $avatar;

				if($av_pos=='left' && $avatar_src) $output .= $avatar;

				$output  .= '<div class="ut-testimonial-message '.$message_col.'">';
					if(($aut_pos=='top' && $value->author) || ($aut_pos=='top' && $value->position) || ($aut_pos=='top' && $value->company)) $output .= $author;
					$output .= '<div class="message">'. $value->message . '</div>';
					$output .= $rating_on_message;
					if(($aut_pos=='bottom' && $value->author) || ($aut_pos=='bottom' && $value->position) || ($aut_pos=='bottom' && $value->company)) $output .= $author;
				$output .= '</div>';

				if($av_pos=='right' && $avatar_src) $output .= $avatar;

				if($av_pos=='after' && $avatar_src) $output .= $avatar;

				if($av_pos=='left' || $av_pos=='right') $output .= '</div>';

			$output  .= '</div>';
		}
		$output	.= '</div>';
		$output	.= '</div>';

		if ($nav == 'true'){
			$output .= '<div id="uttestimonial-navigation-'.$this->addon->id.'" class="ut-personcarousel-navigation swiper-navigation">';
			$output .= '<div id="uttestimonial-nav-prev-'.$this->addon->id.'" class="uttestimonial-nav-prev '.$nav_class_left.'">'.$nav_text_prev.'</div>';
			$output .= '<div id="uttestimonial-nav-next-'.$this->addon->id.'" class="uttestimonial-nav-next '.$nav_class_right.'">'.$nav_text_next.'</div>';
			$output .= '</div>';
		}
		$output	 .= ($dots == 'true' && $dotsContainer == '') ? '<div id="uttestimonial-dots-'.$this->addon->id.'" class="swiper-pagination"></div>' : '';

		$output	.= '</div>';
		return $output;

	}

	public function css() {
		$settings = $this->addon->settings;
		$addon_id = '#sppb-addon-' . $this->addon->id;
		$item_style = (isset($settings->item_bg) && $settings->item_bg ) ? 'background:'. $settings->item_bg. ';' : '';
		$item_style .= (isset($settings->item_color) && $settings->item_color ) ? 'color:'. $settings->item_color. ';' : '';
		$item_style .= (isset($settings->item_padding) && trim($settings->item_padding)) ? 'padding:'. $settings->item_padding. ';' : '';
		$item_style .= (isset($settings->item_border_width) && trim($settings->item_border_width)) ? 'border-width:'. $settings->item_border_width. 'px;' : '';
		$item_style .= (isset($settings->item_border_style) && trim($settings->item_border_style)) ? 'border-style:'. $settings->item_border_style. ';' : '';
		$item_style .= (isset($settings->item_border_color) && trim($settings->item_border_color)) ? 'border-color:'. $settings->item_border_color. ';' : '';
		$item_style .= (isset($settings->item_border_radius) && trim($settings->item_border_radius)) ? 'border-radius:'. $settings->item_border_radius. 'px;' : '';

		// rating styles
		$rating_style = (isset($settings->rating_color) && trim($settings->rating_color)) ? 'color:'. $settings->rating_color.';' : '';
		$rating_style .= (isset($settings->rating_fontsize) && trim($settings->rating_fontsize)) ? 'font-size:'. $settings->rating_fontsize. 'px;' : '';

		// live editor style
		$margin = (isset($settings->margin) && $settings->margin) ? $settings->margin.'px' : '30px';
		$width_lg = (isset($settings->columns) && $settings->columns) ? 'width:calc('.(100 / $settings->columns).'% - '.$margin.');' : 'width:calc(33.333333% - '.$margin.');';
		$width_sm = (isset($settings->columns_sm) && $settings->columns_sm) ? 'width:calc('.(100 / $settings->columns_sm).'% - '.$margin.');' : 'width:calc(50% - '.$margin.');';
		$width_xs = (isset($settings->columns_xs) && $settings->columns_xs) ? 'width:calc('.(100 / $settings->columns_xs).'% - '.$margin.');' : 'width:calc(100% - '.$margin.');';		

		$css = '';

		if($item_style) $css .= $addon_id.' .ut-testimonial-item {'.$item_style.'}';

		// rating
		if($rating_style) $css .= $addon_id. ' .ut-testimonial-rating i{'.$rating_style.'}';

		// editor
		$css .= $addon_id.' .swiper-container:not(.swiper-container-initialized){margin-right:-'.$margin.';}';
		$css .= '@media (min-width:992px){'.$addon_id.' .swiper-container:not(.swiper-container-initialized) .swiper-slide{'.$width_lg.'margin-right:'.$margin.';}}';
		$css .= '@media (min-width:768px) and (max-width:991.98px){'.$addon_id.' .swiper-container:not(.swiper-container-initialized) .swiper-slide{'.$width_sm.'margin-right:'.$margin.';}}';
		$css .= '@media (max-width:767.98px){'.$addon_id.' .swiper-container:not(.swiper-container-initialized) .swiper-slide{'.$width_xs.'margin-right:'.$margin.';}}';

		return $css;
	}

	public function stylesheets(){
		$app = JFactory::getApplication();
		$template = $app->getTemplate();
		$template_path = JURI::base(true) . '/templates/' . $template;
		$cssfiles = array($template_path.'/js/ut_assets/swiper/swiper-bundle.min.css');
		return $cssfiles;
	}

	public function scripts(){
		$app = JFactory::getApplication();
		$template = $app->getTemplate();
		$template_path = JURI::base(true) . '/templates/' . $template;
		return array($template_path.'/js/ut_assets/swiper/swiper-bundle.min.js');
	}

	public function js(){
		$settings = $this->addon->settings;
		$columns = (isset($settings->columns) && $settings->columns) ? $settings->columns : '3';
		$columns_sm = (isset($settings->columns_sm) && $settings->columns_sm) ? $settings->columns_sm : '2';
		$columns_xs = (isset($settings->columns_xs) && $settings->columns_xs) ? $settings->columns_xs : '1';		
		$loop = (isset($settings->loop) && $settings->loop) ? $settings->loop : 'false';
		$autoplay = (isset($settings->autoplay) && $settings->autoplay) ? $settings->autoplay : 'false';
		$center = (isset($settings->center) && $settings->center) ? $settings->center : 'false';
		$dots = (isset($settings->dots) && $settings->dots) ? $settings->dots : 'false';
		$dotsContainer = ((isset($settings->dotsContainer) && $settings->dotsContainer)) ? $settings->dotsContainer : '#uttestimonial-dots-'.$this->addon->id;
		$nav = (isset($settings->nav) && $settings->nav) ? $settings->nav : 'false';
		$nav_text = (isset($settings->nav_text) && $settings->nav_text) ? $settings->nav_text : '';
		$navContainer = ((isset($settings->navContainer) && $settings->navContainer)) ? $settings->navContainer : '';
		$margin = (isset($settings->margin) && $settings->margin) ? $settings->margin : 30;
		$speed = (isset($settings->speed) && $settings->speed) ? $settings->speed : 300;

		$js = "document.addEventListener('DOMContentLoaded', function(){
			var swiper".$this->addon->id." = new Swiper('#uttestimonial-".$this->addon->id."', {
			loop: ".$loop.",
			autoplay: ".$autoplay.",
			speed: ".$speed.",
			slidesPerView: 1,
			centeredSlides: ".$center.",
			spaceBetween: ".$margin.",";
			if($dots) :
		$js .= "pagination: {
				el: '".$dotsContainer."',
				clickable: true,
			},";
			endif;
			if($nav) :
		$js .=	"navigation: {
				nextEl: '#uttestimonial-nav-next-".$this->addon->id."',
				prevEl: '#uttestimonial-nav-prev-".$this->addon->id."',
			},";
			endif;
		$js .=	"breakpoints: {
				480: {
					slidesPerView: ".$columns_xs.",
				},
				768: {
					slidesPerView: ".$columns_sm.",
				},
				992: {
					slidesPerView: ".$columns.",
				}
			}
		});";

		if($navContainer):
		$js .= "const controls = document.querySelectorAll('#uttestimonial-navigation-".$this->addon->id." > div[class*=\"uttestimonial-nav-\"');
		Array.prototype.forEach.call(controls, function (control) {
			document.querySelector('".$navContainer."').append(control);
		});";
		endif;
		$js .= "});";

		return $js;
	}
}
