<?php
/**
 * @package SP Page Builder
 * @author Unitemplates http://www.unitemplates.com
 * @version 1.4.0
 * @copyright Copyright (c) 2010 - 2021 Unitemplates
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted aceess');

class SppagebuilderAddonUtSocialLinks extends SppagebuilderAddons{

	public function render() {
		$settings = $this->addon->settings;
		$class = (isset($settings->class) && $settings->class) ? ' ' . $settings->class : '';
		$class .= (isset($settings->alignment) && $settings->alignment) ? ' sppb-text-' . $settings->alignment : '';

		$button_content = (isset($settings->button_content) && $settings->button_content) ? $settings->button_content : '';
		$colors = (isset($settings->colors) && $settings->colors) ? $settings->colors : '';
		$hovercolors = (isset($settings->hovercolors) && $settings->hovercolors) ? $settings->hovercolors : '';
		$target_link = (isset($settings->target_link) && $settings->target_link) ? 'target="'.$settings->target_link.'" rel="noopener"' : '';

		$output  = '<div class="sppb-addon sppb-addon-ut-social-links' . $class . '">';
		$output .= '<div class="sppb-addon-content">';
		foreach ($settings->ut_social_links_item as $key => $value) {
			$output .= '<a class="'.$value->social_name.' '.$colors.' '.$hovercolors.'" href="'.$value->social_url.'" '.$target_link.' aria-label="'.$value->social_name.'">';
			if($button_content=='icon' || $button_content=='icon-text'){
				$output .= '<i class="'.$value->social_icon.'"></i>';				
			}
			if($button_content=='icon-text' || $button_content=='text'){
				$output .= '<span class="social-name">'.$value->social_name.'</span>';
			}
			$output .= '</a>';
		}

		$output .= '</div>';
		$output .= '</div>';

		return $output;

	}

	public function css() {
		$id = '#sppb-addon-' . $this->addon->id;
		$settings = $this->addon->settings;

		$colors = (isset($settings->colors) && $settings->colors) ? $settings->colors : '';
		$hovercolors = (isset($settings->hovercolors) && $settings->hovercolors) ? $settings->hovercolors : '';
		
		// Social colors
		$color_style = '';
		foreach ($settings->ut_social_links_item as $item) {
			$color_style .= ($colors == 'color') ? $id.' .'.$item->social_name.'.color{background:'.$item->social_color.';border-color:'.$item->social_color.';color:#ffffff;}' : '';
			$color_style .= ($colors == 'color-outline') ? $id.' .'.$item->social_name.'.color-outline{background:transparent;border-color:'.$item->social_color.';color:'.$item->social_color.';}' : '';
			$color_style .= ($colors == 'color-content') ? $id.' .'.$item->social_name.'.color-content{background:transparent;border-color:transparent;color:'.$item->social_color.';}' : '';
			$color_style .= ($colors == 'color-border') ? $id.' .'.$item->social_name.'.color-border{background:transparent;border-color:'.$item->social_color.';color: inherit;}' : '';
			$color_style .= ($hovercolors == 'color-hover') ? $id.' .'.$item->social_name.'.color-hover:hover{background:'.$item->social_color.';border-color:'.$item->social_color.';color: #ffffff;}' : '';
			$color_style .= ($hovercolors == 'color-outline-hover') ? $id.' .'.$item->social_name.'.color-outline-hover:hover{background:transparent;border-color:'.$item->social_color.';color:'.$item->social_color.';}' : '';
			$color_style .= ($hovercolors == 'color-content-hover') ? $id.' .'.$item->social_name.'.color-content-hover:hover{background:transparent;border-color: transparent;color:'.$item->social_color.';}' : '';
			$color_style .= ($hovercolors == 'color-border-hover') ? $id.' .'.$item->social_name.'.color-border-hover:hover{background:transparent;border-color:'.$item->social_color.';color: inherit;}' : '';
		}

		// primary colors
		$color_style .= ($colors == 'primary') ? $id.' .primary{background:var(--primary_color);border-color:var(--primary_color);color:#ffffff;}' : '';
		$color_style .= ($colors == 'primary-outline') ? $id.' .primary-outline{background:transparent;border-color:var(--primary_color);color:var(--primary_color);}' : '';
		$color_style .= ($colors == 'primary-content') ? $id.' .primary-content{background:transparent;border-color:transparent;color:var(--primary_color);}' : '';
		$color_style .= ($colors == 'primary-border') ? $id.' .primary-border{background:transparent;border-color:var(--primary_color);color:inherit;}' : '';
		$color_style .= ($hovercolors == 'primary-hover') ? $id.' .primary-hover:hover{background:var(--primary_color);border-color:var(--primary_color);color:#ffffff;}' : '';
		$color_style .= ($hovercolors == 'primary-outline-hover') ? $id.' .primary-outline-hover:hover{background:transparent;border-color:var(--primary_color);color:var(--primary_color);}' : '';
		$color_style .= ($hovercolors == 'primary-content-hover') ? $id.' .primary-content-hover:hover{background:transparent;border-color:transparent;color:var(--primary_color);}' : '';
		$color_style .= ($hovercolors == 'primary-border-hover') ? $id.' .primary-border-hover:hover{background:transparent;border-color:var(--primary_color);color:inherit;}' : '';

		// Custom Color
		$color = (isset($settings->background_color) && $settings->background_color) ? 'background-color:'. $settings->background_color.';' : '';
		$color .= (isset($settings->border_color) && $settings->border_color) ? 'border-color:'. $settings->border_color.';' : '';
		$color .= (isset($settings->color) && $settings->color) ? 'color:'. $settings->color.';' : '';
		$colorhover = (isset($settings->background_color_hover) && $settings->background_color_hover) ? 'background-color:'. $settings->background_color_hover.';' : '';
		$colorhover .= (isset($settings->border_color_hover) && $settings->border_color_hover) ? 'border-color:'. $settings->border_color_hover.';' : '';
		$colorhover .= (isset($settings->color_hover) && $settings->color_hover) ? 'color:'. $settings->color_hover.';' : '';

		$font_size = (isset($settings->font_size) && $settings->font_size) ? 'font-size:'. $settings->font_size.'px;' : '';
		$icon_size = (isset($settings->icon_size) && $settings->icon_size) ? 'font-size:'. $settings->icon_size.'px;' : '';

		$border = (isset($settings->border_width) && $settings->border_width) ? 'border-width:'. $settings->border_width.'px;' : '';
		$border .= (isset($settings->border_style) && $settings->border_style) ? 'border-style:'. $settings->border_style.';' : '';

		$border .= (isset($settings->border_radius) && $settings->border_radius) ? 'border-radius:'. $settings->border_radius.';' : '';

		$margin = (isset($settings->margin) && $settings->margin) ? $settings->margin : '0';

		//Sizes
		$size = (isset($settings->button_padding) && trim($settings->button_padding)) ? 'padding:'. $settings->button_padding.';' : '';
		$width = (isset($settings->width) && $settings->width) ? $settings->width : '';
		$size .= strpos($width, '%') ? 'width: calc('. $width. ' - ' .($margin * 2).'px);' : 'width:'.$width.';';

		// For optimize on mobiles
		$text_button = (isset($settings->button_content) && $settings->button_content) ? $settings->button_content : '';
		$width_sm = '';
		if($text_button == 'icon-text' || $text_button == 'text'){
			$width_sm .= '
				@media (max-width: 991px) {'.$id.' .sppb-addon-content > a{width:auto;}}
			';
		}
		$size .= (isset($settings->height) && $settings->height) ? 'height:'. $settings->height.'px;' : '';
		$size .= (isset($settings->line_height) && $settings->line_height) ? 'line-height:'. $settings->line_height.'px;' : '';

		$align = (isset($settings->horizontal_align) && $settings->horizontal_align) ? 'justify-content:'. $settings->horizontal_align.';' : 'justify-content:center;';
		$align .= (isset($settings->vertical_align) && $settings->vertical_align) ? 'align-items:'. $settings->vertical_align.';' : 'align-items:center;';

		$css = '';
		$css .= $id . ' .sppb-addon-content > a{display:inline-flex;text-transform:capitalize;'.$size.''.$border.''.$align.'}';
		$css .= $width_sm;
		$css .= $id . ' .sppb-addon-content > a > i+span{margin-left:10px;}';
		$css .= $id . ' .sppb-addon-content > a > i{'.$icon_size.'}';
		$css .= $id . ' .sppb-addon-content > a > span{'.$font_size.'}';
		
		if ($colors=='utsocial-custom') {
			$css .= $id. ' a.utsocial-custom:not(:hover){'.$color.'}';
		}

		if ($hovercolors=='utsocial-customhover') {
			$css .= $id. ' a.utsocial-customhover:hover,';
			$css .= $id. ' a.utsocial-customhover:focus{'.$colorhover.'}';
		}

		if($margin) {
			$css .= $id . ' .sppb-addon-content {';
			$css .= 'margin: -' . (int) $margin . 'px;';
			$css .= '}';

			$css .= $id . ' .sppb-addon-content > a{';
			$css .= 'margin: ' . (int) $margin . 'px;';
			$css .= '}';
		}
		$css .= $color_style;
		return $css;
	}

	public static function getTemplate(){
		$output = '
			<#
				var colors = data.colors;
				var hovercolors = data.hovercolors;
				
				var color = \'background-color:\' + data.background_color + \';\';
				color += \'border-color:\' + data.border_color + \';\';
				color += \'color:\' + data.color + \';\';

				var colorhover = \'background-color:\' + data.background_color_hover + \';\';
				colorhover += \'border-color:\' + data.border_color_hover + \';\';
				colorhover += \'color:\' + data.color_hover + \';\';

				var font_size = \'font-size:\' + data.font_size + \'px;\';
				var icon_size = \'font-size:\' + data.icon_size + \'px;\';

				var border = \'border-width:\' + data.border_width + \'px;\';
				border += \'border-style:\' + data.border_style + \';\';
				border += \'border-radius:\' + data.border_radius + \';\';

				var margin = data.margin;

				var size = \'padding:\' + data.button_padding + \';\';
				var width = data.width;
				var findpercent = _.includes(width, \'%\');
				if(findpercent){
					size += \'width: calc(\' + width + \' - \' +(margin * 2)+\'px);\';
				} else {
					size += \'width:\'+ width +\';\';
				}
				size += \'height:\' + data.height + \'px;\';
				size += \'line-height:\' + data.line_height + \'px;\';

				var align = \'justify-content:\' + data.horizontal_align + \';\';
				align += \'align-items:\' + data.vertical_align + \';\';

				var text_button = data.button_content;
				var width_sm = "";
				if(text_button == "icon-text" || text_button == "text"){
					width_sm += \'@media (max-width: 991px) {#sppb-addon-\' + data.id + \' .sppb-addon-content > a{width:auto!important;}}\';
				}
			#>

			<style type="text/css">
				<# if (findpercent) { #>
					#sppb-addon-{{data.id}} .sppb-addon-content{display:flex;flex-wrap:wrap;}
				<# } #>
					
				#sppb-addon-{{data.id}} .sppb-addon-content > a{display:inline-flex;text-transform:capitalize;{{{size}}} {{{border}}} {{{align}}} }
				{{{width_sm}}}
				#sppb-addon-{{data.id}} .sppb-addon-content > a > i+span{margin-left:10px;}
				#sppb-addon-{{data.id}} .sppb-addon-content > a > i{ {{{icon_size}}} }
				#sppb-addon-{{data.id}} .sppb-addon-content > a > span{ {{{font_size}}} }
				
				<# _.each(data.ut_social_links_item, function(item, key) { #>
					<# if (colors == "color") { #>
						#sppb-addon-{{data.id}} .{{item.social_name}}.color{background:{{item.social_color}};border-color:{{item.social_color}};color:#ffffff;}
					<# } #>
					<# if (colors == "color-outline") { #>
						#sppb-addon-{{data.id}} .{{item.social_name}}.color-outline{background:transparent;border-color:{{item.social_color}};color:{{item.social_color}};}
					<# } #>
					<# if (colors == "color-content") { #>
						#sppb-addon-{{data.id}} .{{item.social_name}}.color-content{background:transparent;border-color:transparent;color:{{item.social_color}};}
					<# } #>
					<# if (colors == "color-border") { #>
						#sppb-addon-{{data.id}} .{{item.social_name}}.color-border{background:transparent;border-color:{{item.social_color}};color: inherit;}
					<# } #>
					<# if (hovercolors == "color-hover") { #>
						#sppb-addon-{{data.id}} .{{item.social_name}}.color-hover:hover{background:{{item.social_color}};border-color:{{item.social_color}};color: #ffffff;}
					<# } #>
					<# if (hovercolors == "color-outline-hover") { #>
						#sppb-addon-{{data.id}} .{{item.social_name}}.color-outline-hover:hover{background:transparent;border-color:{{item.social_color}};color:{{item.social_color}};}
					<# } #>
					<# if (hovercolors == "color-content-hover") { #>
						#sppb-addon-{{data.id}} .{{item.social_name}}.color-content-hover:hover{background:transparent;border-color: transparent;color:{{item.social_color}};}
					<# } #>
					<# if (hovercolors == "color-border-hover") { #>
						#sppb-addon-{{data.id}} .{{item.social_name}}.color-border-hover:hover{background:transparent;border-color:{{item.social_color}};color: inherit;}
					<# } #>
				<# }) #>

				<# if (colors == "primary") { #>
					#sppb-addon-{{data.id}} .primary{background:var(--primary_color);border-color:var(--primary_color);color:#ffffff;}
				<# } #>
				<# if (colors == "primary-outline") { #>
					#sppb-addon-{{data.id}} .primary-outline{background:transparent;border-color:var(--primary_color);color:var(--primary_color);}
				<# } #>
				<# if (colors == "primary-content") { #>
					#sppb-addon-{{data.id}} .primary-content{background:transparent;border-color:transparent;color:var(--primary_color);}
				<# } #>
				<# if (colors == "primary-border") { #>
					#sppb-addon-{{data.id}} .primary-border{background:transparent;border-color:var(--primary_color);color:inherit;}
				<# } #>
				<# if (hovercolors == "primary-hover") { #>
					#sppb-addon-{{data.id}} .primary-hover:hover{background:var(--primary_color);border-color:var(--primary_color);color:#ffffff;}
				<# } #>
				<# if (hovercolors == "primary-outline-hover") { #>
					#sppb-addon-{{data.id}} .primary-outline-hover:hover{background:transparent;border-color:var(--primary_color);color:var(--primary_color);}
				<# } #>
				<# if (hovercolors == "primary-content-hover") { #>
					#sppb-addon-{{data.id}} .primary-content-hover:hover{background:transparent;border-color:transparent;color:var(--primary_color);}
				<# } #>
				<# if (hovercolors == "primary-border-hover") { #>
					#sppb-addon-{{data.id}} .primary-border-hover:hover{background:transparent;border-color:var(--primary_color);color:inherit;}
				<# } #>

				<# if (colors == "utsocial-custom") { #>
					#sppb-addon-{{data.id}} a.utsocial-custom{ {{{color}}} }
				<# } #>

				<# if (hovercolors == "utsocial-customhover") { #>
					#sppb-addon-{{data.id}} a.utsocial-customhover:hover,
					#sppb-addon-{{data.id}} a.utsocial-customhover:focus{ {{{colorhover}}} }
				<# } #>

				<# if(margin) { #>
					#sppb-addon-{{data.id}} .sppb-addon-content {
					margin: -{{{margin}}}px;
					}

					#sppb-addon-{{data.id}} .sppb-addon-content > a{
					margin: {{{margin}}}px;
					}
				<# } #>
			</style>

			<div class="sppb-addon sppb-addon-ut-social-links sppb-text-{{ data.alignment }} {{ data.class }}">
			<div class="sppb-addon-content">
			<# _.each(data.ut_social_links_item, function(link, key) { #>
			<a class="{{link.social_name}} {{{colors}}} {{{hovercolors}}} {{data.shape}} " href="{{link.social_url}}" target="{{ data.target_link }}">
				<# if(data.button_content == "icon" || data.button_content == "icon-text"){ #>
					<i class="{{link.social_icon}}"></i>
				<# }#>
				<# if(data.button_content == "icon-text" || data.button_content == "text"){ #>
					<span class="social-name">{{link.social_name}}</span>
				<# }#>
				</a>
			<# }) #>
			</div>
			</div>
		';
		return $output;
	}
}
