<?php
/**
 * @package SP Page Builder
 * @author Unitemplates http://www.unitemplates.com
 * @version 1.4.0
 * @copyright Copyright (c) 2010 - 2021 Unitemplates
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted aceess');

SpAddonsConfig::addonConfig(
	array(
		'type'=>'general',
		'addon_name'=>'utsociallinks',
		'category'=>'Unitemplates',
		'title'=>JText::_('UT Social Links'),
		'desc'=>JText::_('Add button of your social networks'),
		'attr'=>array(
			'general' => array(

				'admin_label'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL_DESC'),
					'std'=> ''
				),

				'button_content'=>array(
					'type'=>'select',
					'title'=>JText::_('Button Content'),
					'desc'=>JText::_('Select content to show on button'),
					'values'=>array(
						'icon'=>JText::_('Icon'),
						'icon-text'=>JText::_('Icon & Text'),
						'text'=>JText::_('Text'),
					),
					'std'=>'icon',
				),

				'horizontal_align'=>array(
					'type'=>'select',
					'title'=>JText::_('Horizontal Align'),
					'values'=>array(
						'flex-start'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_LEFT'),
						'center'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_CENTER'),
						'flex-end'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_RIGHT'),
					),
					'std'=>'center',
				),

				'vertical_align'=>array(
					'type'=>'select',
					'title'=>JText::_('Vertical Align'),
					'values'=>array(
						'flex-start'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_TOP'),
						'center'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_CENTER'),
						'flex-end'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_BOTTOM'),
					),
					'std'=>'center',
				),

				'border_width'=>array(
					'type'=>'number',
					'title'=>JText::_('Border Width'),
					'desc'=>JText::_('Button border width'),
					'std'=>'1',
				),

				'border_style'=>array(
					'type'=>'select',
					'title'=>JText::_('Border Style'),
					'desc'=>JText::_('Button border style'),
					'values'=>array(
						''=>JText::_('JNONE'),
						'solid'=>JText::_('Solid'),
						'dotted'=>JText::_('Doted'),
						'dashed'=>JText::_('Dashed'),
						'double'=>JText::_('Double'),
					),
					'std'=>'solid',
					'depends'=>array(array('border_width', '!=', '')),
				),

				'border_radius'=>array(
					'type'=>'text',
					'title'=>JText::_('Border Radius'),
					'desc'=>JText::_('Values in px, %'),
					'std'=>'0px',
				),

				'margin'=>array(
					'type'=>'number',
					'title'=>JText::_('COM_SPPAGEBUILDER_BUTTON_GROUP_GUTTER'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_BUTTON_GROUP_GUTTER_DESC'),
					'placeholder'=>'5',
					'std'=>'',
				),

				'separator_colors'=>array(
					'type'=>'separator',
					'title'=>JText::_('Color Settings'),
				),

				'colors'=>array(
					'type'=>'select',
					'title'=>JText::_('Button Color'),
					'desc'=>JText::_('Select a color combination'),
					'values'=>array(
						'color'=>JText::_('Color'),
						'color-outline'=>JText::_('Color Outline'),
						'color-content'=>JText::_('Color Content'),
						'color-border'=>JText::_('Color Border'),
						'primary'=>JText::_('Primary'),
						'primary-outline'=>JText::_('Primary Outline'),
						'primary-content'=>JText::_('Primary Content'),
						'primary-border'=>JText::_('Primary Border'),
						'utsocial-custom'=>JText::_('Custom'),
					),
					'std'=>'color',
				),

				'background_color'=>array(
					'type'=>'color',
					'title'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BACKGROUND_COLOR'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BACKGROUND_COLOR_DESC'),
					'std' => '#444',
					'depends'=>array('colors'=>'utsocial-custom'),
				),

				'border_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Border Color'),
					'desc'=>JText::_('Select a border color. Leave blank if not is needed.'),
					'std' => '#333',
					'depends'=>array('colors'=>'utsocial-custom'),
				),

				'color'=>array(
					'type'=>'color',
					'title'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_COLOR'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_COLOR_DESC'),
					'std' => '#fff',
					'depends'=>array('colors'=>'utsocial-custom'),
				),

				'hovercolors'=>array(
					'type'=>'select',
					'title'=>JText::_('Button Hover Color'),
					'desc'=>JText::_('Select a  hover color'),
					'values'=>array(
						'color-hover'=>JText::_('Color'),
						'color-outline-hover'=>JText::_('Color Outline'),
						'color-content-hover'=>JText::_('Color Content'),
						'color-border-hover'=>JText::_('Color Border'),
						'primary-hover'=>JText::_('Primary'),
						'primary-outline-hover'=>JText::_('Primary Outline'),
						'primary-content-hover'=>JText::_('Primary Content'),
						'primary-border-hover'=>JText::_('Primary Border'),
						'utsocial-customhover'=>JText::_('Custom'),
					),
					'std'=>'color-outline-hover',
				),

				'background_color_hover'=>array(
					'type'=>'color',
					'title'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BACKGROUND_COLOR_HOVER'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BACKGROUND_COLOR_HOVER_DESC'),
					'std' => '#222',
					'depends'=>array('hovercolors'=>'utsocial-customhover'),
				),

				'border_color_hover'=>array(
					'type'=>'color',
					'title'=>JText::_('Hover border color'),
					'desc'=>JText::_('Select a border color. Leave blank if not is needed.'),
					'std' => '#111',
					'depends'=>array('hovercolors'=>'utsocial-customhover'),
				),

				'color_hover'=>array(
					'type'=>'color',
					'title'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_COLOR_HOVER'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_COLOR_HOVER_DESC'),
					'std' => '#fff',
					'depends'=>array('hovercolors'=>'utsocial-customhover'),
				),

				'separator_size'=>array(
					'type'=>'separator',
					'title'=>JText::_('Size Settings'),
				),

				'button_padding'=>array(
					'type'=>'padding',
					'title'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_PADDING'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_PADDING_DESC'),
					'std' => '',
				),

				'width'=>array(
					'type'=>'text',
					'title'=>JText::_('Width'),
					'desc'=>JText::_('Icon width (auto, px, %, rem, em, and other valid values)'),
					'std'=>'32px',
				),

				'height'=>array(
					'type'=>'number',
					'title'=>JText::_('Height'),
					'desc'=>JText::_('Icon height'),
					'std'=>'32',
				),

				'font_size'=>array(
					'type'=>'number',
					'title'=>JText::_('Font Size'),
					'desc'=>JText::_('Text font size'),
					'depends'=>array(
						array('button_content', '!=', 'icon'),
					),
				),

				'icon_size'=>array(
					'type'=>'number',
					'title'=>JText::_('Icon Size'),
					'desc'=>JText::_('Icon font size'),
					'depends'=>array(
						array('button_content', '!=', 'text'),
					),
					'std'=>'15',
				),

				'alignment'=>array(
					'type'=>'select',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_CONTENT_ALIGNMENT'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_CONTENT_ALIGNMENT_DESC'),
					'values'=>array(
						'left'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_LEFT'),
						'center'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_CENTER'),
						'right'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_RIGHT'),
					),
					'std'=>'center',
				),

				'class'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
					'std'=> '',
				),

				'target_link'=>array(
					'type'=>'select',
					'title'=>JText::_('Target Link'),
					'desc'=>JText::_('Target links for social networks'),
					'values'=>array(
						''=>JText::_('Self'),
						'_blank'=>JText::_('Blank'),
					),
					'std'=>'',
				),

				// Repeatable Items
				'ut_social_links_item'=>array(
					'title'=> JText::_('Social Networks'),
					'std' => array(
						array(
							'social_name' => 'behance',
							'social_icon' => 'fab fa-behance',
							'social_color' => '#0057ff',
							'social_url' => 'https://www.behance.net/unitemplates'
						),
						array(
							'social_name' => 'dribbble',
							'social_icon' => 'fab fa-dribbble',
							'social_color' => '#ea4c89',
							'social_url' => 'https://dribbble.com/unitemplates'
						),
						array(
							'social_name' => 'facebook',
							'social_icon' => 'fab fa-facebook-f',
							'social_color' => '#1778f2',
							'social_url' => 'https://www.facebook.com/unitemplates'
						),
						array(
							'social_name' => 'flickr',
							'social_icon' => 'fab fa-flickr',
							'social_color' => '#ff0084',
							'social_url' => '#'
						),
						array(
							'social_name' => 'instagram',
							'social_icon' => 'fab fa-instagram',
							'social_color' => '#833ab4',
							'social_url' => 'https://www.instagram.com/unitemplates/'
						),
						array(
							'social_name' => 'linkedin',
							'social_icon' => 'fab fa-linkedin',
							'social_color' => '#2867b2',
							'social_url' => 'https://www.linkedin.com/company/unitemplates'
						),
						array(
							'social_name' => 'pinterest',
							'social_icon' => 'fab fa-pinterest',
							'social_color' => '#e60023',
							'social_url' => 'https://www.pinterest.com/unitemplates'
						),
						array(
							'social_name' => 'rss',
							'social_icon' => 'fas fa-rss',
							'social_color' => '#ff8a00',
							'social_url' => '#'
						),
						array(
							'social_name' => 'soundcloud',
							'social_icon' => 'fab fa-soundcloud',
							'social_color' => '#ff5500',
							'social_url' => '#'
						),
						array(
							'social_name' => 'tumblr',
							'social_icon' => 'fab fa-tumblr',
							'social_color' => '#34526f',
							'social_url' => '#'
						),
						array(
							'social_name' => 'twitter',
							'social_icon' => 'fab fa-twitter',
							'social_color' => '#1d9bf0',
							'social_url' => 'https://www.twitter.com/unitemplates'
						),
						array(
							'social_name' => 'vimeo',
							'social_icon' => 'fab fa-vimeo',
							'social_color' => '#1ab7ea',
							'social_url' => '#'
						),
						array(
							'social_name' => 'youtube',
							'social_icon' => 'fab fa-youtube',
							'social_color' => '#ff0000',
							'social_url' => 'https://www.youtube.com/channel/UCuAmkhlYSo1NIgjH4qLaiOQ'
						)
					),
					'attr'=>  array(
						'social_name'=>array(
							'type'=>'text',
							'title'=>JText::_('Social Name'),
							'desc'=>JText::_('Name of your social network'),
							'std'=>'facebook',
						),

						'social_icon'=>array(
							'type'=>'text',
							'title'=>JText::_('Social Icon Class'),
							'std'=>'fab fa-facebook-f',
						),
						'social_color'=>array(
							'type'=>'color',
							'title'=>JText::_('Social Color'),
							'std'=>'#1778f2',
						),
						'social_url'=>array(
							'type'=>'text',
							'title'=>JText::_('Social Url'),
							'std'=>'#',
						),
					),
				),
			),
		),
	)
);
