<?php
/**
 * @package SP Page Builder
 * @author Unitemplates http://www.unitemplates.com
 * @version 1.6.0
 * @copyright Copyright (c) 2010 - 2020 Unitemplates
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted access');

class SppagebuilderAddonUtperson extends SppagebuilderAddons{

	public function render() {

		$class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';

		//Options
		$image 			= (isset($this->addon->settings->image) && $this->addon->settings->image) ? $this->addon->settings->image : '';
		$image_src		= isset($image->src) ? $image->src : $image;
		$name 			= (isset($this->addon->settings->name) && $this->addon->settings->name) ? $this->addon->settings->name : '';
		$designation 	= (isset($this->addon->settings->designation) && $this->addon->settings->designation) ? $this->addon->settings->designation : '';
		$email 			= (isset($this->addon->settings->email) && $this->addon->settings->email) ? $this->addon->settings->email : '';
		$url 			= (isset($this->addon->settings->url) && $this->addon->settings->url) ? $this->addon->settings->url : '';
		$introtext 		= (isset($this->addon->settings->introtext) && $this->addon->settings->introtext) ? $this->addon->settings->introtext : '';
		$facebook 		= (isset($this->addon->settings->facebook) && $this->addon->settings->facebook) ? $this->addon->settings->facebook : '';
		$twitter		= (isset($this->addon->settings->twitter) && $this->addon->settings->twitter) ? $this->addon->settings->twitter : '';
		$youtube		= (isset($this->addon->settings->youtube) && $this->addon->settings->youtube) ? $this->addon->settings->youtube : '';
		$linkedin		= (isset($this->addon->settings->linkedin) && $this->addon->settings->linkedin) ? $this->addon->settings->linkedin : '';
		$pinterest 		= (isset($this->addon->settings->pinterest) && $this->addon->settings->pinterest) ? $this->addon->settings->pinterest : '';
		$flickr			= (isset($this->addon->settings->flickr) && $this->addon->settings->flickr) ? $this->addon->settings->flickr : '';
		$dribbble 		= (isset($this->addon->settings->dribbble) && $this->addon->settings->dribbble) ? $this->addon->settings->dribbble : '';
		$behance		= (isset($this->addon->settings->behance) && $this->addon->settings->behance) ? $this->addon->settings->behance : '';
		$instagram 		= (isset($this->addon->settings->instagram) && $this->addon->settings->instagram) ? $this->addon->settings->instagram : '';
		$target_link 	= (isset($this->addon->settings->target_link) && $this->addon->settings->target_link) ? 'target="'.$this->addon->settings->target_link.'" rel="noopener" ' : '';
		$info_position = (isset($this->addon->settings->info_position) && $this->addon->settings->info_position) ? $this->addon->settings->info_position : '';
		$desc_position = (isset($this->addon->settings->desc_position) && $this->addon->settings->desc_position) ? $this->addon->settings->desc_position : '';
		$social_position = (isset($this->addon->settings->social_position) && $this->addon->settings->social_position) ? $this->addon->settings->social_position : '';
		$social_order = (isset($this->addon->settings->social_order) && $this->addon->settings->social_order) ? $this->addon->settings->social_order : '';
		$alignment 		= (isset($this->addon->settings->alignment) && $this->addon->settings->alignment) ? $this->addon->settings->alignment : '';

		//Positions
		$after = '';
		$after .= $info_position=='after';
		$after .= $desc_position=='after';
		$after .= $social_position=='after';

		$overlay = '';
		$overlay .= $info_position=='overlay';
		$overlay .= $desc_position=='overlay';
		$overlay .= $social_position=='overlay';

		$output = '';
		$social_icons = '';
		$person_info = '';
		$person_desc = '';

		if($name || $designation || $email) {
			$person_info  .= '<div class="person-information">';
			if($name && $url){
				$person_info  .= '<span class="person-name"><a href="'.$url.'">' . $name . '</a></span>';
			} elseif ($name) {
				$person_info  .= '<span class="person-name"> ' . $name . '</span>';
			}
			if($designation) $person_info  .= '<span class="person-designation">' . $designation . '</span>';
			if($email) $person_info  .= '<span class="person-email">' . $email . '</span>';
			$person_info  .= '</div>';
		}
		
		if($introtext) $person_desc  .= '<div class="person-description">' . $introtext . '</div>';

		if($facebook || $twitter || $youtube || $linkedin || $pinterest || $flickr || $dribbble || $behance || $instagram) {
			$social_icons  	.= '<div class="person-social-icons">';
			$social_icons 	.= '<ul class="person-social">';

			if($facebook) 		$social_icons .= '<li><a '.$target_link.'href="' . $facebook . '" aria-label="facebook"><i class="fab fa-facebook-f"></i></a></li>';
			if($twitter) 		$social_icons .= '<li><a '.$target_link.'href="' . $twitter . '" aria-label="twitter"><i class="fab fa-twitter"></i></a></li>';
			if($youtube) 		$social_icons .= '<li><a '.$target_link.'href="' . $youtube . '" aria-label="youtube"><i class="fab fa-youtube"></i></a></li>';
			if($linkedin) 		$social_icons .= '<li><a '.$target_link.'href="' . $linkedin . '" aria-label="linkedin"><i class="fab fa-linkedin"></i></a></li>';
			if($pinterest) 		$social_icons .= '<li><a '.$target_link.'href="' . $pinterest . '" aria-label="pinterest"><i class="fab fa-pinterest"></i></a></li>';
			if($flickr) 		$social_icons .= '<li><a '.$target_link.'href="' . $flickr . '" aria-label="flickr"><i class="fab fa-flickr"></i></a></li>';
			if($dribbble) 		$social_icons .= '<li><a '.$target_link.'href="' . $dribbble . '" aria-label="dribbble"><i class="fab fa-dribbble"></i></a></li>';
			if($behance) 		$social_icons .= '<li><a '.$target_link.'href="' . $behance . '" aria-label="behance"><i class="fab fa-behance"></i></a></li>';
			if($instagram) 		$social_icons .= '<li><a '.$target_link.'href="' . $instagram . '" aria-label="instagram"><i class="fab fa-instagram"></i></a></li>';

			$social_icons 	.= '</ul>';
			$social_icons 	.= '</div>';
		}


		$output  .= '<div class="sppb-addon ut-person ' . $alignment . ' ' . $class . '">';
		$output  .= '<div class="sppb-addon-content">';

			if($image_src) {
					$output  .= '<div class="person-image">';
					list($width, $height, $type, $attr) = getimagesize(JURI::root(). $image_src);
					$output  .= '<img class="sppb-img-responsive" src="' . $image_src . '" alt="'. $name .'" loading="lazy" '.$attr.'>';

					if($overlay) {
						$output .= '<div class="person-overlay"><div class="person-overlay-inner">';
						if($social_position=='overlay' && $social_order=='before_info') $output .= $social_icons;
						if($info_position=='overlay') $output  .= $person_info;
						if($social_position=='overlay' && $social_order=='before_desc') $output .= $social_icons;
						if($desc_position=='overlay') $output  .= $person_desc;
						if($social_position=='overlay' && $social_order=='after_desc') $output .= $social_icons;
						$output .= '</div></div>';
					}

					$output  .= '</div>';
			}


			if($after) {
				$output .= '<div class="person-after">';
				if($social_position=='after' && $social_order=='before_info') $output .= $social_icons;
				if($info_position=='after') $output  .= $person_info;
				if($social_position=='after' && $social_order=='before_desc') $output .= $social_icons;
				if($desc_position=='after') $output  .= $person_desc;
				if($social_position=='after' && $social_order=='after_desc') $output .= $social_icons;
				$output .= '</div>';
			}

		$output  .= '</div>';
		$output  .= '</div>';
		return $output;
	}

	public static function getTemplate(){
		$output = '
		<#
			var image = {}
			if (typeof data.image !== "undefined" && typeof data.image.src !== "undefined") {
				image = data.image
			} else {
				image = {src: data.image}
			}

			var after = "";
			after += data.info_position == "after";
			after += data.desc_position == "after";
			after += data.social_position == "after";

			var overlay = "";
			overlay += data.info_position == "overlay";
			overlay += data.desc_position == "overlay";
			overlay += data.social_position == "overlay";

			var social_icons = "";
			var person_info = "";
			var person_desc = "";

			if(data.name || data.designation || data.email){
				person_info  += \'<div class="person-information">\';
				if(data.name && data.url){
					person_info  += \'<span class="person-name"><a href="\' + data.url + \'">\' + data.name + \'</a></span>\';
				} else if(data.name){
					person_info  += \'<span class="person-name">\' + data.name + \'</span>\';
				}
				if(data.designation){
					person_info  += \'<span class="person-designation">\' + data.designation + \'</span>\';
				}
				if(data.email){
					person_info  += \'<span class="person-email">\' + data.email + \'</span>\';
				}
				person_info  += \'</div>\';
			}

			if(data.introtext){
				person_desc  += \'<div class="person-description">\' + data.introtext + \'</div>\';
			}

			if(data.facebook || data.twitter || data.youtube || data.linkedin || data.pinterest || data.flickr || data.dribbble || data.behance || data.instagram) {
				social_icons  	+= \'<div class="person-social-icons">\';
				social_icons 	+= \'<ul class="person-social">\';

				if(!_.isEmpty(data.facebook)){
					social_icons += \'<li><a target="\' + data.target_link + \'" href="\' + data.facebook + \'"><i class="fab fa-facebook-f"></i></a></li>\';
				}
				if(!_.isEmpty(data.twitter)){
					social_icons += \'<li><a target="\' + data.target_link + \'" href="\' + data.twitter + \'"><i class="fab fa-twitter"></i></a></li>\';
				}
				if(!_.isEmpty(data.youtube)){
					social_icons += \'<li><a target="\' + data.target_link + \'" href="\' + data.youtube + \'"><i class="fab fa-youtube"></i></a></li>\';
				}
				if(!_.isEmpty(data.linkedin)){
					social_icons += \'<li><a target="\' + data.target_link + \'" href="\' + data.linkedin + \'"><i class="fab fa-linkedin"></i></a></li>\';
				}
				if(!_.isEmpty(data.pinterest)){
					social_icons += \'<li><a target="\' + data.target_link + \'" href="\' + data.pinterest + \'"><i class="fab fa-pinterest"></i></a></li>\';
				}
				if(!_.isEmpty(data.flickr)){
					social_icons += \'<li><a target="\' + data.target_link + \'" href="\' + data.flickr + \'"><i class="fab fa-flickr"></i></a></li>\';
				}
				if(!_.isEmpty(data.dribbble)){
					social_icons += \'<li><a target="\' + data.target_link + \'" href="\' + data.dribbble + \'"><i class="fab fa-dribbble"></i></a></li>\';
				}
				if(!_.isEmpty(data.behance)){
					social_icons += \'<li><a target="\' + data.target_link + \'" href="\' + data.behance + \'"><i class="fab fa-behance"></i></a></li>\';
				}
				if(!_.isEmpty(data.instagram)){
					social_icons += \'<li><a target="\' + data.target_link + \'" href="\' + data.instagram + \'"><i class="fab fa-instagram"></i></a></li>\';
				}

				social_icons 	+= \'</ul>\';
				social_icons 	+= \'</div>\';
			}
		#>

		<div class="sppb-addon ut-person {{ data.alignment }} {{ data.class }}">
		<div class="sppb-addon-content">
			<# if(image.src) { #>
					<div class="person-image">
					<img class="sppb-img-responsive" src={{{pagebuilder_base + image.src}}} alt="{{ data.name }}">
					<# if(overlay) { #>
						<div class="person-overlay"><div class="person-overlay-inner">
						<# if(data.social_position == "overlay" && data.social_order == "before_info") { #>
							{{{ social_icons}}}
						<# } #>
						<# if(data.info_position == "overlay") { #>
							{{{person_info}}}
						<# } #>
						<# if(data.social_position == "overlay" && data.social_order == "before_desc") { #>
							{{{social_icons}}}
						<# } #>
						<# if(data.desc_position == "overlay") { #>
							{{{person_desc}}}
						<# } #>
						<# if(data.social_position == "overlay" && data.social_order == "after_desc") { #>
							{{{social_icons}}}
						<# } #>
						</div></div>
					<# }#>
					</div>
			<# } #>

			<# if(after) { #>
				<div class="person-after">
				<# if(data.social_position == "after" && data.social_order == "before_info") { #>
					{{{ social_icons }}}
				<# } #>
				<# if(data.info_position == "after") { #>
					{{{ person_info }}}
				<# } #>
				<# if(data.social_position == "after" && data.social_order == "before_desc") { #>
					{{{ social_icons }}}
				<# } #>
				<# if(data.desc_position == "after") { #>
					{{{ person_desc }}}
				<# } #>
				<# if(data.social_position == "after" && data.social_order == "after_desc") { #>
					{{{ social_icons }}}
				<# } #>
				</div>
			<# } #>

		</div>
		</div>
		';
		return $output;
	}
}
