<?php
/**
 * @package SP Page Builder
 * @author Unitemplates http://www.unitemplates.com
 * @version 1.6.0
 * @copyright Copyright (c) 2010 - 2020 Unitemplates
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted aceess');

class SppagebuilderAddonUtclients extends SppagebuilderAddons {

	public function render() {
		$settings = $this->addon->settings;
		$site_base = JURI::root(true); // For show images in live editor, in multilingual sites.
		$class = (isset($settings->class) && $settings->class) ? $settings->class : '';
		$title = (isset($settings->title) && $settings->title) ? $settings->title : '';
		$alignment = (isset($settings->alignment) && $settings->alignment) ? $settings->alignment : '';
		$heading_selector = (isset($settings->heading_selector) && $settings->heading_selector) ? $settings->heading_selector : 'h3';
		$image_effect = (isset($settings->image_effect) && $settings->image_effect) ? $settings->image_effect : '';
		$image_effect_apply = (isset($settings->image_effect_apply) && $settings->image_effect_apply) ? $settings->image_effect_apply : '';
		$image_animation = (isset($settings->image_animation) && $settings->image_animation) ? $settings->image_animation : '';
		$target_link = (isset($settings->target_link) && $settings->target_link) ? 'target="'.$settings->target_link.'" rel="noopener" ' : '';

		// dots and navs
		$dots = (isset($settings->dots) && $settings->dots) ? $settings->dots : '';
		$dotsContainer = ((isset($settings->dotsContainer) && $settings->dotsContainer)) ? $settings->dotsContainer : '';
		$nav = (isset($settings->nav) && $settings->nav) ? $settings->nav : '';
		$nav_text = (isset($settings->nav_text) && $settings->nav_text) ? $settings->nav_text : '';
		switch ($nav_text) {
			case '': $nav_class_left = ''; $nav_class_right = ''; break;
			case 'long-arrow': $nav_class_left = 'fas fa-'.$nav_text.'-alt-left'; $nav_class_right = 'fas fa-'.$nav_text.'-alt-right'; break;
			default: $nav_class_left = 'fas fa-'.$nav_text.'-left'; $nav_class_right = 'fas fa-'.$nav_text.'-right'; break;
		}
		$nav_class = ($nav_text != 'long-arrow') ? $nav_text : $nav_text.'-alt';
		$nav_text_prev = ($nav_text == '') ? JText::_('JPREV') : '';
		$nav_text_next = ($nav_text == '') ? JText::_('JNEXT') : '';
		$navContainer = ((isset($settings->navContainer) && $settings->navContainer)) ? $settings->navContainer : '';
		$interval = (isset($settings->interval) && $settings->interval) ? $settings->interval : 3000;

		$output   = '';
		$output  = '<div class="sppb-addon sppb-addon-ut-clients ' . $alignment . ' ' . $class . '">';

		if($title) {
			$output .= '<'.$heading_selector.' class="sppb-addon-title">' . $title . '</'.$heading_selector.'>';
		}

		$output .= '<div class="sppb-addon-content">';
		$output .= '<div id="ut-clients-'.$this->addon->id.'" class="swiper-container">';
		$output .= '<div class="swiper-wrapper">';

		foreach ($settings->ut_clients_item as $key => $value) {
			$image 		= (isset($value->image) && $value->image) ? $value->image : '';
			$image_src	= isset($image->src) ? $image->src : $image;
			if($image_src) {
				$output .= '<div class="swiper-slide client-item effect-on-'.$image_effect_apply.'" data-swiper-autoplay="'.$interval.'">';
				if($value->url) $output .= '<a '.$target_link.' href="'. $value->url .'">';
				list($width, $height, $type, $attr) = getimagesize(JURI::root(). $image_src);
				$output .= '<img class="sppb-img-responsive '.$image_effect.' '.$image_animation.'" src="' . $site_base .'/' . $image_src . '" alt="' . $value->title . '" loading="lazy" '.$attr.'>';
				if($value->url) $output .= '</a>';
				$output .= '</div>';
			}
		}

		$output  .= '</div>';
		$output  .= '</div>';

		if ($nav == 'true'){
			$output .= '<div id="ut-clients-navigation-'.$this->addon->id.'" class="ut-clients-navigation swiper-navigation">';
			$output .= '<div id="ut-clients-nav-prev-'.$this->addon->id.'" class="ut-clients-nav-prev '.$nav_class_left.'">'.$nav_text_prev.'</div>';
			$output .= '<div id="ut-clients-nav-next-'.$this->addon->id.'" class="ut-clients-nav-next '.$nav_class_right.'">'.$nav_text_next.'</div>';
			$output .= '</div>';
		}
		$output	 .= ($dots == 'true' && $dotsContainer == '') ? '<div id="ut-clients-dots-'.$this->addon->id.'" class="swiper-pagination"></div>' : '';

		$output  .= '</div>';
		$output  .= '</div>';

		return $output;
	}

	public function css() {
		$settings = $this->addon->settings;
		$addon_id = '#sppb-addon-' . $this->addon->id;
		$item_style = (isset($settings->item_bg) && $settings->item_bg ) ? 'background:'. $settings->item_bg. ';' : '';
		$item_style .= (isset($settings->item_color) && $settings->item_color ) ? 'color:'. $settings->item_color. ';' : '';
		$item_style .= (isset($settings->item_padding) && trim($settings->item_padding)) ? 'padding:'. $settings->item_padding. ';' : '';
		$item_style .= (isset($settings->item_border_width) && trim($settings->item_border_width)) ? 'border-width:'. $settings->item_border_width. 'px;' : '';
		$item_style .= (isset($settings->item_border_style) && trim($settings->item_border_style)) ? 'border-style:'. $settings->item_border_style. ';' : '';
		$item_style .= (isset($settings->item_border_color) && trim($settings->item_border_color)) ? 'border-color:'. $settings->item_border_color. ';' : '';
		$item_style .= (isset($settings->item_border_radius) && trim($settings->item_border_radius)) ? 'border-radius:'. $settings->item_border_radius. 'px;' : '';

		// live editor style
		$margin = (isset($settings->margin) && $settings->margin) ? $settings->margin.'px' : '30px';
		$width_lg = (isset($settings->count) && $settings->count) ? 'width:calc('.(100 / $settings->count).'% - '.$margin.');' : 'width:calc(33.333333% - '.$margin.');';
		$width_sm = (isset($settings->count_sm) && $settings->count_sm) ? 'width:calc('.(100 / $settings->count_sm).'% - '.$margin.');' : 'width:calc(50% - '.$margin.');';
		$width_xs = (isset($settings->count_xs) && $settings->count_xs) ? 'width:calc('.(100 / $settings->count_xs).'% - '.$margin.');' : 'width:calc(100% - '.$margin.');';		

		$css = '';

		if($item_style) $css .= $addon_id.' .client-item {'.$item_style.' float:inherit;}';

		// editor
		$css .= $addon_id.' .swiper-container:not(.swiper-container-initialized){margin-right:-'.$margin.';}';
		$css .= '@media (min-width:992px){'.$addon_id.' .swiper-container:not(.swiper-container-initialized) .swiper-slide{'.$width_lg.'margin-right:'.$margin.';}}';
		$css .= '@media (min-width:768px) and (max-width:991.98px){'.$addon_id.' .swiper-container:not(.swiper-container-initialized) .swiper-slide{'.$width_sm.'margin-right:'.$margin.';}}';
		$css .= '@media (max-width:767.98px){'.$addon_id.' .swiper-container:not(.swiper-container-initialized) .swiper-slide{'.$width_xs.'margin-right:'.$margin.';}}';

		return $css;
	}

	public function scripts(){
		$app = JFactory::getApplication();
		$template = $app->getTemplate();
		$template_path = JURI::base(true) . '/templates/' . $template;
		return array($template_path.'/js/ut_assets/swiper/swiper-bundle.min.js');
	}

	public function stylesheets(){
		$app = JFactory::getApplication();
		$template = $app->getTemplate();
		$template_path = JURI::base(true) . '/templates/' . $template;
		$cssfiles = array($template_path.'/js/ut_assets/swiper/swiper-bundle.min.css');
		return $cssfiles;
	}

	public function js(){
		$settings = $this->addon->settings;
		$columns = (isset($settings->count) && $settings->count) ? $settings->count : '3';
		$columns_sm = (isset($settings->count_sm) && $settings->count_sm) ? $settings->count_sm : '2';
		$columns_xs = (isset($settings->count_xs) && $settings->count_xs) ? $settings->count_xs : '1';
		$loop = (isset($settings->loop) && $settings->loop) ? $settings->loop : 'false';
		$autoplay = (isset($settings->autoplay) && $settings->autoplay) ? $settings->autoplay : 'false';
		$center = (isset($settings->center) && $settings->center) ? $settings->center : 'false';
		$dots = (isset($settings->dots) && $settings->dots) ? $settings->dots : 'false';
		$dotsContainer = ((isset($settings->dotsContainer) && $settings->dotsContainer)) ? $settings->dotsContainer : '#ut-clients-dots-'.$this->addon->id;
		$nav = (isset($settings->nav) && $settings->nav) ? $settings->nav : 'false';
		$nav_text = (isset($settings->nav_text) && $settings->nav_text) ? $settings->nav_text : '';
		$navContainer = ((isset($settings->navContainer) && $settings->navContainer)) ? $settings->navContainer : '';
		$margin = (isset($settings->margin) && $settings->margin) ? $settings->margin : 30;
		$speed = (isset($settings->speed) && $settings->speed) ? $settings->speed : 300;

		$js = "document.addEventListener('DOMContentLoaded', function(){
			var swiper".$this->addon->id." = new Swiper('#ut-clients-".$this->addon->id."', {
			loop: ".$loop.",
			autoplay: ".$autoplay.",
			speed: ".$speed.",
			slidesPerView: 1,
			centeredSlides: ".$center.",
			spaceBetween: ".$margin.",";
			if($dots) :
		$js .= "pagination: {
				el: '".$dotsContainer."',
				clickable: true,
			},";
			endif;
			if($nav) :
		$js .=	"navigation: {
				nextEl: '#ut-clients-nav-next-".$this->addon->id."',
				prevEl: '#ut-clients-nav-prev-".$this->addon->id."',
			},";
			endif;
		$js .=	"breakpoints: {
				480: {
					slidesPerView: ".$columns_xs.",
				},
				768: {
					slidesPerView: ".$columns_sm.",
				},
				992: {
					slidesPerView: ".$columns.",
				}
			}
		});";

		if($navContainer):
		$js .= "const controls = document.querySelectorAll('#ut-clients-navigation-".$this->addon->id." > div[class*=\"ut-clients-nav-\"]');
		Array.prototype.forEach.call(controls, function (control) {
			document.querySelector('".$navContainer."').append(control);
		});";
		endif;
		$js .= "});";

		return $js;
	}
}
