<?php
/**
 * @package SP Page Builder
 * @author Unitemplates http://www.unitemplates.com
 * @version 1.9.0
 * @copyright Copyright (c) 2010 - 2020 Unitemplates
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted aceess');

class SppagebuilderAddonUt_person_carousel extends SppagebuilderAddons {

	public function render() {
		$settings = $this->addon->settings;
		$site_base = JURI::root(true); // For show images in live editor, in multilingual sites.
		$class = (isset($settings->class) && $settings->class) ? $settings->class : '';
		$info_position = (isset($settings->info_position) && $settings->info_position) ? $settings->info_position : '';
		$desc_position = (isset($settings->desc_position) && $settings->desc_position) ? $settings->desc_position : '';
		$social_position = (isset($settings->social_position) && $settings->social_position) ? $settings->social_position : '';
		$social_order = (isset($settings->social_order) && $settings->social_order) ? $settings->social_order : '';
		$social_target = (isset($settings->social_target) && $settings->social_target) ? ' target="_blank" rel="noopener"' : '';
		$person_class = (isset($settings->person_class) && $settings->person_class) ? $settings->person_class : '';
		$alignment 		= (isset($settings->alignment) && $settings->alignment) ? $settings->alignment : '';

		// dots and navs
		$dots = (isset($settings->dots) && $settings->dots) ? $settings->dots : '';
		$dotsContainer = ((isset($settings->dotsContainer) && $settings->dotsContainer)) ? $settings->dotsContainer : '';
		$nav = (isset($settings->nav) && $settings->nav) ? $settings->nav : '';
		$nav_text = (isset($settings->nav_text) && $settings->nav_text) ? $settings->nav_text : '';
		switch ($nav_text) {
			case '': $nav_class_left = ''; $nav_class_right = ''; break;
			case 'long-arrow': $nav_class_left = 'fas fa-'.$nav_text.'-alt-left'; $nav_class_right = 'fas fa-'.$nav_text.'-alt-right'; break;
			default: $nav_class_left = 'fas fa-'.$nav_text.'-left'; $nav_class_right = 'fas fa-'.$nav_text.'-right'; break;
		}
		$nav_class = ($nav_text != 'long-arrow') ? $nav_text : $nav_text.'-alt';
		$nav_text_prev = ($nav_text == '') ? JText::_('JPREV') : '';
		$nav_text_next = ($nav_text == '') ? JText::_('JNEXT') : '';
		$navContainer = ((isset($settings->navContainer) && $settings->navContainer)) ? $settings->navContainer : '';
		$interval = (isset($settings->interval) && $settings->interval) ? $settings->interval : 3000;

		//Output
		$output  = '<div class="sppb-addon ut-personcarousel '.$class.'">';
		$output .= '<div id="utPersonC-'.$this->addon->id.'" class="swiper-container">';
		$output .= '<div class="swiper-wrapper">';

		foreach ($settings->ut_person_carousel_item as $key => $value) {
			//Options
			$image 				= (isset($value->image) && $value->image) ? $value->image : '';
			$image_src			= isset($image->src) ? $image->src : $image;
			$name 				= (isset($value->name) && $value->name) ? $value->name : '';
			$designation 	= (isset($value->designation) && $value->designation) ? $value->designation : '';
			$email 				= (isset($value->email) && $value->email) ? $value->email : '';
			$url 				= (isset($value->url) && $value->url) ? $value->url : '';
			$introtext 		= (isset($value->introtext) && $value->introtext) ? $value->introtext : '';
			$facebook 		= (isset($value->facebook) && $value->facebook) ? $value->facebook : '';
			$twitter 			= (isset($value->twitter) && $value->twitter) ? $value->twitter : '';
			$youtube 			= (isset($value->youtube) && $value->youtube) ? $value->youtube : '';
			$linkedin 		= (isset($value->linkedin) && $value->linkedin) ? $value->linkedin : '';
			$pinterest 		= (isset($value->pinterest) && $value->pinterest) ? $value->pinterest : '';
			$flickr 			= (isset($value->flickr) && $value->flickr) ? $value->flickr : '';
			$dribbble 		= (isset($value->dribbble) && $value->dribbble) ? $value->dribbble : '';
			$behance 			= (isset($value->behance) && $value->behance) ? $value->behance : '';
			$instagram 		= (isset($value->instagram) && $value->instagram) ? $value->instagram : '';

			//Positions
			$after = '';
			$after .= $info_position=='after';
			$after .= $desc_position=='after';
			$after .= $social_position=='after';

			$overlay = '';
			$overlay .= $info_position=='overlay';
			$overlay .= $desc_position=='overlay';
			$overlay .= $social_position=='overlay';

			$social_icons = '';
			$person_info = '';
			$person_desc = '';

			if($name || $designation || $email) {
				$person_info  .= '<div class="person-information">';
				if($name && $url){
					$person_info  .= '<span class="person-name"><a href="'.$url.'">' . $name . '</a></span>';
				} elseif ($name) {
					$person_info  .= '<span class="person-name"> ' . $name . '</span>';
				}
				if($designation) $person_info  .= '<span class="person-designation">' . $designation . '</span>';
				if($email) $person_info  .= '<span class="person-email">' . $email . '</span>';
				$person_info  .= '</div>';
			}
			
			if($introtext) $person_desc  .= '<div class="person-description">' . $introtext . '</div>';

			if($facebook || $twitter || $youtube || $linkedin || $pinterest || $flickr || $dribbble || $behance || $instagram) {
				$social_icons  	.= '<div class="person-social-icons">';
				$social_icons 	.= '<ul class="person-social">';

				if($facebook) 		$social_icons .= '<li><a' . $social_target . ' href="' . $facebook . '" aria-label="facebook"><i class="fa fa-facebook"></i></a></li>';
				if($twitter) 		$social_icons .= '<li><a' . $social_target . ' href="' . $twitter . '" aria-label="twitter"><i class="fa fa-twitter"></i></a></li>';
				if($youtube) 		$social_icons .= '<li><a' . $social_target . ' href="' . $youtube . '" aria-label="twitter"><i class="fa fa-youtube"></i></a></li>';
				if($linkedin) 		$social_icons .= '<li><a' . $social_target . ' href="' . $linkedin . '" aria-label="youtube"><i class="fa fa-linkedin"></i></a></li>';
				if($pinterest)		$social_icons .= '<li><a' . $social_target . ' href="' . $pinterest . '" aria-label="linkedin"><i class="fa fa-pinterest"></i></a></li>';
				if($flickr) 		$social_icons .= '<li><a' . $social_target . ' href="' . $flickr . '" aria-label="pinterest"><i class="fa fa-flickr"></i></a></li>';
				if($dribbble) 		$social_icons .= '<li><a' . $social_target . ' href="' . $dribbble . '" aria-label="dribbble"><i class="fa fa-dribbble"></i></a></li>';
				if($behance) 		$social_icons .= '<li><a' . $social_target . ' href="' . $behance . '" aria-label="behance"><i class="fa fa-behance"></i></a></li>';
				if($instagram)		$social_icons .= '<li><a' . $social_target . ' href="' . $instagram . '" aria-label="instagram"><i class="fa fa-instagram"></i></a></li>';

				$social_icons 	.= '</ul>';
				$social_icons 	.= '</div>';
			}

			$output   .= '<div class="sppb-addon-content ut-personcarousel-item swiper-slide '.$alignment.'" data-swiper-autoplay="'.$interval.'">';
				$output  .= '<div class="sppb-addon ut-person '  . $person_class . '">';
				$output  .= '<div class="sppb-addon-content">';

					if($image_src) {
							$output  .= '<div class="person-image">';
							list($width, $height, $type, $attr) = getimagesize(JURI::root(). $image_src);
							$output  .= '<img class="sppb-img-responsive" src="' . $site_base .'/' . $image_src . '" alt="'. $name .'" loading="lazy" '.$attr.'>';

							if($overlay) {
								$output .= '<div class="person-overlay"><div class="person-overlay-inner">';
								if($social_position=='overlay' && $social_order=='before_info') $output .= $social_icons;
								if($info_position=='overlay') $output  .= $person_info;
								if($social_position=='overlay' && $social_order=='before_desc') $output .= $social_icons;
								if($desc_position=='overlay') $output  .= $person_desc;
								if($social_position=='overlay' && $social_order=='after_desc') $output .= $social_icons;
								$output .= '</div></div>';
							}

							$output  .= '</div>';
					}


					if($after) {
						$output .= '<div class="person-after">';
						if($social_position=='after' && $social_order=='before_info') $output .= $social_icons;
						if($info_position=='after') $output  .= $person_info;
						if($social_position=='after' && $social_order=='before_desc') $output .= $social_icons;
						if($desc_position=='after') $output  .= $person_desc;
						if($social_position=='after' && $social_order=='after_desc') $output .= $social_icons;
						$output .= '</div>';
					}

				$output  .= '</div>';
				$output  .= '</div>';
			$output  .= '</div>';
		}
		$output	.= '</div>';
		$output	.= '</div>';

		if ($nav == 'true'){
			$output .= '<div id="utPersonC-navigation-'.$this->addon->id.'" class="ut-personcarousel-navigation swiper-navigation">';
			$output .= '<div id="utPersonC-nav-prev-'.$this->addon->id.'" class="utPersonC-nav-prev '.$nav_class_left.'">'.$nav_text_prev.'</div>';
			$output .= '<div id="utPersonC-nav-next-'.$this->addon->id.'" class="utPersonC-nav-next '.$nav_class_right.'">'.$nav_text_next.'</div>';
			$output .= '</div>';
		}
		$output	 .= ($dots == 'true' && $dotsContainer == '') ? '<div id="utPersonC-dots-'.$this->addon->id.'" class="swiper-pagination"></div>' : '';

		$output	.= '</div>';
		return $output;

	}

	public function css() {
		$settings = $this->addon->settings;
		$addon_id = '#sppb-addon-' . $this->addon->id;

		// columns for live editor
		$margin = (isset($settings->margin) && $settings->margin) ? $settings->margin.'px' : '30px';
		$width_lg = (isset($settings->columns) && $settings->columns) ? 'width:calc('.(100 / $settings->columns).'% - '.$margin.');' : 'width:calc(33.333333% - '.$margin.');';
		$width_sm = (isset($settings->columns_sm) && $settings->columns_sm) ? 'width:calc('.(100 / $settings->columns_sm).'% - '.$margin.');' : 'width:calc(50% - '.$margin.');';
		$width_xs = (isset($settings->columns_xs) && $settings->columns_xs) ? 'width:calc('.(100 / $settings->columns_xs).'% - '.$margin.');' : 'width:calc(100% - '.$margin.');';		

		$css = '';
		$css .= $addon_id.' .swiper-container:not(.swiper-container-initialized){margin-right:-'.$margin.';}';
		$css .= '@media (min-width:992px){'.$addon_id.' .swiper-container:not(.swiper-container-initialized) .swiper-slide{'.$width_lg.'margin-right:'.$margin.';}}';
		$css .= '@media (min-width:768px) and (max-width:991.98px){'.$addon_id.' .swiper-container:not(.swiper-container-initialized) .swiper-slide{'.$width_sm.'margin-right:'.$margin.';}}';
		$css .= '@media (max-width:767.98px){'.$addon_id.' .swiper-container:not(.swiper-container-initialized) .swiper-slide{'.$width_xs.'margin-right:'.$margin.';}}';

		return $css;
	}

	public function stylesheets(){
		$app = JFactory::getApplication();
		$template = $app->getTemplate();
		$template_path = JURI::base(true) . '/templates/' . $template;
		$cssfiles = array($template_path.'/js/ut_assets/swiper/swiper-bundle.min.css');
		return $cssfiles;
	}

	public function scripts(){
		$app = JFactory::getApplication();
		$template = $app->getTemplate();
		$template_path = JURI::base(true) . '/templates/' . $template;
		return array($template_path.'/js/ut_assets/swiper/swiper-bundle.min.js');
	}

	public function js(){
		$settings = $this->addon->settings;
		$columns = (isset($settings->columns) && $settings->columns) ? $settings->columns : '3';
		$columns_sm = (isset($settings->columns_sm) && $settings->columns_sm) ? $settings->columns_sm : '2';
		$columns_xs = (isset($settings->columns_xs) && $settings->columns_xs) ? $settings->columns_xs : '1';		
		$loop = (isset($settings->loop) && $settings->loop) ? $settings->loop : 'false';
		$autoplay = (isset($settings->autoplay) && $settings->autoplay) ? $settings->autoplay : 'false';
		$center = (isset($settings->center) && $settings->center) ? $settings->center : 'false';
		$dots = (isset($settings->dots) && $settings->dots) ? $settings->dots : 'false';
		$dotsContainer = ((isset($settings->dotsContainer) && $settings->dotsContainer)) ? $settings->dotsContainer : '#utPersonC-dots-'.$this->addon->id;
		$nav = (isset($settings->nav) && $settings->nav) ? $settings->nav : 'false';
		$nav_text = (isset($settings->nav_text) && $settings->nav_text) ? $settings->nav_text : '';
		$navContainer = ((isset($settings->navContainer) && $settings->navContainer)) ? $settings->navContainer : '';
		$margin = (isset($settings->margin) && $settings->margin) ? $settings->margin : 30;
		$speed = (isset($settings->speed) && $settings->speed) ? $settings->speed : 300;

		$js = "document.addEventListener('DOMContentLoaded', function(){
			var swiper".$this->addon->id." = new Swiper('#utPersonC-".$this->addon->id."', {
			loop: ".$loop.",
			autoplay: ".$autoplay.",
			speed: ".$speed.",
			slidesPerView: 1,
			centeredSlides: ".$center.",
			spaceBetween: ".$margin.",";
			if($dots) :
		$js .= "pagination: {
				el: '".$dotsContainer."',
				clickable: true,
			},";
			endif;
			if($nav) :
		$js .=	"navigation: {
				nextEl: '#utPersonC-nav-next-".$this->addon->id."',
				prevEl: '#utPersonC-nav-prev-".$this->addon->id."',
			},";
			endif;
		$js .=	"breakpoints: {
				480: {
					slidesPerView: ".$columns_xs.",
				},
				768: {
					slidesPerView: ".$columns_sm.",
				},
				992: {
					slidesPerView: ".$columns.",
				}
			}
		});";

		if($navContainer):
		$js .= "const controls = document.querySelectorAll('#utPersonC-navigation-".$this->addon->id." > div[class*=\"utPersonC-nav-\"]');
		Array.prototype.forEach.call(controls, function (control) {
			document.querySelector('".$navContainer."').append(control);
		});";
		endif;
		$js .= "});";

		return $js;
	}
}
