<?php
/**
 * @package SP Page Builder
 * @author Unitemplates http://www.unitemplates.com
 * @version 1.2.0
 * @copyright Copyright (c) 2010 - 2021 Unitemplates
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted access');

class SppagebuilderAddonUt_image_lazy extends SppagebuilderAddons{

	public function render() {
		$settings = $this->addon->settings;
		$class = (isset($settings->class) && $settings->class) ? $settings->class : '';
		$title = (isset($settings->title) && $settings->title) ? $settings->title : '';
		$title_pos = (isset($settings->title_position) && $settings->title_position) ? $settings->title_position : 'top';
		$heading_selector = (isset($settings->heading_selector) && $settings->heading_selector) ? $settings->heading_selector : 'h3';

		//Image Options
		$image = (isset($settings->image) && $settings->image) ? $settings->image : '';
		$image_src = isset($image->src) ? $image->src : $image;
		$alt_text = (isset($settings->alt_text) && $settings->alt_text) ? $settings->alt_text : '';
		$link = (isset($settings->link) && $settings->link) ? $settings->link : '';
		$target = (isset($settings->target) && $settings->target) ? 'rel="noopener noreferrer" target="' . $settings->target . '"' : '';
		$image_overlay = (isset($settings->overlay_color) && $settings->overlay_color) ? 1 : 0;
		$lazyload = (isset($settings->lazyload) && $settings->lazyload) ? $settings->lazyload : '';
		$image_lazy = (isset($settings->image_lazy) && $settings->image_lazy) ? $settings->image_lazy : '';
		$image_lazy_src = isset($image_lazy->src) ? $image_lazy->src : $image_lazy;

		//image wiidth & height attributes
		$w_h = '';
		if ($image_src) {
			$image_info = getimagesize(JPATH_ROOT.'/'.$image_src);
			$w_h .= ' width="'.$image_info[0].'"';
			$w_h .= ' height="'.$image_info[1].'"';
		}

		//IntersectionObserver
		$observer = (isset($settings->observer) && $settings->observer == 0) ? 0 : 1; // for load in older versions
		$template = JFactory::getApplication()->getTemplate();
		$doc = JFactory::getDocument();
		if(($observer) && $lazyload){
			$doc->addScript(JURI::base(true) . '/templates/'.$template.'/sppagebuilder/addons/ut_image_lazy/assets/js/yall.min.js');
			$doc->addScript('https://polyfill.io/v2/polyfill.min.js?features=IntersectionObserver');
			$doc->addScriptDeclaration('document.addEventListener("DOMContentLoaded", yall)');
		}

		// Description Options
		$description 		= (isset($settings->description) && $settings->description) ? $settings->description : '';
		$desc_pos = (isset($settings->description_position) && $settings->description_position) ? $settings->description_position : 'top';

		// Button Options
        $btn_class = (isset($settings->button_type) && $settings->button_type) ? ' sppb-btn-' . $settings->button_type : '';
        $btn_class .= (isset($settings->button_size) && $settings->button_size) ? ' sppb-btn-' . $settings->button_size : '';
        $btn_class .= (isset($settings->button_block) && $settings->button_block) ? ' ' . $settings->button_block : '';
        $btn_class .= (isset($settings->button_shape) && $settings->button_shape) ? ' sppb-btn-' . $settings->button_shape : ' sppb-btn-rounded';
        $btn_class .= (isset($settings->button_appearance) && $settings->button_appearance) ? ' sppb-btn-' . $settings->button_appearance : '';
        $btn_attribs = (isset($settings->button_target) && $settings->button_target) ? ' rel="noopener noreferrer" target="' . $settings->button_target . '"' : '';
        $btn_attribs .= (isset($settings->button_url) && $settings->button_url) ? ' href="' . $settings->button_url . '"' : '';
        $btn_attribs .= ' id="btn-' . $this->addon->id . '"';
        $btn_text = (isset($settings->button_text) && $settings->button_text) ? $settings->button_text : '';
        $btn_icon = (isset($settings->button_icon) && $settings->button_icon) ? $settings->button_icon : '';
        $btn_icon_position = (isset($settings->button_icon_position) && $settings->button_icon_position) ? $settings->button_icon_position : 'left';
		$btn_pos = (isset($settings->button_position) && $settings->button_position) ? $settings->button_position : 'top';

		$content_col_md = (isset($settings->content_col_md) && $settings->content_col_md) ? $settings->content_col_md : '6';
		$content_col_sm = (isset($settings->content_col_sm) && $settings->content_col_sm) ? $settings->content_col_sm : '12';
		$content_col_xs = (isset($settings->content_col_xs) && $settings->content_col_xs) ? $settings->content_col_xs : '12';
		$alignment = (isset($settings->alignment) && $settings->alignment) ? $settings->alignment : '';
		$middle_alignment = (isset($settings->middle_alignment) && $settings->middle_alignment) ? 'align-items-center' : '';

		// Parts of output
		$title_text = ($link) ? '<a href="' . $link . '" ' . $target . '>' : '';
		$title_text .= $title;
		$title_text .= ($link) ? '</a>' : '';
		$the_title = ($title) ? '<'.$heading_selector.' class="sppb-addon-title">' . $title_text . '</'.$heading_selector.'>' : '';

		$the_description = ($description) ? '<div class="imagelazy-description">' . $description . '</div>' : '';
		
		if ($btn_icon_position == 'left') {
            $btntext = ($btn_icon) ? '<i class="fa ' . $btn_icon . '" aria-hidden="true"></i> ' . $btn_text : $btn_text;
        } else {
            $btntext = ($btn_icon) ? $btn_text . ' <i class="fa ' . $btn_icon . '" aria-hidden="true"></i>' : $btn_text;
        }
        $the_button = ($btn_text) ?'<div class="imagelazy-button"><a' . $btn_attribs . ' class="sppb-btn ' . $btn_class . '">' . $btntext . '</a></div>' : '';

        if ($lazyload && $image_lazy_src) {
        	$the_image = '<img class="sppb-img-responsive lazy" src="' . $image_lazy_src . '" data-src="' . $image_src . '" alt="'. $alt_text .'"'.$w_h.'>';
        } else{
        	$the_image = '<img class="sppb-img-responsive" src="' . $image_src . '" alt="'. $alt_text .'" loading="lazy"'.$w_h.'>';
        }

		//Positions
		$top = (($title_pos=='top' && $title!='') || ($desc_pos=='top' && $description!='') || ($btn_pos=='top' && $btn_text!=''));

		$right = (($title_pos=='right' && $title!='') || ($desc_pos=='right' && $description!='') || ($btn_pos=='right' && $btn_text!=''));

		$bottom = (($title_pos=='bottom' && $title!='') || ($desc_pos=='bottom' && $description!='') || ($btn_pos=='bottom' && $btn_text!=''));

		$left = (($title_pos=='left' && $title!='') || ($desc_pos=='left' && $description!='') || ($btn_pos=='left' && $btn_text!=''));

		$overlay = (($title_pos=='overlay' && $title!='') || ($desc_pos=='overlay' && $description!='') || ($btn_pos=='overlay' && $btn_text!=''));

		// Left nad right columns
		$image_col = '';
		$content_col = '';
		if ($right || $left) {
			$image_col .= ($content_col_md && $content_col_md < 12) ? ' sppb-col-md-'. (12 - $content_col_md) : ' sppb-col-md-12';
			$image_col .= ($content_col_sm && $content_col_sm < 12) ? ' sppb-col-sm-'. (12 - $content_col_sm) : ' sppb-col-sm-12';
			$image_col .= ($content_col_xs && $content_col_xs < 12) ? ' sppb-col-xs-'. (12 - $content_col_xs) : ' sppb-col-xs-12';
			$content_col .= ($content_col_md) ? ' sppb-col-md-'. $content_col_md : 'sppb-col-md-12';
			$content_col .= ($content_col_sm) ? ' sppb-col-sm-'. $content_col_sm : 'sppb-col-sm-12';
			$content_col .= ($content_col_xs) ? ' sppb-col-xs-'. $content_col_xs : 'sppb-col-xs-12';
		}

		$output = '';

		$output  .= '<div class="sppb-addon ut-addon-imagelazy ' . $alignment . ' ' . $class . '">';
		$output  .= '<div class="sppb-addon-content">';
		$output .= '<div class="row ' . $middle_alignment . '">';

			if($top) {
				$output .= '<div class="imagelazy-top sppb-col-xs-12">';
				if($title_pos=='top') $output .= $the_title;
				if($desc_pos=='top') $output  .= $the_description;
				if($btn_pos=='top') $output .= $the_button;
				$output .= '</div>';
			}

			if($left) {
				$output .= '<div class="imagelazy-left'.$content_col.'">';
				if($title_pos=='left') $output .= $the_title;
				if($desc_pos=='left') $output  .= $the_description;
				if($btn_pos=='left') $output .= $the_button;
				$output .= '</div>';
			}

			if($image_src) {
				$output  .= '<div class="imagelazy-image  sppb-col' . $image_col . '">';
				$output .= '<div class="imagelazy-image-ct">';
					if($link) $output .= '<a href="' . $link . '" ' . $target . '>';
						$output  .= $the_image;
					if($link) $output .= '</a>';

					if($overlay) {
						$output .= '<div class="imagelazy-overlay"><div class="imagelazy-overlay-inner">';
						if($title_pos=='overlay') $output .= $the_title;
						if($desc_pos=='overlay') $output  .= $the_description;
						if($btn_pos=='overlay') $output .= $the_button;
						$output .= '</div></div>';
					}
				$output  .= '</div>';
				$output  .= '</div>';
			}

			if($right) {
				$output .= '<div class="imagelazy-right'.$content_col.'">';
				if($title_pos=='right') $output .= $the_title;
				if($desc_pos=='right') $output  .= $the_description;
				if($btn_pos=='right') $output .= $the_button;
				$output .= '</div>';
			}

			if($bottom) {
				$output .= '<div class="imagelazy-bottom sppb-col-xs-12">';
				if($title_pos=='bottom') $output .= $the_title;
				if($desc_pos=='bottom') $output  .= $the_description;
				if($btn_pos=='bottom') $output .= $the_button;
				$output .= '</div>';
			}
		$output .= '</div>';
		$output  .= '</div>';
		$output  .= '</div>';
		return $output;
	}

	public function css(){
		$addon_id = '#sppb-addon-' . $this->addon->id;
		$settings = $this->addon->settings;
		$overlay_color = (isset($settings->overlay_color) && $settings->overlay_color) ? 'background-color: ' . $settings->overlay_color . ';' : '';
		$style_img = (isset($settings->border_radius) && $settings->border_radius) ? 'border-radius: ' . $settings->border_radius . 'px;' : '';
		$title_padding = (isset($settings->title_padding) && trim($settings->title_padding)) ? $settings->title_padding : '';
		$title_text_color = (isset($settings->title_text_color) && trim($settings->title_text_color)) ? $settings->title_text_color : '';
		$desc_fontsize = (isset($settings->description_fontsize) && trim($settings->description_fontsize)) ? $settings->description_fontsize : '';
		$desc_color = (isset($settings->description_color) && trim($settings->description_color)) ? $settings->description_color : '';
		$button_icon_margin = (isset($settings->button_icon_margin) && trim($settings->button_icon_margin)) ? $settings->button_icon_margin : '';

		$css = '';
		$css .= $addon_id . ' .imagelazy-image-ct{' . $style_img . '}';
		$css .= $addon_id . ' img{' . $style_img . '}';

		$css .= ($title_padding) ? $addon_id . ' .sppb-addon-title{padding: ' . $title_padding . ';}' : '';
		$css .= ($button_icon_margin) ? $addon_id . ' .sppb-btn i{margin: ' . $button_icon_margin . ';}' : '';
		$css .= ($title_text_color) ? $addon_id . ' .sppb-addon-title a{color: ' . $title_text_color . ';}' : '';
		$css .= ($desc_fontsize) ? $addon_id . ' .imagelazy-description{font-size: ' . $desc_fontsize . 'px;}' : '';
		$css .= ($desc_color) ? $addon_id . ' .imagelazy-description {color: ' . $desc_color . ';}' : '';
		$css .= ($overlay_color) ? $addon_id . ' .imagelazy-overlay{' .$overlay_color . '}' : '';
		$css .= ($overlay_color) ? $addon_id . ' .imagelazy-image-ct > a:after{' .$overlay_color . '}' : '';

		return $css;
	}

	public static function getTemplate(){
		$output = '
		<#
		var image = {}
		if (typeof data.image !== "undefined" && typeof data.image.src !== "undefined") {
			image = data.image
		} else {
			image = {src: data.image}
		}

		var btn_class = "";
		btn_class += (data.button_type) ? \' sppb-btn-\' + data.button_type : "";
        btn_class += (data.button_size) ? \' sppb-btn-\' + data.button_size : "";
        btn_class += (data.button_block) ? \' \' + data.button_block : "";
        btn_class += (data.button_shape) ? \' sppb-btn-\' + data.button_shape : " sppb-btn-rounded";
        btn_class += (data.button_appearance) ? \' sppb-btn-\' + data.button_appearance : "";

        var btn_attribs = "";
        btn_attribs += (data.button_target) ? \' rel="noopener noreferrer" target="\' + data.button_target + \'"\' : "";
        btn_attribs += (data.button_url) ? \' href="\' + data.button_url + \'"\' : "";
        btn_attribs += \' id="btn-\' + data.id + \'"\';

        var title_text = "";
		title_text += (data.link) ? \'<a href="\' + data.link + \'" target="\' + data.target + \'">\' : "";
		title_text += data.title;
		title_text += (data.link) ? \'</a>\' : "";
		var the_title = (data.title) ? \'<\' + data.heading_selector + \' class="sppb-addon-title">\' + title_text + \'</\' + data.heading_selector + \'>\' : "";
		var the_description = (data.description) ? \'<div class="imagelazy-description">\' + data.description + \'</div>\' : "";
		
		var btntext = "";
		if (data.button_icon_position == "left") {
            btntext = (data.button_icon) ? \'<i class="fa \' + data.button_icon + \'" aria-hidden="true"></i> \' + data.button_text : data.button_text;
        } else {
            btntext = (data.button_icon) ? data.button_text + \' <i class="fa \' + data.button_icon + \'" aria-hidden="true"></i>\' : data.button_text;
        }
        var the_button = (data.button_text) ? \'<div class="imagelazy-button"><a\' + btn_attribs + \' class="sppb-btn \' + btn_class + \'">\' + btntext + \'</a></div>\' : "";

		 var top = ((data.title!="" && data.title_position=="top") || (data.description!="" && data.description_position=="top") || (data.button_text!="" && data.button_position=="top"));

		var right = ((data.title!="" && data.title_position=="right") || (data.description!="" && data.description_position=="right") || (data.button_text!="" && data.button_position=="right"));

		var bottom = ((data.title!="" && data.title_position=="bottom") || (data.description!="" && data.description_position=="bottom") || (data.button_text!="" && data.button_position=="bottom"));

		var left = ((data.title!="" && data.title_position=="left") || (data.description!="" && data.description_position=="left") || (data.button_text!="" && data.button_position=="left"));

		var overlay = ((data.title!="" && data.title_position=="overlay") || (data.description!="" && data.description_position=="overlay") || (data.button_text!="" && data.button_position=="overlay"));

		var image_col = "";
		var content_col = "";
		if (right || left) {
			image_col += (data.content_col_md && data.content_col_md < 12) ? \' sppb-col-md-\' + (12 - data.content_col_md) : " sppb-col-md-12";
			image_col += (data.content_col_sm && data.content_col_sm < 12) ? \' sppb-col-sm-\' + (12 - data.content_col_sm) : " sppb-col-sm-12";
			image_col += (data.content_col_xs && data.content_col_xs < 12) ? \' sppb-col-xs-\' + (12 - data.content_col_xs) : " sppb-col-xs-12";
			content_col += (data.content_col_md) ? \' sppb-col-md-\' + data.content_col_md : " sppb-col-md-12";
			content_col += (data.content_col_sm) ? \' sppb-col-sm-\' + data.content_col_sm : " sppb-col-sm-12";
			content_col += (data.content_col_xs) ? \' sppb-col-xs-\' + data.content_col_xs : " sppb-col-xs-12";
		}

		var middle_alignment = (data.middle_alignment) ? \'align-items-center\' : "";
		#>
		<style type="text/css">
			#sppb-addon-{{ data.id }} .imagelazy-image-ct,
			#sppb-addon-{{ data.id }} img{border-radius: {{ data.border_radius }}px;}
			<# if(data.title_padding) { #> #sppb-addon-{{ data.id }} .sppb-addon-title{padding: {{data.title_padding}};} <# } #>
			<# if(data.button_icon_margin) { #> #sppb-addon-{{ data.id }} .sppb-btn i{margin: {{data.button_icon_margin}};} <# } #>
			<# if(data.title_text_color) { #> #sppb-addon-{{ data.id }} .sppb-addon-title a{color: {{data.title_text_color}};} <# } #>
			<# if(data.description_fontsize) { #> #sppb-addon-{{ data.id }} .imagelazy-description{font-size: {{data.description_fontsize}}px;} <# } #>
			<# if(data.description_color) { #> #sppb-addon-{{ data.id }} .imagelazy-description{color: {{data.description_color}};} <# } #>
			<# if(data.overlay_color) { #> #sppb-addon-{{ data.id }} .imagelazy-overlay{background-color: {{data.overlay_color}};} <# } #>
			<# if(data.overlay_color) { #> #sppb-addon-{{ data.id }} .imagelazy-image-ct > a:after{background-color: {{data.overlay_color}};} <# } #>
		</style>

		<div class="sppb-addon ut-addon-imagelazy {{ data.alignment }} {{ data.class }}">
		<div class="sppb-addon-content">
		<div class="row {{ middle_alignment }}">

			<# if(top) { #>
				<div class="imagelazy-top sppb-col-xs-12">
				<# if(data.title_position=="top") { #>
					{{{ the_title }}}
				<# } #>
				<# if(data.description_position=="top") { #>
					{{{ the_description }}}
				<# } #>
				<# if(data.button_position=="top") { #>
					{{{ the_button }}}
				<# } #>
				</div>
			<# } #>

			<# if(left) { #>
				<div class="imagelazy-left {{ content_col }}">
				<# if(data.title_position=="left") { #>
					{{{ the_title }}}
				<# } #>
				<# if(data.description_position=="left") { #>
					{{{ the_description }}}
				<# } #>
				<# if(data.button_position=="left") { #>
					{{{ the_button }}}
				<# } #>
				</div>
			<# } #>

			<# if(image.src) { #>
				<div class="imagelazy-image  sppb-col {{ image_col }}">
				<div class="imagelazy-image-ct">
					<# if(data.link) { #>
						<a href="{{ data.link }}" target="{{ data.target }}">
					<# } #>
						<img class="sppb-img-responsive" src={{{ image.src }}} alt="{{ data.alt_text }}">
					<# if(data.link) { #>
						</a>
					<# } #>

					<# if(overlay) { #>
						<div class="imagelazy-overlay"><div class="imagelazy-overlay-inner">
						<# if(data.title_position=="overlay") { #>
							{{{ the_title }}}
						<# } #>
						<# if(data.description_position=="overlay") { #>
							{{{ the_description }}}
						<# } #>
						<# if(data.button_position=="overlay") { #>
							{{{ the_button }}}
						<# } #>
						</div></div>
					<# } #>
				</div>
				</div>
			<# } #>

			<# if(right) { #>
				<div class="imagelazy-right {{ content_col }}">
				<# if(data.title_position=="right") { #>
					{{{ the_title }}}
				<# } #>
				<# if(data.description_position=="right") { #>
					{{{ the_description }}}
				<# } #>
				<# if(data.button_position=="right") { #>
					{{{ the_button }}}
				<# } #>
				</div>
			<# } #>

			<# if(bottom) { #>
				<div class="imagelazy-bottom sppb-col-xs-12">
				<# if(data.title_position=="bottom") { #>
					{{{ the_title }}}
				<# } #>
				<# if(data.description_position=="bottom") { #>
					{{{ the_description }}}
				<# } #>
				<# if(data.button_position=="bottom") { #>
					{{{ the_button }}}
				<# } #>
				</div>
			<# } #>
		</div>
		</div>
		</div>
		';
		return $output;
	}
}
