<?php
/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @version 1.0.0
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('Restricted access');

class SppagebuilderAddonUt_animated_number extends SppagebuilderAddons{

	public function render() {
		$settings = $this->addon->settings;

		$number = (isset($settings->number) && $settings->number) ? $settings->number : 0;
		$duration = (isset($settings->duration) && $settings->duration) ? $settings->duration : 0;
		$counter_title = (isset($settings->counter_title) && $settings->counter_title) ? $settings->counter_title : '';
		$title_position = (isset($settings->title_position) && $settings->title_position) ? $settings->title_position : 'after';
		$icon_font = (isset($settings->icon_font) && $settings->icon_font) ? $settings->icon_font : '';
		$custom_icon = (isset($settings->custom_icon) && $settings->custom_icon) ? $settings->custom_icon : '';
		$icon_position = (isset($settings->icon_position) && $settings->icon_position) ? $settings->icon_position : 'top';
		$icon_padding = (isset($settings->icon_padding) && $settings->icon_padding) ? $settings->icon_padding : '';
		$alignment = (isset($settings->alignment) && $settings->alignment) ? $settings->alignment : '';
		$class = (isset($settings->class) && $settings->class) ? $settings->class : '';

		// Positions
		if($icon_position == 'top'){
			$position = ' top';
		} elseif ($icon_position == 'right') {
			$position = ' pull-right right';
		} elseif ($icon_position == 'bottom') {
			$position = ' bottom';
		} elseif ($icon_position == 'left') {
			$position = ' pull-left left';
		} else{
			$position = '';
		}

		if($custom_icon){
			$icon = '<div class="icon-container'.$position.'"><i class="'.$custom_icon.'"></i></div>';
		} elseif ($icon_font) {
			$icon = '<div class="icon-container'.$position.'"><i class="fa '.$icon_font.'"></i></div>';
		} else{
			$icon = '';
		}

		// Output
		$output  = '<div class="sppb-addon ut-addon-animated-number '. $alignment . ' ' . $class .'">';
		$output .= '<div class="sppb-addon-content">';
		if($icon && $icon_position != 'bottom'){
			$output .= $icon;
		}

		$output .= '<div class="number-container">';
		if($counter_title && $title_position != 'after') {
			$output .= '<div class="sppb-animated-number-title">' . $counter_title . '</div>';
		}
		$output .= '<div class="sppb-animated-number" data-digit="'. $number .'" data-duration="' . $duration . '">0</div>';
		if($counter_title && $title_position == 'after') {
			$output .= '<div class="sppb-animated-number-title">' . $counter_title . '</div>';
		}
		$output .= '</div>';
		if($icon && $icon_position == 'bottom'){
			$output .= $icon;
		}
		$output .= '</div>';
		$output .= '</div>';

		return $output;
	}

	public function css() {
		$addon_id = '#sppb-addon-' . $this->addon->id;
		$settings = $this->addon->settings;
		//Number Style
		$number_style = '';
		$number_style .= (isset($settings->color) && $settings->color) ? 'color:' . $settings->color  . ';' : '';
		$number_style .= (isset($settings->font_size) && $settings->font_size) ? 'font-size:' . (int) $settings->font_size . 'px;' : '';
		$number_style .= (isset($settings->line_height) && $settings->line_height) ? 'line-height:' . (int) $settings->line_height . 'px;' : '';
		$number_style .= (isset($settings->font_weight) && trim($settings->font_weight)) ? 'font-weight:' . (int) $settings->font_weight . ';' : '';
		$number_style .= (isset($settings->margin) && trim($settings->margin)) ? 'margin:' . $settings->margin . ';' : '';
		//Number Tablet Style
		$number_style_sm  = '';
		$number_style_sm .= (isset($settings->font_size_sm) && $settings->font_size_sm) ? 'font-size:' . (int) $settings->font_size_sm . 'px;' : '';
		$number_style_sm .= (isset($settings->line_height_sm) && $settings->line_height_sm) ? 'line-height:' . (int) $settings->line_height_sm . 'px;' : '';
		//Number Mobile Style
		$number_style_xs  = '';
		$number_style_xs .= (isset($settings->font_size_xs) && $settings->font_size_xs) ? 'font-size:' . (int) $settings->font_size_xs . 'px;' : '';
		$number_style_xs .= (isset($settings->line_height_xs) && $settings->line_height_xs) ? 'line-height:' . (int) $settings->line_height_xs . 'px;' : '';
		//Text Style
		$text_style = '';
		$text_style_sm = '';
		$text_style_xs = '';

		$text_style .= (isset($settings->title_font_size) && $settings->title_font_size) ? 'font-size:' . (int) $settings->title_font_size . 'px;': '';
		$text_style .= (isset($settings->title_line_height) && $settings->title_line_height) ? 'line-height:' . (int) $settings->title_line_height . 'px;': '';
		$text_style .= (isset($settings->title_color) && $settings->title_color) ? 'color:' . $settings->title_color . ';': '';
		$text_style .= (isset($settings->title_margin) && trim($settings->title_margin)) ? 'margin:' . $settings->title_margin . ';': '';
		$text_style .= (isset($settings->title_font_weight) && trim($settings->title_font_weight)) ? 'font-weight:' . $settings->title_font_weight . ';': '';

		//Title tablet style
		$text_style_sm .= (isset($settings->title_font_size_sm) && $settings->title_font_size_sm) ? 'font-size:' . (int) $settings->title_font_size_sm . 'px;': '';
		$text_style_sm .= (isset($settings->title_line_height_sm) && $settings->title_line_height_sm) ? 'line-height:' . (int) $settings->title_line_height_sm . 'px;': '';
		$text_style_sm .= (isset($settings->title_margin_sm) && $settings->title_margin_sm) ? 'margin:' . $settings->title_margin_sm . ';' : '';
		//Title mobile style
		$text_style_xs .= (isset($settings->title_font_size_xs) && $settings->title_font_size_xs) ? 'font-size:' . (int) $settings->title_font_size_xs . 'px;': '';
		$text_style_xs .= (isset($settings->title_line_height_xs) && $settings->title_line_height_xs) ? 'line-height:' . (int) $settings->title_line_height_xs . 'px;': '';
		$text_style_xs .= (isset($settings->title_margin_xs) && $settings->title_margin_xs) ? 'margin:' . $settings->title_margin_xs . ';' : '';

		// Icon
		$icon_size = (isset($settings->icon_size) && $settings->icon_size) ? $settings->icon_size : '';
		$icon_color = (isset($settings->icon_color) && $settings->icon_color) ? $settings->icon_color : '';
		$icon_background = (isset($settings->icon_background) && $settings->icon_background) ? $settings->icon_background : '';
		$icon_border_radius = (isset($settings->icon_border_radius) && $settings->icon_border_radius) ? $settings->icon_border_radius : '';
		


		$container_style = '';
		$container_style .= (isset($icon_background) && $icon_background) ? 'background-color:'.$icon_background.';' : '';
		$container_style .= (isset($icon_border_radius) && $icon_border_radius) ? 'border-radius:'.(int)$icon_border_radius.'px;' : '';
		$container_style .= (isset($settings->icon_padding) && trim($settings->icon_padding)) ? 'padding:'.$settings->icon_padding.';' : '';


		$container_style_sm = '';
		$container_style_sm .= (isset($settings->icon_padding_sm) && trim($settings->icon_padding_sm)) ? 'padding:'.$settings->icon_padding_sm.';' : '';

		$container_style_xs = '';
		$container_style_xs .= (isset($settings->icon_padding_xs) && trim($settings->icon_padding_xs)) ? 'padding:'.$settings->icon_padding_xs.';' : '';

		$icon_style ='';
		$icon_style	.= (isset($settings->icon_color) && $settings->icon_color) ? 'color:' .$settings->icon_color. ';' : '';
		$icon_style .= (isset($icon_size) && $icon_size) ? 'font-size: '. (int) $icon_size. 'px;width: '. (int) $icon_size. 'px;height:'.(int) $icon_size.'px;line-height:'. (int) $icon_size.'px;' : '';

		$icon_style_sm ='';
		$icon_style_sm .= (isset($settings->icon_size_sm) && $settings->icon_size_sm) ? 'font-size: '. (int) $settings->icon_size_sm. 'px;width: '. (int) $settings->icon_size_sm. 'px;height:'.(int) $settings->icon_size_sm.'px;line-height:'. (int) $settings->icon_size_sm.'px;' : '';

		$icon_style_xs ='';
		$icon_style_xs .= (isset($settings->icon_size_xs) && $settings->icon_size_xs) ? 'font-size: '. (int) $settings->icon_size_xs. 'px;width: '. (int) $settings->icon_size_xs. 'px;height:'.(int) $settings->icon_size_xs.'px;line-height:'. (int) $settings->icon_size_xs.'px;' : '';


		$number_before_after_text = (isset($settings->number_before_after_text) && $settings->number_before_after_text) ? $settings->number_before_after_text : '';
		$number_before_after_text_position = (isset($settings->number_before_after_text_position) && $settings->number_before_after_text_position) ? $settings->number_before_after_text_position : '';
		//Css output start
		$css = '';
		
		if($number_before_after_text_position == 'right'){
			if($number_before_after_text) {
				$css .= $addon_id . ' .sppb-animated-number::after {';
				$css .= 'content:"'.$number_before_after_text.'";';
				$css .= 'display: inline-block;';
				$css .= '}';
			}
		} else {
			if($number_before_after_text) {
				$css .= $addon_id . ' .sppb-animated-number::before {';
				$css .= 'content:"'.$number_before_after_text.'";';
				$css .= 'display: inline-block;';
				$css .= '}';
			}
		}
		if($number_style) {
			$css .= $addon_id . ' .sppb-animated-number {';
			$css .= $number_style;
			$css .= '}';
		}

		if($text_style) {
			$css .= $addon_id . ' .sppb-animated-number-title {';
			$css .= $text_style;
			$css .= '}';
		}

		if($container_style){
			$css .= $addon_id.' .icon-container {';
			$css .= $container_style;
			$css .= '}';
		}

		if($icon_style){
			$css .= $addon_id.' .icon-container i{';
			$css .= $icon_style;
			$css .= '}';
		}

		$css .= '@media (min-width: 768px) and (max-width: 991px) {';
			if($number_style_sm) {
				$css .= $addon_id . ' .sppb-animated-number {';
					$css .= $number_style_sm;
				$css .= '}';
			}

			if($text_style_sm) {
				$css .= $addon_id . ' .sppb-animated-number-title {';
					$css .= $text_style_sm;
				$css .= '}';
			}

			if($container_style_sm){
				$css .= $addon_id.' .icon-container {';
				$css .= $container_style_sm;
				$css .= '}';
			}

			if($icon_style_sm){
				$css .= $addon_id.' .icon-container i{';
				$css .= $icon_style_sm;
				$css .= '}';
			}
		$css .= '}';

		$css .= '@media (max-width: 767px) {';
			if($number_style_xs) {
				$css .= $addon_id . ' .sppb-animated-number {';
					$css .= $number_style_xs;
				$css .= '}';
			}

			if($text_style_xs) {
				$css .= $addon_id . ' .sppb-animated-number-title {';
					$css .= $text_style_xs;
				$css .= '}';
			}

			if($container_style_xs){
				$css .= $addon_id.' .icon-container {';
				$css .= $container_style_xs;
				$css .= '}';
			}

			if($icon_style_xs){
				$css .= $addon_id.' .icon-container i{';
				$css .= $icon_style_xs;
				$css .= '}';
			}
		$css .= '}';

		return $css;
	}

	public static function getTemplate(){
		$output = '
		<#
			var addonId = "sppb-addon-"+data.id;

			var position = "";
			if(data.icon_position == "top"){
				position = " top";
			} else if (data.icon_position == "right") {
				position = " pull-right right";
			} else if (data.icon_position == "bottom") {
				position = " bottom";
			} else if (data.icon_position == "left") {
				position = " pull-left left";
			}

			var icon ="";
			if(data.custom_icon){
				icon = \'<div class="icon-container\'+position+\'"><i class="\'+data.custom_icon+\'"></i></div>\';
			} else if(data.icon_font) {
				icon = \'<div class="icon-container\'+position+\'"><i class="fa \'+data.icon_font+\'"></i></div>\';
			}
			var padding = window.getMarginPadding(data.icon_padding, "padding");
		#>

		<style type="text/css">
			<# if(data.number_before_after_text_position == "right") { #>
				#{{ addonId }} .sppb-animated-number::after{
					content:"{{data.number_before_after_text}}";
				}
			<# } else { #>
				#{{ addonId }} .sppb-animated-number::before{
					content:"{{data.number_before_after_text}}";
				}
			<# } #>
			#{{ addonId }} .sppb-animated-number{
				color: {{ data.color }};
				margin: {{ data.margin }};
				font-weight: {{ data.font_weight }};
				<# if(_.isObject(data.font_size)){ #>
					font-size: {{ data.font_size.md }}px;
				<# } else { #>
					font-size: {{ data.font_size }}px;
				<# }
				if(_.isObject(data.line_height)){ #>
					line-height: {{ data.line_height.md }}px;
				<# } else { #>
					line-height: {{ data.line_height }}px;
				<# } #>
			}
			#{{ addonId }} .sppb-animated-number-title{
				color: {{ data.title_color }};
				font-weight: {{ data.title_font_weight }};
				<# if(_.isObject(data.title_font_size)){ #>
					font-size: {{ data.title_font_size.md }}px;
				<# } else { #>
					font-size: {{ data.title_font_size }}px;
				<# }
				if(_.isObject(data.title_line_height)){ #>
					line-height: {{ data.title_line_height.md }}px;
				<# } else { #>
					line-height: {{ data.title_line_height }}px;
				<# }
				if(_.isObject(data.title_margin)){ #>
					margin: {{ data.title_margin.md }};
				<# } #>
			}

			#{{ addonId }} .icon-container{
				background-color: {{ data.icon_background }};
				border-radius: {{ data.icon_border_radius }}px;
				<# if(_.isObject(padding)){ #>
					{{ padding.md }}
				<# } #>
			}

			#{{ addonId }} .icon-container i{
				<# if (_.isObject(data.icon_size))	{ #>
					font-size: {{ data.icon_size.md }}px;
					width: {{ data.icon_size.md }}px;
					height: {{ data.icon_size.md }}px;
					line-height: {{ data.icon_size.md }}px;
				<# } else { #>
					font-size: {{ data.icon_size }}px;
					width: {{ data.icon_size }}px;
					height: {{ data.icon_size }}px;
					line-height: {{ data.icon_size }}px;
				<# } #>
				color: {{ data.icon_color }};
			}

			@media (min-width: 768px) and (max-width: 991px) {
				#{{ addonId }} .sppb-animated-number{
					<# if(_.isObject(data.font_size)){ #>
						font-size: {{ data.font_size.sm }}px;
					<# }
					if(_.isObject(data.line_height)){ #>
						line-height: {{ data.line_height.sm }}px;
					<# } #>
				}
				#{{ addonId }} .sppb-animated-number-title{
					<# if(_.isObject(data.title_font_size)){ #>
						font-size: {{ data.title_font_size.sm }}px;
					<# }
					if(_.isObject(data.title_line_height)){ #>
						line-height: {{ data.title_line_height.sm }}px;
					<# }
					if(_.isObject(data.title_margin)){ #>
						margin: {{ data.title_margin.sm }};
					<# } #>
				}

				#{{ addonId }} .icon-container{
					<# if(_.isObject(padding)){ #>
						{{ padding.sm }}
					<# } #>
				}

				#{{ addonId }} .icon-container i{
					<# if (_.isObject(data.icon_size))	{ #>
						font-size: {{ data.icon_size.sm }}px;
						width: {{ data.icon_size.sm }}px;
						height: {{ data.icon_size.sm }}px;
						line-height: {{ data.icon_size.sm }}px;
					<# } else { #>
						font-size: {{ data.icon_size }}px;
						width: {{ data.icon_size }}px;
						height: {{ data.icon_size }}px;
						line-height: {{ data.icon_size }}px;
					<# } #>
					color: {{ data.icon_color }};
				}
			}
			@media (max-width: 767px) {
				#{{ addonId }} .sppb-animated-number{
					<# if(_.isObject(data.font_size)){ #>
						font-size: {{ data.font_size.xs }}px;
					<# }
					if(_.isObject(data.line_height)){ #>
						line-height: {{ data.line_height.xs }}px;
					<# } #>
				}
				#{{ addonId }} .sppb-animated-number-title{
					<# if(_.isObject(data.title_font_size)){ #>
						font-size: {{ data.title_font_size.xs }}px;
					<# }
					if(_.isObject(data.title_line_height)){ #>
						line-height: {{ data.title_line_height.xs }}px;
					<# }
					if(_.isObject(data.title_margin)){ #>
						margin: {{ data.title_margin.xs }};
					<# } #>
				}

				#{{ addonId }} .icon-container{
					<# if(_.isObject(padding)){ #>
						{{ padding.xs }}
					<# } #>
				}

				#{{ addonId }} .icon-container i{
					<# if (_.isObject(data.icon_size))	{ #>
						font-size: {{ data.icon_size.xs }}px;
						width: {{ data.icon_size.xs }}px;
						height: {{ data.icon_size.xs }}px;
						line-height: {{ data.icon_size.xs }}px;
					<# } else { #>
						font-size: {{ data.icon_size }}px;
						width: {{ data.icon_size }}px;
						height: {{ data.icon_size }}px;
						line-height: {{ data.icon_size }}px;
					<# } #>
					color: {{ data.icon_color }};
				}
			}
		</style>
		<div class="sppb-addon ut-addon-animated-number {{ data.alignment }} {{ data.class }}">
			<div class="sppb-addon-content">
				<# if(icon && data.icon_position != "bottom"){ #>
					{{{icon}}}
				<# } #>
				<div class="number-container">
					<# if(data.counter_title && data.title_position == "before"){ #>
						<div class="sppb-animated-number-title">{{ data.counter_title }}</div>
					<# } #>
					<div class="sppb-animated-number" data-digit="{{ data.number }}" data-duration="{{ data.duration }}">0</div>
					<# if(data.counter_title && data.title_position != "before"){ #>
						<div class="sppb-animated-number-title">{{ data.counter_title }}</div>
					<# } #>
				</div>
				<# if(icon && data.icon_position == "bottom"){ #>
					{{{icon}}}
				<# } #>
			</div>
		</div>';

		return $output;
	}
}
