<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_articles_category
 *
 * @copyright   (C) 2010 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Uri\Uri;

$doc = Factory::getDocument();
$doc->addScript(Uri::root(true).'/templates/ut_construction/js/ut_assets/isotope/isotope.pkgd.min.js');
?>
<div class="projects interior-layout<?php echo ' '.htmlspecialchars($params->get('moduleclass_sfx'), ENT_COMPAT, 'UTF-8'); ?>">
	<div id="filter<?php echo $module->id;?>" class="filter-options mb-30">
		<a href="#" class="active" data-group="*"><?php echo Text::_('Show all');?></a>
	<?php
	$unique_cats = array();
	foreach ($list as $cats) {
		$unique_cats[$cats->catid] = $cats->category_title;
	}
	foreach ($unique_cats as $cat) {
		echo '<a href="#" class="filter-item" data-group=".'.str_replace(' ', '-', $cat).'">'.$cat.'</a>';
	}?>
	</div>
	<div id="projectWrapper<?php echo $module->id;?>" class="projects-list row overflow-hidden">
		<?php foreach ($list as $item) : ?>
			<?php
			$images = json_decode($item->images);
			$itemattribs = json_decode( $item->attribs );
			$article_format = (isset($itemattribs->helix_ultimate_article_format) && $itemattribs->helix_ultimate_article_format) ? $itemattribs->helix_ultimate_article_format : 'standard';
			$counter = $params->get('count');
			?>

			<div class="col-12 col-md-6 col-lg-<?php echo ($counter >= 3) ? '4' : '6';?> col-xl-4 project-wrapper <?php echo str_replace(' ', '-', $item->category_title);?>">
				<div class="project <?php echo $item->active; ?>">
					<div class="project-media">
						<?php if($article_format == 'gallery') : ?>
							<?php echo LayoutHelper::render('joomla.content.blog.gallery', array('attribs' => $itemattribs, 'id'=>$item->id.'-'.$module->id)); ?>
						<?php elseif($article_format == 'video') : ?>
							<?php echo LayoutHelper::render('joomla.content.projects_video_image', $item); ?>
						<?php elseif($article_format == 'audio') : ?>
							<?php echo LayoutHelper::render('joomla.content.blog.audio', array('attribs' => $itemattribs)); ?>
						<?php else: ?>
							<?php echo LayoutHelper::render('joomla.content.module_image', $item); ?>
						<?php endif; ?>
						<div class="project-header">
							<h3>
								<a href="<?php echo $item->link; ?>"><?php echo $item->title; ?></a>
							</h3>
							<?php if ($item->displayCategoryTitle) : ?>
								<div class="project-category">
									<?php echo $item->displayCategoryTitle; ?>
								</div>
							<?php endif; ?>
						</div>
					</div>
					<?php if ($params->get('show_introtext')) : ?>
					<div class="project-body">
						<div class="project-introtext">
							<?php echo strip_tags($item->displayIntrotext); ?>
						</div>
					</div>
					<?php endif; ?>
				</div>
			</div>
		<?php endforeach; ?>
	</div>
</div>
<script>
	<?php //documentation https://isotope.metafizzy.co/ filtering and masonry ands https://codepen.io/desandro/pen/BgcCD ?>
	window.addEventListener("load", function() {
		var grid = new Isotope('#projectWrapper<?php echo $module->id;?>', {
			// options
			itemSelector: '.project-wrapper',
			percentPosition: true,
			masonry:{
				columnWidth:'.project-wrapper'
			}
		});

		// Filters 
		var filtersElem = document.querySelector('#filter<?php echo $module->id;?>');
		filtersElem.addEventListener( 'click', function( event ) {
			event.preventDefault();
			// only work with buttons
			if ( !matchesSelector( event.target, 'a' ) ) {
				return;
			}
			var filterValue = event.target.getAttribute('data-group');
			// use matching filter function
			grid.arrange({ filter: filterValue });

			//toggle active class
			filtersElem.querySelector('.active').classList.remove('active');
			event.target.classList.add('active');
		});
	});	
</script>
