<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_articles_category
 *
 * @copyright   (C) 2010 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Layout\LayoutHelper;
?>
<div class="projects construction-layout<?php echo ' '.htmlspecialchars($params->get('moduleclass_sfx'), ENT_COMPAT, 'UTF-8'); ?>">
	<div id="projectWrapper" class="projects-list row">
		<?php foreach ($list as $item) : ?>
			<?php
			$images = json_decode($item->images);
			$itemattribs = json_decode( $item->attribs );
			$article_format = (isset($itemattribs->helix_ultimate_article_format) && $itemattribs->helix_ultimate_article_format) ? $itemattribs->helix_ultimate_article_format : 'standard';
			$counter = $params->get('count');
			?>

			<div class="col-12 col-md-6 col-lg-<?php echo ($counter >= 3) ? '4' : '6';?> col-xl-<?php echo ($counter <= 4) ? round(12 / $counter) : '3';?> project-wrapper">
				<div class="project <?php echo $item->active; ?>">
					<div class="project-media">
					<?php if($article_format == 'gallery') : ?>
						<?php echo LayoutHelper::render('joomla.content.blog.gallery', array('attribs' => $itemattribs, 'id'=>$item->id.'-'.$module->id)); ?>
					<?php elseif($article_format == 'video') : ?>
						<?php echo LayoutHelper::render('joomla.content.projects_video_image', $item); ?>
					<?php elseif($article_format == 'audio') : ?>
						<?php echo LayoutHelper::render('joomla.content.blog.audio', array('attribs' => $itemattribs)); ?>
					<?php else: ?>
						<?php echo LayoutHelper::render('joomla.content.module_image', $item); ?>
					<?php endif; ?>
					</div>
					<div class="project-header">
						<h3>
							<a href="<?php echo $item->link; ?>"><?php echo $item->title; ?></a>
						</h3>
					</div>
					<?php if ($item->displayCategoryTitle) : ?>
						<div class="project-category">
							<?php echo $item->displayCategoryTitle; ?>
						</div>
					<?php endif; ?>
					<?php if ($params->get('show_introtext')) : ?>
					<div class="project-body">
						<div class="project-introtext">
							<?php echo strip_tags($item->displayIntrotext); ?>
						</div>
					</div>
					<?php endif; ?>
				</div>
			</div>
		<?php endforeach; ?>
	</div>
</div>
