<?php
/**
 * @package Helix_Ultimate_Framework
 * @author JoomShaper <support@joomshaper.com>
 * Copyright (c) 2010 - 2021 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 */

defined ('_JEXEC') or die();

use Joomla\CMS\Uri\Uri;

/**
 * Helix ultimate footer features
 *
 * @since	1.0.0
 */
class HelixUltimateFeatureFooter
{
	/**
	 * Template params
	 *
	 * @var		Registry	Template params registry
	 * @since	1.0.0
	 */
	private $params;

	public function __construct($params)
	{
		$this->params = $params;
		$this->position = $this->params->get('copyright_position');
		$this->load_pos = $this->params->get('copyright_load_pos');
	}

	public function renderFeature()
	{
		if($this->params->get('enabled_copyright'))
		{
			$domain = Uri::getInstance()->getHost();
			switch ($domain) {
				case 'demo.unitemplates.com':
					$developer = '<span class="designed-by">Unitemplates</span>';
					$company = 'Your Company';
					break;
				
				default:
					$developer = '<a target="_blank" rel="noopener noreferrer" href="https://www.unitemplates.com">Unitemplates</a>';
					$company = $domain;
					break;
			}
			
			$output = '';

			if($this->params->get('copyright'))
			{
				$output .= '<span class="sp-copyright">' .
					str_ireplace(
						'{year}', date('Y'),
						str_ireplace(
							'Your Company',
							$company,
							str_ireplace(
								'Unitemplates',
								$developer,
								$this->params->get('copyright')
							)
						)
					)  .
					'</span>';

				return $output;
			}
		}
	}
}
