<?php
/**
* @package SP Page Builder
* @author Unitemplates http://www.Unitemplates.com
* @version 1.6.0
* @copyright Copyright (c) 2010 - 2021 Unitemplates
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted aceess');

SpAddonsConfig::addonConfig(
	array(
		'type'=>'repeatable',
		'addon_name'=>'uttestimonial',
		'category'=>'Unitemplates',
		'title'=>JText::_('UT Testimonial'),
		'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_DESC'),
		'attr'=>array(
			'general' => array(

				'admin_label'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL_DESC'),
					'std'=> ''
				),

				'control_settings' => array(
					'type'=>'checkbox',
					'title'=>JText::_('Control Settings'),
					'desc'=>JText::_('Enable this for change control values'),
					'values'=>array(
						'0'=>JText::_('JNO'),
						'1'=>JText::_('JYES'),
					),
				),

				'loop'=>array(
					'type'=>'select',
					'title'=>JText::_('Loop: Infinite loop '),
					'values'=>array(
						'false'=>JText::_('JNO'),
						'true'=>JText::_('JYES'),
					),
					'std'=>'false',
					'depends'=>array('control_settings'=>'1'),

				),

				'autoplay'=>array(
					'type'=>'select',
					'title'=>JText::_('Autoplay: Play Automatic'),
					'values'=>array(
						'false'=>JText::_('JNO'),
						'true'=>JText::_('JYES'),
					),
					'std'=>'false',					
					'depends'=>array('control_settings'=>'1'),
				),

				'interval'=>array(
					'type'=>'number',
					'title'=>JText::_('Autoplay interval Timeout'),
					'std'=>'3000',					
					'depends'=>array('control_settings'=>'1'),
				),

				'center'=>array(
					'type'=>'select',
					'title'=>JText::_('Center. Aling item to center'),
					'values'=>array(
						'false'=>JText::_('JNO'),
						'true'=>JText::_('JYES'),
					),
					'std'=>'false',
					'depends'=>array('control_settings'=>'1'),
				),

				'dots'=>array(
					'type'=>'select',
					'title'=>JText::_('Show Dots Navigation'),
					'values'=>array(
						'false'=>JText::_('JNO'),
						'true'=>JText::_('JYES'),
					),
					'std'=>'false',
					'depends'=>array('control_settings'=>'1'),
				),

				'dotsContainer'=>array(
					'type'=>'text',
					'title'=>'Dots Container',
					'desc'=>JText::_('Add the ID or CLASS of the element that will contain the Dots. Used to show the navigation dots outside the carousel.'),
					'std'=>'',
					'depends'=>array(
						array('control_settings', '!=', '0'),
						array('dots', '!=', 'false'),
					),
				),

				'nav'=>array(
					'type'=>'select',
					'title'=>JText::_('Show Buttons Navigation'),
					'values'=>array(
						'false'=>JText::_('JNO'),
						'true'=>JText::_('JYES'),
					),
					'std'=>'false',
					'depends'=>array('control_settings'=>'1'),
				),

				'nav_text'=>array(
					'type'=>'select',
					'title'=>JText::_('Navigation Text or Icon'),
					'values'=>array(
						''=>JText::_('Text'),
						'angle'=>JText::_('Angle'),
						'angle-double'=>JText::_('Angle Double'),
						'arrow'=>JText::_('Arrow'),
						'long-arrow-alt'=>JText::_('Arrow Long'),
						'chevron'=>JText::_('Chevron'),
						'caret'=>JText::_('Caret'),
					),
					'std'=>'',
					'depends'=>array('control_settings'=>'1'),
				),

				'navContainer'=>array(
					'type'=>'text',
					'title'=>'Navigation Container',
					'desc'=>JText::_('Add the ID or CLASS of the element that will contain the navigation. Used to show the navigation outside the carousel.'),
					'std'=>'',
					'depends'=>array(
						array('control_settings', '!=', '0'),
						array('nav', '!=', 'false'),
					),
				),

				'margin'=>array(
					'type'=>'number',
					'title'=>JText::_('Margin: Space between elements'),
					'std'=>'30',
					'depends'=>array('control_settings'=>'1'),
				),

				'speed'=>array(
					'type'=>'number',
					'title'=>JText::_('Speed: Sliding speed in milliseconds'),
					'std'=>'300',
					'depends'=>array('control_settings'=>'1'),
				),

				'columns'=>array(
					'type'=>'select',
					'title'=>JText::_('Columns: Number of columns per row'),
					'values'=>array(
						'1'=>1,
						'2'=>2,
						'3'=>3,
						'4'=>4,
						'5'=>5,
						'6'=>6,
					),
					'std'=>'3',
				),

				'columns_sm'=>array(
					'type'=>'select',
					'title'=>JText::_('Columns: Columns per row on Tablet'),
					'values'=>array(
						'1'=>1,
						'2'=>2,
						'3'=>3,
						'4'=>4,
						'5'=>5,
						'6'=>6,
					),
					'std'=>'2',
				),

				'columns_xs'=>array(
					'type'=>'select',
					'title'=>JText::_('Columns: Columns per row on Phones'),
					'values'=>array(
						'1'=>1,
						'2'=>2,
						'3'=>3,
						'4'=>4,
						'5'=>5,
						'6'=>6,
					),
					'std'=>'1',
				),

				'position_separator'=>array(
					'type'=>'separator',
					'title'=>JText::_('Positions'),
				),

				'author_position'=>array(
					'type'=>'select',
					'title'=>JText::_('Author Position'),
					'desc'=>JText::_('Select a position to show Author Name'),
					'values'=>array(
						'bottom'=>JText::_('After Testimony'),
						'top'=>JText::_('Before Testimony'),
						'before'=>JText::_('Before Avatar'),
						'after'=>JText::_('After Avatar'),
						'left'=>JText::_('Left Avatar'),
						'right'=>JText::_('Right Avatar'),
					),
					'std'=>'after',
				),

				'avatar_position'=>array(
					'type'=>'select',
					'title'=>JText::_('Avatar Position'),
					'desc'=>JText::_('Select a position to show Author Avatar'),
					'values'=>array(
						'before'=>JText::_('Before Testimony'),
						'after'=>JText::_('After Testimony'),
						'left'=>JText::_('Left Testimony'),
						'right'=>JText::_('Right Testimony'),
					),
					'std'=>'after',
				),

				'avatar_col'=>array(
					'type'=>'select',
					'title'=>JText::_('Avatar Column Width'),
					'desc'=>JText::_('Select a width for Author Avatar'),
					'values'=>array(
						'6'=>JText::_('50%'),
						'4'=>JText::_('33%'),
						'3'=>JText::_('25%'),
						'2'=>JText::_('20%'),
					),
					'std'=>'4',
					'depends'=>array(
						array('avatar_position', '!=', 'before'),
						array('avatar_position', '!=', 'after'),
					),
				),

				'rating_separator'=>array(
					'type'=>'separator',
					'title'=>JText::_('Rating Options'),
				),

				'enable_rating'=>array(
					'type'=>'checkbox',
					'title'=>JText::_('Enable Ratings'),
					'std'=>0
				),

				'rating_position'=>array(
					'type'=>'select',
					'title'=>JText::_('Rating Position'),
					'desc'=>JText::_('Select a position to show rating'),
					'values'=>array(
						'after_author'=>JText::_('After Author'),
						'after_message'=>JText::_('After Testimony'),
					),
					'std'=>'after_message',
				),
				
				'rating_color'=>array(
					'type'=>'color',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_CLIENT_RATING_COLOR'),
					'depends'=>array(
						array('enable_rating', '=', 1),
					),
					'std'=>''
				),

				'rating_fontsize'=>array(
					'type'=>'slider',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_CLIENT_RATING_FONTSIZE'),
					'depends'=>array(
						array('enable_rating', '=', 1),
					),
					'std'=>'16',
				),

				'effect_separator'=>array(
					'type'=>'separator',
					'title'=>JText::_('Animation & Effects'),
				),

				'avatar_effect'=>array(
					'type'=>'select',
					'title'=>JText::_('Avatar Image Effect'),
					'desc'=>JText::_('Select an image effect for client avatar'),
					'values'=>array(
						''=>JText::_('JNONE'),
						'blur'=>JText::_('Blur'),
						'grayscale'=>JText::_('Grayscale'),
						'opacity'=>JText::_('Opacity'),
						'sepia'=>JText::_('Sepia'),
						'sepia50'=>JText::_('Sepia50'),
						'saturate'=>JText::_('Saturate'),
						'contrast'=>JText::_('Contrast'),
						'hue-rotate'=>JText::_('Rotate'),
					),
					'std'=>'',
				),

				'avatar_effect_apply'=>array(
					'type'=>'select',
					'title'=>JText::_('Effect Apply'),
					'desc'=>JText::_('Apply effect on element state static or hover'),
					'values'=>array(
						''=>JText::_('JNONE'),
						'static'=>JText::_('Static'),
						'hover'=>JText::_('Hover'),
						'both'=>JText::_('Both'),
					),
					'std'=>'',
				),

				'avatar_animation'=>array(
					'type'=>'select',
					'title'=>JText::_('Avatar Animation'),
					'desc'=>JText::_('Animation for avatar on mouse hover'),
					'values'=>array(
						''=>JText::_('JNONE'),
						'utZoomIn'=>JText::_('Zoom In'),
						'utZoomOut'=>JText::_('Zoom Out'),
						'utFlipX'=>JText::_('Flip X'),
					),
					'std'=>'',
				),

				'styles_separator'=>array(
					'type'=>'separator',
					'title'=>JText::_('Style Options'),
				),

				'item_bg'=>array(
					'type'=>'color',
					'title'=>JText::_('Background: This is assgined to all items'),
				),

				'item_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Text Color: This is assgined to all items'),
				),

				'item_padding'=>array(
					'type'=>'padding',
					'title'=>JText::_('Padding: Assigned to all items'),
				),

				'item_border_width'=>array(
					'type'=>'slider',
					'title'=>JText::_('Border Width'),
					'max'=> 20,
					'std'=>'',
				),

				'item_border_style'=>array(
					'type'=>'select',
					'title'=>JText::_('Border Style'),
					'values' => array(
						'none'=> JText::_('JNONE'),
						'solid'=> JText::_('Solid'),
						'dotted'=> JText::_('Dotted'),
						'dashed'=> JText::_('Dashed'),
						'double'=> JText::_('Double'),
						'groove'=> JText::_('Groove'),
						'ridge'=> JText::_('Ridge'),
						'inset'=> JText::_('Inset'),
						'outset'=> JText::_('Outset'),
					),
					'std'=>'none',
				),

				'item_border_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Border Color'),
					'std'=>'',
				),

				'item_border_radius'=>array(
					'type'=>'slider',
					'title'=>JText::_('Border Radius'),
					'max'=> 400,
					'std'=>'',
				),

				'class'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
					'std'=> ''
				),

				// Repeatable Items
				'ut_testimonial_item'=>array(
					'title'=>JText::_('Testimonials'),

					'attr'=>array(
						'author'=>array(
							'type'=>'text',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_ITEM_TITLE'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_ITEM_TITLE_DESC'),
							'std'=>'John Doe',
						),

						'position'=>array(
							'type'=>'text',
							'title'=>JText::_('Client Position'),
							'desc'=>JText::_('The position that the client has in the company'),
							'std'=>'CEO & Founder',
						),

						'company'=>array(
							'type'=>'text',
							'title'=>JText::_('Client Company'),
							'desc'=>JText::_('The company in which the client works'),
							'std'=>'Uni',
						),

						'url'=>array(
							'type'=>'text',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_CLIENT_URL'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_CLIENT_URL_DESC'),
							'std'=>'#',
						),

						'target' => array(
							'type' => 'select',
							'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB'),
							'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB_DESC'),
							'values' => array(
								'' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_SAME_WINDOW'),
								'_blank' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_NEW_WINDOW'),
							),
							'depends' => array(array('url', '!=', '')),
						),

						'avatar'=>array(
							'type'=>'media',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_CLIENT_IMAGE'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_CLIENT_IMAGE_DESC'),
							'std'=>'',
						),

						'avatar_style'=>array(
							'type'=>'select',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_AVATAR_STYLE'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_AVATAR_STYLE_DESC'),
							'values'=>array(
								''=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_STANDARD'),
								'sppb-img-rounded'=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_ROUNDED'),
								'sppb-img-circle'=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_CIRCLE'),
							),
							'std'=>'sppb-img-circle',
						),

						'message'=>array(
							'type'=>'editor',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_ITEM_TEXT'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_ITEM_TEXT_DESC'),
							'std'=> 'Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.'
						),

						'rating'=>array(
							'type'=>'slider',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_CLIENT_RATING'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_CLIENT_RATING_DESC'),
							'max'=>5,
							'min'=>1,
							'std'=>'5',
						),
					),
				),
			),
		),
	)
);
