<?php
/**
* @package SP Page Builder
* @author Unitemplates http://www.unitemplates.com
* @version 1.6.0
* @copyright Copyright (c) 2010 - 2020 Unitemplates
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted aceess');

SpAddonsConfig::addonConfig(
	array(
		'type'=>'repeatable',
		'addon_name'=>'utclients',
		'category'=>'Unitemplates',
		'title'=>JText::_('UT Clients'),
		'desc'=>JText::_('Display clients on carousel'),
		'attr'=>array(
			'general' => array(

				'admin_label'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL_DESC'),
					'std'=> ''
				),

				'title'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_DESC'),
					'std'=>  ''
				),

				'heading_selector'=>array(
					'type'=>'select',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_HEADINGS'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_DESC'),
					'values'=>array(
						'h1'=>JText::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H1'),
						'h2'=>JText::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H2'),
						'h3'=>JText::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H3'),
						'h4'=>JText::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H4'),
						'h5'=>JText::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H5'),
						'h6'=>JText::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H6'),
					),
					'std'=>'h3',
					'depends'=>array(array('title', '!=', '')),
				),

				'title_fontsize'=>array(
					'type'=>'number',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_FONT_SIZE'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_FONT_SIZE_DESC'),
					'std'=>'',
					'depends'=>array(array('title', '!=', '')),
				),

				'title_lineheight'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_LINE_HEIGHT'),
					'std'=>'',
					'depends'=>array(array('title', '!=', '')),
				),

				'title_fontstyle'=>array(
					'type'=>'select',
					'title'=> JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_FONT_STYLE'),
					'values'=>array(
						'underline'=> JText::_('COM_SPPAGEBUILDER_GLOBAL_FONT_STYLE_UNDERLINE'),
						'uppercase'=> JText::_('COM_SPPAGEBUILDER_GLOBAL_FONT_STYLE_UPPERCASE'),
						'italic'=> JText::_('COM_SPPAGEBUILDER_GLOBAL_FONT_STYLE_ITALIC'),
						'lighter'=> JText::_('COM_SPPAGEBUILDER_GLOBAL_FONT_STYLE_LIGHTER'),
						'normal'=> JText::_('COM_SPPAGEBUILDER_GLOBAL_FONT_STYLE_NORMAL'),
						'bold'=> JText::_('COM_SPPAGEBUILDER_GLOBAL_FONT_STYLE_BOLD'),
						'bolder'=> JText::_('COM_SPPAGEBUILDER_GLOBAL_FONT_STYLE_BOLDER'),
					),
					'multiple'=>true,
					'std'=>'',
					'depends'=>array(array('title', '!=', '')),
				),

				'title_letterspace'=>array(
					'type'=>'select',
					'title'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_LETTER_SPACING'),
					'values'=>array(
						'0'=> 'Default',
						'1px'=> '1px',
						'2px'=> '2px',
						'3px'=> '3px',
						'4px'=> '4px',
						'5px'=> '5px',
						'6px'=>	'6px',
						'7px'=>	'7px',
						'8px'=>	'8px',
						'9px'=>	'9px',
						'10px'=> '10px'
					),
					'std'=>'0',
					'depends'=>array(array('title', '!=', '')),
				),

				'title_fontweight'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_FONT_WEIGHT'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_FONT_WEIGHT_DESC'),
					'std'=>'',
					'depends'=>array(array('title', '!=', '')),
				),

				'title_text_color'=>array(
					'type'=>'color',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_TEXT_COLOR'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_TEXT_COLOR_DESC'),
					'depends'=>array(array('title', '!=', '')),
				),

				'title_margin_top'=>array(
					'type'=>'number',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_MARGIN_TOP'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_MARGIN_TOP_DESC'),
					'placeholder'=>'10',
					'depends'=>array(array('title', '!=', '')),
				),

				'title_margin_bottom'=>array(
					'type'=>'number',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_MARGIN_BOTTOM'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_MARGIN_BOTTOM_DESC'),
					'placeholder'=>'10',
					'depends'=>array(array('title', '!=', '')),
				),

				'Carousel_separator'=>array(
					'type'=>'separator',
					'title'=>JText::_('Carousel Settings'),
				),

				'control_settings' => array(
					'type'=>'checkbox',
					'title'=>JText::_('Control Settings'),
					'desc'=>JText::_('Enable for change values and Disable after change values'),
					'values'=>array(
						'0'=>JText::_('JNO'),
						'1'=>JText::_('JYES'),
					),
				),

				'loop'=>array(
					'type'=>'select',
					'title'=>JText::_('Loop: Infinite loop '),
					'values'=>array(
						'false'=>JText::_('JNO'),
						'true'=>JText::_('JYES'),
					),
					'std'=>'false',
					'depends'=>array('control_settings'=>'1'),

				),

				'autoplay'=>array(
					'type'=>'select',
					'title'=>JText::_('Autoplay: Play Automatic'),
					'values'=>array(
						'false'=>JText::_('JNO'),
						'true'=>JText::_('JYES'),
					),
					'std'=>'false',
					'depends'=>array('control_settings'=>'1'),
				),

				'interval'=>array(
					'type'=>'number',
					'title'=>JText::_('Autoplay interval Timeout'),
					'std'=>'3000',					
					'depends'=>array('control_settings'=>'1'),
				),

				'center'=>array(
					'type'=>'select',
					'title'=>JText::_('Center. Aling item to center'),
					'values'=>array(
						'false'=>JText::_('JNO'),
						'true'=>JText::_('JYES'),
					),
					'std'=>'false',
					'depends'=>array('control_settings'=>'1'),
				),

				'dots'=>array(
					'type'=>'select',
					'title'=>JText::_('Show Dots Navigation'),
					'values'=>array(
						'false'=>JText::_('JNO'),
						'true'=>JText::_('JYES'),
					),
					'std'=>'false',
					'depends'=>array('control_settings'=>'1'),
				),

				'dotsContainer'=>array(
					'type'=>'text',
					'title'=>'Dots Container ID or CLASS',
					'desc'=>JText::_('Add the ID or CLASS of the element that will contain the Dots. Used to show the navigation dots outside the carousel.'),
					'placeholder'=>'Include # for ID and . for CLASS',					
					'std'=>'',
					'depends'=>array(
						array('control_settings', '!=', '0'),
						array('dots', '!=', 'false'),
					),
				),

				'nav'=>array(
					'type'=>'select',
					'title'=>JText::_('Show Buttons Navigation'),
					'values'=>array(
						'false'=>JText::_('JNO'),
						'true'=>JText::_('JYES'),
					),
					'std'=>'false',
					'depends'=>array('control_settings'=>'1'),
				),

				'nav_text'=>array(
					'type'=>'select',
					'title'=>JText::_('Navigation Text or Icon'),
					'values'=>array(
						''=>JText::_('Text'),
						'angle'=>JText::_('Angle'),
						'angle-double'=>JText::_('Angle Double'),
						'arrow'=>JText::_('Arrow'),
						'long-arrow'=>JText::_('Arrow Long'),
						'chevron'=>JText::_('Chevron'),
						'caret'=>JText::_('Caret'),
					),
					'std'=>'',
					'depends'=>array('control_settings'=>'1'),
				),

				'navContainer'=>array(
					'type'=>'text',
					'title'=>'Navigation Container ID or CLASS',
					'desc'=>JText::_('Add the ID or CLASS of the element that will contain the navigation. Used to show the navigation outside the carousel.'),
					'placeholder'=>'Include # for ID and . for CLASS',					
					'std'=>'',
					'depends'=>array(
						array('control_settings', '!=', '0'),
						array('nav', '!=', 'false'),
					),
				),

				'margin'=>array(
					'type'=>'number',
					'title'=>JText::_('Margin: Space between elements'),
					'std'=>'30',
					'depends'=>array('control_settings'=>'1'),
				),

				'speed'=>array(
					'type'=>'number',
					'title'=>JText::_('Speed: Sliding speed in milliseconds'),
					'std'=>'250',
					'depends'=>array('control_settings'=>'1'),
				),

				'count'=>array(
					'type'=>'select',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLIENTS_COUNT'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLIENTS_COUNT_DESC'),
					'values'=>array(
						'1'=>1,
						'2'=>2,
						'3'=>3,
						'4'=>4,
						'5'=>5,
						'6'=>6,
					),
					'std'=>'4',
				),

				'count_sm'=>array(
					'type'=>'select',
					'title'=>JText::_('Clients per row on Tablet'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLIENTS_COUNT_DESC'),
					'values'=>array(
						'1'=>1,
						'2'=>2,
						'3'=>3,
						'4'=>4,
						'5'=>5,
						'6'=>6,
					),
					'std'=>'3',
				),

				'count_xs'=>array(
					'type'=>'select',
					'title'=>JText::_('Clients per row on Phones'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLIENTS_COUNT_DESC'),
					'values'=>array(
						'1'=>1,
						'2'=>2,
						'3'=>3,
						'4'=>4,
						'5'=>5,
						'6'=>6,
					),
					'std'=>'2',
				),

				'effect_separator'=>array(
					'type'=>'separator',
					'title'=>JText::_('Animation & Effects'),
				),

				'image_effect'=>array(
					'type'=>'select',
					'title'=>JText::_('Image Effect'),
					'desc'=>JText::_('Select an image effect for client logo'),
					'values'=>array(
						''=>JText::_('JNONE'),
						'blur'=>JText::_('Blur'),
						'grayscale'=>JText::_('Grayscale'),
						'opacity'=>JText::_('Opacity'),
						'sepia'=>JText::_('Sepia'),
						'sepia50'=>JText::_('Sepia50'),
						'saturate'=>JText::_('Saturate'),
						'contrast'=>JText::_('Contrast'),
						'hue-rotate'=>JText::_('Rotate'),
					),
					'std'=>'',
				),

				'image_effect_apply'=>array(
					'type'=>'select',
					'title'=>JText::_('Effect Apply'),
					'desc'=>JText::_('Apply effect on element state static or hover'),
					'values'=>array(
						''=>JText::_('JNONE'),
						'static'=>JText::_('Static'),
						'hover'=>JText::_('Hover'),
						'both'=>JText::_('Both'),
					),
					'std'=>'',
				),

				'image_animation'=>array(
					'type'=>'select',
					'title'=>JText::_('Image Animation'),
					'desc'=>JText::_('Animation for client logo on mouse hover'),
					'values'=>array(
						''=>JText::_('JNONE'),
						'utZoomIn'=>JText::_('Zoom In'),
						'utZoomOut'=>JText::_('Zoom Out'),
						'utFlipX'=>JText::_('Flip X'),
					),
					'std'=>'',
				),

				'style_separator'=>array(
					'type'=>'separator',
					'title'=>JText::_('Style Options'),
				),

				'item_bg'=>array(
					'type'=>'color',
					'title'=>JText::_('Background: This is assgined to all items'),
				),

				'item_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Text Color: This is assgined to all items'),
				),

				'item_padding'=>array(
					'type'=>'padding',
					'title'=>JText::_('Padding: Assigned to all items'),
				),

				'item_border_width'=>array(
					'type'=>'slider',
					'title'=>JText::_('Border Width'),
					'max'=> 20,
					'std'=>'',
				),

				'item_border_style'=>array(
					'type'=>'select',
					'title'=>JText::_('Border Style'),
					'values' => array(
						'none'=> JText::_('JNONE'),
						'solid'=> JText::_('Solid'),
						'dotted'=> JText::_('Dotted'),
						'dashed'=> JText::_('Dashed'),
						'double'=> JText::_('Double'),
						'groove'=> JText::_('Groove'),
						'ridge'=> JText::_('Ridge'),
						'inset'=> JText::_('Inset'),
						'outset'=> JText::_('Outset'),
					),
					'std'=>'none',
				),

				'item_border_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Border Color'),
					'std'=>'',
				),

				'item_border_radius'=>array(
					'type'=>'slider',
					'title'=>JText::_('Border Radius'),
					'max'=> 400,
					'std'=>'',
				),

				'alignment'=>array(
					'type'=>'select',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_CONTENT_ALIGNMENT'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_CONTENT_ALIGNMENT_DESC'),
					'values'=>array(
						'sppb-text-left'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_LEFT'),
						'sppb-text-center'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_CENTER'),
						'sppb-text-right'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_RIGHT'),
					),
					'std'=>'sppb-text-left',
				),

				'class'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
					'std'=>''
				),

				'target_link'=>array(
					'type'=>'select',
					'title'=>JText::_('Target Link'),
					'desc'=>JText::_('Target for clients links if it is added'),
					'values'=>array(
						''=>JText::_('Self'),
						'_blank'=>JText::_('Blank'),
					),
				),

				// Repeatable Items
				'ut_clients_item'=>array(
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLIENTS'),
					'attr'=>array(
						'title'=>array(
							'type'=>'text',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLIENT_TITLE'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLIENT_TITLE_DESC'),
							'std'=>'Client 1',
						),

						'image'=>array(
							'type'=>'media',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLIENT_IMAGE'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLIENT_IMAGE_DESC'),
							'format'=>'image',
							'std'=>'',
						),

						'url'=>array(
							'type'=>'text',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLIENT_URL'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLIENT_URL_DESC'),
							'std'=>'',
							'placeholder'=>'http://',
						),
					),
				),
			),
		),
	)
);
