<?php
/**
* @package SP Page Builder
* @author Unitemplates http://www.Unitemplates.com
* @version 1.9.0
* @copyright Copyright (c) 2010 - 2020 Unitemplates
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted aceess');

SpAddonsConfig::addonConfig(
	array(
		'type'=>'repeatable',
		'addon_name'=>'ut_person_carousel',
		'category'=>'Unitemplates',
		'title'=>JText::_('UT Person Carousel'),
		'desc'=>JText::_('Insert carousel with Image/Icon, title and text'),
		'attr'=>array(
			'general' => array(

				'admin_label'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL_DESC'),
					'std'=> ''
				),

				'control_settings' => array(
					'type'=>'checkbox',
					'title'=>JText::_('Carousel Settings'),
					'desc'=>JText::_('Open and close this for change control values'),
					'values'=>array(
						'0'=>JText::_('JNO'),
						'1'=>JText::_('JYES'),
					),
				),

				'columns'=>array(
					'type'=>'select',
					'title'=>JText::_('Columns: Number of columns per row'),
					'values'=>array(
						'1'=>1,
						'2'=>2,
						'3'=>3,
						'4'=>4,
						'5'=>5,
						'6'=>6,
					),
					'std'=>'3',
					'depends'=>array('control_settings'=>'1'),
				),

				'columns_sm'=>array(
					'type'=>'select',
					'title'=>JText::_('Columns: Columns per row on Tablet'),
					'values'=>array(
						'1'=>1,
						'2'=>2,
						'3'=>3,
						'4'=>4,
						'5'=>5,
						'6'=>6,
					),
					'std'=>'2',
					'depends'=>array('control_settings'=>'1'),
				),

				'columns_xs'=>array(
					'type'=>'select',
					'title'=>JText::_('Columns: Columns per row on Phones'),
					'values'=>array(
						'1'=>1,
						'2'=>2,
						'3'=>3,
						'4'=>4,
						'5'=>5,
						'6'=>6,
					),
					'std'=>'1',
					'depends'=>array('control_settings'=>'1'),
				),

                'separator_carousel_control'=>array(
					'type'=>'separator',
					'title'=>JText::_('Carousel Control Options'),
					'depends'=>array('control_settings'=>'1'),
				),

				'loop'=>array(
					'type'=>'select',
					'title'=>JText::_('Loop: Infinite loop '),
					'values'=>array(
						'false'=>JText::_('JNO'),
						'true'=>JText::_('JYES'),
					),
					'std'=>'false',
					'depends'=>array('control_settings'=>'1'),

				),

				'autoplay'=>array(
					'type'=>'select',
					'title'=>JText::_('Autoplay: Play Automatic'),
					'values'=>array(
						'false'=>JText::_('JNO'),
						'true'=>JText::_('JYES'),
					),
					'std'=>'false',					
					'depends'=>array('control_settings'=>'1'),
				),

				'interval'=>array(
					'type'=>'number',
					'title'=>JText::_('Autoplay interval Timeout'),
					'std'=>'3000',					
					'depends'=>array('control_settings'=>'1'),
				),

				'center'=>array(
					'type'=>'select',
					'title'=>JText::_('Center. Aling item to center'),
					'values'=>array(
						'false'=>JText::_('JNO'),
						'true'=>JText::_('JYES'),
					),
					'std'=>'false',
					'depends'=>array('control_settings'=>'1'),
				),

				'dots'=>array(
					'type'=>'select',
					'title'=>JText::_('Show Dots Navigation'),
					'values'=>array(
						'false'=>JText::_('JNO'),
						'true'=>JText::_('JYES'),
					),
					'std'=>'false',
					'depends'=>array('control_settings'=>'1'),
				),

				'dotsContainer'=>array(
					'type'=>'text',
					'title'=>'Dots Container ID or CLASS',
					'desc'=>JText::_('Add the ID or CLASS of the element that will contain the Dots, without symbols or spaces. Used to show the navigation dots outside the carousel.'),
					'placeholder'=>'Include # for ID and . for CLASS',
					'std'=>'',
					'depends'=>array(
						array('control_settings', '!=', '0'),
						array('dots', '!=', 'false'),
					),
				),

				'nav'=>array(
					'type'=>'select',
					'title'=>JText::_('Show Buttons Navigation'),
					'values'=>array(
						'false'=>JText::_('JNO'),
						'true'=>JText::_('JYES'),
					),
					'std'=>'false',
					'depends'=>array('control_settings'=>'1'),
				),

				'nav_text'=>array(
					'type'=>'select',
					'title'=>JText::_('Navigation Text or Icon'),
					'values'=>array(
						''=>JText::_('Text'),
						'angle'=>JText::_('Angle'),
						'angle-double'=>JText::_('Angle Double'),
						'arrow'=>JText::_('Arrow'),
						'long-arrow'=>JText::_('Arrow Long'),
						'chevron'=>JText::_('Chevron'),
						'caret'=>JText::_('Caret'),
					),
					'std'=>'',
					'depends'=>array('control_settings'=>'1'),
				),

				'navContainer'=>array(
					'type'=>'text',
					'title'=>'Navigation Container ID or CLASS',
					'desc'=>JText::_('Add the ID or CLASS of the element that will contain the navigation, without symbols or spaces. Used to show the navigation outside the carousel.'),
					'placeholder'=>'Include # for ID and . for CLASS',
					'std'=>'',
					'depends'=>array(
						array('control_settings', '!=', '0'),
						array('nav', '!=', 'false'),
					),
				),

				'margin'=>array(
					'type'=>'number',
					'title'=>JText::_('Margin: Space between elements'),
					'std'=>'30',
					'depends'=>array('control_settings'=>'1'),
				),

				'speed'=>array(
					'type'=>'number',
					'title'=>JText::_('Speed: Sliding speed in milliseconds'),
					'std'=>'300',
					'depends'=>array('control_settings'=>'1'),
				),

                'separator_item_appearance'=>array(
					'type'=>'separator',
					'title'=>JText::_('Item Appearance Options'),
				),

				'info_position'=>array(
					'type'=>'select',
					'title'=>JText::_('Person Info Position'),
					'values'=>array(
						'after'=>JText::_('After Image'),
						'overlay'=>JText::_('Overlay (image over)'),
					),
					'std'=>'after',
				),

				'desc_position'=>array(
					'type'=>'select',
					'title'=>JText::_('Person Description Position'),
					'values'=>array(
						'after'=>JText::_('After Image'),
						'overlay'=>JText::_('Overlay (image over)'),
					),
					'std'=>'after',
				),

				'social_position'=>array(
					'type'=>'select',
					'title'=>JText::_('Social Icons Position'),
					'values'=>array(
						'after'=>JText::_('After Image'),
						'overlay'=>JText::_('Overlay (image over)'),
					),
					'std'=>'after',
				),

				'social_order'=>array(
					'type'=>'select',
					'title'=>JText::_('Order Social Icons with respect to the description.'),
					'values'=>array(
						'before_info'=>JText::_('Before Information'),
						'before_desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_BEFORE_INTROTEXT'),
						'after_desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_AFTER_INTROTEXT'),
					),
					'std'=>'after_desc',
				),

				'social_target' => array(
					'type' => 'select',
					'title' => JText::_('Social Links Open'),
					'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB_DESC'),
					'values' => array(
						'' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_SAME_WINDOW'),
						'_blank' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_NEW_WINDOW'),
					),
					'std'=>'',
				),				

				'person_class'=>array(
					'type'=>'text',
					'title'=>JText::_('Person Class'),
					'desc'=>JText::_('This class is only for person item, Here you can add classes of UT Person Addon.'),
					'std'=>''
				),

				// Repeatable Items
				'ut_person_carousel_item'=>array(
					'title'=>JText::_('Person Items'),

					'attr'=>array(
						'image'=>array(
							'type'=>'media',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_PHOTO'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_PHOTO_DESC'),
						),

						'separator_person_info'=>array(
							'type'=>'separator',
							'title'=>JText::_('Person Information'),
						),

						'name'=>array(
							'type'=>'text',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_NAME'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_NAME_DESC'),
							'placeholder'=>'John Doe',
							'std'=>'John Doe',
						),

						'designation'=>array(
							'type'=>'text',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_DESIGNATION'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_DESIGNATION_DESC'),
							'placeholder'=>'CEO & Founder',
							'std'=>'CEO & Founder',
						),

						'email'=>array(
							'type'=>'text',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_EMAIL'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_EMAIL_DESC'),
							'placeholder'=>'name@domain.com',
							'std'=>'',
						),
						
						'url'=>array(
							'type'=>'text',
							'title'=>JText::_('Profiler URL'),
							'desc'=>JText::_('Enter a profile url (on your website), or leave blank'),
							'placeholder'=>'http://domain.com/profile/name',
							'std'=>'',
						),

						'separator_person_desc'=>array(
							'type'=>'separator',
							'title'=>JText::_('Person Description'),
						),

						'introtext'=>array(
							'type'=>'textarea',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_INTROTEXT'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_INTROTEXT_DESC'),
							'std'=>'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua',
						),

						'separator_social_icons'=>array(
							'type'=>'separator',
							'title'=>JText::_('Social Icons'),
						),


						'facebook'=>array(
							'type'=>'text',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_FACEBOOK'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_FACEBOOK_DESC'),
							'placeholder'=>'http://www.facebook.com/unitemplates',
							'std'=>'http://www.facebook.com/unitemplates',
						),

						'twitter'=>array(
							'type'=>'text',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_TWITTER'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_TWITTER_DESC'),
							'placeholder'=>'http://twitter.com/unitemplates',
							'std'=>'http://twitter.com/unitemplates',
						),

						'youtube'=>array(
							'type'=>'text',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_YOUTUBE'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_YOUTUBE_DESC'),
						),

						'linkedin'=>array(
							'type'=>'text',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_LINKEDIN'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_LINKEDIN_DESC'),
						),

						'pinterest'=>array(
							'type'=>'text',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_PINTEREST'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_PINTEREST_DESC'),
						),

						'flickr'=>array(
							'type'=>'text',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_FLICKR'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_FLICKR_DESC'),
						),

						'dribbble'=>array(
							'type'=>'text',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_DRIBBBLE'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_DRIBBBLE_DESC'),
						),

						'behance'=>array(
							'type'=>'text',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_BEHANCE'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_BEHANCE_DESC'),
						),

						'instagram'=>array(
							'type'=>'text',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_INSTAGRAM'),
							'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_INSTAGRAM_DESC'),
							'std' => 'https://www.instagram.com/unitemplates',
						),
					),
				),

				'separator_addon_options'=>array(
					'type'=>'separator',
					'title'=>JText::_('Addon Options'),
				),

				'alignment'=>array(
					'type'=>'select',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_CONTENT_ALIGNMENT'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_CONTENT_ALIGNMENT_DESC'),
					'values'=>array(
						'sppb-text-left'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_LEFT'),
						'sppb-text-center'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_CENTER'),
						'sppb-text-right'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_RIGHT'),
					),
					'std'=>'sppb-text-left',
				),

				'class'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
					'std'=>''
				),

			),
		),
	)
);
