<?php
/**
* @package SP Page Builder
* @author Unitemplates http://www.unitemplates.com
* @version 1.2.0
* @copyright Copyright (c) 2010 - 2021 Unitemplates
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted access');

// load custom icons
require_once dirname(dirname( __DIR__ )) . '/fields/buttonstyles.php';

SpAddonsConfig::addonConfig(
	array(
		'type'=>'content',
		'addon_name'=>'ut_image_lazy',
		'title'=>JText::_('UT Image Lazy'),
		'category'=>'Unitemplates',
		'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_PERSON_DESC'),
		'attr'=>array(
			'general' => array(

				'admin_label'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL_DESC'),
					'std'=> ''
				),

				'title'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_DESC'),
					'std'=>  ''
				),

				'heading_selector'=>array(
					'type'=>'select',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_HEADINGS'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_DESC'),
					'values'=>array(
						'h1'=>JText::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H1'),
						'h2'=>JText::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H2'),
						'h3'=>JText::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H3'),
						'h4'=>JText::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H4'),
						'h5'=>JText::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H5'),
						'h6'=>JText::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H6'),
					),
					'std'=>'h3',
					'depends'=>array(array('title', '!=', '')),
				),

				'title_fontsize'=>array(
					'type'=>'slider',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_FONT_SIZE'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_FONT_SIZE_DESC'),
					'std'=>'',
					'depends'=>array(array('title', '!=', '')),
					'responsive' => false,
					'max'=> 400,
				),

				'title_lineheight'=>array(
					'type'=>'slider',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_LINE_HEIGHT'),
					'std'=>'',
					'depends'=>array(array('title', '!=', '')),
					'responsive' => false,
					'max'=> 400,
				),

				'title_font_style'=>array(
					'type'=>'fontstyle',
					'title'=> JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_FONT_STYLE'),
					'depends'=>array(array('title', '!=', '')),
				),

				'title_letterspace'=>array(
					'type'=>'select',
					'title'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_LETTER_SPACING'),
					'values'=>array(
						'0'=> 'Default',
						'1px'=> '1px',
						'2px'=> '2px',
						'3px'=> '3px',
						'4px'=> '4px',
						'5px'=> '5px',
						'6px'=>	'6px',
						'7px'=>	'7px',
						'8px'=>	'8px',
						'9px'=>	'9px',
						'10px'=> '10px'
					),
					'std'=>'0',
					'depends'=>array(array('title', '!=', '')),
				),

				'title_text_color'=>array(
					'type'=>'color',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_TEXT_COLOR'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_TEXT_COLOR_DESC'),
					'depends'=>array(array('title', '!=', '')),
				),

				'title_margin_top'=>array(
					'type'=>'slider',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_MARGIN_TOP'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_MARGIN_TOP_DESC'),
					'placeholder'=>'10',
					'depends'=>array(array('title', '!=', '')),
					'responsive' => false,
					'max'=> 400,
				),

				'title_margin_bottom'=>array(
					'type'=>'slider',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_MARGIN_BOTTOM'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_MARGIN_BOTTOM_DESC'),
					'placeholder'=>'10',
					'depends'=>array(array('title', '!=', '')),
					'responsive' => false,
					'max'=> 400,
				),

				'title_padding'=>array(
					'type'=>'padding',
					'title'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_PADDING'),
					'placeholder'=>'10',
					'depends'=>array(array('title', '!=', '')),
					'responsive' => false,
					'std'=> ''
				),

				'title_position'=>array(
					'type'=>'select',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_POSITION'),
					'values'=>array(
						'top'=> 'Top',
						'right'=> 'Right',
						'bottom'=> 'Bottom',
						'left'=> 'Left',
						'overlay'=> 'Overlay',
					),
					'std'=>'top',
					'depends'=>array(array('title', '!=', '')),
				),

				'separator_image'=>array(
					'type'=>'separator',
					'title'=>JText::_('Image Options'),
				),

				'image'=>array(
					'type'=>'media',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_IMAGE_SELECT'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_IMAGE_SELECT_DESC'),
					'show_input' => true,
					'std'=>'https://sppagebuilder.com/addons/image/image1.jpg'
				),

				'lazyload'=>array(
					'type'=>'checkbox',
					'title'=>JText::_('Enable/Disable Lazy Load'),
					'desc'=>JText::_('Lazy load is used to speed up page loading.'),
					'std'=> 0,
					'depends'=>array(
						array('image', '!=', ''),
					),
				),

				'observer'=>array(
					'type'=>'checkbox',
					'title'=>JText::_('IntersectionObserver'),
					'desc'=>JText::_('Enable/Disable IntersectionObserver. This loads only the images that are near the browser viewport. If you are going to use this addon many times in a single page, activate this option only once, deactivate in others to avoid too many requests to the server.'),
					'std'=> 0,
					'depends'=>array(
						array('lazyload', '=', 1),
					),
				),

				'image_lazy'=>array(
					'type'=>'media',
					'title'=>JText::_('Image Lazy'),
					'desc'=>JText::_('Select a low quality version of your real image, a personalized image, SVG or base64'),
					'show_input' => true,
					'std'=>'https://sppagebuilder.com/addons/image/image1.jpg',
					'depends'=>array(
						array('image', '!=', ''),
						array('lazyload', '=', 1),
					),
				),

				'border_radius'=>array(
					'type'=>'slider',
					'title'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_RADIUS'),
					'std'=>0,
					'max'=>1200,
					'depends'=>array(
						array('image', '!=', ''),
					),
				),

				'alt_text'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_ALT_TEXT'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_ALT_TEXT_DESC'),
					'std'=>'Image',
					'depends'=>array(
						array('image', '!=', ''),
					),
				),

				'overlay_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Image Overlay Color'),
					'desc'=>JText::_('Overlay is enabled if a color is selected or a element is asigned to overlay'),
					'std'=>'rgba(119, 219, 31, .5)',
					'depends'=>array(
						array('image', '!=', ''),
					),
				),

				'link'=>array(
					'type'=>'media',
					'format'=>'attachment',
					'hide_preview'=>true,
					'title'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK'),
					'desc'=>JText::_('Link For image and Title'),
					'std'=>'',
					'depends'=>array(
						array('image', '!=', ''),
					),
				),

				'target'=>array(
					'type'=>'select',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_DESC'),
					'values'=>array(
						''=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_SAME_WINDOW'),
						'_blank'=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_NEW_WINDOW'),
					),

					'depends'=>array(
						array('image', '!=', ''),
						array('link', '!=', ''),
					),
				),

				'separator_description'=>array(
					'type'=>'separator',
					'title'=>JText::_('Description Options'),
				),


				'description'=>array(
					'type'=>'editor',
					'title'=>JText::_('Description Text'),
					'desc'=>JText::_('Insert a text for description if you need'),
					'std'=>'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua',
				),

				'description_fontsize'=>array(
					'type'=>'slider',
					'title'=>JText::_('Description Font Size'),
					'std'=>'',
					'depends'=>array(array('title', '!=', '')),
					'responsive' => false,
					'max'=> 400,
					'depends'=>array(array('description', '!=', '')),
				),

				'description_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Description Color'),
					'desc'=>JText::_('Select a color for description if necesary'),
					'depends'=>array(array('description', '!=', '')),
				),

				'description_position'=>array(
					'type'=>'select',
					'title'=>JText::_('Description Position'),
					'values'=>array(
						'top'=> 'Top',
						'right'=> 'Right',
						'bottom'=> 'Bottom',
						'left'=> 'Left',
						'overlay'=> 'Overlay',
					),
					'std'=>'bottom',
					'depends'=>array(array('description', '!=', '')),
				),

				'separator_buttons'=>array(
					'type'=>'separator',
					'title'=>JText::_('Button Options'),
				),

                'button_text' => array(
                    'type' => 'text',
                    'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_TEXT'),
                    'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_TEXT_DESC'),
                    'std' => 'Button',
                ),
                
                'button_url' => array(
                    'type' => 'media',
                    'format' => 'attachment',
                    'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_URL'),
                    'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_URL_DESC'),
                    'placeholder' => 'http://',
                    'hide_preview' => true,
                    'depends' => array(array('button_text', '!=', '')),
                ),
                'button_target' => array(
                    'type' => 'select',
                    'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB'),
                    'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB_DESC'),
                    'values' => array(
                        '' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_SAME_WINDOW'),
                        '_blank' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_NEW_WINDOW'),
                    ),
                    'depends' => array(
                     array('button_text', '!=', ''),
                     array('button_url', '!=', ''),
                    ),
                ),
                'button_type' => array(
                    'type' => 'select',
                    'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_STYLE'),
                    'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_STYLE_DESC'),
                    'values' => $buttonstyles,
                    'std' => 'default',
                    'depends' => array(array('button_text', '!=', '')),
                ),
                'button_appearance' => array(
                    'type' => 'select',
                    'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE'),
                    'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_DESC'),
                    'values' => array(
                        '' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_FLAT'),
                        'gradient' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_GRADIENT'),
                        'outline' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_OUTLINE'),
                        'outline-hover' => JText::_('Otuline Hover'),
                        '3d' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_3D'),
                    ),
                    'std' => '',
                    'depends' => array(
                        array('button_text', '!=', ''),
                        array('button_type', '!=', 'link'),
                    ),
                ),                
                'button_size' => array(
                    'type' => 'select',
                    'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE'),
                    'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_DESC'),
                    'values' => array(
                        '' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_DEFAULT'),
                        'lg' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_LARGE'),
                        'xlg' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_XLARGE'),
                        'sm' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_SMALL'),
                        'xs' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_EXTRA_SAMLL'),
                    ),
                    'depends' => array(array('button_text', '!=', '')),
                ),
                'button_shape' => array(
                    'type' => 'select',
                    'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE'),
                    'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_DESC'),
                    'values' => array(
                        'rounded' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_ROUNDED'),
                        'square' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_SQUARE'),
                        'round' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_ROUND'),
                    ),
                    'depends' => array(
                        array('button_text', '!=', ''),
                        array('button_type', '!=', 'link'),
                    ),
                ),
                'button_block' => array(
                    'type' => 'select',
                    'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BLOCK'),
                    'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BLOCK_DESC'),
                    'values' => array(
                        '' => JText::_('JNO'),
                        'sppb-btn-block' => JText::_('JYES'),
                    ),
                    'depends' => array(
                        array('button_text', '!=', ''),
                        array('button_type', '!=', 'link'),
                    ),
                ),
                'button_icon' => array(
                    'type' => 'icon',
                    'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_ICON'),
                    'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_ICON_DESC'),
                    'depends' => array(array('button_text', '!=', '')),
                ),
                'button_icon_margin' => array(
                    'type' =>'margin',
                    'title' =>JText::_('COM_SPPAGEBUILDER_TAB_ICON_MARGIN'),
                    'responsive' => false,
                    'std'=>'0px 0px 0px 0px',
                    'depends' => array(
                        array('button_text', '!=', ''),
                        array('button_icon', '!=', ''),
                    ),
                ),
                'button_icon_position' => array(
                    'type' => 'select',
                    'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_ICON_POSITION'),
                    'values' => array(
                        'left' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LEFT'),
                        'right' => JText::_('COM_SPPAGEBUILDER_GLOBAL_RIGHT'),
                    ),
                    'std' => 'left',
                    'depends' => array(
                        array('button_text', '!=', ''),
                        array('button_icon', '!=', ''),
                    ),
                ),

				'button_position'=>array(
					'type'=>'select',
					'title'=>JText::_('Button Position'),
					'values'=>array(
						'top'=> 'Top',
						'right'=> 'Right',
						'bottom'=> 'Bottom',
						'left'=> 'Left',
						'overlay'=> 'Overlay',
					),
					'std'=>'bottom',
					'depends'=>array(array('button_text', '!=', '')),
				),

				'separator_general'=>array(
					'type'=>'separator',
					'title'=>JText::_('General Options'),
				),

				'content_col_md'=>array(
					'type'=>'select',
					'title'=>JText::_('Desktop Content Width'),
					'desc'=>JText::_('Width of content column. This work only if you have assigned whatever element to left or right positions'),
					'values'=>array(
						'12'=>JText::_('100%'),
						'10'=>JText::_('83%'),
						'9'=>JText::_('75%'),
						'8'=>JText::_('66%'),
						'7'=>JText::_('58%'),
						'6'=>JText::_('50%'),
						'5'=>JText::_('41%'),
						'4'=>JText::_('33%'),
						'3'=>JText::_('25%'),
						'2'=>JText::_('16%'),
					),
					'std'=> '6',
				),

				'content_col_sm'=>array(
					'type'=>'select',
					'title'=>JText::_('Tablet Content Width'),
					'desc'=>JText::_('Width of content column. This work only if you have assigned whatever element to left or right positions'),
					'values'=>array(
						'12'=>JText::_('100%'),
						'10'=>JText::_('83%'),
						'9'=>JText::_('75%'),
						'8'=>JText::_('66%'),
						'7'=>JText::_('58%'),
						'6'=>JText::_('50%'),
						'5'=>JText::_('41%'),
						'4'=>JText::_('33%'),
						'3'=>JText::_('25%'),
						'2'=>JText::_('16%'),
					),
					'std'=> '12',
				),

				'content_col_xs'=>array(
					'type'=>'select',
					'title'=>JText::_('Mobile Content Width'),
					'desc'=>JText::_('Width of content column. This work only if you have assigned whatever element to left or right positions'),
					'values'=>array(
						'12'=>JText::_('100%'),
						'10'=>JText::_('83%'),
						'9'=>JText::_('75%'),
						'8'=>JText::_('66%'),
						'7'=>JText::_('58%'),
						'6'=>JText::_('50%'),
						'5'=>JText::_('41%'),
						'4'=>JText::_('33%'),
						'3'=>JText::_('25%'),
						'2'=>JText::_('16%'),
					),
					'std'=> '12',
				),

				'alignment'=>array(
					'type'=>'select',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_CONTENT_ALIGNMENT'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_CONTENT_ALIGNMENT_DESC'),
					'values'=>array(
						'sppb-text-left'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_LEFT'),
						'sppb-text-center'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_CENTER'),
						'sppb-text-right'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_RIGHT'),
					),
					'std'=>'sppb-text-left',
				),

				'middle_alignment'=>array(
					'type'=>'checkbox',
					'title'=>JText::_('Middle Align'),
					'desc'=>JText::_('It Align middle vertically, it is perfect when show content in left o right'),
					'std'=>0,
				),


				'class'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
					'std'=>''
				),

			),
		),
	)
);
