<?php
/**
* @package SP Page Builder
* @author JoomShaper http://www.joomshaper.com
* @version 1.0.0
* @copyright Copyright (c) 2010 - 2016 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('Restricted access');

// load custom icons
require_once dirname(dirname( __DIR__ )) . '/fields/customicons.php';

SpAddonsConfig::addonConfig(
	array(
		'type'=>'content',
		'addon_name'=>'ut_animated_number',
		'title'=>JText::_('UT Animated Number'),
		'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_DESC'),
		'category'=>'Unitemplates',
		'attr'=>array(
			'general' => array(
				'admin_label'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL_DESC'),
					'std'=> ''
				),

				'number'=>array(
					'type'=>'number',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_NUMBER'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_NUMBER_DESC'),
					'placeholder'=>'1000',
					'std'=>'1000',
				),

				'number_before_after_text'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_BEF_AFT_TEXT'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_BEF_AFT_TEXT_DESC'),
					'placeholder'=>'+,K,$',
					'std'=>'',
				),

				'number_before_after_text_position'=>array(
					'type'=>'select',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_BEF_AFT_TEXT_POS'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_BEF_AFT_TEXT_POS_DESC'),
					'values'=>array(
						'left'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_BEFORE'),
						'right'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_AFTER'),
					),
					'std'=>'left',
					'depends'=>array(
						array('number_before_after_text', '!=', ''),
					),
				),

				'duration'=>array(
					'type'=>'number',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_DURATION'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_DURATION_DESC'),
					'placeholder'=>'1000',
					'std'=>'1000',
				),

				'color'=>array(
					'type'=>'color',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_NUMBER_COLOR'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_NUMBER_COLOR_DESC'),
					'std'=>'',
				),

				'font_size'=>array(
					'type'=>'slider',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_NUMBER_FONT_SIZE'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_NUMBER_FONT_SIZE_DESC'),
					'placeholder'=>36,
					'std'=>array(
						'md'=>36
					),
					'responsive'=>true,
					'max'=>400
				),
				
				'line_height'=>array(
					'type'=>'slider',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_LINE_HEIGHT'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_LINE_HEIGHT_DESC'),
					'placeholder'=>36,
					'std'=>array(
						'md'=>36
					),
					'responsive'=>true,
					'max'=>400
				),

				'font_weight'=>array(
					'type'=>'select',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_FONT_WEIGHT'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_FONT_WEIGHT_DESC'),
					'values'=>array(
						100=>100,
						200=>200,
						300=>300,
						400=>400,
						500=>500,
						600=>600,
						700=>700,
						800=>800,
						900=>900,
					),
					'std'=>'',
				),

				'margin'=>array(
					'type'=>'margin',
					'title'=>JText::_('Number Margin'),
					'std'=>'',
				),

				'separator_title'=>array(
					'type'=>'separator',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_OPTIONS'),
				),

				'counter_title'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_TITLE'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_TITLE_DESC'),
					'std'=>'Animated Number',
				),

				'title_color'=>array(
					'type'=>'color',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_TITLE_COLOR'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_TITLE_COLOR_DESC'),
					'std'=>'',
					'depends'=>array(array('counter_title', '!=', '')),
				),

				'title_font_size'=>array(
					'type'=>'slider',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_TITLE_FONT_SIZE'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_TITLE_FONT_SIZE_DESC'),
					'placeholder'=>18,
					'std'=>array(
						'md'=>18
					),
					'responsive'=>true,
					'max'=>400
				),

				'title_font_weight'=>array(
					'type'=>'select',
					'title'=>JText::_('Title Font Weight'),
					'desc'=>JText::_('Set Title font weight here'),
					'values'=>array(
						100=>100,
						200=>200,
						300=>300,
						400=>400,
						500=>500,
						600=>600,
						700=>700,
						800=>800,
						900=>900,
					),
					'std'=>'',
				),

				'title_line_height'=>array(
					'type'=>'slider',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_TITLE_LINE_HEIGHT'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_TITLE_LINE_HEIGHT_DESC'),
					'placeholder'=>36,
					'std'=>array(
						'md'=>36
					),
					'responsive'=>true,
					'max'=>400
				),

				'title_margin'=>array(
					'type'=>'margin',
					'title'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN'),
					'responsive'=>true,
					'std'=>array('md'=>'','sm'=>'','xs'=>''),
					'depends'=>array(array('counter_title', '!=', '')),
				),

				'title_position'=>array(
					'type'=>'select',
					'title'=>JText::_('Title Position'),
					'values'=>array(
						'before'=>JText::_('Before Counter'),
						'after'=>JText::_('After Counter'),
					),
					'std'=>'after',
					'depends'=>array(array('counter_title', '!=', '')),
				),

				'separator_icon'=>array(
					'type'=>'separator',
					'title'=>JText::_('Icon Options')
				),

				'icon'=>array(
					'type'=>'select',
					'title'=>JText::_('Icon'),
					'values'=>array(
						''=>JText::_('JNONE'),
						'1'=>JText::_('FontAwesome'),
						'2'=>JText::_('Custom Icon'),
					),
					'std'=>'',
				),

				'icon_font'=>array(
					'type'=>'icon',
					'title'=>JText::_('Icon'),
					'desc'=>JText::_('Select an icon from list'),
					'std'=>'',
					'depends'=>array('icon'=> 1),
				),

				'custom_icon'=>array(
					'type'=>'select',
					'title'=>JText::_('Custom Icon'),
					'desc'=>JText::_('Select a custom icon from list'),
					'values' => $customicons,
					'std'=>'',
					'depends'=>array('icon'=> 2),
				),

				'icon_size'=>array(
					'type'=>'slider',
					'title'=>JText::_('Icon Size'),
					'placeholder'=>48,
					'std'=>array(
						'md'=>48
					),
					'responsive'=>true,
					'max'=>400,
					'depends'=>array(array('icon', '!=', '')),
				),

				'icon_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Icon Color'),
					'depends'=>array(array('icon', '!=', '')),
					'std'=>'',
				),

				'icon_background'=>array(
					'type'=>'color',
					'title'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND_COLOR'),
					'std'=>'',
					'depends'=>array(array('icon', '!=', '')),
				),

				'icon_border_radius'=>array(
					'type'=>'number',
					'title'=>JText::_('Icon Border Radius'),
					'depends'=>array(array('icon', '!=', '')),
					'std'=> 0,
				),

				'icon_position'=>array(
					'type'=>'select',
					'title'=>JText::_('Icon Position'),
					'values'=>array(
						'top'=>JText::_('Top'),
						'right'=>JText::_('Right'),
						'bottom'=>JText::_('Bottom'),
						'left'=>JText::_('Left'),
					),
					'std'=>'top',
					'depends'=>array(array('icon', '!=', '')),
				),

				'icon_padding'=>array(
					'type'=>'padding',
					'title'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_PADDING'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_PADDING_DESC'),
					'depends'=>array(array('icon', '!=', '')),
					'responsive' => true,
				),

				'alignment'=>array(
					'type'=>'select',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_CONTENT_ALIGNMENT'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_CONTENT_ALIGNMENT_DESC'),
					'values'=>array(
						'sppb-text-left'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_LEFT'),
						'sppb-text-center'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_CENTER'),
						'sppb-text-right'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_RIGHT'),
					),
					'std'=>'sppb-text-center',
				),

				'class'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
					'std'=>''
				),
			),
		),
	)
);
