<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_articles_category
 *
 * @copyright   (C) 2010 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;

?>
<div class="ublog<?php echo ' '.htmlspecialchars($params->get('moduleclass_sfx'), ENT_COMPAT, 'UTF-8'); ?>">
	<div class="article-list">
		<div class="row">
		<?php foreach ($list as $item) : ?>
			<?php
			$images = json_decode($item->images);
			$itemattribs = json_decode( $item->attribs );
			$article_format = (isset($itemattribs->helix_ultimate_article_format) && $itemattribs->helix_ultimate_article_format) ? $itemattribs->helix_ultimate_article_format : 'standard';
			$counter = $params->get('count');
			?>

			<div class="col-12 col-md-6 col-lg-<?php echo ($counter >= 3) ? '4' : '6';?> col-xl-<?php echo ($counter <= 4) ? round(12 / $counter) : '3';?>">
				<div class="article">
					<?php if($article_format == 'gallery') : ?>
						<?php echo LayoutHelper::render('joomla.content.blog.gallery', array('attribs' => $itemattribs, 'id'=>$item->id.'-'.$module->id)); ?>
					<?php elseif($article_format == 'video') : ?>
						<?php echo LayoutHelper::render('joomla.content.blog.video', array('attribs' => $itemattribs)); ?>
					<?php elseif($article_format == 'audio') : ?>
						<?php echo LayoutHelper::render('joomla.content.blog.audio', array('attribs' => $itemattribs)); ?>
					<?php else: ?>
						<?php echo LayoutHelper::render('joomla.content.module_image', $item); ?>
					<?php endif; ?>
					<div class="article-body">
						<div class="article-header">
							<h3>
								<a href="<?php echo $item->link; ?>"><?php echo $item->title; ?></a>
							</h3>
						</div>
						<?php if ($params->get('show_author') || $item->displayCategoryTitle || $item->displayDate || $item->displayHits) : ?>
							<div class="article-info">
								<?php if ($params->get('show_author')) : ?>
									<span class="createdby">
										<?php echo $item->displayAuthorName; ?>
									</span>
								<?php endif; ?>

								<?php if ($item->displayCategoryTitle) : ?>
									<span class="category-name">
										<?php echo $item->displayCategoryTitle; ?>
									</span>
								<?php endif; ?>

								<?php if ($item->displayDate) : ?>
									<span class="published"><?php echo $item->displayDate; ?></span>
								<?php endif; ?>

								<?php if ($item->displayHits) : ?>
									<span class="hits">
										<?php echo 'Hits: '.$item->displayHits;?>
									</span>
								<?php endif; ?>
							</div>
						<?php endif;?>
						<?php if ($params->get('show_introtext')) : ?>
							<div class="article-introtext">
								<?php echo strip_tags($item->displayIntrotext); ?>
							</div>
						<?php endif; ?>
						<?php if ($params->get('show_readmore')) : ?>
							<div class="readmore mt-10">
								<a class="btn btn-sm btn-primary <?php echo $item->active; ?>" href="<?php echo $item->link; ?>">
									<?php if ($item->params->get('access-view') == false) : ?>
										<?php echo Text::_('MOD_ARTICLES_CATEGORY_REGISTER_TO_READ_MORE'); ?>
									<?php elseif ($readmore = $item->alternative_readmore) : ?>
										<?php echo $readmore; ?>
										<?php echo HTMLHelper::_('string.truncate', $item->title, $params->get('readmore_limit')); ?>
											<?php if ($params->get('show_readmore_title', 0) != 0) : ?>
												<?php echo HTMLHelper::_('string.truncate', $item->title, $params->get('readmore_limit')); ?>
											<?php endif; ?>
									<?php elseif ($params->get('show_readmore_title', 0) == 0) : ?>
										<?php echo trim(Text::sprintf('MOD_ARTICLES_CATEGORY_READ_MORE_TITLE'), ' .'); ?>
									<?php else : ?>
										<?php echo Text::_('MOD_ARTICLES_CATEGORY_READ_MORE'); ?>
										<?php echo HTMLHelper::_('string.truncate', $item->title, $params->get('readmore_limit')); ?>
									<?php endif; ?>
								</a>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		<?php endforeach; ?>
		</div>
	</div>
</div>
