<?php
/**
 * @package Helix Ultimate Framework
 * @author Unitemplates https://www.unitemplates.com
 * @copyright Copyright (c) 2010 - 2021 Unitemplates
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
*/

defined ('_JEXEC') or die();

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Uri\Uri;

HTMLHelper::addIncludePath(JPATH_COMPONENT . '/helpers');

$app = Factory::getApplication();

$this->category->text = $this->category->description;
$app->triggerEvent('onContentPrepare', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$this->category->description = $this->category->text;

$results = $app->triggerEvent('onContentAfterTitle', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$afterDisplayTitle = trim(implode("\n", $results));

$results = $app->triggerEvent('onContentBeforeDisplay', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$beforeDisplayContent = trim(implode("\n", $results));

$results = $app->triggerEvent('onContentAfterDisplay', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$afterDisplayContent = trim(implode("\n", $results));

// Unitemplates
// Custom Blog Layouts
$doc = Factory::getDocument();
$ublog_layout = $this->params->get('ublog_layout');
if($ublog_layout === 'masonry'){
	$doc->addScript(Uri::root(true) . '/templates/ut_construction/js/ut_assets/isotope/isotope.pkgd.min.js' );
}

?>

<div class="ublog <?php echo $this->pageclass_sfx; ?>" itemscope="" itemtype="http://schema.org/Blog">
	<?php if ($this->params->get('show_page_heading')) : ?>
		<div class="page-header">
			<h1><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
		</div>
	<?php endif; ?>
	
	<?php echo $afterDisplayTitle; ?>

	<?php if (empty($this->lead_items) && empty($this->link_items) && empty($this->intro_items)) : ?>
		<?php if ($this->params->get('show_no_articles', 1)) : ?>
			<p><?php echo Text::_('COM_CONTENT_NO_ARTICLES'); ?></p>
		<?php endif; ?>
	<?php endif; ?>

	<?php $leadingcount = 0; ?>
	<?php if (!empty($this->lead_items)) : ?>
		<div class="article-list articles-leading">
			<?php foreach ($this->lead_items as &$item) : ?>
				<div class="article<?php echo $item->state == 0 ? ' system-unpublished' : null; ?>"
					itemprop="blogPost" itemscope itemtype="https://schema.org/BlogPosting">
					<?php
					$this->item = & $item;
					$this->item->leading = true;
					echo $this->loadTemplate('item');
					?>
				</div>
				<?php $leadingcount++; ?>
			<?php endforeach; ?>
		</div>
	<?php endif; ?>

	<?php
	$introcount = count($this->intro_items);
	$counter = 0;
	?>

	<?php if (!empty($this->intro_items)) : ?>
		<div class="article-list">
			<div class="row<?php if($ublog_layout === 'masonry'){echo ' masonry';}?>">
			<?php foreach ($this->intro_items as $key => &$item) : ?>
				<div class="<?php if($ublog_layout === 'masonry'){echo 'masonry-item';}?> col-lg-6 col-xl-<?php echo round(12 / $this->params->get('num_columns')); ?>">
					<div class="article <?php echo $item->state == 0 ? ' system-unpublished' : null; ?>"
						itemprop="blogPost" itemscope itemtype="https://schema.org/BlogPosting">
						<?php
						$this->item = & $item;
						echo $this->loadTemplate('item');
						?>
					</div>
					<?php $counter++; ?>
				</div>
			<?php endforeach; ?>
			</div>
		</div>
	<?php endif; ?>

	<?php if (($this->params->def('show_pagination', 1) == 1 || ($this->params->get('show_pagination') == 2)) && ($this->pagination->pagesTotal > 1)) : ?>
		<nav class="pagination-wrapper d-flex justify-content-center w-100">
			<?php echo $this->pagination->getPagesLinks(); ?>
		</nav>
	<?php endif; ?>
</div>
<?php if($ublog_layout === 'masonry'):?>
	<script>
	window.addEventListener("load", function() {
		var iso = new Isotope('.masonry', {
			// options
			itemSelector: '.masonry-item',
			percentPosition: true,
			masonry:{
				columnWidth:'.masonry-item'
			}
		});
	});
	</script>
<?php endif;?>
