<?php
/**
 * @package Helix Ultimate Framework
 * @author Unitemplates https://www.unitemplates.com
 * @copyright Copyright (c) 2010 - 2021 Unitemplates
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
*/

defined ('_JEXEC') or die();

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Router\Route;

// Create a shortcut for params.
$params = $this->item->params;
$attribs = json_decode($this->item->attribs);
HTMLHelper::addIncludePath(JPATH_COMPONENT . '/helpers/html');
$article_format = (isset($attribs->helix_ultimate_article_format) && $attribs->helix_ultimate_article_format) ? $attribs->helix_ultimate_article_format : 'standard';

// Check if associations are implemented. If they are, define the parameter.
$assocParam = (Associations::isEnabled() && $params->get('show_associations'));
?>

<div class="project-media">
	<?php if($article_format == 'gallery') : ?>
		<?php echo LayoutHelper::render('joomla.content.blog.gallery', array('attribs' => $attribs, 'id'=>$this->item->id)); ?>
	<?php elseif($article_format == 'video') : ?>
		<?php echo LayoutHelper::render('joomla.content.projects_video_image', $this->item); ?>
	<?php elseif($article_format == 'audio') : ?>
		<?php echo LayoutHelper::render('joomla.content.blog.audio', array('attribs' => $attribs)); ?>
	<?php else: ?>
		<?php echo LayoutHelper::render('joomla.content.intro_image', $this->item); ?>
	<?php endif; ?>

</div>
<div class="project-content">
	<a class="link-icon" href="<?php echo Route::_(ContentHelperRoute::getArticleRoute($this->item->slug, $this->item->catid, $this->item->language)); ?>">
		<span class="fas fa-plus"></span>
	</a>
	<div class="project-header">
		<?php if ($params->get('show_title')) : ?>
			<h2>
				<?php if ($params->get('link_titles') && ($params->get('access-view') || $params->get('show_noauth', '0') == '1')) : ?>
					<a href="<?php echo Route::_(ContentHelperRoute::getArticleRoute($this->item->slug, $this->item->catid, $this->item->language)); ?>">
						<?php echo $this->item->title; ?>
					</a>
				<?php else : ?>
					<?php echo $this->item->title; ?>
				<?php endif; ?>
			</h2>
		<?php endif; ?>

		<?php if (!isset($this->item->catslug)){
			$this->item->catslug = $this->item->catid . ':' . $this->item->category_alias;
		} ?>

		<?php if ($params->get('link_category') && $this->item->catslug) : ?>
			<div class="project-category"><a href="<?php echo JRoute::_(ContentHelperRoute::getCategoryRoute($this->item->catslug)); ?>"><?php echo $this->item->category_title; ?></a></div>
		<?php else : ?>
			<div class="project-category"><?php echo $this->item->category_title; ?></div>
		<?php endif; ?>
		<?php echo LayoutHelper::render('joomla.content.ut_item_state', $this->item); ?>
	</div>

	<div class="project-body">
		<div class="project-introtext">
			<?php
			$intro_limit = $this->params->get('intro_limit');
			if ($params->get('intro_hidden')) {
				if($params->get('intro_truncate')){
					echo HTMLHelper::_('string.abridge', strip_tags($this->item->introtext), $length = $intro_limit, $intro = ($intro_limit + 3));				
				} else {
					echo $this->item->introtext;
				}
			}?>
		</div>
	</div>
</div>
