<?php
/**
 * @package Helix Ultimate Framework
 * @author Unitemplates https://www.unitemplates.com
 * @copyright Copyright (c) 2010 - 2021 Unitemplates
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
*/

defined ('_JEXEC') or die();

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

HTMLHelper::addIncludePath(JPATH_COMPONENT . '/helpers');

$app = Factory::getApplication();
$doc = JFactory::getDocument();
$doc->addScript(Uri::root(true).'/templates/ut_construction/js/ut_assets/isotope/isotope.pkgd.min.js');

// project variables
$project_layout = $this->params->get('projects_layout');
$columns = 'col-12';
$columns .= ($this->params->get('num_columns')) ? ' col-lg-'.round(12 / $this->params->get('num_columns')) : '';
$columns .= ($this->params->get('num_columns_md')) ? ' col-md-'.round(12 / $this->params->get('num_columns_md')) : '';
$columns .= ($this->params->get('num_columns_sm')) ? ' col-sm-'.round(12 / $this->params->get('num_columns_sm')) : '';
$show_filters = $this->params->get('show_filters', 0);
?>

<div class="projects <?php echo $this->pageclass_sfx; ?> <?php echo $project_layout;?>-layout">
	<?php if ($this->params->get('show_page_heading')) : ?>
		<div class="page-header">
			<h1><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
		</div>
	<?php endif; ?>

	<?php if (empty($this->lead_items) && empty($this->link_items) && empty($this->intro_items)) : ?>
		<?php if ($this->params->get('show_no_articles', 1)) : ?>
			<p><?php echo Text::_('COM_CONTENT_NO_ARTICLES'); ?></p>
		<?php endif; ?>
	<?php endif; ?>

	<?php
	$introcount = count($this->intro_items);
	$counter = 0;
	?>

	<?php if (!empty($this->intro_items)) : ?>
		<?php if ($show_filters) :?>
			<div id="filter" class="filter-options mb-30">
				<a href="#" class="active" data-group="*"><?php echo Text::_('UT_FILTER_ALL');?></a>
			<?php
				$unique_cats = array();
				foreach ($this->intro_items as $cats) {
					$unique_cats[$cats->catid] = $cats->category_title;
				}
				foreach ($unique_cats as $key => $cat) {
					echo '<a href="#" class="filter-item" data-group=".'.str_replace(' ', '-', $cat).'">'.$cat.'</a>';
				}
			?>
			</div>
		<?php endif; ?>
		<div id="projectWrapper" class="projects-list row overflow-hidden">
			<?php foreach ($this->intro_items as $key => &$item) : ?>
				<div class="<?php echo $columns; ?> project-wrapper <?php echo str_replace(' ', '-', $item->category_title);?>">
					<div class="project <?php echo $item->state == 0 ? ' system-unpublished' : null; ?>">
						<?php
						$this->item = & $item;
						if ($project_layout != 'construction') {
							echo $this->loadTemplate($project_layout);// load other layouts
						} else {
							echo $this->loadTemplate('item');
						}
						?>
					</div>
					<?php $counter++; ?>
				</div>
			<?php endforeach; ?>
		</div>
	<?php endif; ?>

	<?php if (($this->params->def('show_pagination', 1) == 1 || ($this->params->get('show_pagination') == 2)) && ($this->pagination->pagesTotal > 1)) : ?>
		<nav class="pagination-wrapper d-flex justify-content-center w-100">
			<?php echo $this->pagination->getPagesLinks(); ?>
		</nav>
	<?php endif; ?>
</div>

<script>
	<?php //documentation https://isotope.metafizzy.co/ filtering and masonry ands https://codepen.io/desandro/pen/BgcCD ?>
	window.addEventListener("load", function() {
		var grid = new Isotope('#projectWrapper', {
			// options
			itemSelector: '.project-wrapper',
			percentPosition: true,
			masonry:{
				columnWidth:'.project-wrapper'
			}
		});

		// Filters 
		var filtersElem = document.querySelector('#filter');
		filtersElem.addEventListener( 'click', function( event ) {
			event.preventDefault();			
			// only work with buttons
			if ( !matchesSelector( event.target, 'a' ) ) {
				return;
			}
			var filterValue = event.target.getAttribute('data-group');
			// use matching filter function
			grid.arrange({ filter: filterValue });

			//toggle active class
			filtersElem.querySelector('.active').classList.remove('active');
			event.target.classList.add('active');
		});
	});	
</script>