<?php
/**
 * @package Helix Ultimate Framework
 * @author JoomShaper https://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2021 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
*/

defined ('_JEXEC') or die();

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Helper\ModuleHelper;// for custom modules

HTMLHelper::addIncludePath(JPATH_COMPONENT . '/helpers');

$template = HelixUltimate\Framework\Platform\Helper::loadTemplateData();
$tmpl_params = $template->params;

$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::root(true).'/templates/ut_construction/js/ut_assets/venobox/venobox.min.css');
$doc->addScript(Uri::root(true).'/templates/ut_construction/js/ut_assets/venobox/venobox.min.js');

// Create shortcuts to some parameters.
$params  = $this->item->params;
$images  = json_decode($this->item->images);
$urls    = json_decode($this->item->urls);
$canEdit = $params->get('access-edit');
$user    = Factory::getUser();
$info    = $params->get('info_block_position', 0);
$page_header_tag = 'h1';
$attribs = json_decode($this->item->attribs);
$article_format = (isset($attribs->helix_ultimate_article_format) && $attribs->helix_ultimate_article_format) ? $attribs->helix_ultimate_article_format : 'standard';

// Check if associations are implemented. If they are, define the parameter.
$assocParam = (Associations::isEnabled() && $params->get('show_associations'));
$currentDate   = Factory::getDate()->format('Y-m-d H:i:s');
$isExpired  = JVERSION < 4
	? (strtotime($this->item->publish_down) < strtotime(Factory::getDate())) && $this->item->publish_down != Factory::getDbo()->getNullDate()
	: !is_null($this->item->publish_down) && $this->item->publish_down < $currentDate;
?>

<?php
//All extrafields for get directly by name
foreach($this->item->jcfields as $jcfield)
	{
		$this->item->jcFields[$jcfield->name] = $jcfield;
	}
?>
<?php
if (JVERSION < 4) {
	$project_gallery = (isset($this->item->jcFields['project-gallery']->rawvalue)) ? $this->item->jcFields['project-gallery']->rawvalue : '';
	$gallery_images = json_decode($project_gallery, true);
} else {
	$gallery_images = (isset($this->item->jcFields['project-gallery']->subform_rows)) ? $this->item->jcFields['project-gallery']->subform_rows : '';
}

if (JVERSION < 4) {
	$project_details = (isset($this->item->jcFields['project-details']->rawvalue)) ? $this->item->jcFields['project-details']->rawvalue : '';
	$details = json_decode($project_details, true);
} else {
	$details = (isset($this->item->jcFields['project-details']->subform_rows)) ? $this->item->jcFields['project-details']->subform_rows : '';
}
?>
<div class="single-project interior-layout <?php echo $this->pageclass_sfx; ?>">
	<meta itemprop="inLanguage" content="<?php echo ($this->item->language === '*') ? Factory::getConfig()->get('language') : $this->item->language; ?>">
	<div class="project-main-media">
		<?php if($article_format == 'gallery') : ?>
			<?php echo LayoutHelper::render('joomla.content.blog.gallery', array('attribs' => $attribs, 'id'=>$this->item->id)); ?>
		<?php elseif($article_format == 'video') : ?>
			<?php echo LayoutHelper::render('joomla.content.blog.video', array('attribs' => $attribs)); ?>
		<?php elseif($article_format == 'audio') : ?>
			<?php echo LayoutHelper::render('joomla.content.blog.audio', array('attribs' => $attribs)); ?>
		<?php else: ?>
			<?php echo LayoutHelper::render('joomla.content.full_image', $this->item); ?>
		<?php endif; ?>
	</div>
	<?php if ($params->get('show_title') || $params->get('show_author')) : ?>
	<div class="project-header">
		<?php if ($params->get('show_title')) : ?>
			<<?php echo $page_header_tag; ?>>
				<?php echo $this->escape($this->item->title); ?>
			</<?php echo $page_header_tag; ?>>
		<?php endif; ?>
		<?php if ($this->item->state == 0) : ?>
			<span class="badge bg-warning text-dark"><?php echo Text::_('JUNPUBLISHED'); ?></span>
		<?php endif; ?>
		<?php if (strtotime($this->item->publish_up) > strtotime(Factory::getDate())) : ?>
			<span class="badge bg-warning text-dark"><?php echo Text::_('JNOTPUBLISHEDYET'); ?></span>
		<?php endif; ?>
		<?php if ($isExpired) : ?>
			<span class="badge bg-warning text-dark"><?php echo Text::_('JEXPIRED'); ?></span>
		<?php endif; ?>

		<?php if($canEdit && !$this->print) : ?>
			<?php echo HTMLHelper::_('icon.edit', $this->item, $params); ?>
		<?php endif; ?>
	</div>
	<?php endif; ?>

	<div class="project-main-content">
		<ul class="nav nav-tabs" id="projectTabs" role="tablist">
			<li class="nav-item">
				<a class="nav-link active" id="description-tab" data-bs-toggle="tab" href="#description" role="tab" aria-controls="description" aria-selected="true"><?php echo Text::_('UT_TAB_DESCRIPTION');?></a>
			</li>
			<?php if ($details) : ?>
			<li class="nav-item">
				<a class="nav-link" id="details-tab" data-bs-toggle="tab" href="#details" role="tab" aria-controls="details" aria-selected="false"><?php echo Text::_('UT_TAB_DETAILS');?></a>
			</li>
			<?php endif;?>
			<?php if ($gallery_images) :?>
			<li class="nav-item">
				<a class="nav-link" id="gallery-tab" data-bs-toggle="tab" href="#gallery" role="tab" aria-controls="gallery" aria-selected="false"><?php echo Text::_('UT_TAB_GALLERY');?></a>
			</li>
			<?php endif;?>
		</ul>
		<div class="tab-content" id="projectTabContent">
			<div class="tab-pane fade show active" id="description" role="tabpanel" aria-labelledby="description-tab">
				<div class="project-text">
					<?php echo $this->item->text; ?>
				</div>
			</div>
			<?php if ($details) : ?>
				<div class="tab-pane fade" id="details" role="tabpanel" aria-labelledby="details-tab">
					<div class="project-info">
						<ul class="row">						
							<?php foreach ($details as $detail) : ?>
								<?php
								$detail_name = (JVERSION < 4) ? $detail['Detail Name'] : $detail['detail-name']->rawvalue;
								$detail_value = (JVERSION < 4) ? $detail['Detail Value'] : $detail['detail-value']->rawvalue;
								?>
								<li class="col-12 col-sm-6 col-lg-4">
									<h4><?php echo $detail_name;?>:</h4><span><?php echo $detail_value;?></span>
								</li>
							<?php endforeach ?>
							<li class="col-12 col-sm-6 col-lg-4">
								<h4><?php echo Text::_('JCATEGORY');?>:</h4>

								<?php if (!isset($this->item->catslug)){
									$this->item->catslug = $this->item->catid . ':' . $this->item->category_alias;
								} ?>

								<?php if ($params->get('link_category') && $this->item->catslug) : ?>
									<a href="<?php echo Route::_(ContentHelperRoute::getCategoryRoute($this->item->catslug)); ?>"><?php echo $this->item->category_title; ?></a>
								<?php else : ?>
									<?php echo $this->item->category_title; ?>
								<?php endif; ?>
							</li>
						</ul>
					</div>
				</div>
			<?php endif;?>
			<?php if ($gallery_images) :?>
				<div class="tab-pane fade" id="gallery" role="tabpanel" aria-labelledby="gallery-tab">
					<div class="project-gallery">
						<div class="row">
						<?php
						$i = 0;
						foreach ($gallery_images as $key => $g_image) {
							$i++;
							$image_number = count($gallery_images);
							if ($image_number < 4) {
								$column = (12 / $image_number );
							} else {
								$column = '3';
							}
							$thumbnail = (JVERSION < 4) ? $g_image['Thumbnail'] : $g_image['thumbnail']->rawvalue['imagefile'];
							$fullimage = (JVERSION < 4) ? $g_image['Image'] : $g_image['image']->rawvalue['imagefile'];
							$image_src = ($thumbnail) ? $thumbnail : $fullimage;
							if ($fullimage) {
								echo '<div class="col-6 col-sm-4 col-md-'.$column.'">';
								echo '<a class="venobox" data-gall="project_gallery" data-title="'.$this->item->title.' '. $i.'" href="'.strtok($fullimage, '#').'">';
								if (JVERSION >= 4) {
									$layoutAttr = ['src' => $image_src, 'alt' => $this->item->title,];
									echo LayoutHelper::render('joomla.html.image', array_merge($layoutAttr));
								}
								else
								{
									echo '<img src="'.$image_src.'" alt="'.$this->item->title.' '. $i.'" />';
								}
								echo '</a>';
								echo '</div>';
							}
						}?>
						</div>
					</div>
				</div>
			<?php endif;?>				
		</div>
	</div>
	<?php if($tmpl_params->get('social_share') || ($info == 0 && $params->get('show_tags', 1) && !empty($this->item->tags->itemTags))) : ?>
		<div class="project-footer">
			<?php if ($info == 0 && $params->get('show_tags', 1) && !empty($this->item->tags->itemTags)) : ?>
				<div class="project-tags me-auto align-self-center">
					<?php $this->item->tagLayout = new FileLayout('joomla.content.tags'); ?>
					<?php echo $this->item->tagLayout->render($this->item->tags->itemTags); ?>
				</div>
			<?php endif; ?>
			<div class="project-share">
				<?php echo LayoutHelper::render('joomla.content.social_share', $this->item); ?>
			</div>
		</div>
	<?php endif; ?>

	<?php
	if (!empty($this->item->pagination) && $this->item->pagination && $this->item->paginationposition) :
		echo $this->item->pagination;
	?>
	<?php endif; ?>

	<?php
	$modrelated = ModuleHelper::getModules('related');
	$options = array('style' => 'sp_xhtml');
	foreach ($modrelated as $related):?>
		<div class="project-related">
			<?php echo ModuleHelper::renderModule($related, $options);?>
		</div>
	<?php endforeach;?>

	<?php if (!$this->print) : ?>
		<?php echo LayoutHelper::render('joomla.content.blog.comments.comments', $this->item); ?>
	<?php endif; ?>
</div>
