<?php
/**
 * @package Helix_Ultimate_Framework
 * @author JoomShaper <support@joomshaper.com>
 * Copyright (c) 2010 - 2021 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 */

defined ('_JEXEC') or die();

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Component\ComponentHelper;

$cparams = ComponentHelper::getParams('com_media');
$tparams = $this->item->params;
$canDo   = ContentHelper::getActions('com_contact', 'category', $this->item->catid);
$canEdit = $canDo->get('core.edit') || ($canDo->get('core.edit.own') && $this->item->created_by === Factory::getUser()->id);
$htag    = $tparams->get('show_page_heading') ? 'h2' : 'h1';
?>

<!-- for joomla3 -->
<?php if(JVERSION < 4) : ?>
	<div class="contact" itemscope itemtype="https://schema.org/Person">
		<?php if ($tparams->get('show_page_heading')) : ?>
			<h1>
				<?php echo $this->escape($tparams->get('page_heading')); ?>
			</h1>
		<?php endif; ?>

		<?php if ($this->contact->name && $tparams->get('show_name')) : ?>
			<div class="page-header">
				<h2>
					<?php if ($this->item->published == 0) : ?>
						<span class="label label-warning"><?php echo Text::_('JUNPUBLISHED'); ?></span>
					<?php endif; ?>
					<span class="contact-name" itemprop="name"><?php echo $this->contact->name; ?></span>
				</h2>
			</div>
		<?php endif; ?>

		<?php $show_contact_category = $tparams->get('show_contact_category'); ?>

		<?php if ($show_contact_category === 'show_no_link') : ?>
			<h3>
				<span class="contact-category"><?php echo $this->contact->category_title; ?></span>
			</h3>
		<?php elseif ($show_contact_category === 'show_with_link') : ?>
			<?php $contactLink = ContactHelperRoute::getCategoryRoute($this->contact->catid); ?>
			<h3>
				<span class="contact-category"><a href="<?php echo $contactLink; ?>">
					<?php echo $this->escape($this->contact->category_title); ?></a>
				</span>
			</h3>
		<?php endif; ?>

		<?php echo $this->item->event->afterDisplayTitle; ?>

		<?php if ($tparams->get('show_contact_list') && count($this->contacts) > 1) : ?>
			<form action="#" method="get" name="selectForm" id="selectForm">
				<label for="select_contact"><?php echo Text::_('COM_CONTACT_SELECT_CONTACT'); ?></label>
				<?php echo HTMLHelper::_('select.genericlist', $this->contacts, 'select_contact', 'class="inputbox" onchange="document.location.href = this.value"', 'link', 'name', $this->contact->link); ?>
			</form>
		<?php endif; ?>

		<?php echo $this->item->event->beforeDisplayContent; ?>
		<div class="row">
			<?php if ($tparams->get('show_email_form') && ($this->contact->email_to || $this->contact->user_id)) : ?>
			<div class="col-md-8">
				<?php echo $this->loadTemplate('form'); ?>
			</div>
			<?php endif; ?>

			<?php if ($this->params->get('show_info', 1)) : ?>
				<div class="col-md-4">
				<?php if ($this->contact->image && $tparams->get('show_image')) : ?>
					<div class="thumbnail mb-3">
						<?php echo HTMLHelper::_('image', $this->contact->image, $this->contact->name, array('itemprop' => 'image')); ?>
					</div>
				<?php endif; ?>

				<?php if ($this->contact->con_position && $tparams->get('show_position')) : ?>
					<dl class="contact-position dl-horizontal">
						<dt class="d-none"><?php echo Text::_('COM_CONTACT_POSITION'); ?>:</dt>
						<dd itemprop="jobTitle">
							<h3><?php echo $this->contact->con_position; ?></h3>
						</dd>
					</dl>
				<?php endif; ?>

				<?php echo $this->loadTemplate('address'); ?>

				<?php if ($tparams->get('allow_vcard')) : ?>
					<?php echo Text::_('COM_CONTACT_DOWNLOAD_INFORMATION_AS'); ?>
					<a href="<?php echo Route::_('index.php?option=com_contact&amp;view=contact&amp;id=' . $this->contact->id . '&amp;format=vcf'); ?>">
					<?php echo Text::_('COM_CONTACT_VCARD'); ?></a>
				<?php endif; ?>
				</div>

			<?php endif; ?>
		</div>

		<?php if ($tparams->get('show_links')) : ?>
			<?php echo $this->loadTemplate('links'); ?>
		<?php endif; ?>

		<?php if ($tparams->get('show_articles') && $this->contact->user_id && $this->contact->articles) : ?>
			<?php echo '<h3>' . Text::_('JGLOBAL_ARTICLES') . '</h3>'; ?>
			<?php echo $this->loadTemplate('articles'); ?>
		<?php endif; ?>

		<?php if ($tparams->get('show_profile') && $this->contact->user_id && PluginHelper::isEnabled('user', 'profile')) : ?>
			<?php echo '<h3>' . Text::_('COM_CONTACT_PROFILE') . '</h3>'; ?>
			<?php echo $this->loadTemplate('profile'); ?>
		<?php endif; ?>

		<?php if ($tparams->get('show_user_custom_fields') && $this->contactUser) : ?>
			<?php echo $this->loadTemplate('user_custom_fields'); ?>
		<?php endif; ?>

		<?php if ($this->contact->misc && $tparams->get('show_misc')) : ?>
			<?php echo '<h3>' . Text::_('COM_CONTACT_OTHER_INFORMATION') . '</h3>'; ?>
			<div class="contact-miscinfo">
				<dl class="dl-horizontal">
					<dt class="d-none">
						<span class="<?php echo $tparams->get('marker_class'); ?>">
						<?php echo $tparams->get('marker_misc'); ?>
						</span>
					</dt>
					<dd>
						<span class="contact-misc">
							<?php echo $this->contact->misc; ?>
						</span>
					</dd>
				</dl>
			</div>
		<?php endif; ?>

		<?php echo $this->item->event->afterDisplayContent; ?>
	</div>
<?php endif; ?>

<!-- for joomla4 -->
<?php if(JVERSION >= 4) : ?>
<div class="com-contact contact" itemscope itemtype="https://schema.org/Person">
	<?php if ($tparams->get('show_page_heading')) : ?>
		<h1>
			<?php echo $this->escape($tparams->get('page_heading')); ?>
		</h1>
	<?php endif; ?>

	<?php if ($this->item->name && $tparams->get('show_name')) : ?>
		<div class="page-header">
			<<?php echo $htag; ?>>
				<?php if ($this->item->published == 0) : ?>
					<span class="badge bg-warning text-light"><?php echo Text::_('JUNPUBLISHED'); ?></span>
				<?php endif; ?>
				<span class="contact-name" itemprop="name"><?php echo $this->item->name; ?></span>
			</<?php echo $htag; ?>>
		</div>
	<?php endif; ?>

	<?php if ($canEdit) : ?>
		<?php echo HTMLHelper::_('contacticon.edit', $this->item, $tparams); ?>
	<?php endif; ?>

	<?php $show_contact_category = $tparams->get('show_contact_category'); ?>

	<?php if ($show_contact_category === 'show_no_link') : ?>
		<h3>
			<span class="contact-category"><?php echo $this->item->category_title; ?></span>
		</h3>
	<?php elseif ($show_contact_category === 'show_with_link') : ?>
		<?php $contactLink = Route::_(JVERSION < 4 ? ContactHelperRoute::getCategoryRoute($this->item) : Joomla\Component\Contact\Site\Helper\RouteHelper::getCategoryRoute($this->item->catid, $this->item->language)); ?>
		<h3>
			<span class="contact-category"><a href="<?php echo $contactLink; ?>">
				<?php echo $this->escape($this->item->category_title); ?></a>
			</span>
		</h3>
	<?php endif; ?>

	<?php echo $this->item->event->afterDisplayTitle; ?>

	<?php if ($tparams->get('show_contact_list') && count($this->contacts) > 1) : ?>
		<form action="#" method="get" name="selectForm" id="selectForm" class="mb-4">
			<label for="select_contact" class="form-label"><?php echo Text::_('COM_CONTACT_SELECT_CONTACT'); ?></label>
			<?php echo HTMLHelper::_(
				'select.genericlist',
				$this->contacts,
				'select_contact',
				'class="form-select" onchange="document.location.href = this.value"', 'link', 'name', $this->item->link);
			?>
		</form>
	<?php endif; ?>

	<?php if ($tparams->get('show_tags', 1) && !empty($this->item->tags->itemTags)) : ?>
		<div class="com-contact__tags">
			<?php $this->item->tagLayout = new FileLayout('joomla.content.tags'); ?>
			<?php echo $this->item->tagLayout->render($this->item->tags->itemTags); ?>
		</div>
	<?php endif; ?>

	<?php echo $this->item->event->beforeDisplayContent; ?>
	<div class="row">
		<?php if ($tparams->get('show_email_form') && ($this->item->email_to || $this->item->user_id)) : ?>
			<div class="col-md-8">
				<?php echo '<h3>' . Text::_('COM_CONTACT_EMAIL_FORM') . '</h3>'; ?>
				<?php echo $this->loadTemplate('form'); ?>
			</div>
		<?php endif; ?>
		<?php if ($this->params->get('show_info', 1)) : ?>
			<div class="col-md-4">
				<?php if ($this->item->image && $tparams->get('show_image')) : ?>
					<?php echo HTMLHelper::_(
						'image',
						$this->item->image,
						htmlspecialchars($this->item->name,  ENT_QUOTES, 'UTF-8'),
						array('itemprop' => 'image', 'class' => 'thumbnail mb-3')
					); ?>
				<?php endif; ?>
				<?php //echo '<h3>' . Text::_('COM_CONTACT_DETAILS') . '</h3>'; ?>
				<?php if ($this->item->con_position && $tparams->get('show_position')) : ?>
					<div class="contact-position d-flex mb-3">
						<div itemprop="jobTitle">
							<h3><?php echo $this->item->con_position; ?></h3>
						</div>
					</div>
				<?php endif; ?>

				<div class="contact-info">
					<?php echo $this->loadTemplate('address'); ?>
					<?php if ($tparams->get('allow_vcard')) : ?>
						<div class="mb-4">
							<?php echo Text::_('COM_CONTACT_DOWNLOAD_INFORMATION_AS'); ?>
							<a href="<?php echo Route::_('index.php?option=com_contact&amp;view=contact&amp;id=' . $this->item->id . '&amp;format=vcf'); ?>">
								<?php echo Text::_('COM_CONTACT_VCARD'); ?>
							</a>
						</div>
					<?php endif; ?>
				</div>
			</div>
		<?php endif; ?>
	</div>

	<?php if ($tparams->get('show_links')) : ?>
		<?php echo $this->loadTemplate('links'); ?>
	<?php endif; ?>

	<?php if ($tparams->get('show_articles') && $this->item->user_id && $this->item->articles) : ?>
		<?php echo '<h3>' . Text::_('JGLOBAL_ARTICLES') . '</h3>'; ?>
		<?php echo $this->loadTemplate('articles'); ?>
	<?php endif; ?>

	<?php if ($tparams->get('show_profile') && $this->item->user_id && PluginHelper::isEnabled('user', 'profile')) : ?>
		<?php echo '<h3>' . Text::_('COM_CONTACT_PROFILE') . '</h3>'; ?>
		<?php echo $this->loadTemplate('profile'); ?>
	<?php endif; ?>

	<?php if ($tparams->get('show_user_custom_fields') && $this->contactUser) : ?>
		<?php echo $this->loadTemplate('user_custom_fields'); ?>
	<?php endif; ?>

	<?php if ($this->item->misc && $tparams->get('show_misc')) : ?>
		<div class="contact-miscinfo">
			<?php echo '<h3>' . Text::_('COM_CONTACT_OTHER_INFORMATION') . '</h3>'; ?>
			<div class="d-flex">
				<div class="contact-misc">
					<?php echo $this->item->misc; ?>
				</div>
			</div>
		</div>
	<?php endif; ?>
	<?php echo $this->item->event->afterDisplayContent; ?>
</div>
<?php endif; ?>
