<?php
/**
 * @package Helix_Ultimate_Framework
 * @author JoomShaper <support@joomshaper.com>
 * @copyright Copyright (c) 2010 - 2021 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 */

defined ('_JEXEC') or die('Restricted Access');

use HelixUltimate\Framework\Platform\Helper;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Language\Text;

$data = $displayData;
$offcanvas_position = $displayData->params->get('offcanvas_position', 'right');
$menu_type = $displayData->params->get('menu_type');

$feature_folder_path = JPATH_THEMES . '/' . $data->template->template . '/features';

include_once $feature_folder_path . '/logo.php';
include_once $feature_folder_path . '/social.php';
include_once $feature_folder_path . '/contact.php';
include_once $feature_folder_path . '/menu.php';
include_once $feature_folder_path . '/menu2.php';

/**
 * Helper classes for-
 * social icons, contact info, site logo, Menu header.
 *
 */
$social 	= new HelixUltimateFeatureSocial($data->params);
$contact 	= new HelixUltimateFeatureContact($data->params);
$logo    	= new HelixUltimateFeatureLogo($data->params);
$menu    	= new HelixUltimateFeatureMenu($data->params);
$menu2       = new HelixUltimateFeatureMenu2($data->params);

$logoClass = 'col-6 col-lg-2';
$menuClass = 'col-6 col-lg-5';
if($offcanvas_position == 'left')
{
	$logoClass = 'col-12 col-lg-2';
	$menuClass = 'd-none d-lg-block col-lg-5';
}

/**
 * Get related modules
 * The modules are mod_search
 */
$searchModule = Helper::getSearchModule();
?>

<?php if($displayData->params->get('sticky_header')) { ?>
	<div class="sticky-header-placeholder"></div>
<?php } ?>
<div id="sp-top-bar" class="header-4 d-none d-md-block">
	<div class="container">
		<div class="container-inner">
			<div class="row">
				<div id="sp-top1" class="col-md-4 col-lg-3">
					<div class="sp-column text-center text-md-start">
						<?php if(isset($social->load_pos) && $social->load_pos === 'before') : ?>
							<?php echo $social->renderFeature(); ?>
							<jdoc:include type="modules" name="top1" style="sp_xhtml" />
						<?php else : ?>
							<jdoc:include type="modules" name="top1" style="sp_xhtml" />
							<?php echo $social->renderFeature(); ?>
						<?php endif; ?>
					</div>
				</div>

				<div id="sp-top2" class="col-md-8 col-lg-6">
					<div class="sp-column text-right text-md-center">
						<?php if(isset($contact->load_pos) && $contact->load_pos === 'before') : ?>
							<?php echo $contact->renderFeature(); ?>
							<jdoc:include type="modules" name="top2" style="sp_xhtml" />
						<?php else : ?>
							<jdoc:include type="modules" name="top2" style="sp_xhtml" />
							<?php echo $contact->renderFeature(); ?>
						<?php endif; ?>
					</div>
				</div>

				<div id="sp-top3" class="col-lg-3 d-none d-lg-inline-block">
					<div class="sp-column text-center text-md-end">
						<jdoc:include type="modules" name="top3" style="sp_xhtml" />
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<header id="sp-header" class="header-4">
	<div class="container">
		<div class="container-inner">
			<div class="row">
				<!-- Menu2 -->
				<div id="sp-menu2" class="d-none d-lg-block <?php echo $menuClass;?> menu-left">
					<div class="sp-column">
						<jdoc:include type="modules" name="menu2" style="sp_xhtml" />
						<?php echo $menu2->renderFeature(); ?>
					</div>
				</div>
				<!-- Logo -->
				<div id="sp-logo" class="<?php echo $logoClass;?> logo-center">
					<div class="sp-column">
						<?php echo $logo->renderFeature(); ?>
						<jdoc:include type="modules" name="logo" style="sp_xhtml" />
					</div>
				</div>
				<!-- Menu -->
				<div id="sp-menu" class="<?php echo $menuClass; ?> menu-right">
					<div class="sp-column d-flex justify-content-end align-items-center">
						<?php echo $menu->renderFeature(); ?>
						<jdoc:include type="modules" name="menu" style="sp_xhtml" />
					</div>
				</div>
			</div>
		</div>
	</div>
</header>
