<?php
/**
 * @package Helix_Ultimate_Framework
 * @author JoomShaper <support@joomshaper.com>
 * @copyright Copyright (c) 2010 - 2021 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 */

defined ('_JEXEC') or die('Restricted Access');

use HelixUltimate\Framework\Platform\Helper;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Language\Text;

$data = $displayData;
$offcanvas_position = $displayData->params->get('offcanvas_position', 'right');
$menu_type = $displayData->params->get('menu_type');

$feature_folder_path = JPATH_THEMES . '/' . $data->template->template . '/features';

include_once $feature_folder_path . '/social.php';
include_once $feature_folder_path . '/contact.php';
include_once $feature_folder_path . '/logo.php';
include_once $feature_folder_path . '/menu.php';

/**
 * Helper classes for-
 * social icons, contact info, site logo, Menu header.
 *
 */
$social 	= new HelixUltimateFeatureSocial($data->params);
$contact 	= new HelixUltimateFeatureContact($data->params);
$logo    	= new HelixUltimateFeatureLogo($data->params);
$menu    	= new HelixUltimateFeatureMenu($data->params);

/** Logo and menu html classes */
$logoClass = 'col-auto';
$menuClass = 'col-auto flex-auto';

/**
 * Get related modules
 * The modules are mod_search
 */
$searchModule = Helper::getSearchModule();
?>

<?php if($displayData->params->get('sticky_header')) { ?>
	<div class="sticky-header-placeholder"></div>
<?php } ?>
<div id="sp-top-bar" class="header-1 d-none d-md-block">
	<div class="container">
		<div class="container-inner">
			<div class="row">
				<div class="col-md-3 logo-col d-none d-lg-inline-flex position-relative"></div>
				<div id="sp-top1" class="col-md-8 col-lg-6">
					<div class="sp-column text-center text-md-start">
						<?php if(isset($contact->load_pos) && $contact->load_pos === 'before') :?>
							<?php echo $contact->renderFeature(); ?>
							<jdoc:include type="modules" name="top1" style="sp_xhtml" />
						<?php else : ?>
							<jdoc:include type="modules" name="top1" style="sp_xhtml" />
							<?php echo $contact->renderFeature(); ?>
						<?php endif ?>
					</div>
				</div>

				<div id="sp-top2" class="col-md-4 col-lg-3">
					<div class="sp-column text-center text-md-end">
						<?php if(isset($social->load_pos) && $social->load_pos === 'before') :?>
							<?php echo $social->renderFeature(); ?>
							<jdoc:include type="modules" name="top2" style="sp_xhtml" />
						<?php else : ?>
							<jdoc:include type="modules" name="top2" style="sp_xhtml" />
							<?php echo $social->renderFeature(); ?>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<header id="sp-header" class="header-1">
	<div class="container">
		<div class="container-inner">
			<div class="row justify-content-between">
				<!-- Logo -->
				<div id="sp-logo" class="<?php echo $logoClass; ?>">
					<div class="sp-column">
						<?php echo $logo->renderFeature(); ?>
						<jdoc:include type="modules" name="logo" style="sp_xhtml" />
					</div>
				</div>

				<!-- Menu -->
				<div id="sp-menu" class="<?php echo $menuClass; ?>">
					<div class="sp-column d-flex justify-content-end align-items-center">
						<?php echo $menu->renderFeature(); ?>
						<jdoc:include type="modules" name="menu" style="sp_xhtml" />
					</div>
				</div>
			</div>
		</div>
	</div>
</header>
