/*!
 * jquery.instagramFeed
 *
 * @version 1.2.5
 *
 * @author Javier Sanahuja Liebana <bannss1@gmail.com>
 * @contributor csanahuja <csanahuja@gmail.com>
 *
 * https://github.com/jsanahuja/jquery.instagramFeed
 *
 * Version by Unitemplates.com
 *
 */
(function($){
    var defaults = {
        'host': "https://www.instagram.com/",
        'username': '',
        'tag': '',
        'container': '',
        'display_profile': true,
        'display_biography': true,
        'display_gallery': true,
        'display_igtv': false,
        'get_data': false,
        'callback': null,
        'styling': true,
        'items': 8,
        'items_per_row': 4,
        'items_per_row_md': 3,
        'items_per_row_sm': 2,
        'margin': 5,
        'image_size': 640
    };
    var image_sizes = {
        "150": 0,
        "240": 1,
        "320": 2,
        "480": 3,
        "640": 4
    };
    var escape_map = {
        '&': '&amp;',
        '<': '&lt;',
        '>': '&gt;',
        '"': '&quot;',
        "'": '&#39;',
        '/': '&#x2F;',
        '`': '&#x60;',
        '=': '&#x3D;'
    };
    function escape_string(str){
        return str.replace(/[&<>"'`=\/]/g, function (char) {
            return escape_map[char];
        });
    }

    $.instagramFeed = function(opts){
        var options = $.fn.extend({}, defaults, opts);
        if(options.username == "" && options.tag == ""){
            console.error("Instagram Feed: Error, no username or tag found.");
            return false;
        }
        if(typeof options.get_raw_json !== "undefined"){
            console.warn("Instagram Feed: get_raw_json is deprecated. See use get_data instead");
            options.get_data = options.get_raw_json;
        }
        if(!options.get_data && options.container == ""){
            console.error("Instagram Feed: Error, no container found.");
            return false;
        }
        if(options.get_data && options.callback == null){
            console.error("Instagram Feed: Error, no callback defined to get the raw json");
            return false;
        }

        var is_tag = options.username == "",
            url = is_tag ? options.host + "explore/tags/"+ options.tag + "/" : options.host + options.username + "/";

        $.get(url, function(data){
            data = data.split("window._sharedData = ")[1].split("<\/script>")[0];
            data = JSON.parse(data.substr(0, data.length - 1));
            data = data.entry_data.ProfilePage || data.entry_data.TagPage;
            if(typeof data === "undefined"){
                console.error("Instagram Feed: It looks like YOUR network has been temporary banned because of too many requests. See https://github.com/jsanahuja/jquery.instagramFeed/issues/25");
                return;
            }
            data = data[0].graphql.user || data[0].graphql.hashtag;
            
            if(options.get_data){
                options.callback(data);
                return;
            }   

            var html = "";
            //Displaying profile
            if(options.display_profile){
                html += "<div class='instagram_profile'>";
                html += "<img class='instagram_profile_image' src='"+ data.profile_pic_url +"' alt='"+ (is_tag ? data.name + " tag pic" : data.username + " profile pic") +"' />";
                if(is_tag)
                    html += "<p class='instagram_tag'><a href='https://www.instagram.com/explore/tags/"+ options.tag +"' rel='noopener' target='_blank'>#"+ options.tag +"</a></p>";
                else
                    html += "<p class='instagram_username'>@"+ data.full_name +" (<a href='https://www.instagram.com/"+ options.username +"' rel='noopener' target='_blank'>@"+options.username+"</a>)</p>";
        
                if(!is_tag && options.display_biography)
                    html += "<p class='instagram_biography'>"+ data.biography +"</p>";
        
                html += "</div>";
            }

            //image size
            var image_index = typeof image_sizes[options.image_size] !== "undefined" ? image_sizes[options.image_size] : image_sizes[640];

            if(options.display_gallery){
                if(typeof data.is_private !== "undefined" && data.is_private === true){
                    html += "<p class='instagram_private'><strong>This profile is private</strong></p>";
                }else{
                    var imgs = (data.edge_owner_to_timeline_media || data.edge_hashtag_to_media).edges;
                        max = (imgs.length > options.items) ? options.items : imgs.length;
                    
                    html += "<div class='instagram_gallery'>";
                    html += "<div class='instagram_items'>";
                    for(var i = 0; i < max; i++){
                        var url = "https://www.instagram.com/p/" + imgs[i].node.shortcode,
                            image, type_resource, caption;

                        switch(imgs[i].node.__typename){
                            case "GraphSidecar":
                                type_resource = "sidecar"
                                image = imgs[i].node.thumbnail_resources[image_index].src;
                                break;
                            case "GraphVideo":
                                type_resource = "video";
                                image = imgs[i].node.thumbnail_src
                                break;
                            default:
                                type_resource = "image";
                                image = imgs[i].node.thumbnail_resources[image_index].src;
                        }
                        
                        if(
                            typeof imgs[i].node.edge_media_to_caption.edges[0] !== "undefined" && 
                            typeof imgs[i].node.edge_media_to_caption.edges[0].node !== "undefined" && 
                            typeof imgs[i].node.edge_media_to_caption.edges[0].node.text !== "undefined" && 
                            imgs[i].node.edge_media_to_caption.edges[0].node.text !== null
                        ){
                            caption = imgs[i].node.edge_media_to_caption.edges[0].node.text;
                        }else if(
                            typeof imgs[i].node.accessibility_caption !== "undefined" && 
                            imgs[i].node.accessibility_caption !== null
                        ){
                            caption = imgs[i].node.accessibility_caption;
                        }else{
                            caption = (is_tag ? data.name : data.username) + " image " + i;
                        }

                        html += "<div class='instagram_item'>";
                        html += "<a href='" + url +"' class='instagram-" + type_resource + "' rel='noopener' target='_blank'>";
                        html += "<img src='" + image + "' alt='" + escape_string(caption) + "' />";
                        html += "</a>";
                        html += "</div>";
                    }
                    html += "</div>";
                    html += "</div>";
                }
            }
            
            if(options.display_igtv && typeof data.edge_felix_video_timeline !== "undefined"){
                var igtv = data.edge_felix_video_timeline.edges,
                    max = (igtv.length > options.items) ? options.items : igtv.length
                if(igtv.length > 0){
                    html += "<div class='instagram_igtv'>";
                    html += "<div class='instagram_items'>";
                    for(var i = 0; i < max; i++){
                        html += "<div class='instagram_item'>";
                        html += "<a href='https://www.instagram.com/p/"+ igtv[i].node.shortcode +"' rel='noopener' target='_blank'>";
                        html += "<img src='"+ igtv[i].node.thumbnail_src +"' alt='"+ options.username +" instagram image "+ i+"' />";
                        html += "</a>";
                        html += "</div>";
                    }
                    html += "</div>";
                    html += "</div>";
                }
            }
            $(options.container).html(html);

            if(options.styling){
                $(options.container+' .instagram_profile').css({'text-align':'center'});
                $(options.container+' .instagram_profile_image').css({'max-width':'125px','min-width':'50px','border-radius': '50%','margin':'0 auto 1rem'});
                $(options.container+' .instagram_username').css({'font-size':'1.25rem','margin-bottom':'0.5rem'});
                $(options.container+' .instagram_biography').css({'margin-bottom':'1.25rem'});
                $(options.container+' .instagram_items').css({'display':'flex','display':'-webkit-flex','flex-wrap':'wrap','-webkit-flex-wrap':'wrap','margin': '-'+options.margin+'px'});
                $(options.container+' .instagram_item').css({'position':'relative','width':'100%','padding': options.margin+'px'});
                $(options.container+' .instagram_item img').css({'width':'100%'});

                $(window).on('resize', function () {
                    var MQ = $(window).outerWidth();
                    if (MQ > 991.99) {
                        var itemWidth = (100 / options.items_per_row);
                    } else if (MQ > 767.99 && MQ < 992) {
                        var itemWidth = (100 / options.items_per_row_md);
                    } else if(MQ > 575.99 && MQ < 768){
                        var itemWidth = (100 / options.items_per_row_sm);
                    } else {
                        var itemWidth = 50;
                    }
                    $(options.container+' .instagram_item').css({'max-width': itemWidth+'%','flex':'0 0 '+itemWidth+'%','box-sizing':'border-box'});
                }).trigger("resize");
            }

        }).fail(function(e){
            console.error("Instagram Feed: Unable to fetch the given user/tag. Instagram responded with the status code: ", e.status);
        });

        return true;
    };
    
})(jQuery);
