
--
-- Estructura de tabla para la tabla `#__assets`
--

DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE IF NOT EXISTS `#__assets` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) UNSIGNED NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=340 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `#__assets`
--

INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES
(1, 0, 0, 657, 0, 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(2, 1, 1, 2, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 3, 6, 1, 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(4, 1, 7, 8, 1, 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(5, 1, 9, 10, 1, 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(6, 1, 11, 12, 1, 'com_config', 'com_config', '{}'),
(7, 1, 13, 16, 1, 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(8, 1, 17, 222, 1, 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
(9, 1, 223, 224, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 225, 226, 1, 'com_installer', 'com_installer', '{\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'),
(11, 1, 227, 228, 1, 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1}}'),
(12, 1, 229, 230, 1, 'com_login', 'com_login', '{}'),
(13, 1, 231, 232, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 233, 234, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 235, 236, 1, 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'),
(16, 1, 237, 252, 1, 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1}}'),
(17, 1, 253, 254, 1, 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(18, 1, 255, 354, 1, 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1}}'),
(19, 1, 355, 358, 1, 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(20, 1, 359, 360, 1, 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1}}'),
(21, 1, 361, 362, 1, 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1}}'),
(23, 1, 363, 364, 1, 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1}}'),
(24, 1, 365, 368, 1, 'com_users', 'com_users', '{\"core.admin\":{\"7\":1}}'),
(26, 1, 369, 370, 1, 'com_wrapper', 'com_wrapper', '{}'),
(27, 8, 18, 23, 2, 'com_content.category.2', 'Uncategorised', '{}'),
(28, 3, 4, 5, 2, 'com_banners.category.3', 'Uncategorised', '{}'),
(29, 7, 14, 15, 2, 'com_contact.category.4', 'Uncategorised', '{}'),
(30, 19, 356, 357, 2, 'com_newsfeeds.category.5', 'Uncategorised', '{}'),
(32, 24, 366, 367, 2, 'com_users.category.7', 'Uncategorised', '{}'),
(33, 1, 371, 372, 1, 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(34, 1, 373, 374, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{}'),
(35, 1, 375, 376, 1, 'com_tags', 'com_tags', '{}'),
(36, 1, 377, 378, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(37, 1, 379, 380, 1, 'com_ajax', 'com_ajax', '{}'),
(38, 1, 381, 382, 1, 'com_postinstall', 'com_postinstall', '{}'),
(39, 18, 256, 257, 2, 'com_modules.module.1', 'Main Menu', '{}'),
(40, 18, 258, 259, 2, 'com_modules.module.2', 'Login', '{}'),
(41, 18, 260, 261, 2, 'com_modules.module.3', 'Popular Articles', '{}'),
(42, 18, 262, 263, 2, 'com_modules.module.4', 'Recently Added Articles', '{}'),
(43, 18, 264, 265, 2, 'com_modules.module.8', 'Toolbar', '{}'),
(44, 18, 266, 267, 2, 'com_modules.module.9', 'Quick Icons', '{}'),
(45, 18, 268, 269, 2, 'com_modules.module.10', 'Logged-in Users', '{}'),
(46, 18, 270, 271, 2, 'com_modules.module.12', 'Admin Menu', '{}'),
(47, 18, 272, 273, 2, 'com_modules.module.13', 'Admin Submenu', '{}'),
(48, 18, 274, 275, 2, 'com_modules.module.14', 'User Status', '{}'),
(49, 18, 276, 277, 2, 'com_modules.module.15', 'Title', '{}'),
(50, 18, 278, 279, 2, 'com_modules.module.16', 'Login Form', '{}'),
(51, 18, 280, 281, 2, 'com_modules.module.17', 'Breadcrumbs', '{}'),
(52, 18, 282, 283, 2, 'com_modules.module.79', 'Multilanguage status', '{}'),
(53, 18, 284, 285, 2, 'com_modules.module.86', 'Joomla Version', '{}'),
(54, 16, 238, 239, 2, 'com_menus.menu.1', 'Main Menu', '{}'),
(55, 18, 286, 287, 2, 'com_modules.module.87', 'Sample Data', '{}'),
(56, 1, 383, 384, 1, 'com_privacy', 'com_privacy', '{}'),
(57, 1, 385, 386, 1, 'com_actionlogs', 'com_actionlogs', '{}'),
(58, 18, 288, 289, 2, 'com_modules.module.88', 'Latest Actions', '{}'),
(59, 18, 290, 291, 2, 'com_modules.module.89', 'Privacy Dashboard', '{}'),
(60, 1, 387, 388, 1, 'com_fields', 'com_fields', '{}'),
(61, 1, 389, 390, 1, 'com_associations', 'com_associations', '{}'),
(62, 1, 391, 570, 1, 'com_sppagebuilder', 'SP Page Builder', '{}'),
(63, 18, 292, 293, 2, 'com_modules.module.90', 'Footer 1 (Construction)', '{}'),
(66, 62, 392, 393, 2, 'com_sppagebuilder.page.1', 'Home Presentation', '{}'),
(67, 8, 24, 37, 2, 'com_content.fieldgroup.1', 'Project Details', '{}'),
(68, 8, 38, 155, 2, 'com_content.category.8', 'Projects', '{}'),
(69, 67, 25, 26, 3, 'com_content.field.1', 'Project Gallery', '{}'),
(70, 67, 27, 28, 3, 'com_content.field.2', 'Project Details', '{}'),
(71, 68, 39, 70, 3, 'com_content.category.9', 'Construction', '{}'),
(72, 68, 71, 96, 3, 'com_content.category.10', 'Mining', '{}'),
(73, 68, 97, 128, 3, 'com_content.category.11', 'Interior', '{}'),
(74, 85, 41, 42, 5, 'com_content.article.1', 'Roof Renovation', '{}'),
(75, 86, 51, 52, 5, 'com_content.article.2', 'Beach House', '{}'),
(76, 87, 61, 62, 5, 'com_content.article.3', 'Pipeline Restoration', '{}'),
(77, 85, 43, 44, 5, 'com_content.article.4', 'Office Remodeling', '{}'),
(78, 86, 53, 54, 5, 'com_content.article.5', 'Steel Kitchen', '{}'),
(79, 87, 63, 64, 5, 'com_content.article.6', 'Drinking Water', '{}'),
(80, 85, 45, 46, 5, 'com_content.article.7', 'Drywall Renovation', '{}'),
(81, 1, 571, 572, 1, '#__ucm_content.1', '#__ucm_content.1', '{}'),
(82, 18, 294, 295, 2, 'com_modules.module.93', 'Popular Tags', '{}'),
(83, 18, 296, 297, 2, 'com_modules.module.94', 'Related Projects', '{}'),
(84, 68, 129, 154, 3, 'com_content.category.12', 'Architect', '{}'),
(85, 71, 40, 49, 4, 'com_content.category.13', 'Renovation', '{}'),
(86, 71, 50, 59, 4, 'com_content.category.14', 'General', '{}'),
(87, 71, 60, 69, 4, 'com_content.category.15', 'Industrial', '{}'),
(88, 73, 98, 107, 4, 'com_content.category.16', 'Home', '{}'),
(89, 73, 108, 117, 4, 'com_content.category.17', 'Hotel', '{}'),
(90, 73, 118, 127, 4, 'com_content.category.18', 'Transport', '{}'),
(91, 86, 55, 56, 5, 'com_content.article.8', 'Wood House', '{}'),
(92, 1, 573, 574, 1, '#__ucm_content.2', '#__ucm_content.2', '{}'),
(93, 87, 65, 66, 5, 'com_content.article.9', 'Bridges and Roads', '{}'),
(94, 1, 575, 576, 1, '#__ucm_content.3', '#__ucm_content.3', '{}'),
(95, 85, 47, 48, 5, 'com_content.article.10', 'Floor Change', '{}'),
(96, 1, 577, 578, 1, '#__ucm_content.4', '#__ucm_content.4', '{}'),
(97, 86, 57, 58, 5, 'com_content.article.11', 'Swimming Pool', '{}'),
(98, 1, 579, 580, 1, '#__ucm_content.5', '#__ucm_content.5', '{}'),
(99, 87, 67, 68, 5, 'com_content.article.12', 'Steel Industry', '{}'),
(100, 1, 581, 582, 1, '#__ucm_content.6', '#__ucm_content.6', '{}'),
(101, 16, 240, 241, 2, 'com_menus.menu.2', 'Construction Menu', '{}'),
(102, 16, 242, 243, 2, 'com_menus.menu.3', 'Mining Menu', '{}'),
(103, 16, 244, 245, 2, 'com_menus.menu.4', 'Interior Menu', '{}'),
(104, 16, 246, 247, 2, 'com_menus.menu.5', 'Architect Menu', '{}'),
(105, 62, 394, 395, 2, 'com_sppagebuilder.category.19', 'Construction', '{}'),
(106, 62, 396, 397, 2, 'com_sppagebuilder.category.20', 'Architect', '{}'),
(107, 62, 398, 399, 2, 'com_sppagebuilder.category.21', 'Mining', '{}'),
(108, 62, 400, 401, 2, 'com_sppagebuilder.category.22', 'Interior', '{}'),
(109, 62, 402, 403, 2, 'com_sppagebuilder.category.23', 'Pages', '{}'),
(110, 18, 298, 299, 2, 'com_modules.module.95', 'Related Projects', '{}'),
(111, 1, 583, 584, 1, '#__ucm_content.7', '#__ucm_content.7', '{}'),
(112, 1, 585, 586, 1, '#__ucm_content.8', '#__ucm_content.8', '{}'),
(113, 1, 587, 588, 1, '#__ucm_content.9', '#__ucm_content.9', '{}'),
(114, 1, 589, 590, 1, '#__ucm_content.10', '#__ucm_content.10', '{}'),
(115, 1, 591, 592, 1, '#__ucm_content.11', '#__ucm_content.11', '{}'),
(116, 1, 593, 594, 1, '#__ucm_content.12', '#__ucm_content.12', '{}'),
(119, 88, 99, 100, 5, 'com_content.article.14', 'Large Kitchen', '{}'),
(120, 1, 595, 596, 1, '#__ucm_content.14', '#__ucm_content.14', '{}'),
(121, 89, 109, 110, 5, 'com_content.article.15', 'Drink Bar', '{}'),
(122, 1, 597, 598, 1, '#__ucm_content.15', '#__ucm_content.15', '{}'),
(123, 90, 119, 120, 5, 'com_content.article.16', 'Luxury Train', '{}'),
(124, 1, 599, 600, 1, '#__ucm_content.16', '#__ucm_content.16', '{}'),
(125, 88, 101, 102, 5, 'com_content.article.17', 'Bedroom', '{}'),
(126, 1, 601, 602, 1, '#__ucm_content.17', '#__ucm_content.17', '{}'),
(127, 89, 111, 112, 5, 'com_content.article.18', 'Hotel Lobby', '{}'),
(128, 1, 603, 604, 1, '#__ucm_content.18', '#__ucm_content.18', '{}'),
(129, 90, 121, 122, 5, 'com_content.article.19', 'Yacht Design', '{}'),
(130, 1, 605, 606, 1, '#__ucm_content.19', '#__ucm_content.19', '{}'),
(131, 88, 103, 104, 5, 'com_content.article.20', 'Hall Staircase', '{}'),
(132, 1, 607, 608, 1, '#__ucm_content.20', '#__ucm_content.20', '{}'),
(133, 89, 113, 114, 5, 'com_content.article.21', 'Couple Bedroom', '{}'),
(134, 1, 609, 610, 1, '#__ucm_content.21', '#__ucm_content.21', '{}'),
(135, 90, 123, 124, 5, 'com_content.article.22', 'Luxury Bus Design', '{}'),
(136, 1, 611, 612, 1, '#__ucm_content.22', '#__ucm_content.22', '{}'),
(137, 88, 105, 106, 5, 'com_content.article.23', 'Open Terrace', '{}'),
(138, 1, 613, 614, 1, '#__ucm_content.23', '#__ucm_content.23', '{}'),
(139, 89, 115, 116, 5, 'com_content.article.24', 'Waiting Room', '{}'),
(140, 1, 615, 616, 1, '#__ucm_content.24', '#__ucm_content.24', '{}'),
(141, 90, 125, 126, 5, 'com_content.article.25', 'Private Jet', '{}'),
(142, 1, 617, 618, 1, '#__ucm_content.25', '#__ucm_content.25', '{}'),
(143, 72, 72, 79, 4, 'com_content.category.24', 'Construction', '{}'),
(144, 72, 80, 87, 4, 'com_content.category.25', 'Extraction', '{}'),
(145, 72, 88, 95, 4, 'com_content.category.26', 'Processing', '{}'),
(146, 143, 73, 74, 5, 'com_content.article.26', 'Camp Construction', '{}'),
(147, 1, 619, 620, 1, '#__ucm_content.26', '#__ucm_content.26', '{}'),
(148, 144, 81, 82, 5, 'com_content.article.27', 'Explosives Handling', '{}'),
(149, 1, 621, 622, 1, '#__ucm_content.27', '#__ucm_content.27', '{}'),
(150, 145, 89, 90, 5, 'com_content.article.28', 'Copper Crusher', '{}'),
(151, 1, 623, 624, 1, '#__ucm_content.28', '#__ucm_content.28', '{}'),
(152, 143, 75, 76, 5, 'com_content.article.29', 'Undercut Protection', '{}'),
(153, 1, 625, 626, 1, '#__ucm_content.29', '#__ucm_content.29', '{}'),
(154, 144, 83, 84, 5, 'com_content.article.30', 'Drilling', '{}'),
(155, 1, 627, 628, 1, '#__ucm_content.30', '#__ucm_content.30', '{}'),
(156, 145, 91, 92, 5, 'com_content.article.31', 'Filtering', '{}'),
(157, 1, 629, 630, 1, '#__ucm_content.31', '#__ucm_content.31', '{}'),
(158, 143, 77, 78, 5, 'com_content.article.32', 'Roads', '{}'),
(159, 1, 631, 632, 1, '#__ucm_content.32', '#__ucm_content.32', '{}'),
(160, 144, 85, 86, 5, 'com_content.article.33', 'Transport', '{}'),
(161, 1, 633, 634, 1, '#__ucm_content.33', '#__ucm_content.33', '{}'),
(162, 145, 93, 94, 5, 'com_content.article.34', 'Processing Plant', '{}'),
(163, 1, 635, 636, 1, '#__ucm_content.34', '#__ucm_content.34', '{}'),
(164, 18, 300, 301, 2, 'com_modules.module.96', 'Related Projects', '{}'),
(165, 84, 130, 137, 4, 'com_content.category.27', 'Housing', '{}'),
(166, 84, 138, 145, 4, 'com_content.category.28', 'Building', '{}'),
(167, 84, 146, 153, 4, 'com_content.category.29', 'Culture', '{}'),
(168, 8, 156, 221, 2, 'com_content.category.30', 'Blog', '{}'),
(169, 168, 157, 172, 3, 'com_content.category.31', 'Construction', '{}'),
(170, 168, 173, 188, 3, 'com_content.category.32', 'Mining', '{}'),
(171, 168, 189, 204, 3, 'com_content.category.33', 'Interior', '{}'),
(172, 168, 205, 220, 3, 'com_content.category.34', 'Architect', '{}'),
(173, 165, 131, 132, 5, 'com_content.article.35', 'Mirror House', '{}'),
(174, 1, 637, 638, 1, '#__ucm_content.35', '#__ucm_content.35', '{}'),
(175, 166, 139, 140, 5, 'com_content.article.36', 'Mall Facade', '{}'),
(176, 1, 639, 640, 1, '#__ucm_content.36', '#__ucm_content.36', '{}'),
(177, 167, 147, 148, 5, 'com_content.article.37', 'Riverside Museum', '{}'),
(178, 1, 641, 642, 1, '#__ucm_content.37', '#__ucm_content.37', '{}'),
(179, 165, 133, 134, 5, 'com_content.article.38', 'House Metal Facade', '{}'),
(180, 1, 643, 644, 1, '#__ucm_content.38', '#__ucm_content.38', '{}'),
(181, 166, 141, 142, 5, 'com_content.article.39', 'Shop Center', '{}'),
(182, 1, 645, 646, 1, '#__ucm_content.39', '#__ucm_content.39', '{}'),
(183, 167, 149, 150, 5, 'com_content.article.40', 'Ordos Museum', '{}'),
(184, 1, 647, 648, 1, '#__ucm_content.40', '#__ucm_content.40', '{}'),
(185, 165, 135, 136, 5, 'com_content.article.41', 'Modern House', '{}'),
(186, 1, 649, 650, 1, '#__ucm_content.41', '#__ucm_content.41', '{}'),
(187, 166, 143, 144, 5, 'com_content.article.42', 'York University', '{}'),
(188, 1, 651, 652, 1, '#__ucm_content.42', '#__ucm_content.42', '{}'),
(189, 167, 151, 152, 5, 'com_content.article.43', 'Mosegaard Museum', '{}'),
(190, 1, 653, 654, 1, '#__ucm_content.43', '#__ucm_content.43', '{}'),
(191, 18, 302, 303, 2, 'com_modules.module.97', 'Related Projects', '{}'),
(192, 170, 174, 175, 4, 'com_content.article.44', 'Underground Construction', '{}'),
(193, 170, 176, 177, 4, 'com_content.article.45', 'Womens in the Mine', '{}'),
(194, 170, 178, 179, 4, 'com_content.article.46', 'Automated Mining', '{}'),
(195, 170, 180, 181, 4, 'com_content.article.47', 'Gold Mining', '{}'),
(196, 170, 182, 183, 4, 'com_content.article.48', 'Angola Mines', '{}'),
(197, 170, 184, 185, 4, 'com_content.article.49', 'Engineers Meeting', '{}'),
(198, 170, 186, 187, 4, 'com_content.article.50', 'Inspecting Project', '{}'),
(199, 172, 206, 207, 4, 'com_content.article.51', 'Restaurant Architecture', '{}'),
(200, 172, 208, 209, 4, 'com_content.article.52', 'Coworking Center', '{}'),
(201, 172, 210, 211, 4, 'com_content.article.53', 'Office Interior Design', '{}'),
(202, 172, 212, 213, 4, 'com_content.article.54', 'Architectural House', '{}'),
(203, 172, 214, 215, 4, 'com_content.article.55', 'Modern Cube House', '{}'),
(204, 172, 216, 217, 4, 'com_content.article.56', 'Futuristic Building', '{}'),
(205, 172, 218, 219, 4, 'com_content.article.57', 'Grass Architecture', '{}'),
(206, 169, 158, 159, 4, 'com_content.article.58', 'Water Transport', '{}'),
(207, 169, 160, 161, 4, 'com_content.article.59', 'Roadway Construction', '{}'),
(208, 169, 162, 163, 4, 'com_content.article.60', 'Paving Roadway', '{}'),
(209, 169, 164, 165, 4, 'com_content.article.61', 'Floor Drilling', '{}'),
(210, 169, 166, 167, 4, 'com_content.article.62', 'Women Working', '{}'),
(211, 169, 168, 169, 4, 'com_content.article.63', 'Construction Tools', '{}'),
(212, 169, 170, 171, 4, 'com_content.article.64', 'Mega Construction', '{}'),
(213, 171, 190, 191, 4, 'com_content.article.65', 'Bar Restaurant', '{}'),
(214, 171, 192, 193, 4, 'com_content.article.66', 'Conference Room', '{}'),
(215, 171, 194, 195, 4, 'com_content.article.67', 'Roof Terrace', '{}'),
(216, 171, 196, 197, 4, 'com_content.article.68', 'Beautiful Kitchen', '{}'),
(217, 171, 198, 199, 4, 'com_content.article.69', 'Kids Bedroom', '{}'),
(218, 171, 200, 201, 4, 'com_content.article.70', 'Bedroom Design', '{}'),
(219, 171, 202, 203, 4, 'com_content.article.71', 'Wall Background', '{}'),
(220, 1, 655, 656, 1, '#__ucm_content.44', '#__ucm_content.44', '{}'),
(221, 62, 404, 405, 2, 'com_sppagebuilder.page.2', 'Home Construction', '{}'),
(222, 18, 304, 305, 2, 'com_modules.module.98', 'Smart Search', '{}'),
(223, 18, 306, 307, 2, 'com_modules.module.99', 'Blog Categories', '{}'),
(224, 18, 308, 309, 2, 'com_modules.module.100', 'Latest Articles', '{}'),
(225, 18, 310, 311, 2, 'com_modules.module.101', 'Latest News (construction)', '{}'),
(226, 18, 312, 313, 2, 'com_modules.module.102', 'Smart Search', '{}'),
(227, 18, 314, 315, 2, 'com_modules.module.103', 'Blog Categories', '{}'),
(228, 18, 316, 317, 2, 'com_modules.module.104', 'Latest Articles', '{}'),
(229, 18, 318, 319, 2, 'com_modules.module.105', 'Popular Tags', '{}'),
(230, 16, 248, 249, 2, 'com_menus.menu.6', 'Joomla Menu', '{}'),
(231, 27, 19, 20, 3, 'com_content.article.72', 'Privacy Article', '{}'),
(232, 27, 21, 22, 3, 'com_content.article.73', 'Terms & Conditions', '{}'),
(233, 62, 406, 407, 2, 'com_sppagebuilder.page.3', 'About Us Construction', '{}'),
(234, 62, 408, 409, 2, 'com_sppagebuilder.page.4', 'Services Construction', '{}'),
(235, 62, 410, 411, 2, 'com_sppagebuilder.page.5', 'Contact Construction', '{}'),
(236, 62, 412, 413, 2, 'com_sppagebuilder.page.6', 'Home Architect', '{}'),
(237, 62, 414, 415, 2, 'com_sppagebuilder.page.7', 'About Us Architect', '{}'),
(238, 62, 416, 417, 2, 'com_sppagebuilder.page.8', 'Services Architect', '{}'),
(239, 62, 418, 419, 2, 'com_sppagebuilder.page.9', 'Contact Architect', '{}'),
(240, 16, 250, 251, 2, 'com_menus.menu.7', 'Architect Menu 2', '{}'),
(241, 62, 420, 421, 2, 'com_sppagebuilder.page.10', 'Home Mining', '{}'),
(242, 62, 422, 423, 2, 'com_sppagebuilder.page.11', 'Company Mining', '{}'),
(243, 62, 424, 425, 2, 'com_sppagebuilder.page.12', 'Services Mining', '{}'),
(244, 62, 426, 427, 2, 'com_sppagebuilder.page.13', 'Contact Mining', '{}'),
(245, 62, 428, 429, 2, 'com_sppagebuilder.page.14', 'Home Interior', '{}'),
(246, 62, 430, 431, 2, 'com_sppagebuilder.page.15', 'About Us Interior', '{}'),
(247, 62, 432, 433, 2, 'com_sppagebuilder.page.16', 'Services Interior', '{}'),
(248, 62, 434, 435, 2, 'com_sppagebuilder.page.17', 'Contact Interior', '{}'),
(249, 62, 436, 437, 2, 'com_sppagebuilder.page.18', 'Buttons', '{}'),
(250, 18, 320, 321, 2, 'com_modules.module.106', 'Projects Construction', '{}'),
(251, 62, 438, 439, 2, 'com_sppagebuilder.page.19', 'Footer 1', '{}'),
(252, 62, 440, 441, 2, 'com_sppagebuilder.page.20', 'Services Single Construction', '{}'),
(256, 18, 322, 323, 2, 'com_modules.module.109', 'Projects Architect', '{}'),
(257, 18, 324, 325, 2, 'com_modules.module.110', 'Latest News (Architect)', '{}'),
(258, 62, 442, 443, 2, 'com_sppagebuilder.page.21', 'Service Single Architect', '{}'),
(259, 18, 326, 327, 2, 'com_modules.module.111', 'Footer 2 (Architect)', '{}'),
(260, 62, 444, 445, 2, 'com_sppagebuilder.page.22', 'Footer 2 (Architect)', '{}'),
(261, 18, 328, 329, 2, 'com_modules.module.112', 'Projects Mining', '{}'),
(262, 18, 330, 331, 2, 'com_modules.module.113', 'Latest News (Mining)', '{}'),
(263, 62, 446, 447, 2, 'com_sppagebuilder.page.23', 'Icons', '{}'),
(264, 18, 332, 333, 2, 'com_modules.module.114', 'Projects Interior', '{}'),
(265, 18, 334, 335, 2, 'com_modules.module.115', 'Latest News (Interior)', '{}'),
(266, 18, 336, 337, 2, 'com_modules.module.116', 'Footer 3 (Interior)', '{}'),
(267, 62, 448, 449, 2, 'com_sppagebuilder.page.24', 'Footer 3 (Interior)', '{}'),
(268, 18, 338, 339, 2, 'com_modules.module.117', 'Footer 4 (Mining)', '{}'),
(269, 62, 450, 451, 2, 'com_sppagebuilder.page.25', 'Footer 4 (Mining)', '{}'),
(270, 18, 340, 341, 2, 'com_modules.module.118', 'Mobile Menu - Interior', '{}'),
(271, 18, 342, 343, 2, 'com_modules.module.119', 'Mobile Menu - Mining', '{}'),
(272, 18, 344, 345, 2, 'com_modules.module.120', 'Mobile Menu - Architect 2', '{}'),
(273, 18, 346, 347, 2, 'com_modules.module.121', 'Mobile Menu - Architect', '{}'),
(274, 18, 348, 349, 2, 'com_modules.module.122', 'Mobile Menu - Construction', '{}'),
(275, 62, 452, 453, 2, 'com_sppagebuilder.page.26', 'Typography', '{}'),
(276, 62, 454, 455, 2, 'com_sppagebuilder.page.27', 'Animations', '{}'),
(277, 62, 456, 457, 2, 'com_sppagebuilder.page.28', 'Headers', '{}'),
(278, 62, 458, 459, 2, 'com_sppagebuilder.page.29', 'Title Styles', '{}'),
(279, 62, 460, 461, 2, 'com_sppagebuilder.page.30', 'Addons', '{}'),
(280, 18, 350, 351, 2, 'com_modules.module.123', 'Architect contact Button', '{}'),
(281, 62, 462, 463, 2, 'com_sppagebuilder.category.35', 'Addons', '{}'),
(282, 62, 464, 465, 2, 'com_sppagebuilder.page.31', 'Accordion', '{}'),
(283, 62, 466, 467, 2, 'com_sppagebuilder.page.33', 'Animated Heading', '{}'),
(284, 62, 468, 469, 2, 'com_sppagebuilder.page.35', 'Articles', '{}'),
(285, 62, 470, 471, 2, 'com_sppagebuilder.page.36', 'Articles Scroller', '{}'),
(286, 62, 472, 473, 2, 'com_sppagebuilder.page.37', 'Audio', '{}'),
(287, 62, 474, 475, 2, 'com_sppagebuilder.page.32', 'Alert', '{}'),
(288, 62, 476, 477, 2, 'com_sppagebuilder.page.34', 'Animated Number', '{}'),
(289, 62, 478, 479, 2, 'com_sppagebuilder.page.38', 'Block Number', '{}'),
(290, 62, 480, 481, 2, 'com_sppagebuilder.page.41', 'Carousel', '{}'),
(291, 62, 482, 483, 2, 'com_sppagebuilder.page.42', 'Carousel Pro', '{}'),
(292, 62, 484, 485, 2, 'com_sppagebuilder.page.43', 'Clients', '{}'),
(293, 62, 486, 487, 2, 'com_sppagebuilder.page.44', 'Contact Form', '{}'),
(294, 62, 488, 489, 2, 'com_sppagebuilder.page.45', 'Count Down', '{}'),
(295, 62, 490, 491, 2, 'com_sppagebuilder.page.46', 'Feature Box', '{}'),
(296, 62, 492, 493, 2, 'com_sppagebuilder.page.47', 'Flickr Gallery', '{}'),
(297, 62, 494, 495, 2, 'com_sppagebuilder.page.48', 'Flip Box', '{}'),
(298, 62, 496, 497, 2, 'com_sppagebuilder.page.49', 'Form Builder', '{}'),
(299, 62, 498, 499, 2, 'com_sppagebuilder.page.50', 'Gallery', '{}'),
(300, 62, 500, 501, 2, 'com_sppagebuilder.page.51', 'Google Map', '{}'),
(301, 62, 502, 503, 2, 'com_sppagebuilder.page.52', 'Heading', '{}'),
(302, 62, 504, 505, 2, 'com_sppagebuilder.page.53', 'Icon', '{}'),
(303, 62, 506, 507, 2, 'com_sppagebuilder.page.54', 'Icon Group', '{}'),
(304, 62, 508, 509, 2, 'com_sppagebuilder.page.55', 'Image', '{}'),
(305, 62, 510, 511, 2, 'com_sppagebuilder.page.56', 'Image Carousel', '{}'),
(306, 62, 512, 513, 2, 'com_sppagebuilder.page.57', 'Image Content', '{}'),
(307, 62, 514, 515, 2, 'com_sppagebuilder.page.59', 'Image Overlay', '{}'),
(308, 62, 516, 517, 2, 'com_sppagebuilder.page.60', 'Instagram', '{}'),
(309, 18, 352, 353, 2, 'com_modules.module.124', 'UT Joomstagram', '{}'),
(310, 62, 518, 519, 2, 'com_sppagebuilder.page.62', 'Modal Popup', '{}'),
(311, 62, 520, 521, 2, 'com_sppagebuilder.page.63', 'Navigation', '{}'),
(312, 62, 522, 523, 2, 'com_sppagebuilder.page.64', 'OpenStreet Map', '{}'),
(313, 62, 524, 525, 2, 'com_sppagebuilder.page.65', 'Optin Form', '{}'),
(314, 62, 526, 527, 2, 'com_sppagebuilder.page.66', 'Person', '{}'),
(315, 62, 528, 529, 2, 'com_sppagebuilder.page.67', 'Pie Progress', '{}'),
(316, 62, 530, 531, 2, 'com_sppagebuilder.page.68', 'Price List', '{}'),
(317, 62, 532, 533, 2, 'com_sppagebuilder.page.69', 'Pricing Table', '{}'),
(318, 62, 534, 535, 2, 'com_sppagebuilder.page.70', 'Progress Bar', '{}'),
(319, 62, 536, 537, 2, 'com_sppagebuilder.page.71', 'Slideshow', '{}'),
(320, 62, 538, 539, 2, 'com_sppagebuilder.page.72', 'Raw HTML', '{}'),
(321, 62, 540, 541, 2, 'com_sppagebuilder.page.73', 'Social Share', '{}'),
(322, 62, 542, 543, 2, 'com_sppagebuilder.page.74', 'SoundCloud', '{}'),
(323, 62, 544, 545, 2, 'com_sppagebuilder.page.75', 'Tabs', '{}'),
(324, 62, 546, 547, 2, 'com_sppagebuilder.page.76', 'Table', '{}'),
(325, 62, 548, 549, 2, 'com_sppagebuilder.page.77', 'Team Carousel', '{}'),
(326, 62, 550, 551, 2, 'com_sppagebuilder.page.78', 'Testimonials', '{}'),
(327, 62, 552, 553, 2, 'com_sppagebuilder.page.79', 'Testimonial Carousel', '{}'),
(328, 62, 554, 555, 2, 'com_sppagebuilder.page.80', 'Testimonial Pro', '{}'),
(329, 62, 556, 557, 2, 'com_sppagebuilder.page.81', 'Text Block', '{}'),
(330, 62, 558, 559, 2, 'com_sppagebuilder.page.82', 'Timeline', '{}'),
(331, 62, 560, 561, 2, 'com_sppagebuilder.page.83', 'Twitter Feed', '{}'),
(332, 62, 562, 563, 2, 'com_sppagebuilder.page.85', 'UT Animated Number', '{}'),
(333, 62, 564, 565, 2, 'com_sppagebuilder.page.86', 'UT Person', '{}'),
(334, 62, 566, 567, 2, 'com_sppagebuilder.page.87', 'UT Testimonial', '{}'),
(335, 62, 568, 569, 2, 'com_sppagebuilder.page.58', 'Image Layouts', '{}'),
(336, 67, 29, 30, 3, 'com_content.field.3', 'Thumbnail', '{}'),
(337, 67, 31, 32, 3, 'com_content.field.4', 'Image', '{}'),
(338, 67, 33, 34, 3, 'com_content.field.5', 'Detail Name', '{}'),
(339, 67, 35, 36, 3, 'com_content.field.6', 'Detail Value', '{}');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__associations`
--

DROP TABLE IF EXISTS `#__associations`;
CREATE TABLE IF NOT EXISTS `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__banners`
--

DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE IF NOT EXISTS `#__banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sticky` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `reset` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__banner_clients`
--

DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE IF NOT EXISTS `#__banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__banner_tracks`
--

DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE IF NOT EXISTS `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) UNSIGNED NOT NULL,
  `banner_id` int(10) UNSIGNED NOT NULL,
  `count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__categories`
--

DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE IF NOT EXISTS `#__categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `modified_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_alias` (`alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `#__categories`
--

INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES
(1, 0, 0, 0, 67, 0, '', 'system', 'ROOT', 'root', '', '', 1, NULL, NULL, 1, '{}', '', '', '{}', 101, '2019-04-18 13:44:13', 101, '2019-04-18 13:44:13', 0, '*', 1),
(2, 27, 1, 1, 2, 1, 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2019-04-18 13:44:13', 101, '2019-04-18 13:44:13', 0, '*', 1),
(3, 28, 1, 3, 4, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2019-04-18 13:44:13', 101, '2019-04-18 13:44:13', 0, '*', 1),
(4, 29, 1, 5, 6, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2019-04-18 13:44:13', 101, '2019-04-18 13:44:13', 0, '*', 1),
(5, 30, 1, 7, 8, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2019-04-18 13:44:13', 101, '2019-04-18 13:44:13', 0, '*', 1),
(7, 32, 1, 9, 10, 1, 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2019-04-18 13:44:13', 101, '2019-04-18 13:44:13', 0, '*', 1),
(8, 68, 1, 11, 44, 1, 'projects', 'com_content', 'Projects', 'projects', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-04 05:37:17', 0, '2020-05-04 05:37:17', 0, '*', 1),
(9, 71, 8, 12, 19, 2, 'projects/construction', 'com_content', 'Construction', 'construction', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-07 15:42:27', 0, '2020-05-07 15:42:27', 0, '*', 1),
(10, 72, 8, 20, 27, 2, 'projects/mining', 'com_content', 'Mining', 'mining', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-07 15:43:26', 101, '2020-05-07 15:43:34', 0, '*', 1),
(11, 73, 8, 28, 35, 2, 'projects/interior', 'com_content', 'Interior', 'interior', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-07 15:43:49', 0, '2020-05-07 15:43:49', 0, '*', 1),
(12, 84, 8, 36, 43, 2, 'projects/architect', 'com_content', 'Architect', 'architect', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-16 14:42:30', 0, '2020-05-16 14:42:30', 0, '*', 1),
(13, 85, 9, 13, 14, 3, 'projects/construction/renovation', 'com_content', 'Renovation', 'renovation', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-16 15:45:56', 101, '2020-05-16 15:45:59', 0, '*', 1),
(14, 86, 9, 15, 16, 3, 'projects/construction/general', 'com_content', 'General', 'general', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-16 15:46:38', 101, '2020-05-16 16:37:49', 0, '*', 1),
(15, 87, 9, 17, 18, 3, 'projects/construction/industrial', 'com_content', 'Industrial', 'industrial', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-16 15:48:13', 0, '2020-05-16 15:48:13', 0, '*', 1),
(16, 88, 11, 29, 30, 3, 'projects/interior/home', 'com_content', 'Home', 'home', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-16 18:14:19', 101, '2020-05-16 18:14:22', 0, '*', 1),
(17, 89, 11, 31, 32, 3, 'projects/interior/hotel', 'com_content', 'Hotel', 'hotel', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-16 22:03:34', 0, '2020-05-16 22:03:34', 0, '*', 1),
(18, 90, 11, 33, 34, 3, 'projects/interior/transport', 'com_content', 'Transport', 'transport', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-16 22:03:48', 0, '2020-05-16 22:03:48', 0, '*', 1),
(19, 105, 1, 45, 46, 1, 'construction', 'com_sppagebuilder', 'Construction', 'construction', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-17 07:57:17', 101, '2020-05-17 07:57:21', 0, '*', 1),
(20, 106, 1, 47, 48, 1, 'architect', 'com_sppagebuilder', 'Architect', 'architect', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-17 07:57:31', 0, '2020-05-17 07:57:31', 0, '*', 1),
(21, 107, 1, 49, 50, 1, 'mining', 'com_sppagebuilder', 'Mining', 'mining', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-17 07:57:43', 0, '2020-05-17 07:57:43', 0, '*', 1),
(22, 108, 1, 51, 52, 1, 'interior', 'com_sppagebuilder', 'Interior', 'interior', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-17 07:58:02', 0, '2020-05-17 07:58:02', 0, '*', 1),
(23, 109, 1, 53, 54, 1, 'pages', 'com_sppagebuilder', 'Pages', 'pages', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-17 07:59:59', 101, '2020-05-23 18:43:49', 0, '*', 1),
(24, 143, 10, 21, 22, 3, 'projects/mining/construction', 'com_content', 'Construction', 'construction', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-17 17:25:32', 101, '2020-05-17 17:25:36', 0, '*', 1),
(25, 144, 10, 23, 24, 3, 'projects/mining/extraction', 'com_content', 'Extraction', 'extraction', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-17 17:25:58', 101, '2020-05-17 17:26:29', 0, '*', 1),
(26, 145, 10, 25, 26, 3, 'projects/mining/processing', 'com_content', 'Processing', 'processing', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-17 17:26:39', 0, '2020-05-17 17:26:39', 0, '*', 1),
(27, 165, 12, 37, 38, 3, 'projects/architect/housing', 'com_content', 'Housing', 'housing', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-18 05:08:13', 101, '2020-05-18 05:08:17', 0, '*', 1),
(28, 166, 12, 39, 40, 3, 'projects/architect/building', 'com_content', 'Building', 'building', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-18 05:09:05', 101, '2020-05-18 05:09:07', 0, '*', 1),
(29, 167, 12, 41, 42, 3, 'projects/architect/culture', 'com_content', 'Culture', 'culture', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-18 05:59:22', 0, '2020-05-18 05:59:22', 0, '*', 1),
(30, 168, 1, 55, 64, 1, 'blog', 'com_content', 'Blog', 'blog', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-19 16:31:57', 0, '2020-05-19 16:31:57', 0, '*', 1),
(31, 169, 30, 56, 57, 2, 'blog/construction', 'com_content', 'Construction', 'construction', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-19 16:32:43', 0, '2020-05-19 16:32:43', 0, '*', 1),
(32, 170, 30, 58, 59, 2, 'blog/mining', 'com_content', 'Mining', 'mining', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-19 16:32:43', 101, '2020-05-19 16:33:13', 0, '*', 1),
(33, 171, 30, 60, 61, 2, 'blog/interior', 'com_content', 'Interior', 'interior', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-19 16:32:43', 101, '2020-05-19 16:33:32', 0, '*', 1),
(34, 172, 30, 62, 63, 2, 'blog/architect', 'com_content', 'Architect', 'architect', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-05-19 16:32:43', 101, '2020-05-19 16:33:45', 0, '*', 1),
(35, 281, 1, 65, 66, 1, 'addons', 'com_sppagebuilder', 'Addons', 'addons', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 101, '2020-10-05 04:35:46', 0, '2020-10-05 04:35:46', 0, '*', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__contact_details`
--

DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE IF NOT EXISTS `#__contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `con_position` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` mediumtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname3` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Set if contact is featured.',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `#__contact_details`
--

INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `publish_up`, `publish_down`, `version`, `hits`) VALUES
(1, 'General', 'general', 'Founder', 'Tupac Amaru', 'Comas', 'Lima', 'Peru', '123456', '+51 555 3333', '+51 555 3333', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse scelerisque lobortis odio at cursus. Suspendisse vitae arcu arcu. Suspendisse dignissim nunc at nulla ultricies blandit. Proin efficitur nisi vel ultrices congue. Integer vel mollis ex, nec aliquam leo. Sed convallis, justo vitae placerat aliquet, massa dui suscipit nisl, ac ornare ligula mi vitae neque. Phasellus laoreet a tortor id dignissim. Nulla porta blandit nulla ut dapibus. Maecenas rhoncus dolor sem, at consequat mi ornare nec. Duis aliquet lectus ac neque facilisis, quis commodo nunc suscipit. Duis sit amet enim sit amet tortor tempor accumsan.</p>', 'images/j-contact.jpg', 'admin@localhost.xyz', 0, 1, NULL, NULL, 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"plain\",\"show_tags\":\"\",\"show_info\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"add_mailto_link\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_image\":\"\",\"show_misc\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"articles_display_num\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":false,\"linkb_name\":\"\",\"linkb\":false,\"linkc_name\":\"\",\"linkc\":false,\"linkd_name\":\"\",\"linkd\":false,\"linke_name\":\"\",\"linke\":false,\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', 0, 4, 1, '+51 987654321', '', '', '', '', '*', '2020-05-22 20:27:14', 101, '', '2021-10-03 17:42:23', 101, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 0, NULL, NULL, 4, 39);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__content`
--

DROP TABLE IF EXISTS `#__content`;
CREATE TABLE IF NOT EXISTS `#__content` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `images` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metadata` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(191))
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `#__content`
--

INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `note`) VALUES
(1, 74, 'Roof Renovation', 'roof-renovation', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 13, '2021-08-07 16:51:04', 101, '', '2022-10-25 03:33:59', 101, NULL, NULL, '2021-08-07 16:51:04', NULL, '{\"image_intro\":\"images\\/projects\\/construction\\/renovation_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/renovation_04_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/construction\\/renovation_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/renovation_04.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 9, 4, '', '', 1, 155, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(2, 75, 'Beach House', 'beach-house', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 14, '2021-08-07 16:58:51', 101, '', '2022-10-25 03:34:15', 101, NULL, NULL, '2021-08-07 16:58:51', NULL, '{\"image_intro\":\"images\\/projects\\/construction\\/general_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/general_04_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/construction\\/general_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/general_04.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 6, 4, '', '', 1, 5, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(3, 76, 'Pipeline Restoration', 'pipeline-restoration', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 15, '2021-08-07 17:00:15', 101, '', '2022-10-25 03:34:22', 101, NULL, NULL, '2021-08-07 17:00:15', NULL, '{\"image_intro\":\"images\\/projects\\/construction\\/industrial_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/industrial_04_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/construction\\/industrial_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/industrial_04.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 7, 4, '', '', 1, 7, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(4, 77, 'Office Remodeling', 'office-remodeling', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 13, '2021-08-07 17:01:00', 101, '', '2022-10-25 03:34:29', 101, NULL, NULL, '2021-08-07 17:01:00', NULL, '{\"image_intro\":\"images\\/projects\\/construction\\/renovation_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/renovation_03_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/construction\\/renovation_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/renovation_03.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 6, 3, '', '', 1, 8, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(5, 78, 'Steel Kitchen', 'steel-kitchen', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 14, '2021-08-07 17:01:43', 101, '', '2022-10-25 03:34:34', 101, NULL, NULL, '2021-08-07 17:01:43', NULL, '{\"image_intro\":\"images\\/projects\\/construction\\/general_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/general_03_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/construction\\/general_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/general_03.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 5, 3, '', '', 1, 62, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(6, 79, 'Drinking Water', 'drinking-water', '    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 15, '2021-08-07 17:02:47', 101, '', '2022-10-25 03:34:41', 101, NULL, NULL, '2021-08-07 17:02:47', NULL, '{\"image_intro\":\"images\\/projects\\/construction\\/industrial_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/industrial_03_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/construction\\/industrial_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/industrial_03.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 13, 3, '', '', 1, 106, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(7, 80, 'Drywall Renovation', 'drywall-renovation', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 13, '2021-08-07 17:36:42', 101, '', '2022-10-25 03:34:54', 101, NULL, NULL, '2021-08-07 17:36:42', NULL, '{\"image_intro\":\"images\\/projects\\/construction\\/renovation_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/renovation_02_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/construction\\/renovation_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/renovation_02.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 16, 2, '', '', 1, 205, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(8, 91, 'Wood House', 'wood-house', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 14, '2021-08-17 06:24:37', 101, '', '2022-10-25 03:35:04', 101, NULL, NULL, '2021-08-17 06:24:37', NULL, '{\"image_intro\":\"images\\/projects\\/construction\\/general_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/general_02_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/construction\\/general_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/general_02.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 2, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(9, 93, 'Bridges and Roads', 'bridges-and-roads', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 15, '2021-08-17 06:41:34', 101, '', '2022-10-25 03:35:14', 101, NULL, NULL, '2021-08-17 06:41:34', NULL, '{\"image_intro\":\"images\\/projects\\/construction\\/industrial_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/industrial_02_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/construction\\/industrial_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/industrial_02.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(10, 95, 'Floor Change', 'floor-change', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 13, '2021-08-17 07:05:00', 101, '', '2022-10-25 03:35:24', 101, NULL, NULL, '2021-08-17 07:05:00', NULL, '{\"image_intro\":\"images\\/projects\\/construction\\/renovation_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/renovation_01_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/construction\\/renovation_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/renovation_01.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 1, '', '', 1, 14, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(11, 97, 'Swimming Pool', 'swimming-pool', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 14, '2021-08-17 07:21:32', 101, '', '2022-10-25 03:35:36', 101, NULL, NULL, '2021-08-17 07:21:32', NULL, '{\"image_intro\":\"images\\/projects\\/construction\\/general_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/general_01_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/construction\\/general_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/general_01.jpg?width=1110&height=599\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"video\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"https:\\/\\/www.youtube.com\\/watch?v=IMxPTojTCDw\"}', 3, 1, '', '', 1, 6, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(12, 99, 'Steel Industry', 'steel-industry', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 15, '2021-08-17 07:28:56', 101, '', '2022-10-25 03:42:37', 101, NULL, NULL, '2021-08-17 07:28:56', NULL, '{\"image_intro\":\"images\\/projects\\/construction\\/industrial_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/industrial_01_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/construction\\/industrial_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/industrial_01.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"gallery\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[\\\"images\\/2020\\/05\\/17\\/industrial_01.jpg\\\",\\\"images\\/2020\\/05\\/17\\/industrial_01_b.jpg\\\"]}\",\"helix_ultimate_video\":\"\"}', 10, 1, '', '', 1, 38, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(14, 119, 'Large Kitchen', 'large-kitchen', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 16, '2021-08-17 07:21:32', 101, '', '2022-10-25 03:35:48', 101, NULL, NULL, '2021-08-17 07:21:32', NULL, '{\"image_intro\":\"images\\/projects\\/interior\\/home_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/home_04_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/interior\\/home_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/home_04.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 9, 4, '', '', 1, 5, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(15, 121, 'Drink Bar', 'drink-bar', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 17, '2021-08-17 16:36:37', 101, '', '2022-10-25 03:35:56', 101, NULL, NULL, '2021-08-17 16:36:37', NULL, '{\"image_intro\":\"images\\/projects\\/interior\\/hotel_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/hotel_04_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/interior\\/hotel_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/hotel_04.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 4, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(16, 123, 'Luxury Train', 'luxury-train', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 18, '2021-08-17 16:40:04', 101, '', '2022-10-25 03:36:15', 101, NULL, NULL, '2021-08-17 16:40:04', NULL, '{\"image_intro\":\"images\\/projects\\/interior\\/transport_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/transport_04_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/interior\\/transport_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/transport_04.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 4, 4, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(17, 125, 'Bedroom', 'bedroom', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 16, '2021-08-17 16:42:39', 101, '', '2022-10-25 03:36:25', 101, NULL, NULL, '2021-08-17 16:42:39', NULL, '{\"image_intro\":\"images\\/projects\\/interior\\/home_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/home_03_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/interior\\/home_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/home_03.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `note`) VALUES
(18, 127, 'Hotel Lobby', 'hotel-lobby', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 17, '2021-08-17 16:44:18', 101, '', '2022-10-25 03:36:35', 101, NULL, NULL, '2021-08-17 16:44:18', NULL, '{\"image_intro\":\"images\\/projects\\/interior\\/hotel_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/hotel_02_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/interior\\/hotel_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/hotel_02.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 4, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(19, 129, 'Yacht Design', 'yacht-design', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 18, '2021-08-17 16:47:34', 101, '', '2022-10-25 03:36:46', 101, NULL, NULL, '2021-08-17 16:47:34', NULL, '{\"image_intro\":\"images\\/projects\\/interior\\/transport_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/transport_03_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/interior\\/transport_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/transport_03.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 3, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(20, 131, 'Hall Staircase', 'hall-staircase', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 16, '2021-08-17 16:49:27', 101, '', '2022-10-25 03:36:56', 101, NULL, NULL, '2021-08-17 16:49:27', NULL, '{\"image_intro\":\"images\\/projects\\/interior\\/home_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/home_02_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/interior\\/home_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/home_02.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 4, 2, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(21, 133, 'Couple Bedroom', 'couple-bedroom', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 17, '2021-08-17 16:53:49', 101, '', '2022-10-25 03:37:06', 101, NULL, NULL, '2021-08-17 16:53:49', NULL, '{\"image_intro\":\"images\\/projects\\/interior\\/hotel_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/hotel_03_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/interior\\/hotel_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/hotel_03.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"video\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"https:\\/\\/www.youtube.com\\/watch?v=IMxPTojTCDw\"}', 4, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(22, 135, 'Luxury Bus Design', 'luxury-bus-design', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 18, '2021-08-17 16:56:19', 101, '', '2022-10-25 03:37:16', 101, NULL, NULL, '2021-08-17 16:56:19', NULL, '{\"image_intro\":\"images\\/projects\\/interior\\/transport_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/transport_02_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/interior\\/transport_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/transport_02.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 4, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(23, 137, 'Open Terrace', 'open-terrace', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 16, '2021-08-17 16:59:47', 101, '', '2022-10-25 03:37:25', 101, NULL, NULL, '2021-08-17 16:59:47', NULL, '{\"image_intro\":\"images\\/projects\\/interior\\/home_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/home_01_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/interior\\/home_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/home_01.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"video\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"https:\\/\\/www.youtube.com\\/watch?v=IMxPTojTCDw\"}', 3, 1, '', '', 1, 2, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(24, 139, 'Waiting Room', 'waiting-room', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 17, '2021-08-17 17:02:51', 101, '', '2022-10-25 03:37:34', 101, NULL, NULL, '2021-08-17 17:02:51', NULL, '{\"image_intro\":\"images\\/projects\\/interior\\/hotel_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/hotel_01_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/interior\\/hotel_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/hotel_01.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 1, '', '', 1, 8, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(25, 141, 'Private Jet', 'private-jet', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 18, '2021-08-17 17:06:04', 101, '', '2022-10-25 03:37:43', 101, NULL, NULL, '2021-08-17 17:06:04', NULL, '{\"image_intro\":\"images\\/projects\\/interior\\/transport_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/transport_01_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/interior\\/transport_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/transport_01.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 1, '', '', 1, 48, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(26, 146, 'Camp Construction', 'camp-construction', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 24, '2021-08-17 21:39:09', 101, '', '2022-10-25 03:37:50', 101, NULL, NULL, '2021-08-17 21:39:09', NULL, '{\"image_intro\":\"images\\/projects\\/mining\\/construction_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/construction_03_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/mining\\/construction_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/construction_03.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 7, 3, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(27, 148, 'Explosives Handling', 'explosives-handling', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 25, '2021-08-17 21:40:12', 101, '', '2022-10-25 03:37:58', 101, NULL, NULL, '2021-08-17 21:40:12', NULL, '{\"image_intro\":\"images\\/projects\\/mining\\/extraction_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/extraction_03_thumb.jpg?width=510&height=551\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/mining\\/extraction_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/extraction_03.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 4, 3, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(28, 150, 'Copper Crusher', 'copper-crusher', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 26, '2021-08-17 21:43:54', 101, '', '2022-10-25 03:38:18', 101, NULL, NULL, '2021-08-17 21:43:54', NULL, '{\"image_intro\":\"images\\/projects\\/mining\\/processing_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/processing_02_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/mining\\/processing_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/processing_02.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 6, 3, '', '', 1, 5, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(29, 152, 'Undercut Protection', 'undercut-protection', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 24, '2021-08-17 22:14:20', 101, '', '2022-10-25 03:38:25', 101, NULL, NULL, '2021-08-17 22:14:20', NULL, '{\"image_intro\":\"images\\/projects\\/mining\\/construction_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/construction_02_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/mining\\/construction_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/construction_02.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 4, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(30, 154, 'Drilling', 'drilling', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 25, '2021-08-17 22:34:48', 101, '', '2022-10-25 03:38:48', 101, NULL, NULL, '2021-08-17 22:34:48', NULL, '{\"image_intro\":\"images\\/projects\\/mining\\/extraction_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/extraction_02_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/mining\\/extraction_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/extraction_02.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 5, 2, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(31, 156, 'Filtering', 'filtering', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 26, '2021-08-17 22:38:21', 101, '', '2022-10-25 03:38:42', 101, NULL, NULL, '2021-08-17 22:38:21', NULL, '{\"image_intro\":\"images\\/projects\\/mining\\/processing_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/processing_03_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/mining\\/processing_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/processing_03.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"video\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"https:\\/\\/www.youtube.com\\/watch?v=IMxPTojTCDw\"}', 4, 2, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(32, 158, 'Roads', 'roads', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 24, '2021-08-17 22:42:19', 101, '', '2022-10-25 03:39:08', 101, NULL, NULL, '2021-08-17 22:42:19', NULL, '{\"image_intro\":\"images\\/projects\\/mining\\/construction_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/construction_01_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/mining\\/construction_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/construction_01.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 1, '', '', 1, 11, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(33, 160, 'Transport', 'transport', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 25, '2021-08-17 23:43:03', 101, '', '2022-10-25 03:39:14', 101, NULL, NULL, '2021-08-17 23:43:03', NULL, '{\"image_intro\":\"images\\/projects\\/mining\\/extraction_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/extraction_01_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/mining\\/extraction_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/extraction_01.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 1, '', '', 1, 24, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `note`) VALUES
(34, 162, 'Processing Plant', 'processing-plant', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 26, '2021-08-17 23:46:42', 101, '', '2022-10-25 03:39:19', 101, NULL, NULL, '2021-08-17 23:46:42', NULL, '{\"image_intro\":\"images\\/projects\\/mining\\/processing_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/processing_01_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/mining\\/processing_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/processing_01.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 1, '', '', 1, 25, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(35, 173, 'Mirror House', 'mirror-house', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 27, '2021-08-19 17:22:16', 101, '', '2022-10-25 03:39:26', 101, NULL, NULL, '2021-08-19 17:22:16', NULL, '{\"image_intro\":\"images\\/projects\\/architect\\/house_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/house_03_thumb.jpg?width=510&height=510\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/architect\\/house_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/house_03.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 3, '', '', 1, 4, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(36, 175, 'Mall Facade', 'mall-facade', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 28, '2021-08-19 17:42:17', 101, '', '2022-10-25 03:39:39', 101, NULL, NULL, '2021-08-19 17:42:17', NULL, '{\"image_intro\":\"images\\/projects\\/architect\\/building_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/building_03_thumb.jpg?width=510&height=510\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/architect\\/building_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/building_03.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 4, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(37, 177, 'Riverside Museum', 'riverside-museum', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 29, '2021-08-19 17:45:56', 101, '', '2022-10-25 03:39:47', 101, NULL, NULL, '2021-08-19 17:45:56', NULL, '{\"image_intro\":\"images\\/projects\\/architect\\/culture_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/culture_03_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/architect\\/culture_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/culture_03.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(38, 179, 'House Metal Facade', 'house-metal-facade', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 27, '2021-08-19 17:52:04', 101, '', '2022-10-25 03:39:55', 101, NULL, NULL, '2021-08-19 17:52:04', NULL, '{\"image_intro\":\"images\\/projects\\/architect\\/house_02_thumn.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/house_02_thumn.jpg?width=510&height=510\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/architect\\/house_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/house_02.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 2, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(39, 181, 'Shop Center', 'shop-center', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 28, '2021-08-19 17:55:01', 101, '', '2022-10-25 03:40:04', 101, NULL, NULL, '2021-08-19 17:55:01', NULL, '{\"image_intro\":\"images\\/projects\\/architect\\/building_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/building_02_thumb.jpg?width=510&height=510\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/architect\\/building_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/building_02.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(40, 183, 'Ordos Museum', 'ordos-museum', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 29, '2021-08-19 18:00:40', 101, '', '2022-10-25 03:40:11', 101, NULL, NULL, '2021-08-19 18:00:40', NULL, '{\"image_intro\":\"images\\/projects\\/architect\\/culture_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/culture_02_thumb.jpg?width=510&height=510\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/architect\\/culture_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/culture_02.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 1, '', '', 1, 4, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(41, 185, 'Modern House', 'modern-house', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 27, '2021-08-19 18:05:20', 101, '', '2022-10-25 03:40:19', 101, NULL, NULL, '2021-08-19 18:05:20', NULL, '{\"image_intro\":\"images\\/projects\\/architect\\/house_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/house_01_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/architect\\/house_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/house_01.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(42, 187, 'York University', 'york-university', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 28, '2021-08-19 18:09:39', 101, '', '2022-10-25 03:40:30', 101, NULL, NULL, '2021-08-19 18:09:39', NULL, '{\"image_intro\":\"images\\/projects\\/architect\\/building_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/building_01_thumb.jpg?width=510&height=510\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/architect\\/building_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/building_01.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 1, '', '', 1, 14, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(43, 189, 'Mosegaard Museum', 'mosegaard-museum', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam vehicula id eros sit amet vulputate. Donec venenatis eget felis ut porta. Quisque a eros quis augue pellentesque finibus ut vitae arcu. Integer mollis velit a suscipit vulputate. Nullam bibendum velit nec erat vestibulum, posuere euismod nunc blandit. Donec non mattis lectus. Nulla sed elit aliquam, condimentum massa ut, ultrices quam. Sed vestibulum leo ut aliquam lobortis.</p>\r\n<p>In magna felis, elementum ut erat eu, cursus ullamcorper justo. Cras placerat tellus nunc, et finibus metus placerat convallis. Cras id faucibus dolor. Vestibulum vel efficitur massa. Vestibulum tincidunt dignissim erat quis posuere. Duis id venenatis odio, ac condimentum libero. Sed euismod odio feugiat enim posuere, id varius erat interdum. Morbi efficitur ullamcorper euismod. Vestibulum sapien risus, feugiat id risus at, iaculis volutpat dui. Duis vulputate mi at lorem tristique cursus. Sed in fermentum odio. Nulla porttitor massa sed eros aliquam, at porttitor ante eleifend. Nulla id eros sit amet mauris tincidunt semper in in dolor. Duis volutpat, justo a maximus pellentesque, ligula elit iaculis lectus, id ornare arcu nunc quis diam.</p>', '', 1, 29, '2021-08-19 18:14:54', 101, '', '2022-10-25 03:40:48', 101, NULL, NULL, '2021-08-19 18:14:54', NULL, '{\"image_intro\":\"images\\/projects\\/architect\\/culture_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/culture_01_thumb.jpg?width=510&height=550\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/projects\\/architect\\/culture_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/culture_01.jpg?width=1110&height=600\",\"image_fulltext_alt\":\"Alt Image Full\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[]}\",\"helix_ultimate_video\":\"\"}', 3, 0, '', '', 1, 31, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(44, 192, 'Underground Construction', 'underground-construction', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 32, '2021-08-20 02:58:55', 101, '', '2022-10-25 03:28:47', 101, NULL, NULL, '2021-08-20 02:58:55', NULL, '{\"image_intro\":\"images\\/blog\\/mining_07.jpg#joomlaImage:\\/\\/local-images\\/blog\\/mining_07.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/mining_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/mining_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 2, 7, '', '', 1, 2, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(45, 193, 'Womens in the Mine', 'womens-in-the-mine', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 32, '2021-08-20 03:09:36', 101, '', '2022-10-25 03:28:54', 101, NULL, NULL, '2021-08-20 03:09:36', NULL, '{\"image_intro\":\"images\\/blog\\/mining_06.jpg#joomlaImage:\\/\\/local-images\\/blog\\/mining_06.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/mining_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/mining_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 6, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(46, 194, 'Automated Mining', 'automated-mining', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 32, '2021-08-20 03:13:42', 101, '', '2022-10-25 03:28:59', 101, NULL, NULL, '2021-08-20 03:13:42', NULL, '{\"image_intro\":\"images\\/blog\\/mining_05.jpg#joomlaImage:\\/\\/local-images\\/blog\\/mining_05.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/mining_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/mining_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 5, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(47, 195, 'Gold Mining', 'gold-mining', '    <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 32, '2021-08-20 03:15:40', 101, '', '2022-10-25 03:29:05', 101, NULL, NULL, '2021-08-20 03:15:40', NULL, '{\"image_intro\":\"images\\/blog\\/mining_04.jpg#joomlaImage:\\/\\/local-images\\/blog\\/mining_04.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/mining_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/mining_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 4, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(48, 196, 'Angola Mines', 'angola-mines', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 32, '2021-08-20 03:18:38', 101, '', '2022-10-25 03:29:11', 101, NULL, NULL, '2021-08-20 03:18:38', NULL, '{\"image_intro\":\"images\\/blog\\/mining_03.jpg#joomlaImage:\\/\\/local-images\\/blog\\/mining_03.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/mining_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/mining_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 3, '', '', 1, 5, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `note`) VALUES
(49, 197, 'Engineers Meeting', 'engineers-meeting', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 32, '2021-08-20 03:19:22', 101, '', '2022-10-25 03:29:31', 101, NULL, NULL, '2021-08-20 03:19:22', NULL, '{\"image_intro\":\"images\\/blog\\/mining_02.jpg#joomlaImage:\\/\\/local-images\\/blog\\/mining_02.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/mining_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/mining_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 2, '', '', 1, 36, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(50, 198, 'Inspecting Project', 'inspecting-project', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 32, '2021-08-20 03:21:57', 101, '', '2022-10-25 03:30:16', 101, NULL, NULL, '2021-08-20 03:21:57', NULL, '{\"image_intro\":\"images\\/blog\\/mining_01.jpg#joomlaImage:\\/\\/local-images\\/blog\\/mining_01.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/mining_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/mining_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 16, 1, '', '', 1, 10, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(51, 199, 'Restaurant Architecture', 'restaurant-architecture', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 34, '2021-08-20 16:06:49', 101, '', '2022-10-25 03:30:40', 101, NULL, NULL, '2021-08-20 16:06:49', NULL, '{\"image_intro\":\"images\\/blog\\/architect_07.jpg#joomlaImage:\\/\\/local-images\\/blog\\/architect_07.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/architect_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/architect_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 4, 7, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(52, 200, 'Coworking Center', 'coworking-center', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 34, '2021-08-20 16:14:12', 101, '', '2022-10-25 03:30:46', 101, NULL, NULL, '2021-08-20 16:14:12', NULL, '{\"image_intro\":\"images\\/blog\\/architect_06.jpg#joomlaImage:\\/\\/local-images\\/blog\\/architect_06.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/architect_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/architect_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 6, '', '', 1, 6, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(53, 201, 'Office Interior Design', 'office-interior-design', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 34, '2021-08-20 16:15:51', 101, '', '2022-10-25 03:30:51', 101, NULL, NULL, '2021-08-20 16:15:51', NULL, '{\"image_intro\":\"images\\/blog\\/architect_05.jpg#joomlaImage:\\/\\/local-images\\/blog\\/architect_05.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/architect_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/architect_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 5, '', '', 1, 5, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(54, 202, 'Architectural House', 'architectural-house', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 34, '2021-08-20 16:17:10', 101, '', '2022-10-25 03:30:59', 101, NULL, NULL, '2021-08-20 16:17:10', NULL, '{\"image_intro\":\"images\\/blog\\/architect_04.jpg#joomlaImage:\\/\\/local-images\\/blog\\/architect_04.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/architect_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/architect_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 4, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(55, 203, 'Modern Cube House', 'modern-cube-house', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 34, '2021-08-20 16:18:53', 101, '', '2022-10-25 03:31:04', 101, NULL, NULL, '2021-08-20 16:18:53', NULL, '{\"image_intro\":\"images\\/blog\\/architect_03.jpg#joomlaImage:\\/\\/local-images\\/blog\\/architect_03.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/architect_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/architect_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(56, 204, 'Futuristic Building', 'futuristic-building', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 34, '2021-08-20 16:19:51', 101, '', '2022-10-25 03:31:10', 101, NULL, NULL, '2021-08-20 16:19:51', NULL, '{\"image_intro\":\"images\\/blog\\/architect_02.jpg#joomlaImage:\\/\\/local-images\\/blog\\/architect_02.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/architect_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/architect_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 2, '', '', 1, 29, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(57, 205, 'Grass Architecture', 'grass-architecture', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 34, '2021-08-20 16:22:25', 101, '', '2022-10-25 03:31:16', 101, NULL, NULL, '2021-08-20 16:22:25', NULL, '{\"image_intro\":\"images\\/blog\\/architect_01.jpg#joomlaImage:\\/\\/local-images\\/blog\\/architect_01.jpg?width=540&height=400\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/architect_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/architect_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 1, '', '', 1, 19, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(58, 206, 'Water Transport', 'water-transport', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 31, '2021-08-20 23:43:54', 101, '', '2022-10-25 03:31:23', 101, NULL, NULL, '2021-08-20 23:43:54', NULL, '{\"image_intro\":\"images\\/blog\\/construction_07.jpg#joomlaImage:\\/\\/local-images\\/blog\\/construction_07.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/contruction_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/contruction_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 5, 7, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(59, 207, 'Roadway Construction', 'roadway-construction', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 31, '2021-08-20 23:51:08', 101, '', '2022-10-25 03:31:29', 101, NULL, NULL, '2021-08-20 23:51:08', NULL, '{\"image_intro\":\"images\\/blog\\/construction_06.jpg#joomlaImage:\\/\\/local-images\\/blog\\/construction_06.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/contruction_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/contruction_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 4, 6, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(60, 208, 'Paving Roadway', 'paving-roadway', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 31, '2021-08-21 00:22:17', 101, '', '2022-10-25 03:31:36', 101, NULL, NULL, '2021-08-21 00:22:17', NULL, '{\"image_intro\":\"images\\/blog\\/construction_05.jpg#joomlaImage:\\/\\/local-images\\/blog\\/construction_05.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/contruction_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/contruction_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 5, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(61, 209, 'Floor Drilling', 'floor-drilling', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 31, '2021-08-21 00:31:42', 101, '', '2022-10-25 03:31:42', 101, NULL, NULL, '2021-08-21 00:31:42', NULL, '{\"image_intro\":\"images\\/blog\\/construction_04.jpg#joomlaImage:\\/\\/local-images\\/blog\\/construction_04.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/contruction_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/contruction_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 4, '', '', 1, 4, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(62, 210, 'Women Working', 'women-working', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 31, '2021-08-21 00:56:54', 101, '', '2022-10-25 03:31:47', 101, NULL, NULL, '2021-08-21 00:56:54', NULL, '{\"image_intro\":\"images\\/blog\\/construction_03.jpg#joomlaImage:\\/\\/local-images\\/blog\\/construction_03.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/contruction_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/contruction_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `note`) VALUES
(63, 211, 'Construction Tools', 'construction-tools', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 31, '2021-08-21 00:58:57', 101, '', '2022-10-25 03:31:57', 101, NULL, NULL, '2021-08-21 00:58:57', NULL, '{\"image_intro\":\"images\\/blog\\/construction_02.jpg#joomlaImage:\\/\\/local-images\\/blog\\/construction_02.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/contruction_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/contruction_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 2, '', '', 1, 54, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(64, 212, 'Mega Construction', 'mega-construction', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 31, '2021-08-21 01:00:02', 101, '', '2022-10-25 03:32:08', 101, NULL, NULL, '2021-08-21 01:00:02', NULL, '{\"image_intro\":\"images\\/blog\\/construction_01.jpg#joomlaImage:\\/\\/local-images\\/blog\\/construction_01.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/contruction_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/contruction_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 4, 1, '', '', 1, 30, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(65, 213, 'Bar Restaurant', 'bar-restaurant', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 33, '2021-08-21 01:12:23', 101, '', '2022-10-25 03:32:13', 101, NULL, NULL, '2021-08-21 01:12:23', NULL, '{\"image_intro\":\"images\\/blog\\/interior_07.jpg#joomlaImage:\\/\\/local-images\\/blog\\/interior_07.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/interior_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/interior_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 6, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(66, 214, 'Conference Room', 'conference-room', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 33, '2021-08-21 01:16:49', 101, '', '2022-10-25 03:32:19', 101, NULL, NULL, '2021-08-21 01:16:49', NULL, '{\"image_intro\":\"images\\/blog\\/interior_06.jpg#joomlaImage:\\/\\/local-images\\/blog\\/interior_06.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/interior_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/interior_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 5, '', '', 1, 9, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(67, 215, 'Roof Terrace', 'roof-terrace', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 33, '2021-08-21 01:18:19', 101, '', '2022-10-25 03:32:24', 101, NULL, NULL, '2021-08-21 01:18:19', NULL, '{\"image_intro\":\"images\\/blog\\/interior_05.jpg#joomlaImage:\\/\\/local-images\\/blog\\/interior_05.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/interior_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/interior_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 4, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(68, 216, 'Beautiful Kitchen', 'beautiful-kitchen', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 33, '2021-08-21 01:20:10', 101, '', '2022-10-25 03:32:29', 101, NULL, NULL, '2021-08-21 01:20:10', NULL, '{\"image_intro\":\"images\\/blog\\/interior_04.jpg#joomlaImage:\\/\\/local-images\\/blog\\/interior_04.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/interior_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/interior_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 5, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(69, 217, 'Kids Bedroom', 'kids-bedroom', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 33, '2021-08-21 01:24:13', 101, '', '2022-10-25 03:32:35', 101, NULL, NULL, '2021-08-21 01:24:13', NULL, '{\"image_intro\":\"images\\/blog\\/interior_03.jpg#joomlaImage:\\/\\/local-images\\/blog\\/interior_03.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/interior_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/interior_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 4, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(70, 218, 'Bedroom Design', 'bedroom-design', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 33, '2021-08-21 01:24:36', 101, '', '2022-10-25 03:32:59', 101, NULL, NULL, '2021-08-21 01:24:36', NULL, '{\"image_intro\":\"images\\/blog\\/interior_02.jpg#joomlaImage:\\/\\/local-images\\/blog\\/interior_02.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/interior_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/interior_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 4, 1, '', '', 1, 14, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(71, 219, 'Wall Background', 'wall-background', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>\r\n<p>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like aldus pagemaker including versions.</p>\r\n<blockquote>\r\n<p>The closed-door literate knows nothing of life. Politics, love, the economic problem, the cordial disaster of hope, the direct scuffle of man with men, the small and immediate drama of the opposing forces and directions of reality, none of this personally shakes the writer of closed doors.</p>\r\n<footer>Cesar Vallejo</footer></blockquote>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. <strong>All the lorem ipsum generators on the internet tend</strong> to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour.</p>', '', 1, 33, '2021-08-21 01:25:36', 101, '', '2022-10-25 03:33:05', 101, NULL, NULL, '2021-08-21 01:25:36', NULL, '{\"image_intro\":\"images\\/blog\\/interior_01.jpg#joomlaImage:\\/\\/local-images\\/blog\\/interior_01.jpg?width=540&height=320\",\"image_intro_alt\":\"Alt Image Intro\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/interior_full.jpg#joomlaImage:\\/\\/local-images\\/blog\\/interior_full.jpg?width=1110&height=550\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 7, 0, '', '', 1, 4, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(72, 231, 'Privacy Article', 'privacy-article', '<p>Your privacy text here and below...</p>\r\n', '\r\n<p>Lorem ipsum dolor sit amet,sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, At vero eos et accusam et justo duo dolores et ea rebum. Lorem ipsum dolor sit amet, no sea takimata sanctus est Lorem ipsum dolor sit amet. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. no sea takimata sanctus est Lorem ipsum dolor sit amet. no sea takimata sanctus est Lorem ipsum dolor sit amet. sed diam voluptua.</p>', 1, 2, '2021-08-22 20:58:33', 101, '', '2021-08-22 21:18:12', 101, NULL, NULL, '2021-08-22 20:58:33', NULL, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"ut_construction:blank\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 8, 1, '', '', 1, 26, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(73, 232, 'Terms & Conditions', 'terms-conditions', '<p>Your Terms &amp; Conditions text here and below...</p>\r\n', '\r\n<p>Lorem ipsum dolor sit amet,sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, At vero eos et accusam et justo duo dolores et ea rebum. Lorem ipsum dolor sit amet, no sea takimata sanctus est Lorem ipsum dolor sit amet. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. no sea takimata sanctus est Lorem ipsum dolor sit amet. no sea takimata sanctus est Lorem ipsum dolor sit amet. sed diam voluptua.</p>', 1, 2, '2021-08-22 20:58:33', 101, '', '2021-08-22 21:50:03', 101, NULL, NULL, '2021-08-22 20:58:33', NULL, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"ut_construction:blank\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 2, 0, '', '', 1, 2, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__contentitem_tag_map`
--

DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE IF NOT EXISTS `#__contentitem_tag_map` (
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int(10) UNSIGNED NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) UNSIGNED NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';

--
-- Volcado de datos para la tabla `#__contentitem_tag_map`
--

INSERT INTO `#__contentitem_tag_map` (`type_alias`, `core_content_id`, `content_item_id`, `tag_id`, `tag_date`, `type_id`) VALUES
('com_content.article', 7, 1, 3, '2022-10-25 03:33:59', 1),
('com_content.article', 7, 1, 4, '2022-10-25 03:33:59', 1),
('com_content.article', 7, 1, 6, '2022-10-25 03:33:59', 1),
('com_content.article', 8, 2, 3, '2022-10-25 03:34:15', 1),
('com_content.article', 8, 2, 4, '2022-10-25 03:34:15', 1),
('com_content.article', 8, 2, 6, '2022-10-25 03:34:15', 1),
('com_content.article', 9, 3, 3, '2022-10-25 03:34:22', 1),
('com_content.article', 9, 3, 4, '2022-10-25 03:34:22', 1),
('com_content.article', 9, 3, 6, '2022-10-25 03:34:22', 1),
('com_content.article', 10, 4, 3, '2022-10-25 03:34:29', 1),
('com_content.article', 10, 4, 4, '2022-10-25 03:34:29', 1),
('com_content.article', 10, 4, 6, '2022-10-25 03:34:29', 1),
('com_content.article', 11, 5, 3, '2022-10-25 03:34:34', 1),
('com_content.article', 11, 5, 4, '2022-10-25 03:34:34', 1),
('com_content.article', 11, 5, 6, '2022-10-25 03:34:34', 1),
('com_content.article', 12, 6, 3, '2022-10-25 03:34:41', 1),
('com_content.article', 12, 6, 4, '2022-10-25 03:34:41', 1),
('com_content.article', 12, 6, 5, '2022-10-25 03:34:41', 1),
('com_content.article', 1, 7, 3, '2022-10-25 03:34:54', 1),
('com_content.article', 1, 7, 4, '2022-10-25 03:34:54', 1),
('com_content.article', 1, 7, 5, '2022-10-25 03:34:54', 1),
('com_content.article', 2, 8, 3, '2022-10-25 03:35:04', 1),
('com_content.article', 2, 8, 4, '2022-10-25 03:35:04', 1),
('com_content.article', 2, 8, 5, '2022-10-25 03:35:04', 1),
('com_content.article', 3, 9, 3, '2022-10-25 03:35:14', 1),
('com_content.article', 3, 9, 4, '2022-10-25 03:35:14', 1),
('com_content.article', 3, 9, 5, '2022-10-25 03:35:14', 1),
('com_content.article', 4, 10, 3, '2022-10-25 03:35:24', 1),
('com_content.article', 4, 10, 4, '2022-10-25 03:35:24', 1),
('com_content.article', 4, 10, 5, '2022-10-25 03:35:24', 1),
('com_content.article', 5, 11, 3, '2022-10-25 03:35:36', 1),
('com_content.article', 5, 11, 4, '2022-10-25 03:35:36', 1),
('com_content.article', 5, 11, 5, '2022-10-25 03:35:36', 1),
('com_content.article', 6, 12, 3, '2022-10-25 03:42:37', 1),
('com_content.article', 6, 12, 4, '2022-10-25 03:42:37', 1),
('com_content.article', 6, 12, 5, '2022-10-25 03:42:37', 1),
('com_content.article', 14, 14, 7, '2022-10-25 03:35:48', 1),
('com_content.article', 14, 14, 8, '2022-10-25 03:35:48', 1),
('com_content.article', 14, 14, 9, '2022-10-25 03:35:48', 1),
('com_content.article', 15, 15, 7, '2022-10-25 03:35:56', 1),
('com_content.article', 15, 15, 8, '2022-10-25 03:35:56', 1),
('com_content.article', 15, 15, 9, '2022-10-25 03:35:56', 1),
('com_content.article', 16, 16, 7, '2022-10-25 03:36:15', 1),
('com_content.article', 16, 16, 8, '2022-10-25 03:36:15', 1),
('com_content.article', 16, 16, 9, '2022-10-25 03:36:15', 1),
('com_content.article', 17, 17, 7, '2022-10-25 03:36:25', 1),
('com_content.article', 17, 17, 8, '2022-10-25 03:36:25', 1),
('com_content.article', 17, 17, 9, '2022-10-25 03:36:25', 1),
('com_content.article', 18, 18, 7, '2022-10-25 03:36:35', 1),
('com_content.article', 18, 18, 8, '2022-10-25 03:36:35', 1),
('com_content.article', 18, 18, 9, '2022-10-25 03:36:35', 1),
('com_content.article', 19, 19, 7, '2022-10-25 03:36:46', 1),
('com_content.article', 19, 19, 8, '2022-10-25 03:36:46', 1),
('com_content.article', 19, 19, 9, '2022-10-25 03:36:46', 1),
('com_content.article', 20, 20, 7, '2022-10-25 03:36:57', 1),
('com_content.article', 20, 20, 8, '2022-10-25 03:36:57', 1),
('com_content.article', 20, 20, 9, '2022-10-25 03:36:57', 1),
('com_content.article', 21, 21, 7, '2022-10-25 03:37:06', 1),
('com_content.article', 21, 21, 8, '2022-10-25 03:37:06', 1),
('com_content.article', 21, 21, 9, '2022-10-25 03:37:06', 1),
('com_content.article', 22, 22, 7, '2022-10-25 03:37:16', 1),
('com_content.article', 22, 22, 8, '2022-10-25 03:37:16', 1),
('com_content.article', 22, 22, 9, '2022-10-25 03:37:16', 1),
('com_content.article', 23, 23, 7, '2022-10-25 03:37:25', 1),
('com_content.article', 23, 23, 8, '2022-10-25 03:37:25', 1),
('com_content.article', 23, 23, 9, '2022-10-25 03:37:25', 1),
('com_content.article', 24, 24, 7, '2022-10-25 03:37:34', 1),
('com_content.article', 24, 24, 8, '2022-10-25 03:37:34', 1),
('com_content.article', 24, 24, 9, '2022-10-25 03:37:34', 1),
('com_content.article', 25, 25, 7, '2022-10-25 03:37:43', 1),
('com_content.article', 25, 25, 8, '2022-10-25 03:37:43', 1),
('com_content.article', 25, 25, 9, '2022-10-25 03:37:43', 1),
('com_content.article', 26, 26, 10, '2022-10-25 03:37:50', 1),
('com_content.article', 26, 26, 11, '2022-10-25 03:37:50', 1),
('com_content.article', 26, 26, 12, '2022-10-25 03:37:50', 1),
('com_content.article', 27, 27, 10, '2022-10-25 03:37:58', 1),
('com_content.article', 27, 27, 11, '2022-10-25 03:37:58', 1),
('com_content.article', 27, 27, 12, '2022-10-25 03:37:58', 1),
('com_content.article', 28, 28, 10, '2022-10-25 03:38:18', 1),
('com_content.article', 28, 28, 11, '2022-10-25 03:38:18', 1),
('com_content.article', 28, 28, 12, '2022-10-25 03:38:18', 1),
('com_content.article', 29, 29, 10, '2022-10-25 03:38:25', 1),
('com_content.article', 29, 29, 11, '2022-10-25 03:38:25', 1),
('com_content.article', 29, 29, 12, '2022-10-25 03:38:25', 1),
('com_content.article', 30, 30, 10, '2022-10-25 03:38:48', 1),
('com_content.article', 30, 30, 11, '2022-10-25 03:38:48', 1),
('com_content.article', 30, 30, 12, '2022-10-25 03:38:48', 1),
('com_content.article', 31, 31, 10, '2022-10-25 03:38:42', 1),
('com_content.article', 31, 31, 11, '2022-10-25 03:38:42', 1),
('com_content.article', 31, 31, 12, '2022-10-25 03:38:42', 1),
('com_content.article', 32, 32, 10, '2022-10-25 03:39:08', 1),
('com_content.article', 32, 32, 11, '2022-10-25 03:39:08', 1),
('com_content.article', 32, 32, 12, '2022-10-25 03:39:08', 1),
('com_content.article', 33, 33, 10, '2022-10-25 03:39:14', 1),
('com_content.article', 33, 33, 11, '2022-10-25 03:39:14', 1),
('com_content.article', 33, 33, 12, '2022-10-25 03:39:14', 1),
('com_content.article', 34, 34, 10, '2022-10-25 03:39:19', 1),
('com_content.article', 34, 34, 11, '2022-10-25 03:39:19', 1),
('com_content.article', 34, 34, 12, '2022-10-25 03:39:19', 1),
('com_content.article', 35, 35, 10, '2022-10-25 03:39:26', 1),
('com_content.article', 35, 35, 11, '2022-10-25 03:39:26', 1),
('com_content.article', 35, 35, 12, '2022-10-25 03:39:26', 1),
('com_content.article', 36, 36, 10, '2022-10-25 03:39:39', 1),
('com_content.article', 36, 36, 11, '2022-10-25 03:39:39', 1),
('com_content.article', 36, 36, 12, '2022-10-25 03:39:39', 1),
('com_content.article', 37, 37, 10, '2022-10-25 03:39:47', 1),
('com_content.article', 37, 37, 11, '2022-10-25 03:39:47', 1),
('com_content.article', 37, 37, 12, '2022-10-25 03:39:47', 1),
('com_content.article', 38, 38, 10, '2022-10-25 03:39:55', 1),
('com_content.article', 38, 38, 11, '2022-10-25 03:39:55', 1),
('com_content.article', 38, 38, 12, '2022-10-25 03:39:55', 1),
('com_content.article', 39, 39, 10, '2022-10-25 03:40:04', 1),
('com_content.article', 39, 39, 11, '2022-10-25 03:40:04', 1),
('com_content.article', 39, 39, 12, '2022-10-25 03:40:04', 1),
('com_content.article', 40, 40, 10, '2022-10-25 03:40:11', 1),
('com_content.article', 40, 40, 11, '2022-10-25 03:40:11', 1),
('com_content.article', 40, 40, 12, '2022-10-25 03:40:11', 1),
('com_content.article', 41, 41, 10, '2022-10-25 03:40:19', 1),
('com_content.article', 41, 41, 11, '2022-10-25 03:40:19', 1),
('com_content.article', 41, 41, 12, '2022-10-25 03:40:19', 1),
('com_content.article', 42, 42, 10, '2022-10-25 03:40:30', 1),
('com_content.article', 42, 42, 11, '2022-10-25 03:40:30', 1),
('com_content.article', 42, 42, 12, '2022-10-25 03:40:30', 1),
('com_content.article', 43, 43, 10, '2022-10-25 03:40:48', 1),
('com_content.article', 43, 43, 11, '2022-10-25 03:40:48', 1),
('com_content.article', 43, 43, 12, '2022-10-25 03:40:48', 1),
('com_content.article', 44, 64, 4, '2022-10-25 03:32:08', 1),
('com_content.article', 44, 64, 13, '2022-10-25 03:32:08', 1),
('com_content.article', 44, 64, 14, '2022-10-25 03:32:08', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__content_frontpage`
--

DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE IF NOT EXISTS `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `featured_up` datetime DEFAULT NULL,
  `featured_down` datetime DEFAULT NULL,
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__content_rating`
--

DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE IF NOT EXISTS `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `rating_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lastip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__content_types`
--

DROP TABLE IF EXISTS `#__content_types`;
CREATE TABLE IF NOT EXISTS `#__content_types` (
  `type_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `#__content_types`
--

INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES
(1, 'Article', 'com_content.article', '{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"ArticleTable\",\"prefix\":\"Joomla\\\\Component\\\\Content\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"introtext\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"attribs\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"asset_id\", \"note\":\"note\"}, \"special\":{\"fulltext\":\"fulltext\"}}', 'ContentHelperRoute::getArticleRoute', '{\"formFile\":\"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(2, 'Contact', 'com_contact.contact', '{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"ContactTable\",\"prefix\":\"Joomla\\\\Component\\\\Contact\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}', 'ContactHelperRoute::getContactRoute', '{\"formFile\":\"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml\",\"hideFields\":[\"default_con\",\"checked_out\",\"checked_out_time\",\"version\",\"xreference\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[ {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ] }'),
(3, 'Newsfeed', 'com_newsfeeds.newsfeed', '{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"NewsfeedTable\",\"prefix\":\"Joomla\\\\Component\\\\Newsfeeds\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{\"formFile\":\"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml\",\"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(4, 'User', 'com_users.user', '{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"UserTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerDate\",\"core_modified_time\":\"null\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{}}', '', ''),
(5, 'Article Category', 'com_content.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContentHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(6, 'Contact Category', 'com_contact.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(7, 'Newsfeeds Category', 'com_newsfeeds.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(8, 'Tag', 'com_tags.tag', '{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"TagTable\",\"prefix\":\"Joomla\\\\Component\\\\Tags\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}', 'TagsHelperRoute::getTagRoute', '{\"formFile\":\"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(9, 'Banner', 'com_banners.banner', '{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"BannerTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(10, 'Banners Category', 'com_banners.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(11, 'Banner Client', 'com_banners.client', '{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"ClientTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}'),
(12, 'User Notes', 'com_users.note', '{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"NoteTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(13, 'User Notes Category', 'com_users.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__core_log_searches`
--

DROP TABLE IF EXISTS `#__core_log_searches`;
CREATE TABLE IF NOT EXISTS `#__core_log_searches` (
  `search_term` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__extensions`
--

DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE IF NOT EXISTS `#__extensions` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `package_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `changelogurl` text COLLATE utf8mb4_unicode_ci,
  `folder` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `protected` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate if the extension is protected. Protected extensions cannot be disabled.',
  `manifest_cache` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate if the extension is locked. Locked extensions cannot be uninstalled.',
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10140 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `#__extensions`
--

INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `changelogurl`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `checked_out`, `checked_out_time`, `ordering`, `state`, `note`, `locked`) VALUES
(2, 0, 'com_wrapper', 'component', 'com_wrapper', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"wrapper\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(3, 0, 'com_admin', 'component', 'com_admin', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(4, 0, 'com_banners', 'component', 'com_banners', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"banners\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\",\"save_history\":\"1\",\"history_limit\":10}', '', NULL, NULL, 0, 0, NULL, 1),
(5, 0, 'com_cache', 'component', 'com_cache', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(6, 0, 'com_categories', 'component', 'com_categories', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"2007-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(7, 0, 'com_checkin', 'component', 'com_checkin', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(8, 0, 'com_contact', 'component', 'com_contact', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{\"contact_layout\":\"_:default\",\"show_contact_category\":\"hide\",\"save_history\":\"1\",\"history_limit\":10,\"show_contact_list\":\"0\",\"presentation_style\":\"sliders\",\"show_tags\":\"1\",\"show_info\":\"1\",\"show_name\":\"1\",\"show_position\":\"1\",\"show_email\":\"0\",\"add_mailto_link\":\"1\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"show_misc\":\"1\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"articles_display_num\":\"10\",\"show_profile\":\"0\",\"show_user_custom_fields\":[\"-1\"],\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"2\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"-1\",\"show_subcat_desc\":\"1\",\"show_empty_categories\":\"0\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_subcat_desc_cat\":\"1\",\"show_empty_categories_cat\":\"0\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"0\",\"show_pagination_limit\":\"0\",\"show_headings\":\"1\",\"show_image_heading\":\"0\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"initial_sort\":\"ordering\",\"captcha\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"0\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_feed_link\":\"1\",\"sef_advanced\":0,\"sef_ids\":0,\"custom_fields_enable\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(9, 0, 'com_cpanel', 'component', 'com_cpanel', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"2007-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10, 0, 'com_installer', 'component', 'com_installer', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_jed_info\":\"1\",\"cachetimeout\":\"6\",\"minimum_stability\":\"4\"}', '', NULL, NULL, 0, 0, NULL, 1),
(11, 0, 'com_languages', 'component', 'com_languages', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', NULL, NULL, 0, 0, NULL, 1),
(12, 0, 'com_login', 'component', 'com_login', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(13, 0, 'com_media', 'component', 'com_media', NULL, '', 1, 1, 0, 1, '{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\"}', '', NULL, NULL, 0, 0, NULL, 1),
(14, 0, 'com_menus', 'component', 'com_menus', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menus\"}', '{\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\"}', '', NULL, NULL, 0, 0, NULL, 1),
(15, 0, 'com_messages', 'component', 'com_messages', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(16, 0, 'com_modules', 'component', 'com_modules', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"modules\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(17, 0, 'com_newsfeeds', 'component', 'com_newsfeeds', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"newsfeed_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_character_count\":\"0\",\"feed_display_order\":\"des\",\"float_first\":\"right\",\"float_second\":\"right\",\"show_tags\":\"1\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(18, 0, 'com_plugins', 'component', 'com_plugins', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(20, 0, 'com_templates', 'component', 'com_templates', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"template_positions_display\":\"1\",\"upload_limit\":\"10\",\"image_formats\":\"gif,bmp,jpg,jpeg,png\",\"source_formats\":\"txt,less,ini,xml,js,php,css,scss,sass\",\"font_formats\":\"woff,ttf,otf\",\"compressed_formats\":\"zip\"}', '', NULL, NULL, 0, 0, NULL, 1),
(22, 0, 'com_content', 'component', 'com_content', NULL, '', 1, 1, 0, 1, '{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"info_block_position\":\"0\",\"info_block_show_title\":\"1\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_associations\":\"0\",\"flags\":\"1\",\"show_author\":\"1\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"1\",\"show_vote\":\"0\",\"show_readmore\":\"1\",\"show_readmore_title\":\"1\",\"readmore_limit\":\"100\",\"show_tags\":\"1\",\"show_icons\":\"1\",\"show_print_icon\":\"1\",\"show_email_icon\":\"0\",\"show_hits\":\"1\",\"record_hits\":\"1\",\"show_noauth\":\"0\",\"urls_position\":\"0\",\"captcha\":\"\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"save_history\":\"1\",\"history_limit\":10,\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_heading_title_text\":\"1\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"0\",\"show_subcategory_content\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_featured\":\"show\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\",\"sef_advanced\":0,\"sef_ids\":0,\"custom_fields_enable\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(23, 0, 'com_config', 'component', 'com_config', NULL, '', 1, 1, 0, 1, '{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"config\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', NULL, NULL, 0, 0, NULL, 1),
(24, 0, 'com_redirect', 'component', 'com_redirect', NULL, '', 1, 1, 0, 0, '{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(25, 0, 'com_users', 'component', 'com_users', NULL, '', 1, 1, 0, 1, '{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"users\"}', '{\"allowUserRegistration\":\"0\",\"new_usertype\":\"2\",\"guest_usergroup\":\"9\",\"sendpassword\":\"0\",\"useractivation\":\"2\",\"mail_to_admin\":\"1\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"reset_count\":\"10\",\"reset_time\":\"1\",\"minimum_length\":\"4\",\"minimum_integers\":\"0\",\"minimum_symbols\":\"0\",\"minimum_uppercase\":\"0\",\"save_history\":\"1\",\"history_limit\":5,\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\"}', '', NULL, NULL, 0, 0, NULL, 1),
(27, 0, 'com_finder', 'component', 'com_finder', NULL, '', 1, 1, 0, 0, '{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '{\"enabled\":\"0\",\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_autosuggest\":\"1\",\"show_suggested_query\":\"1\",\"show_explained_query\":\"1\",\"show_advanced\":\"1\",\"show_advanced_tips\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"sort_order\":\"relevance\",\"sort_direction\":\"desc\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stem\":\"1\",\"stemmer\":\"snowball\",\"enable_logging\":\"0\"}', '', NULL, NULL, 0, 0, NULL, 1),
(28, 0, 'com_joomlaupdate', 'component', 'com_joomlaupdate', NULL, '', 1, 1, 0, 1, '{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.3\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"updatesource\":\"default\",\"minimum_stability\":\"4\",\"customurl\":\"\"}', '', NULL, NULL, 0, 0, NULL, 1),
(29, 0, 'com_tags', 'component', 'com_tags', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"2013-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{\"tag_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_tag_title\":\"0\",\"tag_list_show_tag_image\":\"0\",\"tag_list_show_tag_description\":\"0\",\"tag_list_image\":\"\",\"tag_list_orderby\":\"title\",\"tag_list_orderby_direction\":\"ASC\",\"show_headings\":\"0\",\"tag_list_show_date\":\"0\",\"tag_list_show_item_image\":\"0\",\"tag_list_show_item_description\":\"0\",\"tag_list_item_maximum_characters\":0,\"return_any_or_all\":\"1\",\"include_children\":\"0\",\"maximum\":200,\"tag_list_language_filter\":\"all\",\"tags_layout\":\"_:default\",\"all_tags_orderby\":\"title\",\"all_tags_orderby_direction\":\"ASC\",\"all_tags_show_tag_image\":\"0\",\"all_tags_show_tag_description\":\"0\",\"all_tags_tag_maximum_characters\":20,\"all_tags_show_tag_hits\":\"0\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"tag_field_ajax_mode\":\"1\",\"show_feed_link\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(30, 0, 'com_contenthistory', 'component', 'com_contenthistory', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"2013-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contenthistory\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(31, 0, 'com_ajax', 'component', 'com_ajax', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"2013-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ajax\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(32, 0, 'com_postinstall', 'component', 'com_postinstall', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"2013-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(33, 0, 'com_fields', 'component', 'com_fields', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(34, 0, 'com_associations', 'component', 'com_associations', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(35, 0, 'com_privacy', 'component', 'com_privacy', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_privacy\",\"type\":\"component\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacy\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(36, 0, 'com_actionlogs', 'component', 'com_actionlogs', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_actionlogs\",\"type\":\"component\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"ip_logging\":0,\"csv_delimiter\":\",\",\"loggable_extensions\":[\"com_banners\",\"com_cache\",\"com_categories\",\"com_checkin\",\"com_config\",\"com_contact\",\"com_content\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_tags\",\"com_templates\",\"com_users\"]}', '', NULL, NULL, 0, 0, NULL, 1),
(103, 0, 'lib_joomla', 'library', 'joomla', NULL, '', 0, 1, 1, 1, '{\"name\":\"lib_joomla\",\"type\":\"library\",\"creationDate\":\"2008-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"mediaversion\":\"6ae0db9e7bbd47f4a35831281cf97b89\"}', '', NULL, NULL, 0, 0, NULL, 1),
(106, 0, 'lib_phpass', 'library', 'phpass', NULL, '', 0, 1, 1, 1, '{\"name\":\"lib_phpass\",\"type\":\"library\",\"creationDate\":\"2004-01\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"https:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.3\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpass\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(200, 0, 'mod_articles_archive', 'module', 'mod_articles_archive', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_archive\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(201, 0, 'mod_articles_latest', 'module', 'mod_articles_latest', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_latest\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(202, 0, 'mod_articles_popular', 'module', 'mod_articles_popular', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_popular\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(203, 0, 'mod_banners', 'module', 'mod_banners', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_banners\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(204, 0, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_breadcrumbs\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(205, 0, 'mod_custom', 'module', 'mod_custom', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(206, 0, 'mod_feed', 'module', 'mod_feed', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"2005-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(207, 0, 'mod_footer', 'module', 'mod_footer', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_footer\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(208, 0, 'mod_login', 'module', 'mod_login', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(209, 0, 'mod_menu', 'module', 'mod_menu', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(210, 0, 'mod_articles_news', 'module', 'mod_articles_news', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_news\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(211, 0, 'mod_random_image', 'module', 'mod_random_image', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_random_image\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(212, 0, 'mod_related_items', 'module', 'mod_related_items', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_related_items\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(214, 0, 'mod_stats', 'module', 'mod_stats', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(215, 0, 'mod_syndicate', 'module', 'mod_syndicate', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"2006-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_syndicate\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(216, 0, 'mod_users_latest', 'module', 'mod_users_latest', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"2009-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_users_latest\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(218, 0, 'mod_whosonline', 'module', 'mod_whosonline', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_whosonline\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(219, 0, 'mod_wrapper', 'module', 'mod_wrapper', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"2004-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_wrapper\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(220, 0, 'mod_articles_category', 'module', 'mod_articles_category', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_category\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(221, 0, 'mod_articles_categories', 'module', 'mod_articles_categories', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_categories\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(222, 0, 'mod_languages', 'module', 'mod_languages', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_languages\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(223, 0, 'mod_finder', 'module', 'mod_finder', NULL, '', 0, 1, 0, 0, '{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_finder\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(300, 0, 'mod_custom', 'module', 'mod_custom', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(301, 0, 'mod_feed', 'module', 'mod_feed', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"2005-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(302, 0, 'mod_latest', 'module', 'mod_latest', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latest\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(303, 0, 'mod_logged', 'module', 'mod_logged', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"2005-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_logged\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(304, 0, 'mod_login', 'module', 'mod_login', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"2005-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(305, 0, 'mod_menu', 'module', 'mod_menu', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"2006-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(307, 0, 'mod_popular', 'module', 'mod_popular', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_popular\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(308, 0, 'mod_quickicon', 'module', 'mod_quickicon', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_quickicon\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(311, 0, 'mod_title', 'module', 'mod_title', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_title\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(312, 0, 'mod_toolbar', 'module', 'mod_toolbar', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_toolbar\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(313, 0, 'mod_multilangstatus', 'module', 'mod_multilangstatus', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"2011-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_multilangstatus\"}', '{\"cache\":\"0\"}', '', NULL, NULL, 0, 0, NULL, 1),
(314, 0, 'mod_version', 'module', 'mod_version', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"2012-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_version\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', NULL, NULL, 0, 0, NULL, 1),
(315, 0, 'mod_stats_admin', 'module', 'mod_stats_admin', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats_admin\"}', '{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', NULL, NULL, 0, 0, NULL, 1),
(316, 0, 'mod_tags_popular', 'module', 'mod_tags_popular', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"2013-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_popular\"}', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(317, 0, 'mod_tags_similar', 'module', 'mod_tags_similar', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"2013-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_similar\"}', '{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(318, 0, 'mod_sampledata', 'module', 'mod_sampledata', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"2017-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sampledata\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(319, 0, 'mod_latestactions', 'module', 'mod_latestactions', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_latestactions\",\"type\":\"module\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_LATESTACTIONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latestactions\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(320, 0, 'mod_privacy_dashboard', 'module', 'mod_privacy_dashboard', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_privacy_dashboard\",\"type\":\"module\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_PRIVACY_DASHBOARD_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_privacy_dashboard\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(401, 0, 'plg_authentication_joomla', 'plugin', 'joomla', NULL, 'authentication', 0, 1, 1, 1, '{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(402, 0, 'plg_authentication_ldap', 'plugin', 'ldap', NULL, 'authentication', 0, 0, 1, 0, '{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ldap\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', NULL, NULL, 3, 0, NULL, 1),
(403, 0, 'plg_content_contact', 'plugin', 'contact', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"2014-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2014 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(404, 0, 'plg_content_emailcloak', 'plugin', 'emailcloak', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"emailcloak\"}', '{\"mode\":\"1\"}', '', NULL, NULL, 1, 0, NULL, 1),
(406, 0, 'plg_content_loadmodule', 'plugin', 'loadmodule', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"loadmodule\"}', '{\"style\":\"xhtml\"}', '', NULL, '2011-09-18 15:22:50', 0, 0, NULL, 1),
(407, 0, 'plg_content_pagebreak', 'plugin', 'pagebreak', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '{\"title\":1,\"article_index\":1,\"article_index_text\":\"\",\"multipage_toc\":1,\"showall\":1,\"style\":\"pages\"}', '', NULL, NULL, 4, 0, '', 1),
(408, 0, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"2006-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagenavigation\"}', '{\"position\":\"1\"}', '', NULL, NULL, 5, 0, NULL, 1),
(409, 0, 'plg_content_vote', 'plugin', 'vote', NULL, 'content', 0, 0, 1, 0, '{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"vote\"}', '', '', NULL, NULL, 6, 0, NULL, 1),
(410, 0, 'plg_editors_codemirror', 'plugin', 'codemirror', NULL, 'editors', 0, 1, 1, 0, '{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2021 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"https:\\/\\/codemirror.net\\/\",\"version\":\"5.65.6\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"codemirror\"}', '{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}', '', NULL, NULL, 1, 0, NULL, 1),
(411, 0, 'plg_editors_none', 'plugin', 'none', NULL, 'editors', 0, 1, 1, 1, '{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"2005-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"none\"}', '', '', NULL, NULL, 2, 0, NULL, 1);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `changelogurl`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `checked_out`, `checked_out_time`, `ordering`, `state`, `note`, `locked`) VALUES
(412, 0, 'plg_editors_tinymce', 'plugin', 'tinymce', NULL, 'editors', 0, 1, 1, 0, '{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-08\",\"author\":\"Tiny Technologies, Inc\",\"copyright\":\"Tiny Technologies, Inc\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"https:\\/\\/www.tiny.cloud\",\"version\":\"5.10.5\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tinymce\"}', '{\"configuration\":{\"toolbars\":{\"2\":{\"toolbar1\":[\"bold\",\"underline\",\"strikethrough\",\"|\",\"undo\",\"redo\",\"|\",\"bullist\",\"numlist\",\"|\",\"pastetext\"]},\"1\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"formatselect\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"code\",\"|\",\"hr\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"pastetext\",\"preview\"]},\"0\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"styleselect\",\"|\",\"formatselect\",\"fontselect\",\"fontsizeselect\",\"|\",\"searchreplace\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"image\",\"|\",\"code\",\"|\",\"forecolor\",\"backcolor\",\"|\",\"fullscreen\",\"|\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"emoticons\",\"media\",\"hr\",\"ltr\",\"rtl\",\"|\",\"cut\",\"copy\",\"paste\",\"pastetext\",\"|\",\"visualchars\",\"visualblocks\",\"nonbreaking\",\"blockquote\",\"template\",\"|\",\"print\",\"preview\",\"codesample\",\"insertdatetime\",\"removeformat\"]}},\"setoptions\":{\"2\":{\"access\":[\"1\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"1\":{\"access\":[\"6\",\"2\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"0\":{\"access\":[\"7\",\"4\",\"8\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}}},\"sets_amount\":3,\"html_height\":\"550\",\"html_width\":\"750\"}', '', NULL, NULL, 3, 0, NULL, 1),
(413, 0, 'plg_editors-xtd_article', 'plugin', 'article', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"2009-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"article\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(414, 0, 'plg_editors-xtd_image', 'plugin', 'image', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"2004-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"image\"}', '', '', NULL, NULL, 2, 0, NULL, 1),
(415, 0, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"2004-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(416, 0, 'plg_editors-xtd_readmore', 'plugin', 'readmore', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"2006-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"readmore\"}', '', '', NULL, NULL, 4, 0, NULL, 1),
(422, 0, 'plg_system_languagefilter', 'plugin', 'languagefilter', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"2010-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagefilter\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(424, 0, 'plg_system_cache', 'plugin', 'cache', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"2007-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cache\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', NULL, NULL, 9, 0, NULL, 1),
(425, 0, 'plg_system_debug', 'plugin', 'debug', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"2006-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"debug\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', NULL, NULL, 4, 0, NULL, 1),
(426, 0, 'plg_system_log', 'plugin', 'log', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"2007-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"log\"}', '', '', NULL, NULL, 5, 0, NULL, 1),
(427, 0, 'plg_system_redirect', 'plugin', 'redirect', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"2009-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"redirect\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(428, 0, 'plg_system_remember', 'plugin', 'remember', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"2007-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"remember\"}', '', '', NULL, NULL, 7, 0, NULL, 1),
(429, 0, 'plg_system_sef', 'plugin', 'sef', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"2007-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sef\"}', '', '', NULL, NULL, 8, 0, NULL, 1),
(430, 0, 'plg_system_logout', 'plugin', 'logout', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"2009-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logout\"}', '', '', NULL, NULL, 6, 0, NULL, 1),
(431, 0, 'plg_user_contactcreator', 'plugin', 'contactcreator', NULL, 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"2009-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contactcreator\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', NULL, NULL, 1, 0, NULL, 1),
(432, 0, 'plg_user_joomla', 'plugin', 'joomla', NULL, 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"2006-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"autoregister\":\"1\",\"mail_to_user\":\"1\",\"forceLogout\":\"1\"}', '', NULL, NULL, 2, 0, NULL, 1),
(433, 0, 'plg_user_profile', 'plugin', 'profile', NULL, 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"2008-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"profile\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(434, 0, 'plg_extension_joomla', 'plugin', 'joomla', NULL, 'extension', 0, 1, 1, 0, '{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"2010-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(435, 0, 'plg_content_joomla', 'plugin', 'joomla', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"2010-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(436, 0, 'plg_system_languagecode', 'plugin', 'languagecode', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"2011-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagecode\"}', '', '', NULL, NULL, 10, 0, NULL, 1),
(437, 0, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', NULL, 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomlaupdate\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(438, 0, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', NULL, 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"extensionupdate\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(439, 0, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', NULL, 'captcha', 0, 0, 1, 0, '{\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"2011-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.4.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', NULL, NULL, 0, 0, NULL, 1),
(440, 0, 'plg_system_highlight', 'plugin', 'highlight', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"highlight\"}', '', '', NULL, NULL, 7, 0, NULL, 1),
(441, 0, 'plg_content_finder', 'plugin', 'finder', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"2011-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(442, 0, 'plg_finder_categories', 'plugin', 'categories', NULL, 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(443, 0, 'plg_finder_contacts', 'plugin', 'contacts', NULL, 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}', '', '', NULL, NULL, 2, 0, NULL, 1),
(444, 0, 'plg_finder_content', 'plugin', 'content', NULL, 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(445, 0, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', NULL, 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '', '', NULL, NULL, 4, 0, NULL, 1),
(447, 0, 'plg_finder_tags', 'plugin', 'tags', NULL, 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"2013-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(449, 0, 'plg_authentication_cookie', 'plugin', 'cookie', NULL, 'authentication', 0, 1, 1, 0, '{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"2013-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cookie\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(452, 0, 'plg_system_updatenotification', 'plugin', 'updatenotification', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"2015-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2015 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"updatenotification\"}', '{\"lastrun\":1666791265}', '', NULL, NULL, 0, 0, NULL, 1),
(453, 0, 'plg_editors-xtd_module', 'plugin', 'module', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"2015-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2015 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"module\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(454, 0, 'plg_system_stats', 'plugin', 'stats', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"2013-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"stats\"}', '{\"mode\":3,\"lastrun\":\"\",\"unique_id\":\"cada978097619ed8e2176eb13349549bfb333fd0\",\"interval\":12}', '', NULL, NULL, 0, 0, NULL, 1),
(455, 0, 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', NULL, 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"packageinstaller\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(456, 0, 'plg_installer_folderinstaller', 'plugin', 'folderinstaller', NULL, 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_folderinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"folderinstaller\"}', '', '', NULL, NULL, 2, 0, NULL, 1),
(457, 0, 'plg_installer_urlinstaller', 'plugin', 'urlinstaller', NULL, 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_urlinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"urlinstaller\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(458, 0, 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', NULL, 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"2016-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpversioncheck\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(459, 0, 'plg_editors-xtd_menu', 'plugin', 'menu', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"2016-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menu\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(460, 0, 'plg_editors-xtd_contact', 'plugin', 'contact', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"2016-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(461, 0, 'plg_system_fields', 'plugin', 'fields', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(462, 0, 'plg_fields_calendar', 'plugin', 'calendar', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"calendar\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(463, 0, 'plg_fields_checkboxes', 'plugin', 'checkboxes', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"checkboxes\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(464, 0, 'plg_fields_color', 'plugin', 'color', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"color\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(465, 0, 'plg_fields_editor', 'plugin', 'editor', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"editor\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(466, 0, 'plg_fields_imagelist', 'plugin', 'imagelist', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"imagelist\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(467, 0, 'plg_fields_integer', 'plugin', 'integer', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"integer\"}', '{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(468, 0, 'plg_fields_list', 'plugin', 'list', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"list\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(469, 0, 'plg_fields_media', 'plugin', 'media', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(470, 0, 'plg_fields_radio', 'plugin', 'radio', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"radio\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(471, 0, 'plg_fields_sql', 'plugin', 'sql', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sql\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(472, 0, 'plg_fields_text', 'plugin', 'text', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"text\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(473, 0, 'plg_fields_textarea', 'plugin', 'textarea', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"textarea\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(474, 0, 'plg_fields_url', 'plugin', 'url', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"url\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(475, 0, 'plg_fields_user', 'plugin', 'user', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(476, 0, 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"usergrouplist\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(477, 0, 'plg_content_fields', 'plugin', 'fields', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(478, 0, 'plg_editors-xtd_fields', 'plugin', 'fields', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(479, 0, 'plg_sampledata_blog', 'plugin', 'blog', NULL, 'sampledata', 0, 1, 1, 0, '{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"2017-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"blog\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(480, 0, 'plg_system_sessiongc', 'plugin', 'sessiongc', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sessiongc\",\"type\":\"plugin\",\"creationDate\":\"2018-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.6\",\"description\":\"PLG_SYSTEM_SESSIONGC_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sessiongc\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(482, 0, 'plg_content_confirmconsent', 'plugin', 'confirmconsent', NULL, 'content', 0, 0, 1, 0, '{\"name\":\"plg_content_confirmconsent\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_CONTENT_CONFIRMCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"confirmconsent\"}', '{\"consentbox_text\":\"\",\"privacy_article\":72}', '', NULL, NULL, 0, 0, NULL, 1),
(483, 0, 'plg_system_actionlogs', 'plugin', 'actionlogs', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(484, 0, 'plg_actionlog_joomla', 'plugin', 'joomla', NULL, 'actionlog', 0, 1, 1, 0, '{\"name\":\"plg_actionlog_joomla\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_ACTIONLOG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(485, 0, 'plg_system_privacyconsent', 'plugin', 'privacyconsent', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"2018-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacyconsent\"}', '{\"privacy_note\":\"\",\"privacy_article\":72,\"messageOnRedirect\":\"\",\"enabled\":0,\"cachetimeout\":30,\"consentexpiration\":360,\"remind\":30,\"lastrun\":0}', '', NULL, NULL, 0, 0, NULL, 1),
(486, 0, 'plg_system_logrotation', 'plugin', 'logrotation', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_logrotation\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_LOGROTATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logrotation\"}', '{\"lastrun\":1666648950}', '', NULL, NULL, 0, 0, NULL, 1),
(487, 0, 'plg_privacy_user', 'plugin', 'user', NULL, 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_user\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(488, 0, 'plg_quickicon_privacycheck', 'plugin', 'privacycheck', NULL, 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_privacycheck\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_QUICKICON_PRIVACYCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacycheck\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(489, 0, 'plg_user_terms', 'plugin', 'terms', NULL, 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_terms\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TERMS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"terms\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(490, 0, 'plg_privacy_contact', 'plugin', 'contact', NULL, 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_contact\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(491, 0, 'plg_privacy_content', 'plugin', 'content', NULL, 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_content\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(492, 0, 'plg_privacy_message', 'plugin', 'message', NULL, 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_message\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_MESSAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"message\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(493, 0, 'plg_privacy_actionlogs', 'plugin', 'actionlogs', NULL, 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(494, 0, 'plg_captcha_recaptcha_invisible', 'plugin', 'recaptcha_invisible', NULL, 'captcha', 0, 1, 1, 0, '{\"name\":\"plg_captcha_recaptcha_invisible\",\"type\":\"plugin\",\"creationDate\":\"2017-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_INVISIBLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha_invisible\"}', '{\"public_key\":\"6LcxHfsUAAAAABcuYOHbIii0ZO87j-ipWNVateEU\",\"private_key\":\"6LcxHfsUAAAAAAJXQ_UwAYUywC5UhC65jSx7kU9A\",\"badge\":\"inline\",\"tabindex\":0,\"callback\":\"\",\"expired_callback\":\"\",\"error_callback\":\"\"}', '', NULL, NULL, 0, 0, NULL, 1),
(495, 0, 'plg_privacy_consents', 'plugin', 'consents', NULL, 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_consents\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONSENTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"consents\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(600, 802, 'English (en-GB)', 'language', 'en-GB', NULL, '', 0, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2022-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.4\",\"description\":\"en-GB site language\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(601, 802, 'English (en-GB)', 'language', 'en-GB', NULL, '', 1, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2022-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.4\",\"description\":\"en-GB administrator language\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(700, 0, 'files_joomla', 'file', 'joomla', NULL, '', 0, 1, 1, 1, '{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"2022-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.4\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(802, 0, 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', NULL, '', 0, 1, 1, 1, '{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"2022-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.4.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"filename\":\"pkg_en-GB\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10055, 0, 'System - Helix Ultimate Framework', 'plugin', 'helixultimate', '', 'system', 0, 1, 1, 0, '{\"name\":\"System - Helix Ultimate Framework\",\"type\":\"plugin\",\"creationDate\":\"Feb 2018\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2022 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"2.0.11\",\"description\":\"Helix Ultimate Framework - Joomla Template Framework by JoomShaper\",\"group\":\"\",\"filename\":\"helixultimate\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10056, 0, 'ut_construction', 'template', 'ut_construction', '', '', 0, 1, 1, 0, '{\"name\":\"ut_construction\",\"type\":\"template\",\"creationDate\":\"October 2022\",\"author\":\"Unitemplates.com\",\"copyright\":\"Copyright (C) 2015 - 2021 Unitemplates.com. All rights reserved.\",\"authorEmail\":\"info@unitemplates.com\",\"authorUrl\":\"http:\\/\\/www.unitemplates.com\",\"version\":\"2.2\",\"description\":\"UT Construction - Construction Joomla Template\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10058, 0, 'SP Page Builder', 'component', 'com_sppagebuilder', '', '', 1, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"component\",\"creationDate\":\"Sep 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright @ 2010 - 2022 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"https:\\/\\/www.joomshaper.com\",\"version\":\"3.8.9\",\"description\":\"\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{\"production_mode\":\"0\",\"gmap_api\":\"AIzaSyBYAezV9oqZBUa_ccawE6hXcf-YlOikE7E\",\"ig_token\":\"{\\\"appId\\\":\\\"\\\",\\\"appSecret\\\":\\\"\\\",\\\"accessToken\\\":\\\"\\\",\\\"igId\\\":\\\"\\\"}\",\"fontawesome\":\"1\",\"lazyloadimg\":\"0\",\"lazyplaceholder\":\"https:\\/\\/res.cloudinary.com\\/joomshaper\\/image\\/upload\\/v1582107175\\/placeholder.svg\",\"disableanimatecss\":\"0\",\"disablecss\":\"0\",\"disable_og\":\"0\",\"fb_app_id\":\"\",\"disable_tc\":\"0\",\"joomshaper_email\":\"\",\"joomshaper_license_key\":\"\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10059, 0, 'System - SP PageBuilder', 'plugin', 'sppagebuilder', '', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP PageBuilder\",\"type\":\"plugin\",\"creationDate\":\"Sep 2016\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (c) 2010 - 2021 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"3.8.9\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10060, 0, 'System - SP Page Builder Pro Updater', 'plugin', 'sppagebuilderproupdater', '', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP Page Builder Pro Updater\",\"type\":\"plugin\",\"creationDate\":\"Jul 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (c) 2010 - 2022 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"3.8.9\",\"description\":\"SP Page Builder Pro Updater Plugin\",\"group\":\"\",\"filename\":\"sppagebuilderproupdater\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10061, 0, 'plg_search_sppagebuilder', 'plugin', 'sppagebuilder', '', 'search', 0, 0, 1, 0, '{\"name\":\"plg_search_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"July 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2015 Open Source Matters. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"3.8.9\",\"description\":\"PLG_SEARCH_SPPAGEBUILDER_DESCRIPTION\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10062, 0, 'plg_finder_sppagebuilder', 'plugin', 'sppagebuilder', '', 'finder', 0, 0, 1, 0, '{\"name\":\"plg_finder_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"March 2018\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2010 - 2019 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"3.8.9\",\"description\":\"PLG_FINDER_SP_PAGEBUILDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10063, 0, 'SP Page Builder', 'module', 'mod_sppagebuilder', '', '', 0, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"module\",\"creationDate\":\"Oct 2016\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (c) 2010 - 2022 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"3.8.9\",\"description\":\"Module to display content from SP Page Builder\",\"group\":\"\",\"filename\":\"mod_sppagebuilder\"}', '{\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10064, 0, 'mod_sppagebuilder_icons', 'module', 'mod_sppagebuilder_icons', NULL, '', 1, 1, 2, 0, '{\"name\":\"mod_sppagebuilder_icons\",\"type\":\"module\",\"creationDate\":\"August 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.2\",\"description\":\"MOD_SPPAGEBUILDER_ICONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sppagebuilder_icons\"}', '[]', '', NULL, NULL, 0, 0, NULL, 0),
(10066, 0, 'UT Joomstagram', 'module', 'mod_ut_joomstagram', NULL, '', 0, 1, 0, 0, '{\"name\":\"UT Joomstagram\",\"type\":\"module\",\"creationDate\":\"May 2021\",\"author\":\"Unitemplates.com\",\"copyright\":\"Copyright (C) 2015 - 2021 Unitemplates.com. All rights reserved.\",\"authorEmail\":\"info@unitemplates.com\",\"authorUrl\":\"www.unitemplates.com\",\"version\":\"3.0.0\",\"description\":\"MOD_UT_JOOMSTAGRAM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_ut_joomstagram\"}', '{\"jg_show_profile\":\"1\",\"jg_show_biography\":\"1\",\"jg_photo_size\":\"medium\",\"jg_columns\":\"4\",\"jg_columns_md\":\"3\",\"jg_columns_sm\":\"2\",\"jg_rows\":\"2\",\"jg_padding\":\"0\",\"add_container\":\"0\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10067, 0, 'Content - SP Page Builder', 'plugin', 'sppagebuilder', '', 'content', 0, 0, 1, 0, '{\"name\":\"Content - SP Page Builder\",\"type\":\"plugin\",\"creationDate\":\"Sep 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"3.8.9\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10068, 0, 'SP Simple Portfolio - SP Page Builder', 'plugin', 'sppagebuilder', '', 'spsimpleportfolio', 0, 0, 1, 0, '{\"name\":\"SP Simple Portfolio - SP Page Builder\",\"type\":\"plugin\",\"creationDate\":\"Mar 2019\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (c) 2010 - 2021 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"3.8.9\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `changelogurl`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `checked_out`, `checked_out_time`, `ordering`, `state`, `note`, `locked`) VALUES
(10069, 0, 'K2 - SP Page Builder', 'plugin', 'sppagebuilder', '', 'k2', 0, 0, 1, 0, '{\"name\":\"K2 - SP Page Builder\",\"type\":\"plugin\",\"creationDate\":\"Sep 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"3.8.9\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10071, 0, 'plg_behaviour_taggable', 'plugin', 'taggable', NULL, 'behaviour', 0, 1, 1, 0, '{\"name\":\"plg_behaviour_taggable\",\"type\":\"plugin\",\"creationDate\":\"2015-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_TAGGABLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"taggable\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10072, 0, 'plg_behaviour_versionable', 'plugin', 'versionable', NULL, 'behaviour', 0, 1, 1, 0, '{\"name\":\"plg_behaviour_versionable\",\"type\":\"plugin\",\"creationDate\":\"2015-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_VERSIONABLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"versionable\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10073, 0, 'atum', 'template', 'atum', NULL, '', 1, 1, 1, 0, '{\"name\":\"atum\",\"type\":\"template\",\"creationDate\":\"2016-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ATUM_XML_DESCRIPTION\",\"group\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10074, 0, 'cassiopeia', 'template', 'cassiopeia', NULL, '', 0, 1, 1, 0, '{\"name\":\"cassiopeia\",\"type\":\"template\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_CASSIOPEIA_XML_DESCRIPTION\",\"group\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10075, 0, 'plg_filesystem_local', 'plugin', 'local', NULL, 'filesystem', 0, 1, 1, 0, '{\"name\":\"plg_filesystem_local\",\"type\":\"plugin\",\"creationDate\":\"2017-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FILESYSTEM_LOCAL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"local\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10076, 0, 'plg_media-action_crop', 'plugin', 'crop', NULL, 'media-action', 0, 1, 1, 0, '{\"name\":\"plg_media-action_crop\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_CROP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"crop\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10077, 0, 'plg_media-action_resize', 'plugin', 'resize', NULL, 'media-action', 0, 1, 1, 0, '{\"name\":\"plg_media-action_resize\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_RESIZE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"resize\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10078, 0, 'plg_media-action_rotate', 'plugin', 'rotate', NULL, 'media-action', 0, 1, 1, 0, '{\"name\":\"plg_media-action_rotate\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_ROTATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"rotate\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10079, 0, 'plg_system_httpheaders', 'plugin', 'httpheaders', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_httpheaders\",\"type\":\"plugin\",\"creationDate\":\"2017-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_HTTPHEADERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"httpheaders\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10080, 0, 'com_workflow', 'component', 'com_workflow', NULL, '', 1, 1, 0, 1, '{\"name\":\"com_workflow\",\"type\":\"component\",\"creationDate\":\"2017-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WORKFLOW_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10081, 0, 'plg_workflow_publishing', 'plugin', 'publishing', NULL, 'workflow', 0, 1, 1, 0, '{\"name\":\"plg_workflow_publishing\",\"type\":\"plugin\",\"creationDate\":\"2020-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_PUBLISHING_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"publishing\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10082, 0, 'plg_workflow_featuring', 'plugin', 'featuring', NULL, 'workflow', 0, 1, 1, 0, '{\"name\":\"plg_workflow_featuring\",\"type\":\"plugin\",\"creationDate\":\"2020-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_FEATURING_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"featuring\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10083, 0, 'plg_workflow_notification', 'plugin', 'notification', NULL, 'workflow', 0, 1, 1, 0, '{\"name\":\"plg_workflow_notification\",\"type\":\"plugin\",\"creationDate\":\"2020-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"notification\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10084, 0, 'plg_extension_namespacemap', 'plugin', 'namespacemap', NULL, 'extension', 0, 1, 1, 1, '{\"name\":\"plg_extension_namespacemap\",\"type\":\"plugin\",\"creationDate\":\"2017-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_NAMESPACEMAP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"namespacemap\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10085, 0, 'plg_installer_override', 'plugin', 'override', NULL, 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_override\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_OVERRIDE_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"override\"}', '', '', NULL, NULL, 4, 0, NULL, 1),
(10086, 0, 'plg_quickicon_overridecheck', 'plugin', 'overridecheck', NULL, 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_overridecheck\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_OVERRIDECHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"overridecheck\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10087, 0, 'plg_extension_finder', 'plugin', 'finder', NULL, 'extension', 0, 1, 1, 0, '{\"name\":\"plg_extension_finder\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10088, 0, 'plg_api-authentication_basic', 'plugin', 'basic', NULL, 'api-authentication', 0, 0, 1, 0, '{\"name\":\"plg_api-authentication_basic\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_BASIC_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"basic\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10089, 0, 'plg_webservices_content', 'plugin', 'content', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_content\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10090, 0, 'com_mails', 'component', 'com_mails', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_mails\",\"type\":\"component\",\"creationDate\":\"2019-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MAILS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10091, 0, 'plg_system_skipto', 'plugin', 'skipto', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_skipto\",\"type\":\"plugin\",\"creationDate\":\"2020-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_SKIPTO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"skipto\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10092, 0, 'plg_sampledata_multilang', 'plugin', 'multilang', NULL, 'sampledata', 0, 1, 1, 0, '{\"name\":\"plg_sampledata_multilang\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SAMPLEDATA_MULTILANG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"multilang\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10093, 0, 'plg_installer_webinstaller', 'plugin', 'webinstaller', NULL, 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_webinstaller\",\"type\":\"plugin\",\"creationDate\":\"2017-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_WEBINSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"webinstaller\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10094, 0, 'plg_fields_subform', 'plugin', 'subform', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_subform\",\"type\":\"plugin\",\"creationDate\":\"2017-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FIELDS_SUBFORM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"subform\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10095, 0, 'plg_system_webauthn', 'plugin', 'webauthn', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2019-07-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_WEBAUTHN_DESCRIPTION\",\"group\":\"\",\"filename\":\"webauthn\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10096, 0, 'mod_loginsupport', 'module', 'mod_loginsupport', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_loginsupport\",\"type\":\"module\",\"creationDate\":\"2019-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_LOGINSUPPORT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_loginsupport\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10097, 0, 'mod_frontend', 'module', 'mod_frontend', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_frontend\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_FRONTEND_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_frontend\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10098, 0, 'mod_messages', 'module', 'mod_messages', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_messages\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_messages\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10099, 0, 'mod_post_installation_messages', 'module', 'mod_post_installation_messages', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_post_installation_messages\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_POST_INSTALLATION_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_post_installation_messages\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10100, 0, 'mod_user', 'module', 'mod_user', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_user\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_user\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10101, 0, 'mod_submenu', 'module', 'mod_submenu', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"2006-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_submenu\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10102, 0, 'mod_privacy_status', 'module', 'mod_privacy_status', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_privacy_status\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_PRIVACY_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_privacy_status\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10103, 0, 'plg_webservices_banners', 'plugin', 'banners', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_banners\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"banners\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10104, 0, 'plg_webservices_config', 'plugin', 'config', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_config\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"config\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10105, 0, 'plg_webservices_contact', 'plugin', 'contact', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_contact\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10106, 0, 'plg_webservices_languages', 'plugin', 'languages', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_languages\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languages\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10107, 0, 'plg_webservices_menus', 'plugin', 'menus', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_menus\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menus\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10108, 0, 'plg_webservices_messages', 'plugin', 'messages', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_messages\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"messages\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10109, 0, 'plg_webservices_modules', 'plugin', 'modules', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_modules\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"modules\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10110, 0, 'plg_webservices_newsfeeds', 'plugin', 'newsfeeds', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10111, 0, 'plg_webservices_plugins', 'plugin', 'plugins', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_plugins\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"plugins\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10112, 0, 'plg_webservices_privacy', 'plugin', 'privacy', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_privacy\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacy\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10113, 0, 'plg_webservices_redirect', 'plugin', 'redirect', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_redirect\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"redirect\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10114, 0, 'plg_webservices_tags', 'plugin', 'tags', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_tags\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10115, 0, 'plg_webservices_templates', 'plugin', 'templates', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_templates\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templates\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10116, 0, 'plg_webservices_users', 'plugin', 'users', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_users\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_USERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"users\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10117, 0, 'plg_webservices_installer', 'plugin', 'installer', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_installer\",\"type\":\"plugin\",\"creationDate\":\"2020-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"installer\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10118, 0, 'plg_user_token', 'plugin', 'token', NULL, 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_token\",\"type\":\"plugin\",\"creationDate\":\"2019-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"token\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10119, 0, 'plg_api-authentication_token', 'plugin', 'token', NULL, 'api-authentication', 0, 1, 1, 0, '{\"name\":\"plg_api-authentication_token\",\"type\":\"plugin\",\"creationDate\":\"2019-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"token\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10120, 0, 'plg_system_accessibility', 'plugin', 'accessibility', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_accessibility\",\"type\":\"plugin\",\"creationDate\":\"2020-02-15\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_ACCESSIBILITY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"accessibility\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10121, 802, 'English (en-GB)', 'language', 'en-GB', NULL, '', 3, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2022-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.4\",\"description\":\"en-GB api language\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10122, 0, 'plg_quickicon_downloadkey', 'plugin', 'downloadkey', NULL, 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_downloadkey\",\"type\":\"plugin\",\"creationDate\":\"2019-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_DOWNLOADKEY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"downloadkey\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10124, 0, 'com_scheduler', 'component', 'com_scheduler', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_scheduler\",\"type\":\"component\",\"creationDate\":\"2021-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"COM_SCHEDULER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10125, 0, 'plg_system_schedulerunner', 'plugin', 'schedulerunner', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_schedulerunner\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_SCHEDULERUNNER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"schedulerunner\"}', '{}', '', NULL, NULL, 15, 0, NULL, 1),
(10126, 0, 'plg_system_task_notification', 'plugin', 'tasknotification', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_task_notification\",\"type\":\"plugin\",\"creationDate\":\"2021-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_TASK_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tasknotification\"}', '', '', NULL, NULL, 22, 0, NULL, 1),
(10127, 0, 'plg_task_check_files', 'plugin', 'checkfiles', NULL, 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_check_files\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_CHECK_FILES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"checkfiles\"}', '{}', '', NULL, NULL, 15, 0, NULL, 1),
(10128, 0, 'plg_task_demo_tasks', 'plugin', 'demotasks', NULL, 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_demo_tasks\",\"type\":\"plugin\",\"creationDate\":\"2021-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_DEMO_TASKS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"demotasks\"}', '{}', '', NULL, NULL, 15, 0, NULL, 1),
(10129, 0, 'plg_task_requests', 'plugin', 'requests', NULL, 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_requests\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_REQUESTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"requests\"}', '{}', '', NULL, NULL, 15, 0, NULL, 1),
(10130, 0, 'plg_task_site_status', 'plugin', 'sitestatus', NULL, 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_site_status\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_SITE_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sitestatus\"}', '{}', '', NULL, NULL, 15, 0, NULL, 1),
(10131, 0, 'plg_system_jooa11y', 'plugin', 'jooa11y', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_jooa11y\",\"type\":\"plugin\",\"creationDate\":\"2022-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_SYSTEM_JOOA11Y_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"jooa11y\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10132, 0, 'plg_webservices_media', 'plugin', 'media', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_media\",\"type\":\"plugin\",\"creationDate\":\"2021-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"PLG_WEBSERVICES_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10133, 0, 'Unitemplates Custom Fields', 'plugin', 'ut_custom_fields', '', 'content', 0, 0, 1, 0, '{\"name\":\"Unitemplates Custom Fields\",\"type\":\"plugin\",\"creationDate\":\"Jan 2022\",\"author\":\"Unitemplates\",\"copyright\":\"Copyright (C) 2015 - 2022 Unitemplates. All rights reserved.\",\"authorEmail\":\"infor@unitemplates.com\",\"authorUrl\":\"www.unitemplates.com\",\"version\":\"1.0.0\",\"description\":\"Added custom fields, fields are on: Content >> Fields. Read template documentation to continue with the configuration. Do not activate or uninstall the plugin.\",\"group\":\"\",\"filename\":\"ut_custom_fields\"}', '[]', '', NULL, NULL, 0, 0, NULL, 0),
(10134, 0, 'plg_multifactorauth_totp', 'plugin', 'totp', NULL, 'multifactorauth', 0, 0, 1, 0, '{\"name\":\"plg_multifactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"2013-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"totp\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(10135, 0, 'plg_multifactorauth_yubikey', 'plugin', 'yubikey', NULL, 'multifactorauth', 0, 0, 1, 0, '{\"name\":\"plg_multifactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"2013-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"yubikey\"}', '', '', NULL, NULL, 2, 0, NULL, 1),
(10136, 0, 'plg_multifactorauth_webauthn', 'plugin', 'webauthn', NULL, 'multifactorauth', 0, 0, 1, 0, '{\"name\":\"plg_multifactorauth_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_WEBAUTHN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"webauthn\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(10137, 0, 'plg_multifactorauth_email', 'plugin', 'email', NULL, 'multifactorauth', 0, 0, 1, 0, '{\"name\":\"plg_multifactorauth_email\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_EMAIL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"email\"}', '', '', NULL, NULL, 4, 0, NULL, 1),
(10138, 0, 'plg_multifactorauth_fixed', 'plugin', 'fixed', NULL, 'multifactorauth', 0, 0, 1, 0, '{\"name\":\"plg_multifactorauth_fixed\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_FIXED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fixed\"}', '', '', NULL, NULL, 5, 0, NULL, 1),
(10139, 0, 'plg_system_shortcut', 'plugin', 'shortcut', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_shortcut\",\"type\":\"plugin\",\"creationDate\":\"2022-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_SYSTEM_SHORTCUT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"shortcut\"}', '', '', NULL, NULL, 0, 0, NULL, 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__fields`
--

DROP TABLE IF EXISTS `#__fields`;
CREATE TABLE IF NOT EXISTS `#__fields` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_value` text COLLATE utf8mb4_unicode_ci,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldparams` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL,
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  `only_use_in_subform` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_user_id` (`created_user_id`),
  KEY `idx_access` (`access`),
  KEY `idx_language` (`language`),
  KEY `idx_context` (`context`(191))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `#__fields`
--

INSERT INTO `#__fields` (`id`, `asset_id`, `context`, `group_id`, `title`, `name`, `label`, `default_value`, `type`, `note`, `description`, `state`, `required`, `checked_out`, `checked_out_time`, `ordering`, `params`, `fieldparams`, `language`, `created_time`, `created_user_id`, `modified_time`, `modified_by`, `access`, `only_use_in_subform`) VALUES
(1, 69, 'com_content.article', 1, 'Project Gallery', 'project-gallery', 'Project Gallery', '', 'subform', '', 'Additional images of the project. You can add thumbnails of the images to accelerate the loading of the page, or add the large images directly.', 1, 0, NULL, NULL, 2, '{\"hint\":\"\",\"class\":\"\",\"label_class\":\"\",\"show_on\":\"\",\"render_class\":\"\",\"showlabel\":\"1\",\"label_render_class\":\"\",\"display\":\"0\",\"layout\":\"\",\"display_readonly\":\"2\"}', '{\"repeat\":\"1\",\"options\":{\"option0\":{\"customfield\":3,\"render_values\":\"1\"},\"option1\":{\"customfield\":4,\"render_values\":\"1\"}}}', '*', '2020-05-04 05:39:41', 101, '2020-05-04 05:40:02', 101, 1, 0),
(2, 70, 'com_content.article', 1, 'Project Details', 'project-details', 'Project Details', '', 'subform', '', '', 1, 0, NULL, NULL, 1, '{\"hint\":\"\",\"class\":\"\",\"label_class\":\"\",\"show_on\":\"\",\"render_class\":\"\",\"showlabel\":\"1\",\"label_render_class\":\"\",\"display\":\"0\",\"layout\":\"\",\"display_readonly\":\"2\"}', '{\"repeat\":\"1\",\"options\":{\"option0\":{\"customfield\":5,\"render_values\":\"1\"},\"option1\":{\"customfield\":6,\"render_values\":\"1\"}}}', '*', '2020-05-04 05:59:12', 101, '2020-05-04 05:59:22', 101, 1, 0),
(3, 336, 'com_content.article', 1, 'Thumbnail', 'thumbnail', 'Thumbnail', '', 'media', '', 'Additional images of the project. You can add thumbnails of the images to accelerate the loading of the page, or add the large images directly.', 1, 0, NULL, NULL, 0, '{\"hint\":\"\",\"class\":\"\",\"label_class\":\"\",\"show_on\":\"\",\"render_class\":\"\",\"showlabel\":\"1\",\"label_render_class\":\"\",\"display\":\"0\",\"layout\":\"\",\"display_readonly\":\"2\"}', '{}', '*', '2021-10-05 00:59:06', 101, '2021-10-05 00:59:06', 101, 1, 1),
(4, 337, 'com_content.article', 1, 'Image', 'image', 'Image', '', 'media', '', 'Additional images of the project. You can add thumbnails of the images to accelerate the loading of the page, or add the large images directly.', 1, 0, NULL, NULL, 0, '{\"hint\":\"\",\"class\":\"\",\"label_class\":\"\",\"show_on\":\"\",\"render_class\":\"\",\"showlabel\":\"1\",\"label_render_class\":\"\",\"display\":\"0\",\"layout\":\"\",\"display_readonly\":\"2\"}', '{}', '*', '2021-10-05 00:59:06', 101, '2021-10-05 00:59:06', 101, 1, 1),
(5, 338, 'com_content.article', 1, 'Detail Name', 'detail-name', 'Detail Name', '', 'text', '', '', 1, 0, NULL, NULL, 0, '{\"hint\":\"\",\"class\":\"\",\"label_class\":\"\",\"show_on\":\"\",\"render_class\":\"\",\"showlabel\":\"1\",\"label_render_class\":\"\",\"display\":\"0\",\"layout\":\"\",\"display_readonly\":\"2\"}', '{}', '*', '2021-10-05 00:59:06', 101, '2021-10-05 00:59:06', 101, 1, 1),
(6, 339, 'com_content.article', 1, 'Detail Value', 'detail-value', 'Detail Value', '', 'text', '', '', 1, 0, NULL, NULL, 0, '{\"hint\":\"\",\"class\":\"\",\"label_class\":\"\",\"show_on\":\"\",\"render_class\":\"\",\"showlabel\":\"1\",\"label_render_class\":\"\",\"display\":\"0\",\"layout\":\"\",\"display_readonly\":\"2\"}', '{}', '*', '2021-10-05 00:59:06', 101, '2021-10-05 00:59:06', 101, 1, 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__fields_categories`
--

DROP TABLE IF EXISTS `#__fields_categories`;
CREATE TABLE IF NOT EXISTS `#__fields_categories` (
  `field_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`field_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `#__fields_categories`
--

INSERT INTO `#__fields_categories` (`field_id`, `category_id`) VALUES
(1, 8),
(2, 8),
(3, -1),
(4, -1),
(5, -1),
(6, -1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__fields_groups`
--

DROP TABLE IF EXISTS `#__fields_groups`;
CREATE TABLE IF NOT EXISTS `#__fields_groups` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL,
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_access` (`access`),
  KEY `idx_language` (`language`),
  KEY `idx_context` (`context`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `#__fields_groups`
--

INSERT INTO `#__fields_groups` (`id`, `asset_id`, `context`, `title`, `note`, `description`, `state`, `checked_out`, `checked_out_time`, `ordering`, `params`, `language`, `created`, `created_by`, `modified`, `modified_by`, `access`) VALUES
(1, 67, 'com_content.article', 'Project Details', '', '', 1, NULL, NULL, 0, '{\"display_readonly\":\"1\"}', '*', '2020-05-04 05:34:55', 101, '2020-05-17 00:58:48', 101, 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__fields_values`
--

DROP TABLE IF EXISTS `#__fields_values`;
CREATE TABLE IF NOT EXISTS `#__fields_values` (
  `field_id` int(10) UNSIGNED NOT NULL,
  `item_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` text COLLATE utf8mb4_unicode_ci,
  KEY `idx_field_id` (`field_id`),
  KEY `idx_item_id` (`item_id`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `#__fields_values`
--

INSERT INTO `#__fields_values` (`field_id`, `item_id`, `value`) VALUES
(2, '1', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Engineer\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '1', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01.jpg?width=1110&height=599\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '2', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Engineer\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '2', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01.jpg?width=1110&height=599\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '3', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Engineer\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '3', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01.jpg?width=1110&height=599\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '4', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Engineer\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '4', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01.jpg?width=1110&height=599\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '5', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '5', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01.jpg?width=1110&height=599\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '6', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Engineer\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '6', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01.jpg?width=1110&height=599\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '7', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '7', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01.jpg?width=1110&height=599\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '8', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '8', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01.jpg?width=1110&height=599\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '9', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '9', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01.jpg?width=1110&height=599\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '10', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '10', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01.jpg?width=1110&height=599\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '11', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '11', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01.jpg?width=1110&height=599\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '12', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Engineer\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '12', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_01.jpg?width=1110&height=599\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/construction\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/construction\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '14', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}');
INSERT INTO `#__fields_values` (`field_id`, `item_id`, `value`) VALUES
(1, '14', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '15', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '15', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '16', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '16', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '17', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '17', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '18', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '18', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '19', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '19', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '20', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '20', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '21', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '21', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '22', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '22', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '23', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '23', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '24', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '24', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '25', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Lima\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '25', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/interior\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/interior\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '26', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Socavon Mine\"},\"row1\":{\"field5\":\"Engineer\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Mountain\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '26', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '27', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Socavon Mine\"},\"row1\":{\"field5\":\"Engineer\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Mountain\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}');
INSERT INTO `#__fields_values` (`field_id`, `item_id`, `value`) VALUES
(1, '27', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '28', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Socavon Mine\"},\"row1\":{\"field5\":\"Engineer\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Mountain\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '28', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '29', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Socavon Mine\"},\"row1\":{\"field5\":\"Engineer\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Mountain\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '29', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '30', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Socavon Mine\"},\"row1\":{\"field5\":\"Engineer\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Mountain\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '30', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '31', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Socavon Mine\"},\"row1\":{\"field5\":\"Engineer\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Mountain\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '31', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '32', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Socavon Mine\"},\"row1\":{\"field5\":\"Engineer\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Mountain\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '32', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '33', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Socavon Mine\"},\"row1\":{\"field5\":\"Engineer\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Mountain\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '33', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '34', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Socavon Mine\"},\"row1\":{\"field5\":\"Engineer\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"Mountain\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Construction\"}}'),
(1, '34', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/mining\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/mining\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '35', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"World\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Architecture\"}}'),
(1, '35', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '36', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"World\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Architecture\"}}'),
(1, '36', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '37', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"World\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Architecture\"}}'),
(1, '37', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '38', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"World\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Architecture\"}}'),
(1, '38', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '39', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"World\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Architecture\"}}'),
(1, '39', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '40', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"World\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Architecture\"}}');
INSERT INTO `#__fields_values` (`field_id`, `item_id`, `value`) VALUES
(1, '40', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '41', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"World\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Architecture\"}}'),
(1, '41', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '42', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"World\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Architecture\"}}'),
(1, '42', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}'),
(2, '43', '{\"row0\":{\"field5\":\"Client\",\"field6\":\"Unitemplates\"},\"row1\":{\"field5\":\"Architect\",\"field6\":\"Alvaro Mendoza\"},\"row2\":{\"field5\":\"Location\",\"field6\":\"World\"},\"row3\":{\"field5\":\"Date\",\"field6\":\"2021-09-24\"},\"row4\":{\"field5\":\"Service\",\"field6\":\"Architecture\"}}'),
(1, '43', '{\"row0\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_01_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_01_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_01.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_01.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row1\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_02_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_02_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_02.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_02.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row2\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_03_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_03_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_03.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_03.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row3\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_04_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_04_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_04.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_04.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row4\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_05_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_05_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_05.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_05.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row5\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_06_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_06_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_06.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_06.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row6\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_07_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_07_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_07.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_07.jpg?width=1110&height=600\",\"alt_text\":\"\"}},\"row7\":{\"field3\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_08_thumb.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_08_thumb.jpg?width=290&height=157\",\"alt_text\":\"\"},\"field4\":{\"imagefile\":\"images\\/projects\\/architect\\/gallery\\/gallery_08.jpg#joomlaImage:\\/\\/local-images\\/projects\\/architect\\/gallery\\/gallery_08.jpg?width=1110&height=600\",\"alt_text\":\"\"}}}');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__languages`
--

DROP TABLE IF EXISTS `#__languages`;
CREATE TABLE IF NOT EXISTS `#__languages` (
  `lang_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lang_code` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_native` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sef` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `sitename` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `idx_sef` (`sef`),
  UNIQUE KEY `idx_langcode` (`lang_code`),
  KEY `idx_access` (`access`),
  KEY `idx_ordering` (`ordering`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `#__languages`
--

INSERT INTO `#__languages` (`lang_id`, `asset_id`, `lang_code`, `title`, `title_native`, `sef`, `image`, `description`, `metakey`, `metadesc`, `sitename`, `published`, `access`, `ordering`) VALUES
(1, 0, 'en-GB', 'English (en-GB)', 'English (United Kingdom)', 'en', 'en_gb', '', '', '', '', 1, 1, 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__mail_templates`
--

DROP TABLE IF EXISTS `#__mail_templates`;
CREATE TABLE IF NOT EXISTS `#__mail_templates` (
  `template_id` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `htmlbody` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attachments` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`template_id`,`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `#__mail_templates`
--

INSERT INTO `#__mail_templates` (`template_id`, `extension`, `language`, `subject`, `body`, `htmlbody`, `attachments`, `params`) VALUES
('com_actionlogs.notification', 'com_actionlogs', '', 'COM_ACTIONLOGS_EMAIL_SUBJECT', 'COM_ACTIONLOGS_EMAIL_BODY', 'COM_ACTIONLOGS_EMAIL_HTMLBODY', '', '{\"tags\":[\"message\",\"date\",\"extension\",\"username\"]}'),
('com_config.test_mail', 'com_config', '', 'COM_CONFIG_SENDMAIL_SUBJECT', 'COM_CONFIG_SENDMAIL_BODY', '', '', '{\"tags\":[\"sitename\",\"method\"]}'),
('com_contact.mail', 'com_contact', '', 'COM_CONTACT_ENQUIRY_SUBJECT', 'COM_CONTACT_ENQUIRY_TEXT', '', '', '{\"tags\":[\"sitename\",\"name\",\"email\",\"subject\",\"body\",\"url\",\"customfields\"]}'),
('com_contact.mail.copy', 'com_contact', '', 'COM_CONTACT_COPYSUBJECT_OF', 'COM_CONTACT_COPYTEXT_OF', '', '', '{\"tags\":[\"sitename\",\"name\",\"email\",\"subject\",\"body\",\"url\",\"customfields\",\"contactname\"]}'),
('com_messages.new_message', 'com_messages', '', 'COM_MESSAGES_NEW_MESSAGE', 'COM_MESSAGES_NEW_MESSAGE_BODY', '', '', '{\"tags\":[\"subject\",\"message\",\"fromname\",\"sitename\",\"siteurl\",\"fromemail\",\"toname\",\"toemail\"]}'),
('com_privacy.notification.admin.export', 'com_privacy', '', 'COM_PRIVACY_EMAIL_ADMIN_REQUEST_SUBJECT_EXPORT_REQUEST', 'COM_PRIVACY_EMAIL_ADMIN_REQUEST_BODY_EXPORT_REQUEST', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('com_privacy.notification.admin.remove', 'com_privacy', '', 'COM_PRIVACY_EMAIL_ADMIN_REQUEST_SUBJECT_REMOVE_REQUEST', 'COM_PRIVACY_EMAIL_ADMIN_REQUEST_BODY_REMOVE_REQUEST', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('com_privacy.notification.export', 'com_privacy', '', 'COM_PRIVACY_EMAIL_REQUEST_SUBJECT_EXPORT_REQUEST', 'COM_PRIVACY_EMAIL_REQUEST_BODY_EXPORT_REQUEST', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('com_privacy.notification.remove', 'com_privacy', '', 'COM_PRIVACY_EMAIL_REQUEST_SUBJECT_REMOVE_REQUEST', 'COM_PRIVACY_EMAIL_REQUEST_BODY_REMOVE_REQUEST', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('com_privacy.userdataexport', 'com_privacy', '', 'COM_PRIVACY_EMAIL_DATA_EXPORT_COMPLETED_SUBJECT', 'COM_PRIVACY_EMAIL_DATA_EXPORT_COMPLETED_BODY', '', '', '{\"tags\":[\"sitename\",\"url\"]}'),
('com_users.massmail.mail', 'com_users', '', 'COM_USERS_MASSMAIL_MAIL_SUBJECT', 'COM_USERS_MASSMAIL_MAIL_BODY', '', '', '{\"tags\":[\"subject\",\"body\",\"subjectprefix\",\"bodysuffix\"]}'),
('com_users.password_reset', 'com_users', '', 'COM_USERS_EMAIL_PASSWORD_RESET_SUBJECT', 'COM_USERS_EMAIL_PASSWORD_RESET_BODY', '', '', '{\"tags\":[\"name\",\"email\",\"sitename\",\"link_text\",\"link_html\",\"token\"]}'),
('com_users.registration.admin.new_notification', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_NOTIFICATION_TO_ADMIN_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\"]}'),
('com_users.registration.admin.verification_request', 'com_users', '', 'COM_USERS_EMAIL_ACTIVATE_WITH_ADMIN_ACTIVATION_SUBJECT', 'COM_USERS_EMAIL_ACTIVATE_WITH_ADMIN_ACTIVATION_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"email\",\"username\",\"activate\"]}'),
('com_users.registration.user.admin_activated', 'com_users', '', 'COM_USERS_EMAIL_ACTIVATED_BY_ADMIN_ACTIVATION_SUBJECT', 'COM_USERS_EMAIL_ACTIVATED_BY_ADMIN_ACTIVATION_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\"]}'),
('com_users.registration.user.admin_activation', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_WITH_ADMIN_ACTIVATION_BODY_NOPW', '', '', '{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\"]}'),
('com_users.registration.user.admin_activation_w_pw', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_WITH_ADMIN_ACTIVATION_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\",\"password_clear\"]}'),
('com_users.registration.user.registration_mail', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_BODY_NOPW', '', '', '{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\"]}'),
('com_users.registration.user.registration_mail_w_pw', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\",\"password_clear\"]}'),
('com_users.registration.user.self_activation', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_WITH_ACTIVATION_BODY_NOPW', '', '', '{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\"]}'),
('com_users.registration.user.self_activation_w_pw', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_WITH_ACTIVATION_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\",\"password_clear\"]}'),
('com_users.reminder', 'com_users', '', 'COM_USERS_EMAIL_USERNAME_REMINDER_SUBJECT', 'COM_USERS_EMAIL_USERNAME_REMINDER_BODY', '', '', '{\"tags\":[\"name\",\"username\",\"sitename\",\"email\",\"link_text\",\"link_html\"]}'),
('plg_multifactorauth_email.mail', 'plg_multifactorauth_email', '', 'PLG_MULTIFACTORAUTH_EMAIL_EMAIL_SUBJECT', 'PLG_MULTIFACTORAUTH_EMAIL_EMAIL_BODY', '', '', '{\"tags\":[\"code\",\"sitename\",\"siteurl\",\"username\",\"email\",\"fullname\"]}'),
('plg_system_privacyconsent.request.reminder', 'plg_system_privacyconsent', '', 'PLG_SYSTEM_PRIVACYCONSENT_EMAIL_REMIND_SUBJECT', 'PLG_SYSTEM_PRIVACYCONSENT_EMAIL_REMIND_BODY', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('plg_system_tasknotification.failure_mail', 'plg_system_tasknotification', '', 'PLG_SYSTEM_TASK_NOTIFICATION_FAILURE_MAIL_SUBJECT', 'PLG_SYSTEM_TASK_NOTIFICATION_FAILURE_MAIL_BODY', '', '', '{\"tags\": [\"task_id\", \"task_title\", \"exit_code\", \"exec_data_time\", \"task_output\"]}'),
('plg_system_tasknotification.fatal_recovery_mail', 'plg_system_tasknotification', '', 'PLG_SYSTEM_TASK_NOTIFICATION_FATAL_MAIL_SUBJECT', 'PLG_SYSTEM_TASK_NOTIFICATION_FATAL_MAIL_BODY', '', '', '{\"tags\": [\"task_id\", \"task_title\"]}'),
('plg_system_tasknotification.orphan_mail', 'plg_system_tasknotification', '', 'PLG_SYSTEM_TASK_NOTIFICATION_ORPHAN_MAIL_SUBJECT', 'PLG_SYSTEM_TASK_NOTIFICATION_ORPHAN_MAIL_BODY', '', '', '{\"tags\": [\"task_id\", \"task_title\"]}'),
('plg_system_tasknotification.success_mail', 'plg_system_tasknotification', '', 'PLG_SYSTEM_TASK_NOTIFICATION_SUCCESS_MAIL_SUBJECT', 'PLG_SYSTEM_TASK_NOTIFICATION_SUCCESS_MAIL_BODY', '', '', '{\"tags\":[\"task_id\", \"task_title\", \"exec_data_time\", \"task_output\"]}'),
('plg_system_updatenotification.mail', 'plg_system_updatenotification', '', 'PLG_SYSTEM_UPDATENOTIFICATION_EMAIL_SUBJECT', 'PLG_SYSTEM_UPDATENOTIFICATION_EMAIL_BODY', '', '', '{\"tags\":[\"newversion\",\"curversion\",\"sitename\",\"url\",\"link\",\"releasenews\"]}'),
('plg_user_joomla.mail', 'plg_user_joomla', '', 'PLG_USER_JOOMLA_NEW_USER_EMAIL_SUBJECT', 'PLG_USER_JOOMLA_NEW_USER_EMAIL_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"url\",\"username\",\"password\",\"email\"]}');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__menu`
--

DROP TABLE IF EXISTS `#__menu`;
CREATE TABLE IF NOT EXISTS `#__menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`(100),`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_path` (`path`(100))
) ENGINE=InnoDB AUTO_INCREMENT=290 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `#__menu`
--

INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`, `publish_up`, `publish_down`) VALUES
(1, '', 'Menu_Item_Root', 'root', '', '', '', '', 1, 0, 0, 0, NULL, NULL, 0, 0, '', 0, '', 0, 351, 0, '*', 0, NULL, NULL),
(2, 'main', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', 1, 1, 1, 4, NULL, NULL, 0, 0, 'class:bookmark', 0, '', 27, 36, 0, '*', 1, NULL, NULL),
(3, 'main', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners&view=banners', 'component', 1, 2, 2, 4, NULL, NULL, 0, 0, 'class:banners', 0, '', 28, 29, 0, '*', 1, NULL, NULL),
(4, 'main', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&view=categories&extension=com_banners', 'component', 1, 2, 2, 6, NULL, NULL, 0, 0, 'class:banners-cat', 0, '', 30, 31, 0, '*', 1, NULL, NULL),
(5, 'main', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', 1, 2, 2, 4, NULL, NULL, 0, 0, 'class:banners-clients', 0, '', 32, 33, 0, '*', 1, NULL, NULL),
(6, 'main', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', 1, 2, 2, 4, NULL, NULL, 0, 0, 'class:banners-tracks', 0, '', 34, 35, 0, '*', 1, NULL, NULL),
(7, 'main', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', 1, 1, 1, 8, NULL, NULL, 0, 0, 'class:address-book', 0, '', 37, 48, 0, '*', 1, NULL, NULL),
(8, 'main', 'com_contact_contacts', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact&view=contacts', 'component', 1, 7, 2, 8, NULL, NULL, 0, 0, 'class:contact', 0, '', 38, 39, 0, '*', 1, NULL, NULL),
(9, 'main', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&view=categories&extension=com_contact', 'component', 1, 7, 2, 6, NULL, NULL, 0, 0, 'class:contact-cat', 0, '', 40, 41, 0, '*', 1, NULL, NULL),
(13, 'main', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 1, 1, 17, NULL, NULL, 0, 0, 'class:rss', 0, '', 49, 54, 0, '*', 1, NULL, NULL),
(14, 'main', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds&view=newsfeeds', 'component', 1, 13, 2, 17, NULL, NULL, 0, 0, 'class:newsfeeds', 0, '', 50, 51, 0, '*', 1, NULL, NULL),
(15, 'main', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&view=categories&extension=com_newsfeeds', 'component', 1, 13, 2, 6, NULL, NULL, 0, 0, 'class:newsfeeds-cat', 0, '', 52, 53, 0, '*', 1, NULL, NULL),
(18, 'main', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', 1, 1, 1, 27, NULL, NULL, 0, 0, 'class:search-plus', 0, '', 55, 66, 0, '*', 1, NULL, NULL),
(20, 'main', 'com_tags', 'Tags', '', 'Tags', 'index.php?option=com_tags&view=tags', 'component', 1, 1, 1, 29, NULL, NULL, 0, 1, 'class:tags', 0, '', 67, 68, 0, '', 1, NULL, NULL),
(22, 'main', 'com_associations', 'Multilingual Associations', '', 'Multilingual Associations', 'index.php?option=com_associations&view=associations', 'component', 1, 1, 1, 34, NULL, NULL, 0, 0, 'class:language', 0, '', 69, 70, 0, '*', 1, NULL, NULL),
(101, 'mainmenu', 'Home', 'home', '', 'home', 'index.php?option=com_sppagebuilder&view=page&id=1', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 71, 72, 1, '*', 0, NULL, NULL),
(103, 'constructionmenu', 'Projects', 'projects-construction', '', 'projects-construction', 'index.php?option=com_content&view=category&layout=ut_construction:projects&id=9', 'component', 1, 1, 1, 22, NULL, NULL, 0, 1, ' ', 30, '{\"layout_type\":\"blog\",\"category_layout\":\"_:projects\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"9\",\"num_columns\":\"3\",\"num_columns_md\":\"2\",\"num_columns_sm\":\"1\",\"num_links\":\"0\",\"show_filters\":\"1\",\"projects_layout\":\"construction\",\"article_layout\":\"ut_construction:project-construction\",\"intro_hidden\":\"0\",\"intro_truncate\":\"1\",\"intro_limit\":\"70\",\"multi_column_order\":\"1\",\"show_subcategory_content\":\"-1\",\"orderby_pri\":\"none\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"1\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 73, 74, 0, '*', 0, NULL, NULL),
(104, 'interiormenu', 'Projects', 'projects-interior', '', 'projects-interior', 'index.php?option=com_content&view=category&layout=ut_construction:projects&id=11', 'component', 1, 1, 1, 22, NULL, NULL, 0, 1, ' ', 27, '{\"layout_type\":\"blog\",\"category_layout\":\"_:projects\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"9\",\"num_columns\":\"3\",\"num_columns_md\":\"2\",\"num_columns_sm\":\"1\",\"num_links\":\"0\",\"show_filters\":\"1\",\"projects_layout\":\"interior\",\"article_layout\":\"ut_construction:project-interior\",\"intro_hidden\":\"0\",\"intro_truncate\":\"1\",\"intro_limit\":\"70\",\"multi_column_order\":\"1\",\"show_subcategory_content\":\"-1\",\"orderby_pri\":\"none\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"1\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 75, 76, 0, '*', 0, NULL, NULL),
(105, 'miningmenu', 'Projects', 'projects-mining', '', 'projects-mining', 'index.php?option=com_content&view=category&layout=ut_construction:projects&id=10', 'component', 1, 1, 1, 22, NULL, NULL, 0, 1, ' ', 29, '{\"layout_type\":\"blog\",\"category_layout\":\"_:projects\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"9\",\"num_columns\":\"3\",\"num_columns_md\":\"2\",\"num_columns_sm\":\"1\",\"num_links\":\"0\",\"show_filters\":\"1\",\"projects_layout\":\"mining\",\"article_layout\":\"ut_construction:project-mining\",\"intro_hidden\":\"0\",\"intro_truncate\":\"1\",\"intro_limit\":\"70\",\"multi_column_order\":\"1\",\"show_subcategory_content\":\"-1\",\"orderby_pri\":\"none\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"1\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/mining\\/page-title.jpg\"}', 77, 78, 0, '*', 0, NULL, NULL),
(106, 'architectmenu', 'Projects', 'projects-architect', '', 'projects-architect', 'index.php?option=com_content&view=category&layout=ut_construction:projects&id=12', 'component', 1, 1, 1, 22, NULL, NULL, 0, 1, ' ', 28, '{\"layout_type\":\"blog\",\"category_layout\":\"_:projects\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"9\",\"num_columns\":\"3\",\"num_columns_md\":\"2\",\"num_columns_sm\":\"1\",\"num_links\":\"0\",\"show_filters\":\"1\",\"projects_layout\":\"architect\",\"article_layout\":\"ut_construction:project-architect\",\"intro_hidden\":\"0\",\"intro_truncate\":\"1\",\"intro_limit\":\"70\",\"multi_column_order\":\"1\",\"show_subcategory_content\":\"-1\",\"orderby_pri\":\"none\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"1\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 13, 14, 0, '*', 0, NULL, NULL),
(107, 'miningmenu', 'Blog', 'blog-mining', '', 'blog-mining', 'index.php?option=com_content&view=category&layout=ut_construction:ublog&id=32', 'component', 1, 1, 1, 22, NULL, NULL, 0, 1, ' ', 29, '{\"layout_type\":\"blog\",\"category_layout\":\"_:ublog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"6\",\"num_columns\":\"3\",\"num_links\":\"0\",\"ublog_layout\":\"default\",\"intro_truncate\":\"1\",\"intro_limit\":\"180\",\"multi_column_order\":\"1\",\"show_subcategory_content\":\"-1\",\"orderby_pri\":\"none\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"\",\"article_layout\":\"ut_construction:ublog\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"1\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/mining\\/page-title.jpg\"}', 79, 80, 0, '*', 0, NULL, NULL),
(108, 'architectmenu', 'Blog', 'blog-architect', '', 'blog-architect', 'index.php?option=com_content&view=category&layout=ut_construction:ublog&id=34', 'component', 1, 1, 1, 22, NULL, NULL, 0, 1, ' ', 28, '{\"layout_type\":\"blog\",\"category_layout\":\"_:ublog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"6\",\"num_columns\":\"2\",\"num_links\":\"0\",\"ublog_layout\":\"masonry\",\"intro_truncate\":\"1\",\"intro_limit\":\"150\",\"multi_column_order\":\"1\",\"show_subcategory_content\":\"-1\",\"orderby_pri\":\"none\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"\",\"article_layout\":\"ut_construction:ublog\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"1\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 15, 16, 0, '*', 0, NULL, NULL),
(109, 'constructionmenu', 'Blog', 'blog-construction', '', 'blog-construction', 'index.php?option=com_content&view=category&layout=ut_construction:ublog&id=31', 'component', 1, 1, 1, 22, NULL, NULL, 0, 1, ' ', 30, '{\"layout_type\":\"blog\",\"category_layout\":\"_:ublog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"6\",\"num_columns\":\"2\",\"num_links\":\"0\",\"ublog_layout\":\"default\",\"intro_truncate\":\"1\",\"intro_limit\":\"180\",\"multi_column_order\":\"1\",\"show_subcategory_content\":\"-1\",\"orderby_pri\":\"none\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"\",\"article_layout\":\"ut_construction:ublog\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"1\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 81, 82, 0, '*', 0, NULL, NULL),
(110, 'interiormenu', 'Blog', 'blog-interior', '', 'blog-interior', 'index.php?option=com_content&view=category&layout=ut_construction:ublog&id=33', 'component', 1, 1, 1, 22, NULL, NULL, 0, 1, ' ', 27, '{\"layout_type\":\"blog\",\"category_layout\":\"_:ublog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"6\",\"num_columns\":\"2\",\"num_links\":\"0\",\"ublog_layout\":\"default\",\"intro_truncate\":\"1\",\"intro_limit\":\"240\",\"multi_column_order\":\"1\",\"show_subcategory_content\":\"-1\",\"orderby_pri\":\"none\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"\",\"article_layout\":\"ut_construction:ublog\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"1\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 83, 84, 0, '*', 0, NULL, NULL),
(111, 'constructionmenu', 'Home', 'home-construction', '', 'home-construction', 'index.php?option=com_sppagebuilder&view=page&id=2', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, ' ', 32, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 17, 18, 0, '*', 0, NULL, NULL),
(112, 'joomlamenu', 'Search', 'search', '', 'search', 'index.php?option=com_search&view=search&searchword=Lorem', 'component', 1, 1, 1, 19, NULL, NULL, 0, 1, ' ', 0, '{\"search_phrases\":\"\",\"search_areas\":\"\",\"show_date\":\"\",\"searchphrase\":\"0\",\"ordering\":\"newest\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 85, 86, 0, '*', 0, NULL, NULL),
(113, 'joomlamenu', 'Smart Search', 'smart-search', '', 'smart-search', 'index.php?option=com_finder&view=search&q=Lorem', 'component', 1, 1, 1, 27, NULL, NULL, 0, 1, ' ', 0, '{\"show_date_filters\":\"\",\"show_advanced\":\"\",\"expand_advanced\":\"\",\"show_description\":\"\",\"description_length\":\"\",\"show_url\":\"\",\"show_pagination_limit\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"allow_empty_query\":\"\",\"show_suggested_query\":\"\",\"show_explained_query\":\"\",\"sort_order\":\"\",\"sort_direction\":\"\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 87, 88, 0, '*', 0, NULL, NULL),
(114, 'joomlamenu', 'Tags', 'tags', '', 'tags', 'index.php?option=com_tags&view=tags', 'component', 1, 1, 1, 29, NULL, NULL, 0, 1, ' ', 0, '{\"tag_columns\":4,\"all_tags_description\":\"\",\"all_tags_show_description_image\":\"\",\"all_tags_description_image\":\"\",\"all_tags_orderby\":\"\",\"all_tags_orderby_direction\":\"DESC\",\"all_tags_show_tag_image\":\"\",\"all_tags_show_tag_description\":\"\",\"all_tags_tag_maximum_characters\":\"\",\"all_tags_show_tag_hits\":\"\",\"maximum\":200,\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 89, 90, 0, '*', 0, NULL, NULL),
(115, 'joomlamenu', 'Tagged Items', 'tagged-items', '', 'tagged-items', 'index.php?option=com_tags&view=tag&id[0]=10', 'component', 1, 1, 1, 29, NULL, NULL, 0, 1, ' ', 0, '{\"show_tag_title\":\"\",\"tag_list_show_tag_image\":\"\",\"tag_list_show_tag_description\":\"\",\"tag_list_image\":\"\",\"tag_list_description\":\"\",\"tag_list_orderby\":\"\",\"tag_list_orderby_direction\":\"\",\"tag_list_show_item_image\":\"1\",\"tag_list_show_item_description\":\"1\",\"tag_list_item_maximum_characters\":180,\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"return_any_or_all\":\"\",\"include_children\":\"\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 91, 92, 0, '*', 0, NULL, NULL),
(116, 'joomlamenu', 'Joomla Contact', 'joomla-contact', '', 'joomla-contact', 'index.php?option=com_contact&view=contact&id=1', 'component', 1, 1, 1, 8, NULL, NULL, 0, 1, ' ', 0, '{\"presentation_style\":\"\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"\",\"show_tags\":\"\",\"show_info\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"add_mailto_link\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_misc\":\"\",\"show_articles\":\"\",\"articles_display_num\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 93, 94, 0, '*', 0, NULL, NULL),
(117, 'joomlamenu', 'User Profile', 'user-profile', '', 'user-profile', 'index.php?option=com_users&view=profile', 'component', 1, 1, 1, 25, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 95, 96, 0, '*', 0, NULL, NULL),
(118, 'joomlamenu', 'Login', 'login', '', 'login', 'index.php?option=com_users&view=login', 'component', 1, 1, 1, 25, NULL, NULL, 0, 1, ' ', 0, '{\"loginredirectchoice\":\"1\",\"login_redirect_url\":\"\",\"login_redirect_menuitem\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"logoutredirectchoice\":\"1\",\"logout_redirect_url\":\"\",\"logout_redirect_menuitem\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 97, 98, 0, '*', 0, NULL, NULL),
(119, 'joomlamenu', 'Register', 'register', '', 'register', 'index.php?option=com_users&view=registration', 'component', 1, 1, 1, 25, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 99, 100, 0, '*', 0, NULL, NULL),
(120, 'joomlamenu', 'Privacy Request', 'privacy-request', '', 'privacy-request', 'index.php?option=com_privacy&view=request', 'component', 1, 1, 1, 35, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 101, 102, 0, '*', 0, NULL, NULL),
(121, 'joomlamenu', 'Privacy Confirm', 'privacy-confirm', '', 'privacy-confirm', 'index.php?option=com_privacy&view=confirm', 'component', 1, 1, 1, 35, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 103, 104, 0, '*', 0, NULL, NULL),
(122, 'joomlamenu', 'Privacy Extend', 'privacy-extend', '', 'privacy-extend', 'index.php?option=com_privacy&view=remind', 'component', 1, 1, 1, 35, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 105, 106, 0, '*', 0, NULL, NULL),
(123, 'joomlamenu', 'Privacy', 'privacy', '', 'privacy', 'index.php?option=com_content&view=article&id=72', 'component', 1, 1, 1, 22, NULL, NULL, 0, 1, ' ', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 107, 108, 0, '*', 0, NULL, NULL),
(124, 'joomlamenu', 'Terms', 'terms', '', 'terms', 'index.php?option=com_content&view=article&id=73', 'component', 1, 1, 1, 22, NULL, NULL, 0, 1, ' ', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 109, 110, 0, '*', 0, NULL, NULL),
(125, 'constructionmenu', 'About Us', 'about-us-construction', '', 'about-us-construction', 'index.php?option=com_sppagebuilder&view=page&id=3', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, ' ', 30, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 21, 22, 0, '*', 0, NULL, NULL),
(126, 'constructionmenu', 'Services', 'services-construction', '', 'services-construction', 'index.php?option=com_sppagebuilder&view=page&id=4', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, ' ', 30, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 23, 26, 0, '*', 0, NULL, NULL),
(127, 'constructionmenu', 'Contact Us', 'contact-us-construction', '', 'contact-us-construction', 'index.php?option=com_sppagebuilder&view=page&id=5', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, ' ', 30, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 111, 112, 0, '*', 0, NULL, NULL),
(128, 'architectmenu2', 'Home', 'home-architect', '', 'home-architect', 'index.php?option=com_sppagebuilder&view=page&id=6', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, ' ', 33, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 113, 114, 0, '*', 0, NULL, NULL),
(129, 'architectmenu2', 'About Us', 'about-us-architect', '', 'about-us-architect', 'index.php?option=com_sppagebuilder&view=page&id=7', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, ' ', 28, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 115, 116, 0, '*', 0, NULL, NULL),
(130, 'architectmenu2', 'Services', 'services-architect', '', 'services-architect', 'index.php?option=com_sppagebuilder&view=page&id=8', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, ' ', 28, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 117, 120, 0, '*', 0, NULL, NULL);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`, `publish_up`, `publish_down`) VALUES
(131, 'architectmenu', 'Contact Us', 'contact-us-architect', '', 'contact-us-architect', 'index.php?option=com_sppagebuilder&view=page&id=9', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, ' ', 28, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 19, 20, 0, '*', 0, NULL, NULL),
(132, 'miningmenu', 'Home', 'home-mining', '', 'home-mining', 'index.php?option=com_sppagebuilder&view=page&id=10', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, ' ', 31, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 7, 8, 0, '*', 0, NULL, NULL),
(133, 'miningmenu', 'Company', 'company-mining', '', 'company-mining', 'index.php?option=com_sppagebuilder&view=page&id=11', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, ' ', 29, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/mining\\/page-title.jpg\"}', 9, 10, 0, '*', 0, NULL, NULL),
(134, 'miningmenu', 'Services', 'services-mining', '', 'services-mining', 'index.php?option=com_sppagebuilder&view=page&id=12', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, ' ', 29, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/mining\\/page-title.jpg\"}', 11, 12, 0, '*', 0, NULL, NULL),
(135, 'miningmenu', 'Contact Us', 'contact-us-mining', '', 'contact-us-mining', 'index.php?option=com_sppagebuilder&view=page&id=13', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, ' ', 29, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/mining\\/page-title.jpg\"}', 121, 122, 0, '*', 0, NULL, NULL),
(136, 'interiormenu', 'Home', 'home-interior', '', 'home-interior', 'index.php?option=com_sppagebuilder&view=page&id=14', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, ' ', 34, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 1, 2, 0, '*', 0, NULL, NULL),
(137, 'interiormenu', 'About Us', 'about-us-interior', '', 'about-us-interior', 'index.php?option=com_sppagebuilder&view=page&id=15', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, ' ', 27, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 3, 4, 0, '*', 0, NULL, NULL),
(138, 'interiormenu', 'Services', 'services-interior', '', 'services-interior', 'index.php?option=com_sppagebuilder&view=page&id=16', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, ' ', 27, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 5, 6, 0, '*', 0, NULL, NULL),
(139, 'interiormenu', 'Contact Us', 'contact-us-interior', '', 'contact-us-interior', 'index.php?option=com_sppagebuilder&view=page&id=17', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, ' ', 27, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 123, 124, 0, '*', 0, NULL, NULL),
(141, 'constructionmenu', 'Services Single', 'services-single', '', 'services-construction/services-single', 'index.php?option=com_sppagebuilder&view=page&id=20', 'component', 1, 126, 2, 10058, NULL, NULL, 0, 1, ' ', 30, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 24, 25, 0, '*', 0, NULL, NULL),
(142, 'architectmenu2', 'Services Single', 'services-single', '', 'services-architect/services-single', 'index.php?option=com_sppagebuilder&view=page&id=21', 'component', 1, 130, 2, 10058, NULL, NULL, 0, 1, ' ', 28, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 118, 119, 0, '*', 0, NULL, NULL),
(144, 'mainmenu', 'Demos', 'demos', '', 'demos', '#', 'url', 1, 1, 1, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":true,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"hide-badge\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"New\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 125, 134, 0, '*', 0, NULL, NULL),
(145, 'mainmenu', 'Pages', 'pages', '', 'pages', '#', 'url', 1, 1, 1, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"full\\\",\\\"megamenu\\\":1,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"4\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"153\\\",\\\"items\\\":[{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":153}]},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"4\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"154\\\",\\\"items\\\":[{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":154}]},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"4\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"155\\\",\\\"items\\\":[{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":155}]}]}]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 135, 166, 0, '*', 0, NULL, NULL),
(146, 'mainmenu', 'Projects', 'projects', '', 'projects', '#', 'url', 1, 1, 1, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 167, 176, 0, '*', 0, NULL, NULL),
(147, 'mainmenu', 'Blog', 'blog', '', 'blog', '#', 'url', 1, 1, 1, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"left\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 177, 186, 0, '*', 0, NULL, NULL),
(148, 'mainmenu', 'Features', 'features', '', 'features', '#', 'url', 1, 1, 1, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"left\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 187, 214, 0, '*', 0, NULL, NULL),
(149, 'mainmenu', 'Construction Website', 'construction-website', '', 'demos/construction-website', 'index.php?Itemid=', 'alias', 1, 144, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"111\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 126, 127, 0, '*', 0, NULL, NULL),
(150, 'mainmenu', 'Architect Website', 'architect-website', '', 'demos/architect-website', 'index.php?Itemid=', 'alias', 1, 144, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"128\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 128, 129, 0, '*', 0, NULL, NULL),
(151, 'mainmenu', 'Interior Design Website', 'interior-design-website', '', 'demos/interior-design-website', 'index.php?Itemid=', 'alias', 1, 144, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"136\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 130, 131, 0, '*', 0, NULL, NULL),
(152, 'mainmenu', 'Mining Website', 'mining-website', '', 'demos/mining-website', 'index.php?Itemid=', 'alias', 1, 144, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"132\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 132, 133, 0, '*', 0, NULL, NULL),
(153, 'mainmenu', 'About Us', 'about-us', '', 'pages/about-us', '#', 'url', 1, 145, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 136, 145, 0, '*', 0, NULL, NULL),
(154, 'mainmenu', 'Services', 'services', '', 'pages/services', '#', 'url', 1, 145, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 146, 155, 0, '*', 0, NULL, NULL),
(155, 'mainmenu', 'Contact Us', 'contact-us', '', 'pages/contact-us', '#', 'url', 1, 145, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 156, 165, 0, '*', 0, NULL, NULL),
(156, 'mainmenu', 'About Us Interior', 'about-us-interior', '', 'pages/about-us/about-us-interior', 'index.php?Itemid=', 'alias', 1, 153, 3, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"137\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 137, 138, 0, '*', 0, NULL, NULL),
(157, 'mainmenu', 'About Us Mining', 'about-us-mining', '', 'pages/about-us/about-us-mining', 'index.php?Itemid=', 'alias', 1, 153, 3, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"133\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 139, 140, 0, '*', 0, NULL, NULL),
(158, 'mainmenu', 'About Us Construction', 'about-us-construction', '', 'pages/about-us/about-us-construction', 'index.php?Itemid=', 'alias', 1, 153, 3, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"125\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 141, 142, 0, '*', 0, NULL, NULL),
(159, 'mainmenu', 'About Us Architect', 'about-us-architect', '', 'pages/about-us/about-us-architect', 'index.php?Itemid=', 'alias', 1, 153, 3, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"129\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 143, 144, 0, '*', 0, NULL, NULL),
(160, 'mainmenu', 'Services Interior', 'services-interior', '', 'pages/services/services-interior', 'index.php?Itemid=', 'alias', 1, 154, 3, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"138\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 147, 148, 0, '*', 0, NULL, NULL),
(161, 'mainmenu', 'Services Mining', 'services-mining', '', 'pages/services/services-mining', 'index.php?Itemid=', 'alias', 1, 154, 3, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"134\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 149, 150, 0, '*', 0, NULL, NULL),
(162, 'mainmenu', 'Services Construction', 'services-construction', '', 'pages/services/services-construction', 'index.php?Itemid=', 'alias', 1, 154, 3, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"126\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 151, 152, 0, '*', 0, NULL, NULL),
(163, 'mainmenu', 'Services Architect', 'services-architect', '', 'pages/services/services-architect', 'index.php?Itemid=', 'alias', 1, 154, 3, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"130\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 153, 154, 0, '*', 0, NULL, NULL),
(164, 'mainmenu', 'Contact Us Interior', 'contact-us-interior', '', 'pages/contact-us/contact-us-interior', 'index.php?Itemid=', 'alias', 1, 155, 3, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"139\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 157, 158, 0, '*', 0, NULL, NULL),
(165, 'mainmenu', 'Contact Us Mining', 'contact-us-mining', '', 'pages/contact-us/contact-us-mining', 'index.php?Itemid=', 'alias', 1, 155, 3, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"135\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 159, 160, 0, '*', 0, NULL, NULL),
(166, 'mainmenu', 'Contact Us Construction', 'contact-us-construction', '', 'pages/contact-us/contact-us-construction', 'index.php?Itemid=', 'alias', 1, 155, 3, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"127\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 161, 162, 0, '*', 0, NULL, NULL),
(167, 'mainmenu', 'Contact Us Architect', 'contact-us-architect', '', 'pages/contact-us/contact-us-architect', 'index.php?Itemid=', 'alias', 1, 155, 3, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"131\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 163, 164, 0, '*', 0, NULL, NULL),
(168, 'mainmenu', 'Projects Interior Design', 'projects-interior-design', '', 'projects/projects-interior-design', 'index.php?Itemid=', 'alias', 1, 146, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"104\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 168, 169, 0, '*', 0, NULL, NULL),
(169, 'mainmenu', 'Projects Mining', 'projects-mining', '', 'projects/projects-mining', 'index.php?Itemid=', 'alias', 1, 146, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"105\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 170, 171, 0, '*', 0, NULL, NULL),
(170, 'mainmenu', 'Projects Construction', 'projects-construction', '', 'projects/projects-construction', 'index.php?Itemid=', 'alias', 1, 146, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"103\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 172, 173, 0, '*', 0, NULL, NULL),
(171, 'mainmenu', 'Projects Architect', 'projects-architect', '', 'projects/projects-architect', 'index.php?Itemid=', 'alias', 1, 146, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"106\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 174, 175, 0, '*', 0, NULL, NULL),
(172, 'mainmenu', 'Blog 2 Columns', 'blog-2-columns', '', 'blog/blog-2-columns', 'index.php?Itemid=', 'alias', 1, 147, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"110\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 178, 179, 0, '*', 0, NULL, NULL),
(173, 'mainmenu', 'Blog 3 Columns', 'blog-3-columns', '', 'blog/blog-3-columns', 'index.php?Itemid=', 'alias', 1, 147, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"107\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 180, 181, 0, '*', 0, NULL, NULL),
(174, 'mainmenu', 'Blog Masonry', 'blog-masonry', '', 'blog/blog-masonry', 'index.php?Itemid=', 'alias', 1, 147, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"108\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 182, 183, 0, '*', 0, NULL, NULL),
(175, 'mainmenu', 'Blog Sidebar', 'blog-sidebar', '', 'blog/blog-sidebar', 'index.php?Itemid=', 'alias', 1, 147, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"109\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 184, 185, 0, '*', 0, NULL, NULL),
(176, 'mainmenu', 'Joomla', 'joomla', '', 'features/joomla', '#', 'url', 1, 148, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"left\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 188, 201, 0, '*', 0, NULL, NULL),
(177, 'mainmenu', 'Search', 'search', '', 'features/joomla/search', 'index.php?Itemid=', 'alias', 1, 176, 3, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"112\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 189, 190, 0, '*', 0, NULL, NULL),
(178, 'mainmenu', 'Smart Search', 'smart-search', '', 'features/joomla/smart-search', 'index.php?Itemid=', 'alias', 1, 176, 3, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"113\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 191, 192, 0, '*', 0, NULL, NULL),
(179, 'mainmenu', 'Tags', 'tags', '', 'features/joomla/tags', 'index.php?Itemid=', 'alias', 1, 176, 3, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"114\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 193, 194, 0, '*', 0, NULL, NULL),
(180, 'mainmenu', 'Tagged Items', 'tagged-items', '', 'features/joomla/tagged-items', 'index.php?Itemid=', 'alias', 1, 176, 3, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"115\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 195, 196, 0, '*', 0, NULL, NULL),
(181, 'mainmenu', 'Joomla Contact', 'joomla-contact', '', 'features/joomla/joomla-contact', 'index.php?Itemid=', 'alias', 1, 176, 3, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"116\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 197, 198, 0, '*', 0, NULL, NULL);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`, `publish_up`, `publish_down`) VALUES
(182, 'mainmenu', 'User Login', 'user-login', '', 'features/joomla/user-login', 'index.php?Itemid=', 'alias', 1, 176, 3, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"118\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 199, 200, 0, '*', 0, NULL, NULL),
(183, 'mainmenu', 'Page Builder', 'addons', '', 'addons', 'index.php?option=com_sppagebuilder&view=page&id=30', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"full\\\",\\\"megamenu\\\":1,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"3\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"245\\\",\\\"items\\\":[{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":245}]},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"3\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"246\\\",\\\"items\\\":[{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":246}]},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"3\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"247\\\",\\\"items\\\":[{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":247}]},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"3\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"248\\\",\\\"items\\\":[{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":248}]}]}]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 215, 336, 0, '*', 0, NULL, NULL),
(184, 'mainmenu', 'Header Styles', 'header-styles', '', 'features/header-styles', 'index.php?option=com_sppagebuilder&view=page&id=28', 'component', 1, 148, 2, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 202, 203, 0, '*', 0, NULL, NULL),
(185, 'mainmenu', 'Title Styles', 'title-styles', '', 'features/title-styles', 'index.php?option=com_sppagebuilder&view=page&id=29', 'component', 1, 148, 2, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 204, 205, 0, '*', 0, NULL, NULL),
(186, 'mainmenu', 'Buttons', 'buttons', '', 'features/buttons', 'index.php?option=com_sppagebuilder&view=page&id=18', 'component', 1, 148, 2, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 206, 207, 0, '*', 0, NULL, NULL),
(187, 'mainmenu', 'Typography', 'typography', '', 'features/typography', 'index.php?option=com_sppagebuilder&view=page&id=26', 'component', 1, 148, 2, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 208, 209, 0, '*', 0, NULL, NULL),
(188, 'mainmenu', 'Animations', 'animations', '', 'features/animations', 'index.php?option=com_sppagebuilder&view=page&id=27', 'component', 1, 148, 2, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 210, 211, 0, '*', 0, NULL, NULL),
(189, 'mainmenu', 'Accordion', 'accordion', '', 'addons/addons-1/accordion', 'index.php?option=com_sppagebuilder&view=page&id=31', 'component', 1, 245, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 217, 218, 0, '*', 0, NULL, NULL),
(190, 'mainmenu', 'Alert', 'alert', '', 'addons/addons-1/alert', 'index.php?option=com_sppagebuilder&view=page&id=32', 'component', 1, 245, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 219, 220, 0, '*', 0, NULL, NULL),
(191, 'mainmenu', 'Animated Heading', 'animated-heading', '', 'addons/addons-1/animated-heading', 'index.php?option=com_sppagebuilder&view=page&id=33', 'component', 1, 245, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 221, 222, 0, '*', 0, NULL, NULL),
(192, 'mainmenu', 'Animated Number', 'animated-number', '', 'addons/addons-1/animated-number', 'index.php?option=com_sppagebuilder&view=page&id=34', 'component', 1, 245, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 223, 224, 0, '*', 0, NULL, NULL),
(193, 'mainmenu', 'Articles & Joomla Modules', 'articles-joomla-modules', '', 'addons/addons-1/articles-joomla-modules', 'index.php?option=com_sppagebuilder&view=page&id=35', 'component', 1, 245, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 225, 226, 0, '*', 0, NULL, NULL),
(194, 'mainmenu', 'Articles Scroller', 'articles-scroller', '', 'addons/addons-1/articles-scroller', 'index.php?option=com_sppagebuilder&view=page&id=36', 'component', 1, 245, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 227, 228, 0, '*', 0, NULL, NULL),
(195, 'mainmenu', 'Audio', 'audio', '', 'addons/addons-1/audio', 'index.php?option=com_sppagebuilder&view=page&id=37', 'component', 1, 245, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 229, 230, 0, '*', 0, NULL, NULL),
(196, 'mainmenu', 'Block Number', 'block-number', '', 'addons/addons-1/block-number', 'index.php?option=com_sppagebuilder&view=page&id=38', 'component', 1, 245, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 231, 232, 0, '*', 0, NULL, NULL),
(197, 'mainmenu', 'Button', 'button', '', 'addons/addons-1/button', 'index.php?option=com_sppagebuilder&view=page&id=39', 'component', 1, 245, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 233, 234, 0, '*', 0, NULL, NULL),
(198, 'mainmenu', 'Button Group', 'button-group', '', 'addons/addons-1/button-group', 'index.php?option=com_sppagebuilder&view=page&id=40', 'component', 1, 245, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 235, 236, 0, '*', 0, NULL, NULL),
(199, 'mainmenu', 'Carousel', 'carousel', '', 'addons/addons-1/carousel', 'index.php?option=com_sppagebuilder&view=page&id=41', 'component', 1, 245, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 237, 238, 0, '*', 0, NULL, NULL),
(200, 'mainmenu', 'Carousel Pro', 'carousel-pro', '', 'addons/addons-1/carousel-pro', 'index.php?option=com_sppagebuilder&view=page&id=42', 'component', 1, 245, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 239, 240, 0, '*', 0, NULL, NULL),
(201, 'mainmenu', 'Clients', 'clients', '', 'addons/addons-1/clients', 'index.php?option=com_sppagebuilder&view=page&id=43', 'component', 1, 245, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 241, 242, 0, '*', 0, NULL, NULL),
(202, 'mainmenu', 'Contact Form', 'contact-form', '', 'addons/addons-1/contact-form', 'index.php?option=com_sppagebuilder&view=page&id=44', 'component', 1, 245, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 243, 244, 0, '*', 0, NULL, NULL),
(203, 'mainmenu', 'Count Down', 'count-down', '', 'addons/addons-2/count-down', 'index.php?option=com_sppagebuilder&view=page&id=45', 'component', 1, 246, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 247, 248, 0, '*', 0, NULL, NULL),
(204, 'mainmenu', 'Feature Box', 'feature-box', '', 'addons/addons-2/feature-box', 'index.php?option=com_sppagebuilder&view=page&id=46', 'component', 1, 246, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 249, 250, 0, '*', 0, NULL, NULL),
(205, 'mainmenu', 'Flickr Gallery', 'flickr-gallery', '', 'addons/addons-2/flickr-gallery', 'index.php?option=com_sppagebuilder&view=page&id=47', 'component', 1, 246, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 251, 252, 0, '*', 0, NULL, NULL),
(206, 'mainmenu', 'Flip Box', 'flip-box', '', 'addons/addons-2/flip-box', 'index.php?option=com_sppagebuilder&view=page&id=48', 'component', 1, 246, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 253, 254, 0, '*', 0, NULL, NULL),
(207, 'mainmenu', 'Form Builder', 'form-builder', '', 'addons/addons-2/form-builder', 'index.php?option=com_sppagebuilder&view=page&id=49', 'component', 1, 246, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 255, 256, 0, '*', 0, NULL, NULL),
(208, 'mainmenu', 'Gallery', 'gallery', '', 'addons/addons-2/gallery', 'index.php?option=com_sppagebuilder&view=page&id=50', 'component', 1, 246, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 257, 258, 0, '*', 0, NULL, NULL),
(209, 'mainmenu', 'Google Map', 'google-map', '', 'addons/addons-2/google-map', 'index.php?option=com_sppagebuilder&view=page&id=51', 'component', 1, 246, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 259, 260, 0, '*', 0, NULL, NULL),
(210, 'mainmenu', 'Heading', 'heading', '', 'addons/addons-2/heading', 'index.php?option=com_sppagebuilder&view=page&id=52', 'component', 1, 246, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 261, 262, 0, '*', 0, NULL, NULL),
(211, 'mainmenu', 'Icon', 'icon', '', 'addons/addons-2/icon', 'index.php?option=com_sppagebuilder&view=page&id=53', 'component', 1, 246, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 263, 264, 0, '*', 0, NULL, NULL),
(212, 'mainmenu', 'Icon Group', 'icon-group', '', 'addons/addons-2/icon-group', 'index.php?option=com_sppagebuilder&view=page&id=54', 'component', 1, 246, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 265, 266, 0, '*', 0, NULL, NULL),
(213, 'mainmenu', 'Image', 'image', '', 'addons/addons-2/image', 'index.php?option=com_sppagebuilder&view=page&id=55', 'component', 1, 246, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 267, 268, 0, '*', 0, NULL, NULL),
(214, 'mainmenu', 'Image Carousel', 'image-carousel', '', 'addons/addons-2/image-carousel', 'index.php?option=com_sppagebuilder&view=page&id=56', 'component', 1, 246, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 269, 270, 0, '*', 0, NULL, NULL),
(215, 'mainmenu', 'Image Content', 'image-content', '', 'addons/addons-2/image-content', 'index.php?option=com_sppagebuilder&view=page&id=57', 'component', 1, 246, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 271, 272, 0, '*', 0, NULL, NULL),
(216, 'mainmenu', 'Image Layouts', 'image-layouts', '', 'addons/addons-2/image-layouts', 'index.php?option=com_sppagebuilder&view=page&id=58', 'component', 1, 246, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 273, 274, 0, '*', 0, NULL, NULL),
(217, 'mainmenu', 'Image Overlay', 'image-overlay', '', 'addons/addons-3/image-overlay', 'index.php?option=com_sppagebuilder&view=page&id=59', 'component', 1, 247, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 277, 278, 0, '*', 0, NULL, NULL),
(218, 'mainmenu', 'Instagram', 'instagram', '', 'addons/addons-3/instagram', 'index.php?option=com_sppagebuilder&view=page&id=60', 'component', 1, 247, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 279, 280, 0, '*', 0, NULL, NULL),
(219, 'mainmenu', 'Modal Popup', 'modal-popup', '', 'addons/addons-3/modal-popup', 'index.php?option=com_sppagebuilder&view=page&id=62', 'component', 1, 247, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 281, 282, 0, '*', 0, NULL, NULL),
(220, 'mainmenu', 'Navigation', 'navigation', '', 'addons/addons-3/navigation', 'index.php?option=com_sppagebuilder&view=page&id=63', 'component', 1, 247, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 283, 284, 0, '*', 0, NULL, NULL),
(221, 'mainmenu', 'OpenStreet Map', 'openstreet-map', '', 'addons/addons-3/openstreet-map', 'index.php?option=com_sppagebuilder&view=page&id=64', 'component', 1, 247, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 285, 286, 0, '*', 0, NULL, NULL),
(222, 'mainmenu', 'Optin Form', 'optin-form', '', 'addons/addons-3/optin-form', 'index.php?option=com_sppagebuilder&view=page&id=65', 'component', 1, 247, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 287, 288, 0, '*', 0, NULL, NULL),
(223, 'mainmenu', 'Person', 'person', '', 'addons/addons-3/person', 'index.php?option=com_sppagebuilder&view=page&id=66', 'component', 1, 247, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 289, 290, 0, '*', 0, NULL, NULL),
(224, 'mainmenu', 'Pie Progress', 'pie-progress', '', 'addons/addons-3/pie-progress', 'index.php?option=com_sppagebuilder&view=page&id=67', 'component', 1, 247, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 291, 292, 0, '*', 0, NULL, NULL);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`, `publish_up`, `publish_down`) VALUES
(225, 'mainmenu', 'Price List', 'price-list', '', 'addons/addons-3/price-list', 'index.php?option=com_sppagebuilder&view=page&id=68', 'component', 1, 247, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 293, 294, 0, '*', 0, NULL, NULL),
(226, 'mainmenu', 'Pricing Table', 'pricing-table', '', 'addons/addons-3/pricing-table', 'index.php?option=com_sppagebuilder&view=page&id=69', 'component', 1, 247, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 295, 296, 0, '*', 0, NULL, NULL),
(227, 'mainmenu', 'Progress Bar', 'progress-bar', '', 'addons/addons-3/progress-bar', 'index.php?option=com_sppagebuilder&view=page&id=70', 'component', 1, 247, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 297, 298, 0, '*', 0, NULL, NULL),
(228, 'mainmenu', 'Slideshow', 'slideshow', '', 'addons/addons-3/slideshow', 'index.php?option=com_sppagebuilder&view=page&id=71', 'component', 1, 247, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 299, 300, 0, '*', 0, NULL, NULL),
(229, 'mainmenu', 'Raw HTML', 'raw-html', '', 'addons/addons-3/raw-html', 'index.php?option=com_sppagebuilder&view=page&id=72', 'component', 1, 247, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 301, 302, 0, '*', 0, NULL, NULL),
(230, 'mainmenu', 'Social Share', 'social-share', '', 'addons/addons-3/social-share', 'index.php?option=com_sppagebuilder&view=page&id=73', 'component', 1, 247, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 303, 304, 0, '*', 0, NULL, NULL),
(231, 'mainmenu', 'SoundCloud', 'soundcloud', '', 'addons/addons-4/soundcloud', 'index.php?option=com_sppagebuilder&view=page&id=74', 'component', 1, 248, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 307, 308, 0, '*', 0, NULL, NULL),
(232, 'mainmenu', 'Tabs', 'tabs', '', 'addons/addons-4/tabs', 'index.php?option=com_sppagebuilder&view=page&id=75', 'component', 1, 248, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 309, 310, 0, '*', 0, NULL, NULL),
(233, 'mainmenu', 'Table', 'table', '', 'addons/addons-4/table', 'index.php?option=com_sppagebuilder&view=page&id=76', 'component', 1, 248, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 311, 312, 0, '*', 0, NULL, NULL),
(234, 'mainmenu', 'Team Carousel', 'team-carousel', '', 'addons/addons-4/team-carousel', 'index.php?option=com_sppagebuilder&view=page&id=77', 'component', 1, 248, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 313, 314, 0, '*', 0, NULL, NULL),
(235, 'mainmenu', 'Testimonials', 'testimonials', '', 'addons/addons-4/testimonials', 'index.php?option=com_sppagebuilder&view=page&id=78', 'component', 1, 248, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 315, 316, 0, '*', 0, NULL, NULL),
(236, 'mainmenu', 'Testimonial Carousel', 'testimonial-carousel', '', 'addons/addons-4/testimonial-carousel', 'index.php?option=com_sppagebuilder&view=page&id=79', 'component', 1, 248, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 317, 318, 0, '*', 0, NULL, NULL),
(237, 'mainmenu', 'Testimonial Pro', 'testimonial-pro', '', 'addons/addons-4/testimonial-pro', 'index.php?option=com_sppagebuilder&view=page&id=80', 'component', 1, 248, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 319, 320, 0, '*', 0, NULL, NULL),
(238, 'mainmenu', 'Text Block', 'text-block', '', 'addons/addons-4/text-block', 'index.php?option=com_sppagebuilder&view=page&id=81', 'component', 1, 248, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 321, 322, 0, '*', 0, NULL, NULL),
(239, 'mainmenu', 'Timeline', 'timeline', '', 'addons/addons-4/timeline', 'index.php?option=com_sppagebuilder&view=page&id=82', 'component', 1, 248, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 323, 324, 0, '*', 0, NULL, NULL),
(240, 'mainmenu', 'Twitter Feed', 'twitter-feed', '', 'addons/addons-4/twitter-feed', 'index.php?option=com_sppagebuilder&view=page&id=83', 'component', 1, 248, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 325, 326, 0, '*', 0, NULL, NULL),
(241, 'mainmenu', 'Video', 'video', '', 'addons/addons-4/video', 'index.php?option=com_sppagebuilder&view=page&id=84', 'component', 1, 248, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 327, 328, 0, '*', 0, NULL, NULL),
(242, 'mainmenu', 'UT Animated Number', 'ut-animated-number', '', 'addons/addons-4/ut-animated-number', 'index.php?option=com_sppagebuilder&view=page&id=85', 'component', 1, 248, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 329, 330, 0, '*', 0, NULL, NULL),
(243, 'mainmenu', 'UT Person', 'ut-person', '', 'addons/addons-4/ut-person', 'index.php?option=com_sppagebuilder&view=page&id=86', 'component', 1, 248, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 331, 332, 0, '*', 0, NULL, NULL),
(244, 'mainmenu', 'UT Testimonial', 'ut-testimonial', '', 'addons/addons-4/ut-testimonial', 'index.php?option=com_sppagebuilder&view=page&id=87', 'component', 1, 248, 3, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 333, 334, 0, '*', 0, NULL, NULL),
(245, 'mainmenu', 'Addons 1', 'addons-1', '', 'addons/addons-1', '#', 'url', 1, 183, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 216, 245, 0, '*', 0, NULL, NULL),
(246, 'mainmenu', 'Addons 2', 'addons-2', '', 'addons/addons-2', '#', 'url', 1, 183, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 246, 275, 0, '*', 0, NULL, NULL),
(247, 'mainmenu', 'Addons 3', 'addons-3', '', 'addons/addons-3', '#', 'url', 1, 183, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 276, 305, 0, '*', 0, NULL, NULL),
(248, 'mainmenu', 'Addons 4', 'addons-4', '', 'addons/addons-4', '#', 'url', 1, 183, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 306, 335, 0, '*', 0, NULL, NULL),
(249, 'mainmenu', 'Icons', 'icons', '', 'features/icons', 'index.php?option=com_sppagebuilder&view=page&id=23', 'component', 1, 148, 2, 10058, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 212, 213, 0, '*', 0, NULL, NULL),
(252, 'main', '-', '1633395548-5321', '', 'Contacts/1633395548-5321', '#', 'separator', 1, 7, 2, 33, NULL, NULL, 0, 0, ' ', 0, '{}', 42, 43, 0, '*', 1, NULL, NULL),
(253, 'main', 'mod_menu_fields', 'contact-custom-fields', '', 'Contacts/contact-custom-fields', 'index.php?option=com_fields&context=com_contact.contact', 'component', 1, 7, 2, 33, NULL, NULL, 0, 0, ' ', 0, '{}', 44, 45, 0, '*', 1, NULL, NULL),
(254, 'main', 'mod_menu_fields_group', 'contact-custom-fields-group', '', 'Contacts/contact-custom-fields-group', 'index.php?option=com_fields&view=groups&context=com_contact.contact', 'component', 1, 7, 2, 33, NULL, NULL, 0, 0, ' ', 0, '{}', 46, 47, 0, '*', 1, NULL, NULL),
(255, 'main', '-', '1633395548-5335', '', 'Smart Search/1633395548-5335', '#', 'separator', 1, 18, 2, 27, NULL, NULL, 0, 0, ' ', 0, '{}', 56, 57, 0, '*', 1, NULL, NULL),
(256, 'main', 'com_finder_index', 'smart-search-index', '', 'Smart Search/smart-search-index', 'index.php?option=com_finder&view=index', 'component', 1, 18, 2, 27, NULL, NULL, 0, 0, ' ', 0, '{}', 58, 59, 0, '*', 1, NULL, NULL),
(257, 'main', 'com_finder_maps', 'smart-search-maps', '', 'Smart Search/smart-search-maps', 'index.php?option=com_finder&view=maps', 'component', 1, 18, 2, 27, NULL, NULL, 0, 0, ' ', 0, '{}', 60, 61, 0, '*', 1, NULL, NULL),
(258, 'main', 'com_finder_filters', 'smart-search-filters', '', 'Smart Search/smart-search-filters', 'index.php?option=com_finder&view=filters', 'component', 1, 18, 2, 27, NULL, NULL, 0, 0, ' ', 0, '{}', 62, 63, 0, '*', 1, NULL, NULL),
(259, 'main', 'com_finder_searches', 'smart-search-searches', '', 'Smart Search/smart-search-searches', 'index.php?option=com_finder&view=searches', 'component', 1, 18, 2, 27, NULL, NULL, 0, 0, ' ', 0, '{}', 64, 65, 0, '*', 1, NULL, NULL),
(283, 'main', 'COM_SPPAGEBUILDER', 'com-sppagebuilder', '', 'com-sppagebuilder', 'index.php?option=com_sppagebuilder', 'component', 1, 1, 1, 10058, NULL, NULL, 0, 1, 'class:component', 0, '{}', 337, 350, 0, '', 1, NULL, NULL),
(284, 'main', 'COM_SPPAGEBUILDER_PAGES', 'com-sppagebuilder-pages', '', 'com-sppagebuilder/com-sppagebuilder-pages', 'index.php?option=com_sppagebuilder&view=pages', 'component', 1, 283, 2, 10058, NULL, NULL, 0, 1, 'class:component', 0, '{}', 338, 339, 0, '', 1, NULL, NULL),
(285, 'main', 'COM_SPPAGEBUILDER_MEDIA', 'com-sppagebuilder-media', '', 'com-sppagebuilder/com-sppagebuilder-media', 'index.php?option=com_sppagebuilder&view=media', 'component', 1, 283, 2, 10058, NULL, NULL, 0, 1, 'class:component', 0, '{}', 340, 341, 0, '', 1, NULL, NULL),
(286, 'main', 'COM_SPPAGEBUILDER_CATEGORIES', 'com-sppagebuilder-categories', '', 'com-sppagebuilder/com-sppagebuilder-categories', 'index.php?option=com_categories&extension=com_sppagebuilder', 'component', 1, 283, 2, 10058, NULL, NULL, 0, 1, 'class:component', 0, '{}', 342, 343, 0, '', 1, NULL, NULL),
(287, 'main', 'COM_SPPAGEBUILDER_INTEGRATIONS', 'com-sppagebuilder-integrations', '', 'com-sppagebuilder/com-sppagebuilder-integrations', 'index.php?option=com_sppagebuilder&view=integrations', 'component', 1, 283, 2, 10058, NULL, NULL, 0, 1, 'class:component', 0, '{}', 344, 345, 0, '', 1, NULL, NULL),
(288, 'main', 'COM_SPPAGEBUILDER_LANGUAGES', 'com-sppagebuilder-languages', '', 'com-sppagebuilder/com-sppagebuilder-languages', 'index.php?option=com_sppagebuilder&view=languages', 'component', 1, 283, 2, 10058, NULL, NULL, 0, 1, 'class:component', 0, '{}', 346, 347, 0, '', 1, NULL, NULL),
(289, 'main', 'COM_SPPAGEBUILDER_ABOUT', 'com-sppagebuilder-about', '', 'com-sppagebuilder/com-sppagebuilder-about', 'index.php?option=com_sppagebuilder&view=about', 'component', 1, 283, 2, 10058, NULL, NULL, 0, 1, 'class:component', 0, '{}', 348, 349, 0, '', 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__menu_types`
--

DROP TABLE IF EXISTS `#__menu_types`;
CREATE TABLE IF NOT EXISTS `#__menu_types` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `#__menu_types`
--

INSERT INTO `#__menu_types` (`id`, `asset_id`, `menutype`, `title`, `description`, `client_id`) VALUES
(1, 0, 'mainmenu', 'Main Menu', 'The main menu for the site', 0),
(2, 101, 'constructionmenu', 'Construction Menu', '', 0),
(3, 102, 'miningmenu', 'Mining Menu', '', 0),
(4, 103, 'interiormenu', 'Interior Menu', '', 0),
(5, 104, 'architectmenu', 'Architect Menu', '', 0),
(6, 230, 'joomlamenu', 'Joomla Menu', '', 0),
(7, 240, 'architectmenu2', 'Architect Menu 2', '', 0);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__messages`
--

DROP TABLE IF EXISTS `#__messages`;
CREATE TABLE IF NOT EXISTS `#__messages` (
  `message_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id_from` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_id_to` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `folder_id` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `useridto_state` (`user_id_to`,`state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__messages_cfg`
--

DROP TABLE IF EXISTS `#__messages_cfg`;
CREATE TABLE IF NOT EXISTS `#__messages_cfg` (
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfg_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__modules`
--

DROP TABLE IF EXISTS `#__modules`;
CREATE TABLE IF NOT EXISTS `#__modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` text COLLATE utf8mb4_unicode_ci,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `showtitle` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=144 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `#__modules`
--

INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(1, 39, 'Main Menu', '', '', 1, 'offcanvas', NULL, NULL, NULL, NULL, 1, 'mod_menu', 1, 1, '{\"menutype\":\"mainmenu\",\"base\":\"\",\"startLevel\":1,\"endLevel\":0,\"showAllChildren\":1,\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"_menu\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(2, 40, 'Login', '', '', 1, 'login', NULL, NULL, NULL, NULL, 1, 'mod_login', 1, 1, '', 1, '*'),
(3, 41, 'Popular Articles', '', '', 3, 'cpanel', NULL, NULL, NULL, NULL, 1, 'mod_popular', 3, 1, '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(4, 42, 'Recently Added Articles', '', '', 4, 'cpanel', NULL, NULL, NULL, NULL, 1, 'mod_latest', 3, 1, '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(8, 43, 'Toolbar', '', '', 1, 'toolbar', NULL, NULL, NULL, NULL, 1, 'mod_toolbar', 3, 1, '', 1, '*'),
(9, 44, 'Notifications', '', '', 3, 'icon', NULL, NULL, NULL, NULL, 1, 'mod_quickicon', 3, 1, '{\"context\":\"update_quickicon\",\"header_icon\":\"fas fa-sync\",\"show_global\":\"0\",\"show_checkin\":\"0\",\"show_cache\":\"0\",\"show_users\":\"0\",\"show_articles\":\"0\",\"show_categories\":\"0\",\"show_media\":\"0\",\"show_menuItems\":\"0\",\"show_modules\":\"0\",\"show_plugins\":\"0\",\"show_templates\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(10, 45, 'Logged-in Users', '', '', 2, 'cpanel', NULL, NULL, NULL, NULL, 1, 'mod_logged', 3, 1, '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(12, 46, 'Admin Menu', '', '', 1, 'menu', NULL, NULL, NULL, NULL, 1, 'mod_menu', 3, 1, '{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}', 1, '*'),
(13, 47, 'Admin Submenu', '', '', 1, 'submenu', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 3, 1, '', 1, '*'),
(14, 48, 'User Status', '', '', 2, 'status', NULL, NULL, NULL, NULL, 1, 'mod_status', 3, 1, '', 1, '*'),
(15, 49, 'Title', '', '', 1, 'title', NULL, NULL, NULL, NULL, 1, 'mod_title', 3, 1, '', 1, '*'),
(16, 50, 'Login Form', '', '', 7, 'position-7', NULL, NULL, NULL, NULL, 1, 'mod_login', 1, 1, '{\"greeting\":\"1\",\"name\":\"0\"}', 0, '*'),
(17, 51, 'Breadcrumbs', '', '', 1, 'breadcrumb', NULL, NULL, NULL, NULL, 1, 'mod_breadcrumbs', 1, 1, '{\"showHere\":0,\"showHome\":1,\"homeText\":\"\",\"showLast\":1,\"separator\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":0,\"cache_time\":0,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(79, 52, 'Multilanguage status', '', '', 2, 'status', NULL, NULL, NULL, NULL, 0, 'mod_multilangstatus', 3, 1, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(86, 53, 'Joomla Version', '', '', 1, 'status', NULL, NULL, NULL, NULL, 1, 'mod_version', 3, 1, '{\"format\":\"short\",\"product\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(87, 55, 'Sample Data', '', '', 0, 'cpanel', NULL, NULL, NULL, NULL, 1, 'mod_sampledata', 6, 1, '{}', 1, '*'),
(88, 58, 'Latest Actions', '', '', 0, 'cpanel', NULL, NULL, NULL, NULL, 1, 'mod_latestactions', 6, 1, '{}', 1, '*'),
(89, 59, 'Privacy Dashboard', '', '', 0, 'cpanel', NULL, NULL, NULL, NULL, 1, 'mod_privacy_dashboard', 6, 1, '{}', 1, '*'),
(90, 63, 'Footer 1 (Construction)', '', '', 1, 'bottom1', NULL, NULL, NULL, NULL, 1, 'mod_sppagebuilder', 1, 0, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"footer-1 mb-0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(93, 82, 'Popular Tags', '', NULL, 3, 'right', NULL, NULL, NULL, NULL, 1, 'mod_tags_popular', 1, 1, '{\"maximum\":6,\"timeframe\":\"alltime\",\"order_value\":\"count\",\"order_direction\":1,\"display_count\":0,\"no_results_text\":0,\"minsize\":1,\"maxsize\":2,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(94, 83, 'Related Projects', 'For Construction', NULL, 1, 'related', NULL, NULL, NULL, NULL, 1, 'mod_articles_category', 1, 1, '{\"mode\":\"dynamic\",\"show_on_article_page\":1,\"count\":3,\"show_front\":\"show\",\"category_filtering_type\":1,\"catid\":[9],\"show_child_category_articles\":1,\"levels\":4,\"author_filtering_type\":1,\"author_alias_filtering_type\":1,\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":30,\"article_ordering\":\"a.title\",\"article_ordering_direction\":\"ASC\",\"article_grouping\":\"none\",\"date_grouping_field\":\"created\",\"month_year_format\":\"F Y\",\"article_grouping_direction\":\"ksort\",\"link_titles\":1,\"show_date\":1,\"show_date_field\":\"created\",\"show_date_format\":\"Y-m-d H:i:s\",\"show_category\":1,\"show_hits\":1,\"show_author\":0,\"show_tags\":1,\"show_introtext\":0,\"introtext_limit\":100,\"show_readmore\":1,\"show_readmore_title\":1,\"readmore_limit\":15,\"layout\":\"ut_construction:projects-construction\",\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(95, 110, 'Related Projects', 'For Interior', NULL, 1, 'related', NULL, NULL, NULL, NULL, 1, 'mod_articles_category', 1, 1, '{\"mode\":\"dynamic\",\"show_on_article_page\":1,\"count\":3,\"show_front\":\"show\",\"category_filtering_type\":1,\"catid\":[11],\"show_child_category_articles\":1,\"levels\":4,\"author_filtering_type\":1,\"author_alias_filtering_type\":1,\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":30,\"article_ordering\":\"publish_up\",\"article_ordering_direction\":\"DESC\",\"article_grouping\":\"none\",\"date_grouping_field\":\"created\",\"month_year_format\":\"F Y\",\"article_grouping_direction\":\"ksort\",\"link_titles\":1,\"show_date\":0,\"show_date_field\":\"created\",\"show_date_format\":\"Y-m-d H:i:s\",\"show_category\":1,\"show_hits\":0,\"show_author\":0,\"show_tags\":0,\"show_introtext\":0,\"introtext_limit\":100,\"show_readmore\":0,\"show_readmore_title\":1,\"readmore_limit\":15,\"layout\":\"ut_construction:projects-interior\",\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(96, 164, 'Related Projects', 'For Interior', NULL, 1, 'related', NULL, NULL, NULL, NULL, 1, 'mod_articles_category', 1, 1, '{\"mode\":\"dynamic\",\"show_on_article_page\":1,\"count\":3,\"show_front\":\"show\",\"category_filtering_type\":1,\"catid\":[10],\"show_child_category_articles\":1,\"levels\":4,\"author_filtering_type\":1,\"author_alias_filtering_type\":1,\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":30,\"article_ordering\":\"publish_up\",\"article_ordering_direction\":\"DESC\",\"article_grouping\":\"none\",\"date_grouping_field\":\"created\",\"month_year_format\":\"F Y\",\"article_grouping_direction\":\"ksort\",\"link_titles\":1,\"show_date\":0,\"show_date_field\":\"created\",\"show_date_format\":\"Y-m-d H:i:s\",\"show_category\":1,\"show_hits\":0,\"show_author\":0,\"show_tags\":0,\"show_introtext\":0,\"introtext_limit\":100,\"show_readmore\":0,\"show_readmore_title\":1,\"readmore_limit\":15,\"layout\":\"ut_construction:projects-mining\",\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(97, 191, 'Related Projects', 'For Architect', NULL, 1, 'related', NULL, NULL, NULL, NULL, 1, 'mod_articles_category', 1, 1, '{\"mode\":\"dynamic\",\"show_on_article_page\":1,\"count\":3,\"show_front\":\"show\",\"category_filtering_type\":1,\"catid\":[12],\"show_child_category_articles\":1,\"levels\":4,\"author_filtering_type\":1,\"author_alias_filtering_type\":1,\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":30,\"article_ordering\":\"publish_up\",\"article_ordering_direction\":\"DESC\",\"article_grouping\":\"none\",\"date_grouping_field\":\"created\",\"month_year_format\":\"F Y\",\"article_grouping_direction\":\"ksort\",\"link_titles\":1,\"show_date\":0,\"show_date_field\":\"created\",\"show_date_format\":\"Y-m-d H:i:s\",\"show_category\":1,\"show_hits\":0,\"show_author\":0,\"show_tags\":0,\"show_introtext\":0,\"introtext_limit\":100,\"show_readmore\":0,\"show_readmore_title\":1,\"readmore_limit\":15,\"layout\":\"ut_construction:projects-architect\",\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(98, 222, 'Smart Search', '', NULL, 1, 'right', NULL, NULL, NULL, NULL, 1, 'mod_finder', 1, 1, '{\"searchfilter\":\"\",\"show_autosuggest\":1,\"show_advanced\":0,\"show_label\":0,\"alt_label\":\"\",\"show_button\":1,\"opensearch\":1,\"opensearch_name\":\"\",\"set_itemid\":0,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\"}', 0, '*'),
(99, 223, 'Blog Categories', '', NULL, 1, 'right', NULL, NULL, NULL, NULL, 1, 'mod_articles_categories', 1, 1, '{\"parent\":30,\"show_description\":0,\"numitems\":1,\"show_children\":0,\"count\":0,\"maxlevel\":0,\"layout\":\"_:default\",\"item_heading\":4,\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(100, 224, 'Latest Articles', '', NULL, 1, 'right', NULL, NULL, NULL, NULL, 1, 'mod_articles_category', 1, 1, '{\"mode\":\"normal\",\"show_on_article_page\":1,\"count\":3,\"show_front\":\"show\",\"category_filtering_type\":1,\"catid\":[31],\"show_child_category_articles\":1,\"levels\":3,\"author_filtering_type\":1,\"author_alias_filtering_type\":1,\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":30,\"article_ordering\":\"publish_up\",\"article_ordering_direction\":\"DESC\",\"article_grouping\":\"none\",\"date_grouping_field\":\"created\",\"month_year_format\":\"F Y\",\"article_grouping_direction\":\"ksort\",\"link_titles\":1,\"show_date\":0,\"show_date_field\":\"created\",\"show_date_format\":\"Y-m-d H:i:s\",\"show_category\":0,\"show_hits\":0,\"show_author\":0,\"show_tags\":0,\"show_introtext\":1,\"introtext_limit\":40,\"show_readmore\":0,\"show_readmore_title\":1,\"readmore_limit\":15,\"layout\":\"ut_construction:sidebar-list\",\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(101, 225, 'Latest News (construction)', '', NULL, 1, 'pagebuilder', NULL, NULL, NULL, NULL, 1, 'mod_articles_category', 1, 1, '{\"mode\":\"normal\",\"show_on_article_page\":1,\"count\":3,\"show_front\":\"show\",\"category_filtering_type\":1,\"catid\":[31],\"show_child_category_articles\":1,\"levels\":3,\"author_filtering_type\":1,\"author_alias_filtering_type\":1,\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":30,\"article_ordering\":\"publish_up\",\"article_ordering_direction\":\"DESC\",\"article_grouping\":\"none\",\"date_grouping_field\":\"created\",\"month_year_format\":\"F Y\",\"article_grouping_direction\":\"ksort\",\"link_titles\":1,\"show_date\":1,\"show_date_field\":\"created\",\"show_date_format\":\"d m, Y\",\"show_category\":1,\"show_hits\":0,\"show_author\":1,\"show_tags\":0,\"show_introtext\":1,\"introtext_limit\":150,\"show_readmore\":0,\"show_readmore_title\":0,\"readmore_limit\":15,\"layout\":\"ut_construction:ublog\",\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(102, 226, 'Smart Search', '', NULL, 1, 'left', NULL, NULL, NULL, NULL, 1, 'mod_finder', 1, 1, '{\"searchfilter\":\"\",\"show_autosuggest\":1,\"show_advanced\":0,\"show_label\":0,\"alt_label\":\"\",\"show_button\":1,\"opensearch\":1,\"opensearch_name\":\"\",\"set_itemid\":0,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\"}', 0, '*'),
(103, 227, 'Blog Categories', '', NULL, 1, 'left', NULL, NULL, NULL, NULL, 1, 'mod_articles_categories', 1, 1, '{\"parent\":30,\"show_description\":0,\"numitems\":1,\"show_children\":0,\"count\":0,\"maxlevel\":0,\"layout\":\"_:default\",\"item_heading\":4,\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(104, 228, 'Latest Articles', '', NULL, 1, 'left', NULL, NULL, NULL, NULL, 1, 'mod_articles_category', 1, 1, '{\"mode\":\"normal\",\"show_on_article_page\":1,\"count\":3,\"show_front\":\"show\",\"category_filtering_type\":1,\"catid\":[31],\"show_child_category_articles\":1,\"levels\":3,\"author_filtering_type\":1,\"author_alias_filtering_type\":1,\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":30,\"article_ordering\":\"publish_up\",\"article_ordering_direction\":\"DESC\",\"article_grouping\":\"none\",\"date_grouping_field\":\"created\",\"month_year_format\":\"F Y\",\"article_grouping_direction\":\"ksort\",\"link_titles\":1,\"show_date\":0,\"show_date_field\":\"created\",\"show_date_format\":\"Y-m-d H:i:s\",\"show_category\":0,\"show_hits\":0,\"show_author\":0,\"show_tags\":0,\"show_introtext\":1,\"introtext_limit\":40,\"show_readmore\":0,\"show_readmore_title\":1,\"readmore_limit\":15,\"layout\":\"ut_construction:sidebar-list\",\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(105, 229, 'Popular Tags', '', NULL, 3, 'left', NULL, NULL, NULL, NULL, 1, 'mod_tags_popular', 1, 1, '{\"maximum\":6,\"timeframe\":\"alltime\",\"order_value\":\"count\",\"order_direction\":1,\"display_count\":0,\"no_results_text\":0,\"minsize\":1,\"maxsize\":2,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(106, 250, 'Projects Construction', '', NULL, 1, 'pagebuilder', NULL, NULL, NULL, NULL, 1, 'mod_articles_category', 1, 1, '{\"mode\":\"normal\",\"show_on_article_page\":1,\"count\":8,\"show_front\":\"show\",\"category_filtering_type\":1,\"catid\":[9],\"show_child_category_articles\":1,\"levels\":4,\"author_filtering_type\":1,\"author_alias_filtering_type\":1,\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":30,\"article_ordering\":\"publish_up\",\"article_ordering_direction\":\"ASC\",\"article_grouping\":\"none\",\"date_grouping_field\":\"created\",\"month_year_format\":\"F Y\",\"article_grouping_direction\":\"ksort\",\"link_titles\":1,\"show_date\":0,\"show_date_field\":\"created\",\"show_date_format\":\"Y-m-d H:i:s\",\"show_category\":1,\"show_hits\":0,\"show_author\":0,\"show_tags\":0,\"show_introtext\":0,\"introtext_limit\":100,\"show_readmore\":0,\"show_readmore_title\":1,\"readmore_limit\":15,\"layout\":\"ut_construction:projects-construction-filter\",\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(109, 256, 'Projects Architect', '', NULL, 1, 'pagebuilder', NULL, NULL, NULL, NULL, 1, 'mod_articles_category', 1, 1, '{\"mode\":\"normal\",\"show_on_article_page\":1,\"count\":8,\"show_front\":\"show\",\"category_filtering_type\":1,\"catid\":[12],\"show_child_category_articles\":1,\"levels\":4,\"author_filtering_type\":1,\"author_alias_filtering_type\":1,\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":30,\"article_ordering\":\"publish_up\",\"article_ordering_direction\":\"ASC\",\"article_grouping\":\"none\",\"date_grouping_field\":\"created\",\"month_year_format\":\"F Y\",\"article_grouping_direction\":\"ksort\",\"link_titles\":1,\"show_date\":0,\"show_date_field\":\"created\",\"show_date_format\":\"Y-m-d H:i:s\",\"show_category\":1,\"show_hits\":0,\"show_author\":0,\"show_tags\":0,\"show_introtext\":0,\"introtext_limit\":100,\"show_readmore\":0,\"show_readmore_title\":1,\"readmore_limit\":15,\"layout\":\"ut_construction:projects-architect-filter\",\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(110, 257, 'Latest News (Architect)', '', NULL, 1, 'pagebuilder', NULL, NULL, NULL, NULL, 1, 'mod_articles_category', 1, 1, '{\"mode\":\"normal\",\"show_on_article_page\":1,\"count\":3,\"show_front\":\"show\",\"category_filtering_type\":1,\"catid\":[34],\"show_child_category_articles\":1,\"levels\":3,\"author_filtering_type\":1,\"author_alias_filtering_type\":1,\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":30,\"article_ordering\":\"publish_up\",\"article_ordering_direction\":\"DESC\",\"article_grouping\":\"none\",\"date_grouping_field\":\"created\",\"month_year_format\":\"F Y\",\"article_grouping_direction\":\"ksort\",\"link_titles\":1,\"show_date\":1,\"show_date_field\":\"created\",\"show_date_format\":\"d m, Y\",\"show_category\":1,\"show_hits\":0,\"show_author\":1,\"show_tags\":0,\"show_introtext\":1,\"introtext_limit\":150,\"show_readmore\":0,\"show_readmore_title\":0,\"readmore_limit\":15,\"layout\":\"ut_construction:ublog\",\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(111, 259, 'Footer 2 (Architect)', '', NULL, 1, 'bottom1', NULL, NULL, NULL, NULL, 1, 'mod_sppagebuilder', 1, 0, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"footer-2 mb-0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(112, 261, 'Projects Mining', '', NULL, 1, 'pagebuilder', NULL, NULL, NULL, NULL, 1, 'mod_articles_category', 1, 1, '{\"mode\":\"normal\",\"show_on_article_page\":1,\"count\":8,\"show_front\":\"show\",\"category_filtering_type\":1,\"catid\":[10],\"show_child_category_articles\":1,\"levels\":4,\"author_filtering_type\":1,\"author_alias_filtering_type\":1,\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":30,\"article_ordering\":\"publish_up\",\"article_ordering_direction\":\"ASC\",\"article_grouping\":\"none\",\"date_grouping_field\":\"created\",\"month_year_format\":\"F Y\",\"article_grouping_direction\":\"ksort\",\"link_titles\":1,\"show_date\":0,\"show_date_field\":\"created\",\"show_date_format\":\"Y-m-d H:i:s\",\"show_category\":1,\"show_hits\":0,\"show_author\":0,\"show_tags\":0,\"show_introtext\":0,\"introtext_limit\":100,\"show_readmore\":0,\"show_readmore_title\":1,\"readmore_limit\":15,\"layout\":\"ut_construction:projects-mining-filter\",\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(113, 262, 'Latest News (Mining)', '', NULL, 1, 'pagebuilder', NULL, NULL, NULL, NULL, 1, 'mod_articles_category', 1, 1, '{\"mode\":\"normal\",\"show_on_article_page\":1,\"count\":3,\"show_front\":\"show\",\"category_filtering_type\":1,\"catid\":[32],\"show_child_category_articles\":1,\"levels\":3,\"author_filtering_type\":1,\"author_alias_filtering_type\":1,\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":30,\"article_ordering\":\"publish_up\",\"article_ordering_direction\":\"DESC\",\"article_grouping\":\"none\",\"date_grouping_field\":\"created\",\"month_year_format\":\"F Y\",\"article_grouping_direction\":\"ksort\",\"link_titles\":1,\"show_date\":1,\"show_date_field\":\"created\",\"show_date_format\":\"d m, Y\",\"show_category\":1,\"show_hits\":0,\"show_author\":1,\"show_tags\":0,\"show_introtext\":1,\"introtext_limit\":150,\"show_readmore\":0,\"show_readmore_title\":0,\"readmore_limit\":15,\"layout\":\"ut_construction:ublog\",\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(114, 264, 'Projects Interior', '', NULL, 1, 'pagebuilder', NULL, NULL, NULL, NULL, 1, 'mod_articles_category', 1, 1, '{\"mode\":\"normal\",\"show_on_article_page\":1,\"count\":6,\"show_front\":\"show\",\"category_filtering_type\":1,\"catid\":[11],\"show_child_category_articles\":1,\"levels\":4,\"author_filtering_type\":1,\"author_alias_filtering_type\":1,\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":30,\"article_ordering\":\"publish_up\",\"article_ordering_direction\":\"ASC\",\"article_grouping\":\"none\",\"date_grouping_field\":\"created\",\"month_year_format\":\"F Y\",\"article_grouping_direction\":\"ksort\",\"link_titles\":1,\"show_date\":0,\"show_date_field\":\"created\",\"show_date_format\":\"Y-m-d H:i:s\",\"show_category\":1,\"show_hits\":0,\"show_author\":0,\"show_tags\":0,\"show_introtext\":0,\"introtext_limit\":100,\"show_readmore\":0,\"show_readmore_title\":1,\"readmore_limit\":15,\"layout\":\"ut_construction:projects-interior-filter\",\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(115, 265, 'Latest News (Interior)', '', NULL, 1, 'pagebuilder', NULL, NULL, NULL, NULL, 1, 'mod_articles_category', 1, 1, '{\"mode\":\"normal\",\"show_on_article_page\":1,\"count\":2,\"show_front\":\"show\",\"category_filtering_type\":1,\"catid\":[33],\"show_child_category_articles\":1,\"levels\":3,\"author_filtering_type\":1,\"author_alias_filtering_type\":1,\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":30,\"article_ordering\":\"publish_up\",\"article_ordering_direction\":\"DESC\",\"article_grouping\":\"none\",\"date_grouping_field\":\"created\",\"month_year_format\":\"F Y\",\"article_grouping_direction\":\"ksort\",\"link_titles\":1,\"show_date\":1,\"show_date_field\":\"created\",\"show_date_format\":\"d m, Y\",\"show_category\":1,\"show_hits\":0,\"show_author\":1,\"show_tags\":0,\"show_introtext\":1,\"introtext_limit\":150,\"show_readmore\":0,\"show_readmore_title\":0,\"readmore_limit\":15,\"layout\":\"ut_construction:ublog\",\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(116, 266, 'Footer 3 (Interior)', '', NULL, 1, 'bottom1', NULL, NULL, NULL, NULL, 1, 'mod_sppagebuilder', 1, 0, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"footer-3 mb-0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(117, 268, 'Footer 4 (Mining)', '', NULL, 1, 'bottom1', NULL, NULL, NULL, NULL, 1, 'mod_sppagebuilder', 1, 0, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"footer-4 mb-0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(118, 270, 'Mobile Menu - Interior', '', NULL, 1, 'offcanvas', NULL, NULL, NULL, NULL, 1, 'mod_menu', 1, 0, '{\"menutype\":\"interiormenu\",\"base\":\"\",\"startLevel\":1,\"endLevel\":0,\"showAllChildren\":1,\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"_menu\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(119, 271, 'Mobile Menu - Mining', '', NULL, 1, 'offcanvas', NULL, NULL, NULL, NULL, 1, 'mod_menu', 1, 0, '{\"menutype\":\"miningmenu\",\"base\":\"\",\"startLevel\":1,\"endLevel\":0,\"showAllChildren\":1,\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"_menu\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(120, 272, 'Mobile Menu - Architect 2', '', NULL, 1, 'offcanvas', NULL, NULL, NULL, NULL, 1, 'mod_menu', 1, 0, '{\"menutype\":\"architectmenu2\",\"base\":\"\",\"startLevel\":1,\"endLevel\":0,\"showAllChildren\":1,\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"_menu\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(121, 273, 'Mobile Menu - Architect', '', NULL, 1, 'offcanvas', NULL, NULL, NULL, NULL, 1, 'mod_menu', 1, 0, '{\"menutype\":\"architectmenu\",\"base\":\"\",\"startLevel\":1,\"endLevel\":0,\"showAllChildren\":1,\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"_menu mt-n20\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(122, 274, 'Mobile Menu - Construction', '', NULL, 1, 'offcanvas', NULL, NULL, NULL, NULL, 1, 'mod_menu', 1, 0, '{\"menutype\":\"constructionmenu\",\"base\":\"\",\"startLevel\":1,\"endLevel\":0,\"showAllChildren\":1,\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"_menu\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(123, 280, 'Architect contact Button', '', '<p class=\"mb-0\"><a class=\"sppb-btn sppb-btn-sm sppb-btn-white sppb-btn-outline\" href=\"#\">Contact Us</a></p>', 1, 'top3', NULL, NULL, NULL, NULL, 1, 'mod_custom', 1, 0, '{\"prepare_content\":0,\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"text-right\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(124, 309, 'UT Joomstagram', '', '', 1, 'pagebuilder', NULL, NULL, NULL, NULL, 1, 'mod_ut_joomstagram', 1, 1, '{\"jg_token\":\"IGQVJYZATRUV1BOUllqbTJ3bjZAGeE9BUWJwU2drWWRDYy1CeEF0RVZATcHdWN3RGTjc1aEtqcFJ3VTY5aHBDSlk5VWQ5Skw4LU03bXB4Q196c2thOW5uVXM2N05qVUNuZAzJRTHp3bmJn\",\"jg_username\":\"Unitemplates\",\"jg_cache_time\":262800,\"jg_intro\":\"\",\"jg_show_profile\":\"1\",\"jg_user_img\":\"images\\/ut_logo.jpg\",\"jg_name\":\"Unitemplates\",\"jg_biography\":\"Best Developer Joomla templates in the World Wide\",\"jg_image_size\":\"320\",\"jg_columns\":\"4\",\"jg_columns_md\":\"3\",\"jg_columns_sm\":\"2\",\"jg_rows\":\"2\",\"jg_padding\":\"1px\",\"layout\":\"_:default\",\"add_container\":\"0\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(125, 0, 'Login Support', '', '', 1, 'sidebar', NULL, NULL, NULL, NULL, 1, 'mod_loginsupport', 1, 1, '{\"forum_url\":\"https://forum.joomla.org/\",\"documentation_url\":\"https://docs.joomla.org/\",\"news_url\":\"https://www.joomla.org/announcements.html\",\"automatic_title\":1,\"prepare_content\":1,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 1, '*'),
(126, 0, 'System Dashboard', '', '', 1, 'cpanel-system', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 1, 0, '{\"menutype\":\"*\",\"preset\":\"system\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', 1, '*'),
(127, 0, 'Content Dashboard', '', '', 1, 'cpanel-content', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 1, 0, '{\"menutype\":\"*\",\"preset\":\"content\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"3\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', 1, '*'),
(128, 0, 'Menus Dashboard', '', '', 1, 'cpanel-menus', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 1, 0, '{\"menutype\":\"*\",\"preset\":\"menus\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', 1, '*'),
(129, 0, 'Components Dashboard', '', '', 1, 'cpanel-components', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 1, 0, '{\"menutype\":\"*\",\"preset\":\"components\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', 1, '*'),
(130, 0, 'Users Dashboard', '', '', 1, 'cpanel-users', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 1, 0, '{\"menutype\":\"*\",\"preset\":\"users\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', 1, '*'),
(131, 0, 'Popular Articles', '', '', 3, 'cpanel-content', NULL, NULL, NULL, NULL, 1, 'mod_popular', 3, 1, '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\":\"12\"}', 1, '*'),
(132, 0, 'Recently Added Articles', '', '', 4, 'cpanel-content', NULL, NULL, NULL, NULL, 1, 'mod_latest', 3, 1, '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\":\"12\"}', 1, '*'),
(133, 0, 'Logged-in Users', '', '', 2, 'cpanel-users', NULL, NULL, NULL, NULL, 1, 'mod_logged', 3, 1, '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\":\"12\"}', 1, '*'),
(134, 0, 'Frontend Link', '', '', 5, 'status', NULL, NULL, NULL, NULL, 1, 'mod_frontend', 1, 1, '', 1, '*'),
(135, 0, 'Messages', '', '', 4, 'status', NULL, NULL, NULL, NULL, 1, 'mod_messages', 3, 1, '', 1, '*'),
(136, 0, 'Post Install Messages', '', '', 3, 'status', NULL, NULL, NULL, NULL, 1, 'mod_post_installation_messages', 3, 1, '', 1, '*'),
(137, 0, 'User Status', '', '', 6, 'status', NULL, NULL, NULL, NULL, 1, 'mod_user', 3, 1, '', 1, '*'),
(138, 0, 'Site', '', '', 1, 'icon', NULL, NULL, NULL, NULL, 1, 'mod_quickicon', 1, 1, '{\"context\":\"site_quickicon\",\"header_icon\":\"fas fa-desktop\",\"show_users\":\"1\",\"show_articles\":\"1\",\"show_categories\":\"1\",\"show_media\":\"1\",\"show_menuItems\":\"1\",\"show_modules\":\"1\",\"show_plugins\":\"1\",\"show_templates\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(139, 0, 'System', '', '', 2, 'icon', NULL, NULL, NULL, NULL, 1, 'mod_quickicon', 1, 1, '{\"context\":\"system_quickicon\",\"header_icon\":\"fas fa-wrench\",\"show_global\":\"1\",\"show_checkin\":\"1\",\"show_cache\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(140, 0, '3rd Party', '', '', 4, 'icon', NULL, NULL, NULL, NULL, 1, 'mod_quickicon', 1, 1, '{\"context\":\"mod_quickicon\",\"header_icon\":\"fas fa-boxes\",\"load_plugins\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(141, 0, 'Help Dashboard', '', '', 1, 'cpanel-help', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 1, 0, '{\"menutype\":\"*\",\"preset\":\"help\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"style\":\"System-none\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(142, 0, 'Privacy Requests', '', '', 1, 'cpanel-privacy', NULL, NULL, NULL, NULL, 1, 'mod_privacy_dashboard', 1, 1, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(143, 0, 'Privacy Status', '', '', 1, 'cpanel-privacy', NULL, NULL, NULL, NULL, 1, 'mod_privacy_status', 1, 1, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__modules_menu`
--

DROP TABLE IF EXISTS `#__modules_menu`;
CREATE TABLE IF NOT EXISTS `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `#__modules_menu`
--

INSERT INTO `#__modules_menu` (`moduleid`, `menuid`) VALUES
(1, -142),
(1, -141),
(1, -139),
(1, -138),
(1, -137),
(1, -136),
(1, -135),
(1, -134),
(1, -133),
(1, -132),
(1, -131),
(1, -130),
(1, -129),
(1, -128),
(1, -127),
(1, -126),
(1, -125),
(1, -111),
(1, -110),
(1, -109),
(1, -108),
(1, -107),
(1, -106),
(1, -105),
(1, -104),
(1, -103),
(2, 0),
(3, 0),
(4, 0),
(6, 0),
(7, 0),
(8, 0),
(9, 0),
(10, 0),
(12, 0),
(13, 0),
(14, 0),
(15, 0),
(16, 0),
(17, 0),
(79, 0),
(86, 0),
(87, 0),
(88, 0),
(89, 0),
(90, -142),
(90, -139),
(90, -138),
(90, -137),
(90, -136),
(90, -135),
(90, -134),
(90, -133),
(90, -132),
(90, -131),
(90, -130),
(90, -129),
(90, -128),
(90, -110),
(90, -108),
(90, -107),
(90, -106),
(90, -105),
(90, -104),
(93, 109),
(94, 103),
(95, 104),
(96, 105),
(97, 106),
(98, 109),
(99, 109),
(100, 109),
(101, 0),
(102, 108),
(103, 108),
(104, 108),
(105, 108),
(106, 0),
(109, 0),
(110, 0),
(111, 106),
(111, 108),
(111, 128),
(111, 129),
(111, 130),
(111, 131),
(111, 142),
(112, 0),
(113, 0),
(114, 0),
(115, 0),
(116, 104),
(116, 110),
(116, 136),
(116, 137),
(116, 138),
(116, 139),
(117, 105),
(117, 107),
(117, 132),
(117, 133),
(117, 134),
(117, 135),
(118, 104),
(118, 110),
(118, 136),
(118, 137),
(118, 138),
(118, 139),
(119, 105),
(119, 107),
(119, 132),
(119, 133),
(119, 134),
(119, 135),
(120, 106),
(120, 108),
(120, 128),
(120, 129),
(120, 130),
(120, 131),
(120, 142),
(121, 106),
(121, 108),
(121, 128),
(121, 129),
(121, 130),
(121, 131),
(121, 142),
(122, 103),
(122, 109),
(122, 111),
(122, 125),
(122, 126),
(122, 127),
(122, 141),
(123, 106),
(123, 108),
(123, 128),
(123, 129),
(123, 130),
(123, 131),
(123, 142),
(124, 0),
(125, 0),
(126, 0),
(127, 0),
(128, 0),
(129, 0),
(130, 0),
(131, 0),
(132, 0),
(133, 0),
(134, 0),
(135, 0),
(136, 0),
(137, 0),
(138, 0),
(139, 0),
(140, 0),
(141, 0),
(142, 0),
(143, 0);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__newsfeeds`
--

DROP TABLE IF EXISTS `#__newsfeeds`;
CREATE TABLE IF NOT EXISTS `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `link` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `cache_time` int(10) UNSIGNED NOT NULL DEFAULT '3600',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `images` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__privacy_requests`
--

DROP TABLE IF EXISTS `#__privacy_requests`;
CREATE TABLE IF NOT EXISTS `#__privacy_requests` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `requested_at` datetime NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `request_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token_created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__redirect_links`
--

DROP TABLE IF EXISTS `#__redirect_links`;
CREATE TABLE IF NOT EXISTS `#__redirect_links` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `old_url` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `new_url` varchar(2048) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referer` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `published` tinyint(4) NOT NULL,
  `created_date` datetime NOT NULL,
  `modified_date` datetime NOT NULL,
  `header` smallint(3) NOT NULL DEFAULT '301',
  PRIMARY KEY (`id`),
  KEY `idx_old_url` (`old_url`(100)),
  KEY `idx_link_modified` (`modified_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__scheduler_tasks`
--

DROP TABLE IF EXISTS `#__scheduler_tasks`;
CREATE TABLE IF NOT EXISTS `#__scheduler_tasks` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'unique identifier for job defined by plugin',
  `execution_rules` text COLLATE utf8mb4_unicode_ci COMMENT 'Execution Rules, Unprocessed',
  `cron_rules` text COLLATE utf8mb4_unicode_ci COMMENT 'Processed execution rules, crontab-like JSON form',
  `state` tinyint(4) NOT NULL DEFAULT '0',
  `last_exit_code` int(11) NOT NULL DEFAULT '0' COMMENT 'Exit code when job was last run',
  `last_execution` datetime DEFAULT NULL COMMENT 'Timestamp of last run',
  `next_execution` datetime DEFAULT NULL COMMENT 'Timestamp of next (planned) run, referred for execution on trigger',
  `times_executed` int(11) DEFAULT '0' COMMENT 'Count of successful triggers',
  `times_failed` int(11) DEFAULT '0' COMMENT 'Count of failures',
  `locked` datetime DEFAULT NULL,
  `priority` smallint(6) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0' COMMENT 'Configurable list ordering',
  `cli_exclusive` smallint(6) NOT NULL DEFAULT '0' COMMENT 'If 1, the task is only accessible via CLI',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created` datetime NOT NULL,
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_type` (`type`),
  KEY `idx_state` (`state`),
  KEY `idx_last_exit` (`last_exit_code`),
  KEY `idx_next_exec` (`next_execution`),
  KEY `idx_locked` (`locked`),
  KEY `idx_priority` (`priority`),
  KEY `idx_cli_exclusive` (`cli_exclusive`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__schemas`
--

DROP TABLE IF EXISTS `#__schemas`;
CREATE TABLE IF NOT EXISTS `#__schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`extension_id`,`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `#__schemas`
--

INSERT INTO `#__schemas` (`extension_id`, `version_id`) VALUES
(10058, '3.8.9');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__spmedia`
--

DROP TABLE IF EXISTS `#__spmedia`;
CREATE TABLE IF NOT EXISTS `#__spmedia` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `thumb` varchar(255) NOT NULL DEFAULT '',
  `alt` varchar(255) NOT NULL DEFAULT '',
  `caption` varchar(2048) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `type` varchar(100) NOT NULL DEFAULT 'image',
  `media_attr` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '{}',
  `extension` varchar(100) NOT NULL DEFAULT '',
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `#__sppagebuilder`
--

DROP TABLE IF EXISTS `#__sppagebuilder`;
CREATE TABLE IF NOT EXISTS `#__sppagebuilder` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `text` mediumtext NOT NULL,
  `extension` varchar(255) NOT NULL DEFAULT 'com_sppagebuilder',
  `extension_view` varchar(255) NOT NULL DEFAULT 'page',
  `view_id` bigint(20) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(3) NOT NULL DEFAULT '1',
  `catid` int(10) NOT NULL DEFAULT '0',
  `access` int(10) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `checked_out` int(10) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[]',
  `og_title` varchar(255) NOT NULL DEFAULT '',
  `og_image` varchar(255) NOT NULL DEFAULT '',
  `og_description` varchar(255) NOT NULL DEFAULT '',
  `language` char(7) NOT NULL DEFAULT '',
  `hits` bigint(20) NOT NULL DEFAULT '0',
  `css` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8;

--
-- Volcado de datos para la tabla `#__sppagebuilder`
--

INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `attribs`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(1, 66, 'Home Presentation', '[{\"id\":1596391937642,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"255px 0px 470px 0px\",\"sm\":\"   \",\"xs\":\"100px 0px 200px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"images/construction/slider_01.jpg\"},\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"50% 50%\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596391937642,\"section_height_option\":\"\",\"background_color\":\"\",\"overlay\":\"rgba(33, 37, 41, 0.3)\"},\"layout\":\"12\",\"columns\":[{\"id\":1596391937641,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1596392208867,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"<span>JOOMLA TEMPLATE FOR</span> Construction, Architect, Interior Design and Mining Industry\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-center\",\"title_text_shadow\":\"\",\"class\":\"title-1 title-white\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px auto 0px auto\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":1,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596392208867,\"global_width\":{\"md\":\"60\",\"sm\":\"90\",\"xs\":\"100\"}}}]}]},{\"id\":1596391938046,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"-300px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"-100px 0px 0px 0px\"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596391938046},\"layout\":\"12\",\"columns\":[{\"id\":1596391938045,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1596395474612,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images/template-demo/device_demo.png\"},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px auto 0px auto\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596395474612,\"image_width\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_width\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"}}}]}]},{\"id\":1596391938049,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"100px 0px 100px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596391938049},\"layout\":\"6,6\",\"columns\":[{\"id\":1596391938047,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"images/template-demo/video_bg.jpg\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596391938047,\"padding\":{\"md\":\"140px 100px 130px 100px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1596948991103,\"name\":\"modal\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"modal_selector\":\"icon\",\"button_text\":\"Button Text\",\"button_type\":\"default\",\"button_letterspace\":\"0\",\"button_padding\":\"\",\"button_appearance\":\"flat\",\"button_status\":\"normal\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color_hover\":\"#fff\",\"selector_image\":{\"src\":\"\"},\"show_ripple_effect\":1,\"selector_icon_name\":\"fas fa-play-circle\",\"selector_icon_size\":{\"md\":\"60\"},\"selector_text\":\"\",\"selector_text_weight\":\"\",\"selector_text_color\":\"\",\"modal_content_type\":\"video\",\"modal_content_text\":\"Kevin chicken fatback sirloin ball tip, flank meatloaf t-bone. Meatloaf shankle swine pancetta biltong capicola ham hock meatball. Shoulder bacon andouille ground round pancetta pastrami. Sirloin beef ribs tenderloin rump corned beef filet mignon capicola kielbasa drumstick chuck turducken beef t-bone ribeye. Pork loin ground round t-bone chuck beef ribs swine pastrami cow. Venison tenderloin drumstick, filet mignon salami jowl sausage shank hamburger meatball ribeye kevin tri-tip. Swine kielbasa tenderloin fatback pork shankle andouille, flank frankfurter jerky chicken tri-tip jowl leberkas.&lt;br&gt;&lt;br&gt;Pancetta chicken pork belly beef cow kielbasa fatback sirloin biltong andouille bacon. Sirloin beef tenderloin porchetta, jerky tri-tip andouille sausage landjaeger shank bresaola short ribs tongue meatloaf fatback. Kielbasa pancetta shoulder tri-tip pastrami filet mignon ham corned beef prosciutto doner beef ribs. Doner sausage ham hock, shoulder sirloin pancetta boudin filet mignon chuck. Meatball ham hock beef, filet mignon tri-tip andouille venison ground round chuck turducken drumstick.\",\"modal_content_image\":{\"src\":\"\"},\"modal_popup_width\":\"760\",\"modal_popup_height\":\"440\",\"alignment\":\"sppb-text-center\",\"class\":\"icon-primary\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596948991103,\"selector_text_margin\":\"   \",\"selector_icon_border_radius\":{\"md\":\"100\",\"sm\":\"\",\"xs\":\"\"},\"modal_content_video_url\":\"https://www.youtube.com/watch?v=DVNOUdRRutk\"}}]},{\"id\":1596391938048,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":1,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596391938048},\"addons\":[{\"id\":1596399047903,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Build Websites For All Kinds\",\"heading_selector\":\"h2\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"This template is dedicated to create websites for construction companies and similar services. But you can build websites of any type, because more than a simple template it is a kit that includes Useful Classes (paddings, margins, borders, backgrounds, colors, ready to use), Bootstrap, Helix Ultimate and SP Page Builder PRO with 63+ addons, each addon with many styles. Best of all with Real Time editor. <strong class=\\\"text-primary\\\" style=\\\"font-size: 20px;\\\">Esy to use, Watch Video.</strong>\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"30px 0px 0px 0px\",\"xs\":\"30px 0px 0px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596399047903}}]}]},{\"id\":1596489980203,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596489980203},\"layout\":\"4,4,4\",\"columns\":[{\"id\":1596489980200,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-3\",\"xs_col\":\"col-xs-2\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596489980200},\"addons\":[]},{\"id\":1596489980201,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"col-xs-8\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596489980201,\"padding\":{\"md\":\"30px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"skew-block-x skew-light\"},\"addons\":[]},{\"id\":1596489980202,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-3\",\"xs_col\":\"col-xs-2\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596489980202},\"addons\":[]}]},{\"id\":1596343966285,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"<span>READY TO USE</span> Prebuilt Websites\",\"heading_selector\":\"h2\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"50px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596343966285,\"class\":\"bg-gray-20 title-1\",\"subtitle\":\"With 4 pre-built sites for construction, architecture, interior design and the mining industry, you can create your new or your clients\' in a few hours.\",\"title_text_color\":\"#222222\",\"color\":\"#656565\"},\"layout\":\"6,6,6,6\",\"columns\":[{\"id\":1596343966284,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596343966284},\"addons\":[{\"id\":1596578304676,\"name\":\"ut_image_lazy\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Website Construction\",\"heading_selector\":\"h3\",\"title_fontsize\":\"22\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"   \",\"title_position\":\"bottom\",\"image\":{\"src\":\"images/template-demo/construction.png\"},\"lazyload\":1,\"observer\":1,\"image_lazy\":{\"src\":\"images/template-demo/loader_540x640.svg\"},\"border_radius\":0,\"alt_text\":\"Construction template\",\"overlay_color\":\"rgba(33, 37, 41, 0.5)\",\"link\":\"index.php/home-construction\",\"description\":\"\",\"description_fontsize\":\"\",\"description_position\":\"bottom\",\"button_text\":\"See Demo\",\"button_type\":\"primary\",\"button_appearance\":\"\",\"button_icon_margin\":\"0px 0px 0px 0px\",\"button_icon_position\":\"left\",\"button_position\":\"overlay\",\"content_col_md\":\"6\",\"content_col_sm\":\"12\",\"content_col_xs\":\"12\",\"alignment\":\"sppb-text-center\",\"middle_alignment\":0,\"class\":\"bg-white\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"15\",\"blur\":\"30\",\"spread\":0,\"color\":\"rgba(73, 80, 87, 0.2)\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-title > a:not(:hover){color:#222;}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596578304676,\"target\":\"\",\"button_url\":\"index.php/home-construction\",\"button_shape\":\"square\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"button_target\":\"\"}}]},{\"id\":1596389705146,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596389705146,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1596578221216,\"name\":\"ut_image_lazy\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Website Architect\",\"heading_selector\":\"h3\",\"title_fontsize\":\"22\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"   \",\"title_position\":\"bottom\",\"image\":{\"src\":\"images/template-demo/architect.png\"},\"lazyload\":1,\"observer\":0,\"image_lazy\":{\"src\":\"images/template-demo/loader_540x640.svg\"},\"border_radius\":0,\"alt_text\":\"architect template\",\"overlay_color\":\"rgba(33, 37, 41, 0.5)\",\"link\":\"index.php/home-architect\",\"description\":\"\",\"description_fontsize\":\"\",\"description_position\":\"bottom\",\"button_text\":\"See Demo\",\"button_type\":\"primary\",\"button_appearance\":\"\",\"button_icon_margin\":\"0px 0px 0px 0px\",\"button_icon_position\":\"left\",\"button_position\":\"overlay\",\"content_col_md\":\"6\",\"content_col_sm\":\"12\",\"content_col_xs\":\"12\",\"alignment\":\"sppb-text-center\",\"middle_alignment\":0,\"class\":\"bg-white\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"15\",\"blur\":\"30\",\"spread\":0,\"color\":\"rgba(73, 80, 87, 0.2)\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-title > a:not(:hover){color:#222;}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596578221216,\"target\":\"\",\"button_url\":\"index.php/home-architect\",\"button_shape\":\"square\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"button_target\":\"\"}}]},{\"id\":1596389705147,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596389705147},\"addons\":[{\"id\":1596578221225,\"name\":\"ut_image_lazy\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Website Mining\",\"heading_selector\":\"h3\",\"title_fontsize\":\"22\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"   \",\"title_position\":\"bottom\",\"image\":{\"src\":\"images/template-demo/mining.png\"},\"lazyload\":1,\"observer\":0,\"image_lazy\":{\"src\":\"images/template-demo/loader_540x640.svg\"},\"border_radius\":0,\"alt_text\":\"Mining template\",\"overlay_color\":\"rgba(33, 37, 41, 0.5)\",\"link\":\"index.php/home-mining\",\"description\":\"\",\"description_fontsize\":\"\",\"description_position\":\"bottom\",\"button_text\":\"See Demo\",\"button_type\":\"primary\",\"button_appearance\":\"\",\"button_icon_margin\":\"0px 0px 0px 0px\",\"button_icon_position\":\"left\",\"button_position\":\"overlay\",\"content_col_md\":\"6\",\"content_col_sm\":\"12\",\"content_col_xs\":\"12\",\"alignment\":\"sppb-text-center\",\"middle_alignment\":0,\"class\":\"bg-white\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"15\",\"blur\":\"30\",\"spread\":0,\"color\":\"rgba(73, 80, 87, 0.2)\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-title > a:not(:hover){color:#222;}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596578221225,\"target\":\"\",\"button_url\":\"index.php/home-mining\",\"button_shape\":\"square\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"button_target\":\"\"}}]},{\"id\":1596389705148,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596389705148},\"addons\":[{\"id\":1596578221228,\"name\":\"ut_image_lazy\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Website Interior Design\",\"heading_selector\":\"h3\",\"title_fontsize\":\"22\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"   \",\"title_position\":\"bottom\",\"image\":{\"src\":\"images/template-demo/interior.png\"},\"lazyload\":1,\"observer\":0,\"image_lazy\":{\"src\":\"images/template-demo/loader_540x640.svg\"},\"border_radius\":0,\"alt_text\":\"Interior design template\",\"overlay_color\":\"rgba(33, 37, 41, 0.5)\",\"link\":\"index.php/home-interior\",\"description\":\"\",\"description_fontsize\":\"\",\"description_position\":\"bottom\",\"button_text\":\"See Demo\",\"button_type\":\"primary\",\"button_appearance\":\"\",\"button_icon_margin\":\"0px 0px 0px 0px\",\"button_icon_position\":\"left\",\"button_position\":\"overlay\",\"content_col_md\":\"6\",\"content_col_sm\":\"12\",\"content_col_xs\":\"12\",\"alignment\":\"sppb-text-center\",\"middle_alignment\":0,\"class\":\"bg-white\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"15\",\"blur\":\"30\",\"spread\":0,\"color\":\"rgba(73, 80, 87, 0.2)\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-title > a:not(:hover){color:#222;}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596578221228,\"target\":\"\",\"button_url\":\"index.php/home-interior\",\"button_shape\":\"square\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"button_target\":\"\"}}]}]},{\"id\":1596589313221,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596589313221},\"layout\":\"4,4,4\",\"columns\":[{\"id\":1596589313218,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-3\",\"xs_col\":\"col-xs-2\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596589313218},\"addons\":[]},{\"id\":1596589313219,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"col-xs-8\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596589313219,\"class\":\"skew-block-x-invert skew-light\",\"padding\":{\"md\":\"30px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[]},{\"id\":1596589313220,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-3\",\"xs_col\":\"col-xs-2\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596589313220},\"addons\":[]}]},{\"id\":1588365401375,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"<span>BUILT WITH</span>Latest Technologies\",\"heading_selector\":\"h2\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"80px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1588365401375,\"class\":\"title-1 title-w-55\",\"subtitle\":\"This template is built using modern technologies for website creation. With features like drag & drop, live editor and others for a better user experience.\"},\"layout\":\"4,4,4\",\"columns\":[{\"id\":1588365401374,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1588365401374},\"addons\":[{\"id\":1596641420120,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Helix Ultimate\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"\"},\"title_lineheight\":{\"md\":\"\"},\"title_letterspace\":\"0\",\"title_text_color\":\"\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"feature_image_width\":{\"md\":50},\"custom_icon\":\"\",\"icon_name\":\"\",\"icon_size\":{\"md\":36},\"icon_color\":\"\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"Helix Ultimate is the best template framework for Joomla. It’s a user-friendly, modern, and highly customizable. Add, revome, reorder and configure each part of your site.\",\"text_fontsize\":\"\",\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-center\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"feature-box-1\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596641420120,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}}}]},{\"id\":1596589313272,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596589313272},\"addons\":[{\"id\":1596641291690,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"SP Page Builder\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"\"},\"title_lineheight\":{\"md\":\"\"},\"title_letterspace\":\"0\",\"title_text_color\":\"\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"feature_image_width\":{\"md\":50},\"custom_icon\":\"\",\"icon_name\":\"\",\"icon_size\":{\"md\":36},\"icon_color\":\"\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"Real-time Frontend Site Building with 62+ Addons. Just drag and drop to new frontend editing system for create your website in few hours, watching your customizations LIVE in real-time.\",\"text_fontsize\":\"\",\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-center\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"feature-box-1\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596641291690,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}}}]},{\"id\":1596589313273,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596589313220},\"addons\":[{\"id\":1596641291687,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Bootstrap 4\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"\"},\"title_lineheight\":{\"md\":\"\"},\"title_letterspace\":\"0\",\"title_text_color\":\"\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"feature_image_width\":{\"md\":50},\"custom_icon\":\"\",\"icon_name\":\"\",\"icon_size\":{\"md\":36},\"icon_color\":\"\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"We use Bootstrap to create responsive Mobile-first sites. The most popular framework in the world with new technologies such as HTML5, Sass and powerful JavaScript plugins.\",\"text_fontsize\":\"\",\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-center\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"feature-box-1\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596641291687,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}}}]}]},{\"id\":1596589313222,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596589313221},\"layout\":\"4,4,4\",\"columns\":[{\"id\":1596589313223,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-3\",\"xs_col\":\"col-xs-2\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596589313218},\"addons\":[]},{\"id\":1596589313224,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"col-xs-8\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596589313224,\"class\":\"skew-block-x skew-light\",\"padding\":{\"md\":\"30px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[]},{\"id\":1596589313225,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-3\",\"xs_col\":\"col-xs-2\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596589313220},\"addons\":[]}]},{\"id\":1596578221536,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"<span>UNIQUE DESIGNS</span>Awesome Inner Pages\",\"heading_selector\":\"h2\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":1,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"80px 30px 70px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596578221536,\"class\":\"bg-gray-20 title-1\",\"title_text_color\":\"#222222\",\"color\":\"#656565\",\"subtitle\":\"Many inner pages like about us, services, single services, and contacts that you can use for any need. Besides them blogs and project pages with many presentations.\"},\"layout\":\"3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6\",\"columns\":[{\"id\":1596578221532,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596578221532},\"addons\":[{\"id\":1596578221540,\"name\":\"ut_image_lazy\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"About Us Construction\",\"heading_selector\":\"h3\",\"title_fontsize\":\"18\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"   \",\"title_position\":\"bottom\",\"image\":{\"src\":\"images/template-demo/about_construction.png\"},\"lazyload\":1,\"observer\":0,\"image_lazy\":{\"src\":\"images/template-demo/loader_540x540.svg\"},\"border_radius\":0,\"alt_text\":\"about us construction\",\"overlay_color\":\"rgba(33, 37, 41, 0.7)\",\"link\":\"index.php/about-us-construction\",\"description\":\"\",\"description_fontsize\":\"\",\"description_position\":\"bottom\",\"button_text\":\"\",\"button_type\":\"primary\",\"button_appearance\":\"\",\"button_icon_margin\":\"0px 0px 0px 0px\",\"button_icon_position\":\"left\",\"button_position\":\"overlay\",\"content_col_md\":\"6\",\"content_col_sm\":\"12\",\"content_col_xs\":\"12\",\"alignment\":\"sppb-text-center\",\"middle_alignment\":0,\"class\":\"bg-white\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"15\",\"blur\":\"30\",\"spread\":0,\"color\":\"rgba(73, 80, 87, 0.2)\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-title > a:not(:hover){color:#222;}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596578221540,\"target\":\"\",\"button_url\":\"\",\"button_shape\":\"square\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"button_target\":\"_blank\"}}]},{\"id\":1596578221533,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596578221533},\"addons\":[{\"id\":1596589311498,\"name\":\"ut_image_lazy\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"About Us Architect\",\"heading_selector\":\"h3\",\"title_fontsize\":\"18\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"   \",\"title_position\":\"bottom\",\"image\":{\"src\":\"images/template-demo/about_architect.png\"},\"lazyload\":1,\"observer\":0,\"image_lazy\":{\"src\":\"images/template-demo/loader_540x540.svg\"},\"border_radius\":0,\"alt_text\":\"About us architect\",\"overlay_color\":\"rgba(33, 37, 41, 0.7)\",\"link\":\"index.php/about-us-architect\",\"description\":\"\",\"description_fontsize\":\"\",\"description_position\":\"bottom\",\"button_text\":\"\",\"button_type\":\"primary\",\"button_appearance\":\"\",\"button_icon_margin\":\"0px 0px 0px 0px\",\"button_icon_position\":\"left\",\"button_position\":\"overlay\",\"content_col_md\":\"6\",\"content_col_sm\":\"12\",\"content_col_xs\":\"12\",\"alignment\":\"sppb-text-center\",\"middle_alignment\":0,\"class\":\"bg-white\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"15\",\"blur\":\"30\",\"spread\":0,\"color\":\"rgba(73, 80, 87, 0.2)\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-title > a:not(:hover){color:#222;}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596589311498,\"target\":\"\",\"button_url\":\"\",\"button_shape\":\"square\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"button_target\":\"_blank\"}}]},{\"id\":1596578221534,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596578221534},\"addons\":[{\"id\":1596589311567,\"name\":\"ut_image_lazy\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"About Us Mining\",\"heading_selector\":\"h3\",\"title_fontsize\":\"18\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"   \",\"title_position\":\"bottom\",\"image\":{\"src\":\"images/template-demo/about_mining.png\"},\"lazyload\":1,\"observer\":0,\"image_lazy\":{\"src\":\"images/template-demo/loader_540x540.svg\"},\"border_radius\":0,\"alt_text\":\"about us mining\",\"overlay_color\":\"rgba(33, 37, 41, 0.7)\",\"link\":\"index.php/company-mining\",\"description\":\"\",\"description_fontsize\":\"\",\"description_position\":\"bottom\",\"button_text\":\"\",\"button_type\":\"primary\",\"button_appearance\":\"\",\"button_icon_margin\":\"0px 0px 0px 0px\",\"button_icon_position\":\"left\",\"button_position\":\"overlay\",\"content_col_md\":\"6\",\"content_col_sm\":\"12\",\"content_col_xs\":\"12\",\"alignment\":\"sppb-text-center\",\"middle_alignment\":0,\"class\":\"bg-white\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"15\",\"blur\":\"30\",\"spread\":0,\"color\":\"rgba(73, 80, 87, 0.2)\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-title > a:not(:hover){color:#222;}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596589311567,\"target\":\"\",\"button_url\":\"\",\"button_shape\":\"square\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"button_target\":\"_blank\"}}]},{\"id\":1596578221535,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596578221535},\"addons\":[{\"id\":1596589311570,\"name\":\"ut_image_lazy\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"About Us Interior Design\",\"heading_selector\":\"h3\",\"title_fontsize\":\"18\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"   \",\"title_position\":\"bottom\",\"image\":{\"src\":\"images/template-demo/about_interior.png\"},\"lazyload\":1,\"observer\":0,\"image_lazy\":{\"src\":\"images/template-demo/loader_540x540.svg\"},\"border_radius\":0,\"alt_text\":\"About us interior design\",\"overlay_color\":\"rgba(33, 37, 41, 0.7)\",\"link\":\"index.php/about-us-interior\",\"description\":\"\",\"description_fontsize\":\"\",\"description_position\":\"bottom\",\"button_text\":\"\",\"button_type\":\"primary\",\"button_appearance\":\"\",\"button_icon_margin\":\"0px 0px 0px 0px\",\"button_icon_position\":\"left\",\"button_position\":\"overlay\",\"content_col_md\":\"6\",\"content_col_sm\":\"12\",\"content_col_xs\":\"12\",\"alignment\":\"sppb-text-center\",\"middle_alignment\":0,\"class\":\"bg-white\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"15\",\"blur\":\"30\",\"spread\":0,\"color\":\"rgba(73, 80, 87, 0.2)\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-title > a:not(:hover){color:#222;}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596589311570,\"target\":\"\",\"button_url\":\"\",\"button_shape\":\"square\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"button_target\":\"_blank\"}}]},{\"id\":1596589311404,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596589311404},\"addons\":[{\"id\":1596589311888,\"name\":\"ut_image_lazy\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Blog Architect\",\"heading_selector\":\"h3\",\"title_fontsize\":\"18\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"   \",\"title_position\":\"bottom\",\"image\":{\"src\":\"images/template-demo/blog_architect.png\"},\"lazyload\":1,\"observer\":0,\"image_lazy\":{\"src\":\"images/template-demo/loader_540x540.svg\"},\"border_radius\":0,\"alt_text\":\"Blog architect\",\"overlay_color\":\"rgba(33, 37, 41, 0.7)\",\"link\":\"index.php/blog-architect\",\"description\":\"\",\"description_fontsize\":\"\",\"description_position\":\"bottom\",\"button_text\":\"\",\"button_type\":\"primary\",\"button_appearance\":\"\",\"button_icon_margin\":\"0px 0px 0px 0px\",\"button_icon_position\":\"left\",\"button_position\":\"overlay\",\"content_col_md\":\"6\",\"content_col_sm\":\"12\",\"content_col_xs\":\"12\",\"alignment\":\"sppb-text-center\",\"middle_alignment\":0,\"class\":\"bg-white\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"15\",\"blur\":\"30\",\"spread\":0,\"color\":\"rgba(73, 80, 87, 0.2)\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-title > a:not(:hover){color:#222;}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596589311888,\"target\":\"\",\"button_url\":\"\",\"button_shape\":\"square\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"button_target\":\"_blank\"}}]},{\"id\":1596589311405,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596589311405},\"addons\":[{\"id\":1596589311885,\"name\":\"ut_image_lazy\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Blog Construction\",\"heading_selector\":\"h3\",\"title_fontsize\":\"18\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"   \",\"title_position\":\"bottom\",\"image\":{\"src\":\"images/template-demo/blog_construction.png\"},\"lazyload\":1,\"observer\":0,\"image_lazy\":{\"src\":\"images/template-demo/loader_540x540.svg\"},\"border_radius\":0,\"alt_text\":\"Blog construction\",\"overlay_color\":\"rgba(33, 37, 41, 0.7)\",\"link\":\"index.php/blog-construction\",\"description\":\"\",\"description_fontsize\":\"\",\"description_position\":\"bottom\",\"button_text\":\"\",\"button_type\":\"primary\",\"button_appearance\":\"\",\"button_icon_margin\":\"0px 0px 0px 0px\",\"button_icon_position\":\"left\",\"button_position\":\"overlay\",\"content_col_md\":\"6\",\"content_col_sm\":\"12\",\"content_col_xs\":\"12\",\"alignment\":\"sppb-text-center\",\"middle_alignment\":0,\"class\":\"bg-white\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"15\",\"blur\":\"30\",\"spread\":0,\"color\":\"rgba(73, 80, 87, 0.2)\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-title > a:not(:hover){color:#222;}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596589311885,\"target\":\"\",\"button_url\":\"\",\"button_shape\":\"square\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"button_target\":\"_blank\"}}]},{\"id\":1596589311406,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596589311406},\"addons\":[{\"id\":1596589311891,\"name\":\"ut_image_lazy\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Blog Interior Design\",\"heading_selector\":\"h3\",\"title_fontsize\":\"18\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"   \",\"title_position\":\"bottom\",\"image\":{\"src\":\"images/template-demo/blog_interior.png\"},\"lazyload\":1,\"observer\":0,\"image_lazy\":{\"src\":\"images/template-demo/loader_540x540.svg\"},\"border_radius\":0,\"alt_text\":\"Blog interior design\",\"overlay_color\":\"rgba(33, 37, 41, 0.7)\",\"link\":\"index.php/blog-interior\",\"description\":\"\",\"description_fontsize\":\"\",\"description_position\":\"bottom\",\"button_text\":\"\",\"button_type\":\"primary\",\"button_appearance\":\"\",\"button_icon_margin\":\"0px 0px 0px 0px\",\"button_icon_position\":\"left\",\"button_position\":\"overlay\",\"content_col_md\":\"6\",\"content_col_sm\":\"12\",\"content_col_xs\":\"12\",\"alignment\":\"sppb-text-center\",\"middle_alignment\":0,\"class\":\"bg-white\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"15\",\"blur\":\"30\",\"spread\":0,\"color\":\"rgba(73, 80, 87, 0.2)\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-title > a:not(:hover){color:#222;}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596589311891,\"target\":\"\",\"button_url\":\"\",\"button_shape\":\"square\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"button_target\":\"_blank\"}}]},{\"id\":1596589311407,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596589311407},\"addons\":[{\"id\":1596589311894,\"name\":\"ut_image_lazy\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Blog Mining\",\"heading_selector\":\"h3\",\"title_fontsize\":\"18\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"   \",\"title_position\":\"bottom\",\"image\":{\"src\":\"images/template-demo/blog_mining.png\"},\"lazyload\":1,\"observer\":0,\"image_lazy\":{\"src\":\"images/template-demo/loader_540x540.svg\"},\"border_radius\":0,\"alt_text\":\"blog mining\",\"overlay_color\":\"rgba(33, 37, 41, 0.7)\",\"link\":\"index.php/blog-mining\",\"description\":\"\",\"description_fontsize\":\"\",\"description_position\":\"bottom\",\"button_text\":\"\",\"button_type\":\"primary\",\"button_appearance\":\"\",\"button_icon_margin\":\"0px 0px 0px 0px\",\"button_icon_position\":\"left\",\"button_position\":\"overlay\",\"content_col_md\":\"6\",\"content_col_sm\":\"12\",\"content_col_xs\":\"12\",\"alignment\":\"sppb-text-center\",\"middle_alignment\":0,\"class\":\"bg-white\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"15\",\"blur\":\"30\",\"spread\":0,\"color\":\"rgba(73, 80, 87, 0.2)\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-title > a:not(:hover){color:#222;}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596589311894,\"target\":\"\",\"button_url\":\"\",\"button_shape\":\"square\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"button_target\":\"_blank\"}}]},{\"id\":1596589311408,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596589311408},\"addons\":[{\"id\":1596589312071,\"name\":\"ut_image_lazy\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Projects Interior Design\",\"heading_selector\":\"h3\",\"title_fontsize\":\"18\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"   \",\"title_position\":\"bottom\",\"image\":{\"src\":\"images/template-demo/projects_interior.png\"},\"lazyload\":1,\"observer\":0,\"image_lazy\":{\"src\":\"images/template-demo/loader_540x540.svg\"},\"border_radius\":0,\"alt_text\":\"Blog interior design\",\"overlay_color\":\"rgba(33, 37, 41, 0.7)\",\"link\":\"index.php/projects-interior\",\"description\":\"\",\"description_fontsize\":\"\",\"description_position\":\"bottom\",\"button_text\":\"\",\"button_type\":\"primary\",\"button_appearance\":\"\",\"button_icon_margin\":\"0px 0px 0px 0px\",\"button_icon_position\":\"left\",\"button_position\":\"overlay\",\"content_col_md\":\"6\",\"content_col_sm\":\"12\",\"content_col_xs\":\"12\",\"alignment\":\"sppb-text-center\",\"middle_alignment\":0,\"class\":\"bg-white\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"15\",\"blur\":\"30\",\"spread\":0,\"color\":\"rgba(73, 80, 87, 0.2)\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-title > a:not(:hover){color:#222;}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596589312071,\"target\":\"\",\"button_url\":\"\",\"button_shape\":\"square\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"button_target\":\"_blank\"}}]},{\"id\":1596589311409,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1596589311409},\"addons\":[{\"id\":1596589312074,\"name\":\"ut_image_lazy\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Projects Mining\",\"heading_selector\":\"h3\",\"title_fontsize\":\"18\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"   \",\"title_position\":\"bottom\",\"image\":{\"src\":\"images/template-demo/projects_mining.png\"},\"lazyload\":1,\"observer\":0,\"image_lazy\":{\"src\":\"images/template-demo/loader_540x540.svg\"},\"border_radius\":0,\"alt_text\":\"Projects mining\",\"overlay_color\":\"rgba(33, 37, 41, 0.7)\",\"link\":\"index.php/projects-mining\",\"description\":\"\",\"description_fontsize\":\"\",\"description_position\":\"bottom\",\"button_text\":\"\",\"button_type\":\"primary\",\"button_appearance\":\"\",\"button_icon_margin\":\"0px 0px 0px 0px\",\"button_icon_position\":\"left\",\"button_position\":\"overlay\",\"content_col_md\":\"6\",\"content_col_sm\":\"12\",\"content_col_xs\":\"12\",\"alignment\":\"sppb-text-center\",\"middle_alignment\":0,\"class\":\"bg-white\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":0,\"vo\":\"15\",\"blur\":\"30\",\"spread\":0,\"color\":\"rgba(73, 80, 87, 0.2)\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-title > a:not(:hover){color:#222;}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1596589312074,\"target\":\"\",\"button_url\":\"\",\"button_shape\":\"square\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"button_target\":\"_blank\"}}]},{\"id\":1596589311410,\"class_name\":\"col-md-3\",\"v